<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/tool_service.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Response message for
 * [ToolService.ExecuteTool][google.cloud.ces.v1.ToolService.ExecuteTool].
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.ExecuteToolResponse</code>
 */
class ExecuteToolResponse extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The tool execution result in JSON object format.
     * Use "output" key to specify tool response and "error" key to specify
     * error details (if any). If "output" and "error" keys are not specified,
     * then whole "response" is treated as tool execution result.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $response = null;
    protected $tool_identifier;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $tool
     *           The name of the tool that got executed.
     *           Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *     @type \Google\Cloud\Ces\V1\ToolsetTool $toolset_tool
     *           The toolset tool that got executed.
     *     @type \Google\Protobuf\Struct $response
     *           Required. The tool execution result in JSON object format.
     *           Use "output" key to specify tool response and "error" key to specify
     *           error details (if any). If "output" and "error" keys are not specified,
     *           then whole "response" is treated as tool execution result.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\ToolService::initOnce();
        parent::__construct($data);
    }

    /**
     * The name of the tool that got executed.
     * Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *
     * Generated from protobuf field <code>string tool = 1 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getTool()
    {
        return $this->readOneof(1);
    }

    public function hasTool()
    {
        return $this->hasOneof(1);
    }

    /**
     * The name of the tool that got executed.
     * Format: `projects/{project}/locations/{location}/apps/{app}/tools/{tool}`
     *
     * Generated from protobuf field <code>string tool = 1 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setTool($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * The toolset tool that got executed.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ToolsetTool toolset_tool = 3;</code>
     * @return \Google\Cloud\Ces\V1\ToolsetTool|null
     */
    public function getToolsetTool()
    {
        return $this->readOneof(3);
    }

    public function hasToolsetTool()
    {
        return $this->hasOneof(3);
    }

    /**
     * The toolset tool that got executed.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ToolsetTool toolset_tool = 3;</code>
     * @param \Google\Cloud\Ces\V1\ToolsetTool $var
     * @return $this
     */
    public function setToolsetTool($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ToolsetTool::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * Required. The tool execution result in JSON object format.
     * Use "output" key to specify tool response and "error" key to specify
     * error details (if any). If "output" and "error" keys are not specified,
     * then whole "response" is treated as tool execution result.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getResponse()
    {
        return $this->response;
    }

    public function hasResponse()
    {
        return isset($this->response);
    }

    public function clearResponse()
    {
        unset($this->response);
    }

    /**
     * Required. The tool execution result in JSON object format.
     * Use "output" key to specify tool response and "error" key to specify
     * error details (if any). If "output" and "error" keys are not specified,
     * then whole "response" is treated as tool execution result.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct response = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setResponse($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->response = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getToolIdentifier()
    {
        return $this->whichOneof("tool_identifier");
    }

}

