<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/deployment.proto

namespace Google\Cloud\Ces\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A deployment represents an immutable, queryable version of the app.
 * It is used to deploy an app version with a specific channel profile.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.Deployment</code>
 */
class Deployment extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the deployment.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. Display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. The resource name of the app version to deploy.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/versions/{version}
     *
     * Generated from protobuf field <code>string app_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $app_version = '';
    /**
     * Required. The channel profile used in the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ChannelProfile channel_profile = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $channel_profile = null;
    /**
     * Output only. Timestamp when this deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. Timestamp when this deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the deployment.
     *           Format:
     *           projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
     *     @type string $display_name
     *           Required. Display name of the deployment.
     *     @type string $app_version
     *           Required. The resource name of the app version to deploy.
     *           Format:
     *           projects/{project}/locations/{location}/apps/{app}/versions/{version}
     *     @type \Google\Cloud\Ces\V1\ChannelProfile $channel_profile
     *           Required. The channel profile used in the deployment.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. Timestamp when this deployment was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. Timestamp when this deployment was last updated.
     *     @type string $etag
     *           Output only. Etag used to ensure the object hasn't changed during a
     *           read-modify-write operation. If the etag is empty, the update will
     *           overwrite any concurrent changes.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\Deployment::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the deployment.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the deployment.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/deployments/{deployment}
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. Display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. Display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. The resource name of the app version to deploy.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/versions/{version}
     *
     * Generated from protobuf field <code>string app_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getAppVersion()
    {
        return $this->app_version;
    }

    /**
     * Required. The resource name of the app version to deploy.
     * Format:
     * projects/{project}/locations/{location}/apps/{app}/versions/{version}
     *
     * Generated from protobuf field <code>string app_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setAppVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->app_version = $var;

        return $this;
    }

    /**
     * Required. The channel profile used in the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ChannelProfile channel_profile = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Ces\V1\ChannelProfile|null
     */
    public function getChannelProfile()
    {
        return $this->channel_profile;
    }

    public function hasChannelProfile()
    {
        return isset($this->channel_profile);
    }

    public function clearChannelProfile()
    {
        unset($this->channel_profile);
    }

    /**
     * Required. The channel profile used in the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.ces.v1.ChannelProfile channel_profile = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Ces\V1\ChannelProfile $var
     * @return $this
     */
    public function setChannelProfile($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Ces\V1\ChannelProfile::class);
        $this->channel_profile = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. Timestamp when this deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. Timestamp when this deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. Timestamp when this deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Output only. Etag used to ensure the object hasn't changed during a
     * read-modify-write operation. If the etag is empty, the update will
     * overwrite any concurrent changes.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

