<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/ces/v1/tool_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Ces\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Ces\V1\ExecuteToolRequest;
use Google\Cloud\Ces\V1\ExecuteToolResponse;
use Google\Cloud\Ces\V1\RetrieveToolSchemaRequest;
use Google\Cloud\Ces\V1\RetrieveToolSchemaResponse;
use Google\Cloud\Ces\V1\RetrieveToolsRequest;
use Google\Cloud\Ces\V1\RetrieveToolsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Tool service provides APIs for interacting with CES tools.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<ExecuteToolResponse> executeToolAsync(ExecuteToolRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RetrieveToolSchemaResponse> retrieveToolSchemaAsync(RetrieveToolSchemaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<RetrieveToolsResponse> retrieveToolsAsync(RetrieveToolsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class ToolServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.ces.v1.ToolService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'ces.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'ces.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/ces',
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/tool_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/tool_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/tool_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/tool_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a app
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     *
     * @return string The formatted app resource.
     */
    public static function appName(string $project, string $location, string $app): string
    {
        return self::getPathTemplate('app')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a tool
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $tool
     *
     * @return string The formatted tool resource.
     */
    public static function toolName(string $project, string $location, string $app, string $tool): string
    {
        return self::getPathTemplate('tool')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'tool' => $tool,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a toolset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $app
     * @param string $toolset
     *
     * @return string The formatted toolset resource.
     */
    public static function toolsetName(string $project, string $location, string $app, string $toolset): string
    {
        return self::getPathTemplate('toolset')->render([
            'project' => $project,
            'location' => $location,
            'app' => $app,
            'toolset' => $toolset,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - app: projects/{project}/locations/{location}/apps/{app}
     * - tool: projects/{project}/locations/{location}/apps/{app}/tools/{tool}
     * - toolset: projects/{project}/locations/{location}/apps/{app}/toolsets/{toolset}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'ces.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Ces\V1\ToolServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new ToolServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Executes the given tool with the given arguments.
     *
     * The async variant is {@see ToolServiceClient::executeToolAsync()} .
     *
     * @example samples/V1/ToolServiceClient/execute_tool.php
     *
     * @param ExecuteToolRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ExecuteToolResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executeTool(ExecuteToolRequest $request, array $callOptions = []): ExecuteToolResponse
    {
        return $this->startApiCall('ExecuteTool', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the schema of the given tool. The schema is computed on the fly
     * for the given instance of the tool.
     *
     * The async variant is {@see ToolServiceClient::retrieveToolSchemaAsync()} .
     *
     * @example samples/V1/ToolServiceClient/retrieve_tool_schema.php
     *
     * @param RetrieveToolSchemaRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RetrieveToolSchemaResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retrieveToolSchema(
        RetrieveToolSchemaRequest $request,
        array $callOptions = []
    ): RetrieveToolSchemaResponse {
        return $this->startApiCall('RetrieveToolSchema', $request, $callOptions)->wait();
    }

    /**
     * Retrieve the list of tools included in the specified toolset.
     *
     * The async variant is {@see ToolServiceClient::retrieveToolsAsync()} .
     *
     * @example samples/V1/ToolServiceClient/retrieve_tools.php
     *
     * @param RetrieveToolsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return RetrieveToolsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function retrieveTools(RetrieveToolsRequest $request, array $callOptions = []): RetrieveToolsResponse
    {
        return $this->startApiCall('RetrieveTools', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see ToolServiceClient::getLocationAsync()} .
     *
     * @example samples/V1/ToolServiceClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
    This method can be called in two ways:

    *   **List all public locations:** Use the path `GET /v1/locations`.
    *   **List project-visible locations:** Use the path
    `GET /v1/projects/{project_id}/locations`. This may include public
    locations as well as private or other locations specifically visible
    to the project.
     *
     * The async variant is {@see ToolServiceClient::listLocationsAsync()} .
     *
     * @example samples/V1/ToolServiceClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
