<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/ces/v1/common.proto

namespace Google\Cloud\Ces\V1\ChannelProfile\WebWidgetConfig;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Security settings for the web widget.
 *
 * Generated from protobuf message <code>google.cloud.ces.v1.ChannelProfile.WebWidgetConfig.SecuritySettings</code>
 */
class SecuritySettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Indicates whether public access to the web widget is enabled.
     * If `true`, the web widget will be publicly accessible.
     * If `false`, the web widget must be integrated with your own
     * authentication and authorization system to return valid credentials for
     * accessing the CES agent.
     *
     * Generated from protobuf field <code>bool enable_public_access = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_public_access = false;
    /**
     * Optional. Indicates whether origin check for the web widget is enabled.
     * If `true`, the web widget will check the origin of the website that
     * loads the web widget and only allow it to be loaded in the same origin
     * or any of the allowed origins.
     *
     * Generated from protobuf field <code>bool enable_origin_check = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_origin_check = false;
    /**
     * Optional. The origins that are allowed to host the web widget. An
     * origin is defined by RFC 6454. If empty, all origins are allowed. A
     * maximum of 100 origins is allowed. Example: "https://example.com"
     *
     * Generated from protobuf field <code>repeated string allowed_origins = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $allowed_origins;
    /**
     * Optional. Indicates whether reCAPTCHA verification for the web widget
     * is enabled.
     *
     * Generated from protobuf field <code>bool enable_recaptcha = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $enable_recaptcha = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $enable_public_access
     *           Optional. Indicates whether public access to the web widget is enabled.
     *           If `true`, the web widget will be publicly accessible.
     *           If `false`, the web widget must be integrated with your own
     *           authentication and authorization system to return valid credentials for
     *           accessing the CES agent.
     *     @type bool $enable_origin_check
     *           Optional. Indicates whether origin check for the web widget is enabled.
     *           If `true`, the web widget will check the origin of the website that
     *           loads the web widget and only allow it to be loaded in the same origin
     *           or any of the allowed origins.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $allowed_origins
     *           Optional. The origins that are allowed to host the web widget. An
     *           origin is defined by RFC 6454. If empty, all origins are allowed. A
     *           maximum of 100 origins is allowed. Example: "https://example.com"
     *     @type bool $enable_recaptcha
     *           Optional. Indicates whether reCAPTCHA verification for the web widget
     *           is enabled.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Ces\V1\Common::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Indicates whether public access to the web widget is enabled.
     * If `true`, the web widget will be publicly accessible.
     * If `false`, the web widget must be integrated with your own
     * authentication and authorization system to return valid credentials for
     * accessing the CES agent.
     *
     * Generated from protobuf field <code>bool enable_public_access = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnablePublicAccess()
    {
        return $this->enable_public_access;
    }

    /**
     * Optional. Indicates whether public access to the web widget is enabled.
     * If `true`, the web widget will be publicly accessible.
     * If `false`, the web widget must be integrated with your own
     * authentication and authorization system to return valid credentials for
     * accessing the CES agent.
     *
     * Generated from protobuf field <code>bool enable_public_access = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnablePublicAccess($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_public_access = $var;

        return $this;
    }

    /**
     * Optional. Indicates whether origin check for the web widget is enabled.
     * If `true`, the web widget will check the origin of the website that
     * loads the web widget and only allow it to be loaded in the same origin
     * or any of the allowed origins.
     *
     * Generated from protobuf field <code>bool enable_origin_check = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableOriginCheck()
    {
        return $this->enable_origin_check;
    }

    /**
     * Optional. Indicates whether origin check for the web widget is enabled.
     * If `true`, the web widget will check the origin of the website that
     * loads the web widget and only allow it to be loaded in the same origin
     * or any of the allowed origins.
     *
     * Generated from protobuf field <code>bool enable_origin_check = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableOriginCheck($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_origin_check = $var;

        return $this;
    }

    /**
     * Optional. The origins that are allowed to host the web widget. An
     * origin is defined by RFC 6454. If empty, all origins are allowed. A
     * maximum of 100 origins is allowed. Example: "https://example.com"
     *
     * Generated from protobuf field <code>repeated string allowed_origins = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAllowedOrigins()
    {
        return $this->allowed_origins;
    }

    /**
     * Optional. The origins that are allowed to host the web widget. An
     * origin is defined by RFC 6454. If empty, all origins are allowed. A
     * maximum of 100 origins is allowed. Example: "https://example.com"
     *
     * Generated from protobuf field <code>repeated string allowed_origins = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAllowedOrigins($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->allowed_origins = $arr;

        return $this;
    }

    /**
     * Optional. Indicates whether reCAPTCHA verification for the web widget
     * is enabled.
     *
     * Generated from protobuf field <code>bool enable_recaptcha = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getEnableRecaptcha()
    {
        return $this->enable_recaptcha;
    }

    /**
     * Optional. Indicates whether reCAPTCHA verification for the web widget
     * is enabled.
     *
     * Generated from protobuf field <code>bool enable_recaptcha = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableRecaptcha($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_recaptcha = $var;

        return $this;
    }

}


