<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/reservation/v1/reservation.proto

namespace Google\Cloud\BigQuery\Reservation\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Capacity commitment is a way to purchase compute capacity for BigQuery jobs
 * (in the form of slots) with some committed period of usage. Annual
 * commitments renew by default. Commitments can be removed after their
 * commitment end time passes.
 * In order to remove annual commitment, its plan needs to be changed
 * to monthly or flex first.
 * A capacity commitment resource exists as a child resource of the admin
 * project.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.reservation.v1.CapacityCommitment</code>
 */
class CapacityCommitment extends \Google\Protobuf\Internal\Message
{
    /**
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $name = '';
    /**
     * Optional. Number of slots in this commitment.
     *
     * Generated from protobuf field <code>int64 slot_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $slot_count = 0;
    /**
     * Optional. Capacity commitment commitment plan.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $plan = 0;
    /**
     * Output only. State of the commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $state = 0;
    /**
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after the commitment is renewed,
     * commitment_start_time won't be changed. It refers to the start time of the
     * original commitment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $commitment_start_time = null;
    /**
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after renewal,
     * commitment_end_time is the time the renewed commitment expires. So itwould
     * be at a time after commitment_start_time + committed period, because we
     * don't change commitment_start_time ,
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $commitment_end_time = null;
    /**
     * Output only. For FAILED commitment plan, provides the reason of failure.
     *
     * Generated from protobuf field <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $failure_status = null;
    /**
     * Optional. The plan this capacity commitment is converted to after
     * commitment_end_time passes. Once the plan is changed, committed period is
     * extended according to commitment plan. Only applicable for ANNUAL and TRIAL
     * commitments.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $renewal_plan = 0;
    /**
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 10 [deprecated = true];</code>
     * @deprecated
     */
    protected $multi_region_auxiliary = false;
    /**
     * Optional. Edition of the capacity commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $edition = 0;
    /**
     * Output only. If true, the commitment is a flat-rate commitment, otherwise,
     * it's an edition commitment.
     *
     * Generated from protobuf field <code>bool is_flat_rate = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $is_flat_rate = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Output only. The resource name of the capacity commitment, e.g.,
     *           `projects/myproject/locations/US/capacityCommitments/123`
     *           The commitment_id must only contain lower case alphanumeric characters or
     *           dashes. It must start with a letter and must not end
     *           with a dash. Its maximum length is 64 characters.
     *     @type int|string $slot_count
     *           Optional. Number of slots in this commitment.
     *     @type int $plan
     *           Optional. Capacity commitment commitment plan.
     *     @type int $state
     *           Output only. State of the commitment.
     *     @type \Google\Protobuf\Timestamp $commitment_start_time
     *           Output only. The start of the current commitment period. It is applicable
     *           only for ACTIVE capacity commitments. Note after the commitment is renewed,
     *           commitment_start_time won't be changed. It refers to the start time of the
     *           original commitment.
     *     @type \Google\Protobuf\Timestamp $commitment_end_time
     *           Output only. The end of the current commitment period. It is applicable
     *           only for ACTIVE capacity commitments. Note after renewal,
     *           commitment_end_time is the time the renewed commitment expires. So itwould
     *           be at a time after commitment_start_time + committed period, because we
     *           don't change commitment_start_time ,
     *     @type \Google\Rpc\Status $failure_status
     *           Output only. For FAILED commitment plan, provides the reason of failure.
     *     @type int $renewal_plan
     *           Optional. The plan this capacity commitment is converted to after
     *           commitment_end_time passes. Once the plan is changed, committed period is
     *           extended according to commitment plan. Only applicable for ANNUAL and TRIAL
     *           commitments.
     *     @type bool $multi_region_auxiliary
     *           Applicable only for commitments located within one of the BigQuery
     *           multi-regions (US or EU).
     *           If set to true, this commitment is placed in the organization's
     *           secondary region which is designated for disaster recovery purposes.
     *           If false, this commitment is placed in the organization's default region.
     *           NOTE: this is a preview feature. Project must be allow-listed in order to
     *           set this field.
     *     @type int $edition
     *           Optional. Edition of the capacity commitment.
     *     @type bool $is_flat_rate
     *           Output only. If true, the commitment is a flat-rate commitment, otherwise,
     *           it's an edition commitment.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Reservation\V1\Reservation::initOnce();
        parent::__construct($data);
    }

    /**
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Output only. The resource name of the capacity commitment, e.g.,
     * `projects/myproject/locations/US/capacityCommitments/123`
     * The commitment_id must only contain lower case alphanumeric characters or
     * dashes. It must start with a letter and must not end
     * with a dash. Its maximum length is 64 characters.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. Number of slots in this commitment.
     *
     * Generated from protobuf field <code>int64 slot_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int|string
     */
    public function getSlotCount()
    {
        return $this->slot_count;
    }

    /**
     * Optional. Number of slots in this commitment.
     *
     * Generated from protobuf field <code>int64 slot_count = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int|string $var
     * @return $this
     */
    public function setSlotCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->slot_count = $var;

        return $this;
    }

    /**
     * Optional. Capacity commitment commitment plan.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getPlan()
    {
        return $this->plan;
    }

    /**
     * Optional. Capacity commitment commitment plan.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan plan = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setPlan($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\CapacityCommitment\CommitmentPlan::class);
        $this->plan = $var;

        return $this;
    }

    /**
     * Output only. State of the commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. State of the commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.State state = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\CapacityCommitment\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after the commitment is renewed,
     * commitment_start_time won't be changed. It refers to the start time of the
     * original commitment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCommitmentStartTime()
    {
        return $this->commitment_start_time;
    }

    public function hasCommitmentStartTime()
    {
        return isset($this->commitment_start_time);
    }

    public function clearCommitmentStartTime()
    {
        unset($this->commitment_start_time);
    }

    /**
     * Output only. The start of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after the commitment is renewed,
     * commitment_start_time won't be changed. It refers to the start time of the
     * original commitment.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_start_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCommitmentStartTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->commitment_start_time = $var;

        return $this;
    }

    /**
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after renewal,
     * commitment_end_time is the time the renewed commitment expires. So itwould
     * be at a time after commitment_start_time + committed period, because we
     * don't change commitment_start_time ,
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCommitmentEndTime()
    {
        return $this->commitment_end_time;
    }

    public function hasCommitmentEndTime()
    {
        return isset($this->commitment_end_time);
    }

    public function clearCommitmentEndTime()
    {
        unset($this->commitment_end_time);
    }

    /**
     * Output only. The end of the current commitment period. It is applicable
     * only for ACTIVE capacity commitments. Note after renewal,
     * commitment_end_time is the time the renewed commitment expires. So itwould
     * be at a time after commitment_start_time + committed period, because we
     * don't change commitment_start_time ,
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp commitment_end_time = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCommitmentEndTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->commitment_end_time = $var;

        return $this;
    }

    /**
     * Output only. For FAILED commitment plan, provides the reason of failure.
     *
     * Generated from protobuf field <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Rpc\Status|null
     */
    public function getFailureStatus()
    {
        return $this->failure_status;
    }

    public function hasFailureStatus()
    {
        return isset($this->failure_status);
    }

    public function clearFailureStatus()
    {
        unset($this->failure_status);
    }

    /**
     * Output only. For FAILED commitment plan, provides the reason of failure.
     *
     * Generated from protobuf field <code>.google.rpc.Status failure_status = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setFailureStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->failure_status = $var;

        return $this;
    }

    /**
     * Optional. The plan this capacity commitment is converted to after
     * commitment_end_time passes. Once the plan is changed, committed period is
     * extended according to commitment plan. Only applicable for ANNUAL and TRIAL
     * commitments.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRenewalPlan()
    {
        return $this->renewal_plan;
    }

    /**
     * Optional. The plan this capacity commitment is converted to after
     * commitment_end_time passes. Once the plan is changed, committed period is
     * extended according to commitment plan. Only applicable for ANNUAL and TRIAL
     * commitments.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.CapacityCommitment.CommitmentPlan renewal_plan = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRenewalPlan($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\CapacityCommitment\CommitmentPlan::class);
        $this->renewal_plan = $var;

        return $this;
    }

    /**
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 10 [deprecated = true];</code>
     * @return bool
     * @deprecated
     */
    public function getMultiRegionAuxiliary()
    {
        if ($this->multi_region_auxiliary !== false) {
            @trigger_error('multi_region_auxiliary is deprecated.', E_USER_DEPRECATED);
        }
        return $this->multi_region_auxiliary;
    }

    /**
     * Applicable only for commitments located within one of the BigQuery
     * multi-regions (US or EU).
     * If set to true, this commitment is placed in the organization's
     * secondary region which is designated for disaster recovery purposes.
     * If false, this commitment is placed in the organization's default region.
     * NOTE: this is a preview feature. Project must be allow-listed in order to
     * set this field.
     *
     * Generated from protobuf field <code>bool multi_region_auxiliary = 10 [deprecated = true];</code>
     * @param bool $var
     * @return $this
     * @deprecated
     */
    public function setMultiRegionAuxiliary($var)
    {
        @trigger_error('multi_region_auxiliary is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkBool($var);
        $this->multi_region_auxiliary = $var;

        return $this;
    }

    /**
     * Optional. Edition of the capacity commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getEdition()
    {
        return $this->edition;
    }

    /**
     * Optional. Edition of the capacity commitment.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.reservation.v1.Edition edition = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setEdition($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\BigQuery\Reservation\V1\Edition::class);
        $this->edition = $var;

        return $this;
    }

    /**
     * Output only. If true, the commitment is a flat-rate commitment, otherwise,
     * it's an edition commitment.
     *
     * Generated from protobuf field <code>bool is_flat_rate = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getIsFlatRate()
    {
        return $this->is_flat_rate;
    }

    /**
     * Output only. If true, the commitment is a flat-rate commitment, otherwise,
     * it's an edition commitment.
     *
     * Generated from protobuf field <code>bool is_flat_rate = 14 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setIsFlatRate($var)
    {
        GPBUtil::checkBool($var);
        $this->is_flat_rate = $var;

        return $this;
    }

}

