<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/auditmanager/v1/auditmanager.proto

namespace Google\Cloud\AuditManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message for requesting the Audit Report.
 *
 * Generated from protobuf message <code>google.cloud.auditmanager.v1.GenerateAuditReportRequest</code>
 */
class GenerateAuditReportRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Scope for which the AuditScopeReport is required. Must be of
     * format resource_type/resource_identifier Eg:
     * projects/{project}/locations/{location},
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $scope = '';
    /**
     * Required. Compliance Standard against which the Scope Report must be
     * generated. Eg: FEDRAMP_MODERATE
     *
     * Generated from protobuf field <code>string compliance_standard = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $compliance_standard = '';
    /**
     * Required. The format in which the audit report should be created.
     *
     * Generated from protobuf field <code>.google.cloud.auditmanager.v1.GenerateAuditReportRequest.AuditReportFormat report_format = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $report_format = 0;
    /**
     * Required. Compliance framework against which the Report must be generated.
     *
     * Generated from protobuf field <code>string compliance_framework = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $compliance_framework = '';
    protected $destination;

    /**
     * @param string $scope              Required. Scope for which the AuditScopeReport is required. Must be of
     *                                   format resource_type/resource_identifier Eg:
     *                                   projects/{project}/locations/{location},
     *                                   folders/{folder}/locations/{location}
     * @param string $gcsUri             Destination Cloud storage bucket where report and evidence must be
     *                                   uploaded. The Cloud storage bucket provided here must be selected among
     *                                   the buckets entered during the enrollment process.
     * @param string $complianceStandard Required. Compliance Standard against which the Scope Report must be
     *                                   generated. Eg: FEDRAMP_MODERATE
     * @param int    $reportFormat       Required. The format in which the audit report should be created.
     *                                   For allowed values, use constants defined on {@see \Google\Cloud\AuditManager\V1\GenerateAuditReportRequest\AuditReportFormat}
     *
     * @return \Google\Cloud\AuditManager\V1\GenerateAuditReportRequest
     *
     * @experimental
     */
    public static function build(string $scope, string $gcsUri, string $complianceStandard, int $reportFormat): self
    {
        return (new self())
            ->setScope($scope)
            ->setGcsUri($gcsUri)
            ->setComplianceStandard($complianceStandard)
            ->setReportFormat($reportFormat);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $gcs_uri
     *           Destination Cloud storage bucket where report and evidence must be
     *           uploaded. The Cloud storage bucket provided here must be selected among
     *           the buckets entered during the enrollment process.
     *     @type string $scope
     *           Required. Scope for which the AuditScopeReport is required. Must be of
     *           format resource_type/resource_identifier Eg:
     *           projects/{project}/locations/{location},
     *           folders/{folder}/locations/{location}
     *     @type string $compliance_standard
     *           Required. Compliance Standard against which the Scope Report must be
     *           generated. Eg: FEDRAMP_MODERATE
     *     @type int $report_format
     *           Required. The format in which the audit report should be created.
     *     @type string $compliance_framework
     *           Required. Compliance framework against which the Report must be generated.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Auditmanager\V1\Auditmanager::initOnce();
        parent::__construct($data);
    }

    /**
     * Destination Cloud storage bucket where report and evidence must be
     * uploaded. The Cloud storage bucket provided here must be selected among
     * the buckets entered during the enrollment process.
     *
     * Generated from protobuf field <code>string gcs_uri = 2;</code>
     * @return string
     */
    public function getGcsUri()
    {
        return $this->readOneof(2);
    }

    public function hasGcsUri()
    {
        return $this->hasOneof(2);
    }

    /**
     * Destination Cloud storage bucket where report and evidence must be
     * uploaded. The Cloud storage bucket provided here must be selected among
     * the buckets entered during the enrollment process.
     *
     * Generated from protobuf field <code>string gcs_uri = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setGcsUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Required. Scope for which the AuditScopeReport is required. Must be of
     * format resource_type/resource_identifier Eg:
     * projects/{project}/locations/{location},
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Required. Scope for which the AuditScopeReport is required. Must be of
     * format resource_type/resource_identifier Eg:
     * projects/{project}/locations/{location},
     * folders/{folder}/locations/{location}
     *
     * Generated from protobuf field <code>string scope = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Required. Compliance Standard against which the Scope Report must be
     * generated. Eg: FEDRAMP_MODERATE
     *
     * Generated from protobuf field <code>string compliance_standard = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getComplianceStandard()
    {
        return $this->compliance_standard;
    }

    /**
     * Required. Compliance Standard against which the Scope Report must be
     * generated. Eg: FEDRAMP_MODERATE
     *
     * Generated from protobuf field <code>string compliance_standard = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setComplianceStandard($var)
    {
        GPBUtil::checkString($var, True);
        $this->compliance_standard = $var;

        return $this;
    }

    /**
     * Required. The format in which the audit report should be created.
     *
     * Generated from protobuf field <code>.google.cloud.auditmanager.v1.GenerateAuditReportRequest.AuditReportFormat report_format = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getReportFormat()
    {
        return $this->report_format;
    }

    /**
     * Required. The format in which the audit report should be created.
     *
     * Generated from protobuf field <code>.google.cloud.auditmanager.v1.GenerateAuditReportRequest.AuditReportFormat report_format = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setReportFormat($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\AuditManager\V1\GenerateAuditReportRequest\AuditReportFormat::class);
        $this->report_format = $var;

        return $this;
    }

    /**
     * Required. Compliance framework against which the Report must be generated.
     *
     * Generated from protobuf field <code>string compliance_framework = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getComplianceFramework()
    {
        return $this->compliance_framework;
    }

    /**
     * Required. Compliance framework against which the Report must be generated.
     *
     * Generated from protobuf field <code>string compliance_framework = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setComplianceFramework($var)
    {
        GPBUtil::checkString($var, True);
        $this->compliance_framework = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getDestination()
    {
        return $this->whichOneof("destination");
    }

}

