<?php
/*
 * Copyright 2026 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/auditmanager/v1/auditmanager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\AuditManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\AuditManager\V1\AuditReport;
use Google\Cloud\AuditManager\V1\AuditScopeReport;
use Google\Cloud\AuditManager\V1\EnrollResourceRequest;
use Google\Cloud\AuditManager\V1\Enrollment;
use Google\Cloud\AuditManager\V1\GenerateAuditReportRequest;
use Google\Cloud\AuditManager\V1\GenerateAuditScopeReportRequest;
use Google\Cloud\AuditManager\V1\GetAuditReportRequest;
use Google\Cloud\AuditManager\V1\GetResourceEnrollmentStatusRequest;
use Google\Cloud\AuditManager\V1\ListAuditReportsRequest;
use Google\Cloud\AuditManager\V1\ListControlsRequest;
use Google\Cloud\AuditManager\V1\ListResourceEnrollmentStatusesRequest;
use Google\Cloud\AuditManager\V1\ResourceEnrollmentStatus;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Service describing handlers for resources
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<Enrollment> enrollResourceAsync(EnrollResourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> generateAuditReportAsync(GenerateAuditReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AuditScopeReport> generateAuditScopeReportAsync(GenerateAuditScopeReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AuditReport> getAuditReportAsync(GetAuditReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ResourceEnrollmentStatus> getResourceEnrollmentStatusAsync(GetResourceEnrollmentStatusRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAuditReportsAsync(ListAuditReportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listControlsAsync(ListControlsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listResourceEnrollmentStatusesAsync(ListResourceEnrollmentStatusesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Location> getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class AuditManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.auditmanager.v1.AuditManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'auditmanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'auditmanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/audit_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/audit_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/audit_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/audit_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a audit_report
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $auditReport
     *
     * @return string The formatted audit_report resource.
     */
    public static function auditReportName(string $project, string $location, string $auditReport): string
    {
        return self::getPathTemplate('auditReport')->render([
            'project' => $project,
            'location' => $location,
            'audit_report' => $auditReport,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * enrollment_status_scope resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted enrollment_status_scope resource.
     */
    public static function enrollmentStatusScopeName(string $folder, string $location): string
    {
        return self::getPathTemplate('enrollmentStatusScope')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location resource.
     */
    public static function folderLocationName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocation')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_audit_report resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $auditReport
     *
     * @return string The formatted folder_location_audit_report resource.
     */
    public static function folderLocationAuditReportName(string $folder, string $location, string $auditReport): string
    {
        return self::getPathTemplate('folderLocationAuditReport')->render([
            'folder' => $folder,
            'location' => $location,
            'audit_report' => $auditReport,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_resource_enrollment_status resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $resourceEnrollmentStatus
     *
     * @return string The formatted folder_location_resource_enrollment_status resource.
     */
    public static function folderLocationResourceEnrollmentStatusName(
        string $folder,
        string $location,
        string $resourceEnrollmentStatus
    ): string {
        return self::getPathTemplate('folderLocationResourceEnrollmentStatus')->render([
            'folder' => $folder,
            'location' => $location,
            'resource_enrollment_status' => $resourceEnrollmentStatus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_standard resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $standard
     *
     * @return string The formatted folder_location_standard resource.
     */
    public static function folderLocationStandardName(string $folder, string $location, string $standard): string
    {
        return self::getPathTemplate('folderLocationStandard')->render([
            'folder' => $folder,
            'location' => $location,
            'standard' => $standard,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location resource.
     *
     * @param string $organization
     * @param string $location
     *
     * @return string The formatted organization_location resource.
     */
    public static function organizationLocationName(string $organization, string $location): string
    {
        return self::getPathTemplate('organizationLocation')->render([
            'organization' => $organization,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_resource_enrollment_status resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $resourceEnrollmentStatus
     *
     * @return string The formatted organization_location_resource_enrollment_status resource.
     */
    public static function organizationLocationResourceEnrollmentStatusName(
        string $organization,
        string $location,
        string $resourceEnrollmentStatus
    ): string {
        return self::getPathTemplate('organizationLocationResourceEnrollmentStatus')->render([
            'organization' => $organization,
            'location' => $location,
            'resource_enrollment_status' => $resourceEnrollmentStatus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_location_standard resource.
     *
     * @param string $organization
     * @param string $location
     * @param string $standard
     *
     * @return string The formatted organization_location_standard resource.
     */
    public static function organizationLocationStandardName(
        string $organization,
        string $location,
        string $standard
    ): string {
        return self::getPathTemplate('organizationLocationStandard')->render([
            'organization' => $organization,
            'location' => $location,
            'standard' => $standard,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_audit_report resource.
     *
     * @param string $project
     * @param string $location
     * @param string $auditReport
     *
     * @return string The formatted project_location_audit_report resource.
     */
    public static function projectLocationAuditReportName(
        string $project,
        string $location,
        string $auditReport
    ): string {
        return self::getPathTemplate('projectLocationAuditReport')->render([
            'project' => $project,
            'location' => $location,
            'audit_report' => $auditReport,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_resource_enrollment_status resource.
     *
     * @param string $project
     * @param string $location
     * @param string $resourceEnrollmentStatus
     *
     * @return string The formatted project_location_resource_enrollment_status resource.
     */
    public static function projectLocationResourceEnrollmentStatusName(
        string $project,
        string $location,
        string $resourceEnrollmentStatus
    ): string {
        return self::getPathTemplate('projectLocationResourceEnrollmentStatus')->render([
            'project' => $project,
            'location' => $location,
            'resource_enrollment_status' => $resourceEnrollmentStatus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_standard resource.
     *
     * @param string $project
     * @param string $location
     * @param string $standard
     *
     * @return string The formatted project_location_standard resource.
     */
    public static function projectLocationStandardName(string $project, string $location, string $standard): string
    {
        return self::getPathTemplate('projectLocationStandard')->render([
            'project' => $project,
            'location' => $location,
            'standard' => $standard,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * resource_enrollment_status resource.
     *
     * @param string $folder
     * @param string $location
     * @param string $resourceEnrollmentStatus
     *
     * @return string The formatted resource_enrollment_status resource.
     */
    public static function resourceEnrollmentStatusName(
        string $folder,
        string $location,
        string $resourceEnrollmentStatus
    ): string {
        return self::getPathTemplate('resourceEnrollmentStatus')->render([
            'folder' => $folder,
            'location' => $location,
            'resource_enrollment_status' => $resourceEnrollmentStatus,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a standard
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $standard
     *
     * @return string The formatted standard resource.
     */
    public static function standardName(string $project, string $location, string $standard): string
    {
        return self::getPathTemplate('standard')->render([
            'project' => $project,
            'location' => $location,
            'standard' => $standard,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - auditReport: projects/{project}/locations/{location}/auditReports/{audit_report}
     * - enrollmentStatusScope: folders/{folder}/locations/{location}
     * - folderLocation: folders/{folder}/locations/{location}
     * - folderLocationAuditReport: folders/{folder}/locations/{location}/auditReports/{audit_report}
     * - folderLocationResourceEnrollmentStatus: folders/{folder}/locations/{location}/resourceEnrollmentStatuses/{resource_enrollment_status}
     * - folderLocationStandard: folders/{folder}/locations/{location}/standards/{standard}
     * - location: projects/{project}/locations/{location}
     * - organizationLocation: organizations/{organization}/locations/{location}
     * - organizationLocationResourceEnrollmentStatus: organizations/{organization}/locations/{location}/resourceEnrollmentStatuses/{resource_enrollment_status}
     * - organizationLocationStandard: organizations/{organization}/locations/{location}/standards/{standard}
     * - projectLocationAuditReport: projects/{project}/locations/{location}/auditReports/{audit_report}
     * - projectLocationResourceEnrollmentStatus: projects/{project}/locations/{location}/resourceEnrollmentStatuses/{resource_enrollment_status}
     * - projectLocationStandard: projects/{project}/locations/{location}/standards/{standard}
     * - resourceEnrollmentStatus: folders/{folder}/locations/{location}/resourceEnrollmentStatuses/{resource_enrollment_status}
     * - standard: projects/{project}/locations/{location}/standards/{standard}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'auditmanager.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\AuditManager\V1\AuditManagerClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new AuditManagerClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Enrolls the customer resource(folder/project/organization) to the audit
     * manager service by creating the audit managers Service Agent in customers
     * workload and granting required permissions to the Service Agent. Please
     * note that if enrollment request is made on the already enrolled workload
     * then enrollment is executed overriding the existing set of destinations.
     *
     * The async variant is {@see AuditManagerClient::enrollResourceAsync()} .
     *
     * @example samples/V1/AuditManagerClient/enroll_resource.php
     *
     * @param EnrollResourceRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Enrollment
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function enrollResource(EnrollResourceRequest $request, array $callOptions = []): Enrollment
    {
        return $this->startApiCall('EnrollResource', $request, $callOptions)->wait();
    }

    /**
     * Register the Audit Report generation requests and returns the OperationId
     * using which the customer can track the report generation progress.
     *
     * The async variant is {@see AuditManagerClient::generateAuditReportAsync()} .
     *
     * @example samples/V1/AuditManagerClient/generate_audit_report.php
     *
     * @param GenerateAuditReportRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AuditReport>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateAuditReport(GenerateAuditReportRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('GenerateAuditReport', $request, $callOptions)->wait();
    }

    /**
     * Generates a demo report highlighting different responsibilities
     * (Google/Customer/ shared) required to be fulfilled for the customer's
     * workload to be compliant with the given standard.
     *
     * The async variant is {@see AuditManagerClient::generateAuditScopeReportAsync()}
     * .
     *
     * @example samples/V1/AuditManagerClient/generate_audit_scope_report.php
     *
     * @param GenerateAuditScopeReportRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AuditScopeReport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function generateAuditScopeReport(
        GenerateAuditScopeReportRequest $request,
        array $callOptions = []
    ): AuditScopeReport {
        return $this->startApiCall('GenerateAuditScopeReport', $request, $callOptions)->wait();
    }

    /**
     * Get the overall audit report
     *
     * The async variant is {@see AuditManagerClient::getAuditReportAsync()} .
     *
     * @example samples/V1/AuditManagerClient/get_audit_report.php
     *
     * @param GetAuditReportRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AuditReport
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAuditReport(GetAuditReportRequest $request, array $callOptions = []): AuditReport
    {
        return $this->startApiCall('GetAuditReport', $request, $callOptions)->wait();
    }

    /**
     * Get a resource along with its enrollment status.
     *
     * The async variant is
     * {@see AuditManagerClient::getResourceEnrollmentStatusAsync()} .
     *
     * @example samples/V1/AuditManagerClient/get_resource_enrollment_status.php
     *
     * @param GetResourceEnrollmentStatusRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ResourceEnrollmentStatus
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getResourceEnrollmentStatus(
        GetResourceEnrollmentStatusRequest $request,
        array $callOptions = []
    ): ResourceEnrollmentStatus {
        return $this->startApiCall('GetResourceEnrollmentStatus', $request, $callOptions)->wait();
    }

    /**
     * Lists audit reports in the selected parent scope
     *
     * The async variant is {@see AuditManagerClient::listAuditReportsAsync()} .
     *
     * @example samples/V1/AuditManagerClient/list_audit_reports.php
     *
     * @param ListAuditReportsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAuditReports(ListAuditReportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAuditReports', $request, $callOptions);
    }

    /**
     * Gets controls needed to be implemented to be compliant to a standard.
     *
     * The async variant is {@see AuditManagerClient::listControlsAsync()} .
     *
     * @example samples/V1/AuditManagerClient/list_controls.php
     *
     * @param ListControlsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listControls(ListControlsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListControls', $request, $callOptions);
    }

    /**
     * Fetches all resources under the parent along with their enrollment.
     *
     * The async variant is
     * {@see AuditManagerClient::listResourceEnrollmentStatusesAsync()} .
     *
     * @example samples/V1/AuditManagerClient/list_resource_enrollment_statuses.php
     *
     * @param ListResourceEnrollmentStatusesRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listResourceEnrollmentStatuses(
        ListResourceEnrollmentStatusesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('ListResourceEnrollmentStatuses', $request, $callOptions);
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see AuditManagerClient::getLocationAsync()} .
     *
     * @example samples/V1/AuditManagerClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
    This method can be called in two ways:

    *   **List all public locations:** Use the path `GET /v1/locations`.
    *   **List project-visible locations:** Use the path
    `GET /v1/projects/{project_id}/locations`. This may include public
    locations as well as private or other locations specifically visible
    to the project.
     *
     * The async variant is {@see AuditManagerClient::listLocationsAsync()} .
     *
     * @example samples/V1/AuditManagerClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
