<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/asset/v1/asset_service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Asset\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyLongrunningRequest;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyLongrunningResponse;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyRequest;
use Google\Cloud\Asset\V1\AnalyzeIamPolicyResponse;
use Google\Cloud\Asset\V1\AnalyzeMoveRequest;
use Google\Cloud\Asset\V1\AnalyzeMoveResponse;
use Google\Cloud\Asset\V1\AnalyzeOrgPoliciesRequest;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedAssetsRequest;
use Google\Cloud\Asset\V1\AnalyzeOrgPolicyGovernedContainersRequest;
use Google\Cloud\Asset\V1\BatchGetAssetsHistoryRequest;
use Google\Cloud\Asset\V1\BatchGetAssetsHistoryResponse;
use Google\Cloud\Asset\V1\BatchGetEffectiveIamPoliciesRequest;
use Google\Cloud\Asset\V1\BatchGetEffectiveIamPoliciesResponse;
use Google\Cloud\Asset\V1\CreateFeedRequest;
use Google\Cloud\Asset\V1\CreateSavedQueryRequest;
use Google\Cloud\Asset\V1\DeleteFeedRequest;
use Google\Cloud\Asset\V1\DeleteSavedQueryRequest;
use Google\Cloud\Asset\V1\ExportAssetsRequest;
use Google\Cloud\Asset\V1\ExportAssetsResponse;
use Google\Cloud\Asset\V1\Feed;
use Google\Cloud\Asset\V1\GetFeedRequest;
use Google\Cloud\Asset\V1\GetSavedQueryRequest;
use Google\Cloud\Asset\V1\ListAssetsRequest;
use Google\Cloud\Asset\V1\ListFeedsRequest;
use Google\Cloud\Asset\V1\ListFeedsResponse;
use Google\Cloud\Asset\V1\ListSavedQueriesRequest;
use Google\Cloud\Asset\V1\QueryAssetsRequest;
use Google\Cloud\Asset\V1\QueryAssetsResponse;
use Google\Cloud\Asset\V1\SavedQuery;
use Google\Cloud\Asset\V1\SearchAllIamPoliciesRequest;
use Google\Cloud\Asset\V1\SearchAllResourcesRequest;
use Google\Cloud\Asset\V1\UpdateFeedRequest;
use Google\Cloud\Asset\V1\UpdateSavedQueryRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Asset service definition.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<AnalyzeIamPolicyResponse> analyzeIamPolicyAsync(AnalyzeIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> analyzeIamPolicyLongrunningAsync(AnalyzeIamPolicyLongrunningRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AnalyzeMoveResponse> analyzeMoveAsync(AnalyzeMoveRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> analyzeOrgPoliciesAsync(AnalyzeOrgPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> analyzeOrgPolicyGovernedAssetsAsync(AnalyzeOrgPolicyGovernedAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> analyzeOrgPolicyGovernedContainersAsync(AnalyzeOrgPolicyGovernedContainersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BatchGetAssetsHistoryResponse> batchGetAssetsHistoryAsync(BatchGetAssetsHistoryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<BatchGetEffectiveIamPoliciesResponse> batchGetEffectiveIamPoliciesAsync(BatchGetEffectiveIamPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Feed> createFeedAsync(CreateFeedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SavedQuery> createSavedQueryAsync(CreateSavedQueryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteFeedAsync(DeleteFeedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteSavedQueryAsync(DeleteSavedQueryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> exportAssetsAsync(ExportAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Feed> getFeedAsync(GetFeedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SavedQuery> getSavedQueryAsync(GetSavedQueryRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAssetsAsync(ListAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ListFeedsResponse> listFeedsAsync(ListFeedsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listSavedQueriesAsync(ListSavedQueriesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<QueryAssetsResponse> queryAssetsAsync(QueryAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchAllIamPoliciesAsync(SearchAllIamPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> searchAllResourcesAsync(SearchAllResourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Feed> updateFeedAsync(UpdateFeedRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SavedQuery> updateSavedQueryAsync(UpdateSavedQueryRequest $request, array $optionalArgs = [])
 */
final class AssetServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.asset.v1.AssetService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'cloudasset.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'cloudasset.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/asset_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/asset_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/asset_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/asset_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = $this->descriptors[$methodName]['longRunning'] ?? [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a feed
     * resource.
     *
     * @param string $project
     * @param string $feed
     *
     * @return string The formatted feed resource.
     */
    public static function feedName(string $project, string $feed): string
    {
        return self::getPathTemplate('feed')->render([
            'project' => $project,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder_feed
     * resource.
     *
     * @param string $folder
     * @param string $feed
     *
     * @return string The formatted folder_feed resource.
     */
    public static function folderFeedName(string $folder, string $feed): string
    {
        return self::getPathTemplate('folderFeed')->render([
            'folder' => $folder,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_saved_query resource.
     *
     * @param string $folder
     * @param string $savedQuery
     *
     * @return string The formatted folder_saved_query resource.
     */
    public static function folderSavedQueryName(string $folder, string $savedQuery): string
    {
        return self::getPathTemplate('folderSavedQuery')->render([
            'folder' => $folder,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_feed resource.
     *
     * @param string $organization
     * @param string $feed
     *
     * @return string The formatted organization_feed resource.
     */
    public static function organizationFeedName(string $organization, string $feed): string
    {
        return self::getPathTemplate('organizationFeed')->render([
            'organization' => $organization,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_saved_query resource.
     *
     * @param string $organization
     * @param string $savedQuery
     *
     * @return string The formatted organization_saved_query resource.
     */
    public static function organizationSavedQueryName(string $organization, string $savedQuery): string
    {
        return self::getPathTemplate('organizationSavedQuery')->render([
            'organization' => $organization,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project_feed
     * resource.
     *
     * @param string $project
     * @param string $feed
     *
     * @return string The formatted project_feed resource.
     */
    public static function projectFeedName(string $project, string $feed): string
    {
        return self::getPathTemplate('projectFeed')->render([
            'project' => $project,
            'feed' => $feed,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_saved_query resource.
     *
     * @param string $project
     * @param string $savedQuery
     *
     * @return string The formatted project_saved_query resource.
     */
    public static function projectSavedQueryName(string $project, string $savedQuery): string
    {
        return self::getPathTemplate('projectSavedQuery')->render([
            'project' => $project,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a saved_query
     * resource.
     *
     * @param string $project
     * @param string $savedQuery
     *
     * @return string The formatted saved_query resource.
     */
    public static function savedQueryName(string $project, string $savedQuery): string
    {
        return self::getPathTemplate('savedQuery')->render([
            'project' => $project,
            'saved_query' => $savedQuery,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - feed: projects/{project}/feeds/{feed}
     * - folder: folders/{folder}
     * - folderFeed: folders/{folder}/feeds/{feed}
     * - folderSavedQuery: folders/{folder}/savedQueries/{saved_query}
     * - organization: organizations/{organization}
     * - organizationFeed: organizations/{organization}/feeds/{feed}
     * - organizationSavedQuery: organizations/{organization}/savedQueries/{saved_query}
     * - project: projects/{project}
     * - projectFeed: projects/{project}/feeds/{feed}
     * - projectSavedQuery: projects/{project}/savedQueries/{saved_query}
     * - savedQuery: projects/{project}/savedQueries/{saved_query}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'cloudasset.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Asset\V1\AssetServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new AssetServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Analyzes IAM policies to answer which identities have what accesses on
     * which resources.
     *
     * The async variant is {@see AssetServiceClient::analyzeIamPolicyAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_iam_policy.php
     *
     * @param AnalyzeIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnalyzeIamPolicyResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeIamPolicy(
        AnalyzeIamPolicyRequest $request,
        array $callOptions = []
    ): AnalyzeIamPolicyResponse {
        return $this->startApiCall('AnalyzeIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Analyzes IAM policies asynchronously to answer which identities have what
     * accesses on which resources, and writes the analysis results to a Google
     * Cloud Storage or a BigQuery destination. For Cloud Storage destination, the
     * output format is the JSON format that represents a
     * [AnalyzeIamPolicyResponse][google.cloud.asset.v1.AnalyzeIamPolicyResponse].
     * This method implements the
     * [google.longrunning.Operation][google.longrunning.Operation], which allows
     * you to track the operation status. We recommend intervals of at least 2
     * seconds with exponential backoff retry to poll the operation result. The
     * metadata contains the metadata for the long-running operation.
     *
     * The async variant is
     * {@see AssetServiceClient::analyzeIamPolicyLongrunningAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_iam_policy_longrunning.php
     *
     * @param AnalyzeIamPolicyLongrunningRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<AnalyzeIamPolicyLongrunningResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeIamPolicyLongrunning(
        AnalyzeIamPolicyLongrunningRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('AnalyzeIamPolicyLongrunning', $request, $callOptions)->wait();
    }

    /**
     * Analyze moving a resource to a specified destination without kicking off
     * the actual move. The analysis is best effort depending on the user's
     * permissions of viewing different hierarchical policies and configurations.
     * The policies and configuration are subject to change before the actual
     * resource migration takes place.
     *
     * The async variant is {@see AssetServiceClient::analyzeMoveAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_move.php
     *
     * @param AnalyzeMoveRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnalyzeMoveResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeMove(AnalyzeMoveRequest $request, array $callOptions = []): AnalyzeMoveResponse
    {
        return $this->startApiCall('AnalyzeMove', $request, $callOptions)->wait();
    }

    /**
     * Analyzes organization policies under a scope.
     *
     * The async variant is {@see AssetServiceClient::analyzeOrgPoliciesAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_org_policies.php
     *
     * @param AnalyzeOrgPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeOrgPolicies(AnalyzeOrgPoliciesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('AnalyzeOrgPolicies', $request, $callOptions);
    }

    /**
     * Analyzes organization policies governed assets (Google Cloud resources or
     * policies) under a scope. This RPC supports custom constraints and the
     * following canned constraints:
     *
     * * constraints/ainotebooks.accessMode
     * * constraints/ainotebooks.disableFileDownloads
     * * constraints/ainotebooks.disableRootAccess
     * * constraints/ainotebooks.disableTerminal
     * * constraints/ainotebooks.environmentOptions
     * * constraints/ainotebooks.requireAutoUpgradeSchedule
     * * constraints/ainotebooks.restrictVpcNetworks
     * * constraints/compute.disableGuestAttributesAccess
     * * constraints/compute.disableInstanceDataAccessApis
     * * constraints/compute.disableNestedVirtualization
     * * constraints/compute.disableSerialPortAccess
     * * constraints/compute.disableSerialPortLogging
     * * constraints/compute.disableVpcExternalIpv6
     * * constraints/compute.requireOsLogin
     * * constraints/compute.requireShieldedVm
     * * constraints/compute.restrictLoadBalancerCreationForTypes
     * * constraints/compute.restrictProtocolForwardingCreationForTypes
     * * constraints/compute.restrictXpnProjectLienRemoval
     * * constraints/compute.setNewProjectDefaultToZonalDNSOnly
     * * constraints/compute.skipDefaultNetworkCreation
     * * constraints/compute.trustedImageProjects
     * * constraints/compute.vmCanIpForward
     * * constraints/compute.vmExternalIpAccess
     * * constraints/gcp.detailedAuditLoggingMode
     * * constraints/gcp.resourceLocations
     * * constraints/iam.allowedPolicyMemberDomains
     * * constraints/iam.automaticIamGrantsForDefaultServiceAccounts
     * * constraints/iam.disableServiceAccountCreation
     * * constraints/iam.disableServiceAccountKeyCreation
     * * constraints/iam.disableServiceAccountKeyUpload
     * * constraints/iam.restrictCrossProjectServiceAccountLienRemoval
     * * constraints/iam.serviceAccountKeyExpiryHours
     * * constraints/resourcemanager.accessBoundaries
     * * constraints/resourcemanager.allowedExportDestinations
     * * constraints/sql.restrictAuthorizedNetworks
     * * constraints/sql.restrictNoncompliantDiagnosticDataAccess
     * * constraints/sql.restrictNoncompliantResourceCreation
     * * constraints/sql.restrictPublicIp
     * * constraints/storage.publicAccessPrevention
     * * constraints/storage.restrictAuthTypes
     * * constraints/storage.uniformBucketLevelAccess
     *
     * This RPC only returns either resources of types [supported by search
     * APIs](https://cloud.google.com/asset-inventory/docs/supported-asset-types)
     * or IAM policies.
     *
     * The async variant is
     * {@see AssetServiceClient::analyzeOrgPolicyGovernedAssetsAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_org_policy_governed_assets.php
     *
     * @param AnalyzeOrgPolicyGovernedAssetsRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeOrgPolicyGovernedAssets(
        AnalyzeOrgPolicyGovernedAssetsRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('AnalyzeOrgPolicyGovernedAssets', $request, $callOptions);
    }

    /**
     * Analyzes organization policies governed containers (projects, folders or
     * organization) under a scope.
     *
     * The async variant is
     * {@see AssetServiceClient::analyzeOrgPolicyGovernedContainersAsync()} .
     *
     * @example samples/V1/AssetServiceClient/analyze_org_policy_governed_containers.php
     *
     * @param AnalyzeOrgPolicyGovernedContainersRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function analyzeOrgPolicyGovernedContainers(
        AnalyzeOrgPolicyGovernedContainersRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('AnalyzeOrgPolicyGovernedContainers', $request, $callOptions);
    }

    /**
     * Batch gets the update history of assets that overlap a time window.
     * For IAM_POLICY content, this API outputs history when the asset and its
     * attached IAM POLICY both exist. This can create gaps in the output history.
     * Otherwise, this API outputs history with asset in both non-delete or
     * deleted status.
     * If a specified asset does not exist, this API returns an INVALID_ARGUMENT
     * error.
     *
     * The async variant is {@see AssetServiceClient::batchGetAssetsHistoryAsync()} .
     *
     * @example samples/V1/AssetServiceClient/batch_get_assets_history.php
     *
     * @param BatchGetAssetsHistoryRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchGetAssetsHistoryResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchGetAssetsHistory(
        BatchGetAssetsHistoryRequest $request,
        array $callOptions = []
    ): BatchGetAssetsHistoryResponse {
        return $this->startApiCall('BatchGetAssetsHistory', $request, $callOptions)->wait();
    }

    /**
     * Gets effective IAM policies for a batch of resources.
     *
     * The async variant is
     * {@see AssetServiceClient::batchGetEffectiveIamPoliciesAsync()} .
     *
     * @example samples/V1/AssetServiceClient/batch_get_effective_iam_policies.php
     *
     * @param BatchGetEffectiveIamPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchGetEffectiveIamPoliciesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchGetEffectiveIamPolicies(
        BatchGetEffectiveIamPoliciesRequest $request,
        array $callOptions = []
    ): BatchGetEffectiveIamPoliciesResponse {
        return $this->startApiCall('BatchGetEffectiveIamPolicies', $request, $callOptions)->wait();
    }

    /**
     * Creates a feed in a parent project/folder/organization to listen to its
     * asset updates.
     *
     * The async variant is {@see AssetServiceClient::createFeedAsync()} .
     *
     * @example samples/V1/AssetServiceClient/create_feed.php
     *
     * @param CreateFeedRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Feed
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFeed(CreateFeedRequest $request, array $callOptions = []): Feed
    {
        return $this->startApiCall('CreateFeed', $request, $callOptions)->wait();
    }

    /**
     * Creates a saved query in a parent project/folder/organization.
     *
     * The async variant is {@see AssetServiceClient::createSavedQueryAsync()} .
     *
     * @example samples/V1/AssetServiceClient/create_saved_query.php
     *
     * @param CreateSavedQueryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SavedQuery
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSavedQuery(CreateSavedQueryRequest $request, array $callOptions = []): SavedQuery
    {
        return $this->startApiCall('CreateSavedQuery', $request, $callOptions)->wait();
    }

    /**
     * Deletes an asset feed.
     *
     * The async variant is {@see AssetServiceClient::deleteFeedAsync()} .
     *
     * @example samples/V1/AssetServiceClient/delete_feed.php
     *
     * @param DeleteFeedRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFeed(DeleteFeedRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteFeed', $request, $callOptions)->wait();
    }

    /**
     * Deletes a saved query.
     *
     * The async variant is {@see AssetServiceClient::deleteSavedQueryAsync()} .
     *
     * @example samples/V1/AssetServiceClient/delete_saved_query.php
     *
     * @param DeleteSavedQueryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSavedQuery(DeleteSavedQueryRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteSavedQuery', $request, $callOptions)->wait();
    }

    /**
     * Exports assets with time and resource types to a given Cloud Storage
     * location/BigQuery table. For Cloud Storage location destinations, the
     * output format is newline-delimited JSON. Each line represents a
     * [google.cloud.asset.v1.Asset][google.cloud.asset.v1.Asset] in the JSON
     * format; for BigQuery table destinations, the output table stores the fields
     * in asset Protobuf as columns. This API implements the
     * [google.longrunning.Operation][google.longrunning.Operation] API, which
     * allows you to keep track of the export. We recommend intervals of at least
     * 2 seconds with exponential retry to poll the export operation result. For
     * regular-size resource parent, the export operation usually finishes within
     * 5 minutes.
     *
     * The async variant is {@see AssetServiceClient::exportAssetsAsync()} .
     *
     * @example samples/V1/AssetServiceClient/export_assets.php
     *
     * @param ExportAssetsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse<ExportAssetsResponse>
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function exportAssets(ExportAssetsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ExportAssets', $request, $callOptions)->wait();
    }

    /**
     * Gets details about an asset feed.
     *
     * The async variant is {@see AssetServiceClient::getFeedAsync()} .
     *
     * @example samples/V1/AssetServiceClient/get_feed.php
     *
     * @param GetFeedRequest $request     A request to house fields associated with the call.
     * @param array          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Feed
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFeed(GetFeedRequest $request, array $callOptions = []): Feed
    {
        return $this->startApiCall('GetFeed', $request, $callOptions)->wait();
    }

    /**
     * Gets details about a saved query.
     *
     * The async variant is {@see AssetServiceClient::getSavedQueryAsync()} .
     *
     * @example samples/V1/AssetServiceClient/get_saved_query.php
     *
     * @param GetSavedQueryRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SavedQuery
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSavedQuery(GetSavedQueryRequest $request, array $callOptions = []): SavedQuery
    {
        return $this->startApiCall('GetSavedQuery', $request, $callOptions)->wait();
    }

    /**
     * Lists assets with time and resource types and returns paged results in
     * response.
     *
     * The async variant is {@see AssetServiceClient::listAssetsAsync()} .
     *
     * @example samples/V1/AssetServiceClient/list_assets.php
     *
     * @param ListAssetsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAssets(ListAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssets', $request, $callOptions);
    }

    /**
     * Lists all asset feeds in a parent project/folder/organization.
     *
     * The async variant is {@see AssetServiceClient::listFeedsAsync()} .
     *
     * @example samples/V1/AssetServiceClient/list_feeds.php
     *
     * @param ListFeedsRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ListFeedsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFeeds(ListFeedsRequest $request, array $callOptions = []): ListFeedsResponse
    {
        return $this->startApiCall('ListFeeds', $request, $callOptions)->wait();
    }

    /**
     * Lists all saved queries in a parent project/folder/organization.
     *
     * The async variant is {@see AssetServiceClient::listSavedQueriesAsync()} .
     *
     * @example samples/V1/AssetServiceClient/list_saved_queries.php
     *
     * @param ListSavedQueriesRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSavedQueries(ListSavedQueriesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSavedQueries', $request, $callOptions);
    }

    /**
     * Issue a job that queries assets using a SQL statement compatible with
     * [BigQuery SQL](https://cloud.google.com/bigquery/docs/introduction-sql).
     *
     * If the query execution finishes within timeout and there's no pagination,
     * the full query results will be returned in the `QueryAssetsResponse`.
     *
     * Otherwise, full query results can be obtained by issuing extra requests
     * with the `job_reference` from the a previous `QueryAssets` call.
     *
     * Note, the query result has approximately 10 GB limitation enforced by
     * [BigQuery](https://cloud.google.com/bigquery/docs/best-practices-performance-output).
     * Queries return larger results will result in errors.
     *
     * The async variant is {@see AssetServiceClient::queryAssetsAsync()} .
     *
     * @example samples/V1/AssetServiceClient/query_assets.php
     *
     * @param QueryAssetsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return QueryAssetsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function queryAssets(QueryAssetsRequest $request, array $callOptions = []): QueryAssetsResponse
    {
        return $this->startApiCall('QueryAssets', $request, $callOptions)->wait();
    }

    /**
     * Searches all IAM policies within the specified scope, such as a project,
     * folder, or organization. The caller must be granted the
     * `cloudasset.assets.searchAllIamPolicies` permission on the desired scope,
     * otherwise the request will be rejected.
     *
     * The async variant is {@see AssetServiceClient::searchAllIamPoliciesAsync()} .
     *
     * @example samples/V1/AssetServiceClient/search_all_iam_policies.php
     *
     * @param SearchAllIamPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchAllIamPolicies(
        SearchAllIamPoliciesRequest $request,
        array $callOptions = []
    ): PagedListResponse {
        return $this->startApiCall('SearchAllIamPolicies', $request, $callOptions);
    }

    /**
     * Searches all Google Cloud resources within the specified scope, such as a
     * project, folder, or organization. The caller must be granted the
     * `cloudasset.assets.searchAllResources` permission on the desired scope,
     * otherwise the request will be rejected.
     *
     * The async variant is {@see AssetServiceClient::searchAllResourcesAsync()} .
     *
     * @example samples/V1/AssetServiceClient/search_all_resources.php
     *
     * @param SearchAllResourcesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function searchAllResources(SearchAllResourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('SearchAllResources', $request, $callOptions);
    }

    /**
     * Updates an asset feed configuration.
     *
     * The async variant is {@see AssetServiceClient::updateFeedAsync()} .
     *
     * @example samples/V1/AssetServiceClient/update_feed.php
     *
     * @param UpdateFeedRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Feed
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFeed(UpdateFeedRequest $request, array $callOptions = []): Feed
    {
        return $this->startApiCall('UpdateFeed', $request, $callOptions)->wait();
    }

    /**
     * Updates a saved query.
     *
     * The async variant is {@see AssetServiceClient::updateSavedQueryAsync()} .
     *
     * @example samples/V1/AssetServiceClient/update_saved_query.php
     *
     * @param UpdateSavedQueryRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SavedQuery
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSavedQuery(UpdateSavedQueryRequest $request, array $callOptions = []): SavedQuery
    {
        return $this->startApiCall('UpdateSavedQuery', $request, $callOptions)->wait();
    }
}
