<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/apps/events/subscriptions/v1beta/subscription_resource.proto

namespace Google\Apps\Events\Subscriptions\V1beta;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The endpoint where the subscription delivers events.
 *
 * Generated from protobuf message <code>google.apps.events.subscriptions.v1beta.NotificationEndpoint</code>
 */
class NotificationEndpoint extends \Google\Protobuf\Internal\Message
{
    protected $endpoint;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $pubsub_topic
     *           Immutable. The Pub/Sub topic that receives events for the subscription.
     *           Format: `projects/{project}/topics/{topic}`
     *           You must create the topic in the same Google Cloud project where
     *           you create this subscription.
     *           Note: The Workspace Events API uses [ordering
     *           keys](https://cloud.google.com/pubsub/docs/ordering) for the benefit of
     *           sequential events. If the Cloud Pub/Sub topic has a [message storage
     *           policy](https://cloud.google.com/pubsub/docs/resource-location-restriction#exceptions)
     *           configured to exclude the nearest Google Cloud region, publishing events
     *           with ordering keys will fail.
     *           When the topic receives events, the events are encoded as Pub/Sub
     *           messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for
     *           CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Apps\Events\Subscriptions\V1Beta\SubscriptionResource::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. The Pub/Sub topic that receives events for the subscription.
     * Format: `projects/{project}/topics/{topic}`
     * You must create the topic in the same Google Cloud project where
     * you create this subscription.
     * Note: The Workspace Events API uses [ordering
     * keys](https://cloud.google.com/pubsub/docs/ordering) for the benefit of
     * sequential events. If the Cloud Pub/Sub topic has a [message storage
     * policy](https://cloud.google.com/pubsub/docs/resource-location-restriction#exceptions)
     * configured to exclude the nearest Google Cloud region, publishing events
     * with ordering keys will fail.
     * When the topic receives events, the events are encoded as Pub/Sub
     * messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for
     * CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
     *
     * Generated from protobuf field <code>string pubsub_topic = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getPubsubTopic()
    {
        return $this->readOneof(1);
    }

    public function hasPubsubTopic()
    {
        return $this->hasOneof(1);
    }

    /**
     * Immutable. The Pub/Sub topic that receives events for the subscription.
     * Format: `projects/{project}/topics/{topic}`
     * You must create the topic in the same Google Cloud project where
     * you create this subscription.
     * Note: The Workspace Events API uses [ordering
     * keys](https://cloud.google.com/pubsub/docs/ordering) for the benefit of
     * sequential events. If the Cloud Pub/Sub topic has a [message storage
     * policy](https://cloud.google.com/pubsub/docs/resource-location-restriction#exceptions)
     * configured to exclude the nearest Google Cloud region, publishing events
     * with ordering keys will fail.
     * When the topic receives events, the events are encoded as Pub/Sub
     * messages. For details, see the [Google Cloud Pub/Sub Protocol Binding for
     * CloudEvents](https://github.com/googleapis/google-cloudevents/blob/main/docs/spec/pubsub.md).
     *
     * Generated from protobuf field <code>string pubsub_topic = 1 [(.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setPubsubTopic($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getEndpoint()
    {
        return $this->whichOneof("endpoint");
    }

}

