<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/css/v1/css_product_common.proto

namespace Google\Shopping\Css\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Attributes for CSS Product.
 *
 * Generated from protobuf message <code>google.shopping.css.v1.Attributes</code>
 */
class Attributes extends \Google\Protobuf\Internal\Message
{
    /**
     * URL directly linking to your the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_link = 1;</code>
     */
    protected $cpp_link = null;
    /**
     * URL for the mobile-optimized version of the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_mobile_link = 2;</code>
     */
    protected $cpp_mobile_link = null;
    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product Ads.
     *
     * Generated from protobuf field <code>optional string cpp_ads_redirect = 42;</code>
     */
    protected $cpp_ads_redirect = null;
    /**
     * Low Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price low_price = 3;</code>
     */
    protected $low_price = null;
    /**
     * High Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price high_price = 4;</code>
     */
    protected $high_price = null;
    /**
     * The number of aggregate offers.
     *
     * Generated from protobuf field <code>optional int64 number_of_offers = 5;</code>
     */
    protected $number_of_offers = null;
    /**
     * Condition of the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_condition = 6;</code>
     */
    protected $headline_offer_condition = null;
    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_price = 7;</code>
     */
    protected $headline_offer_price = null;
    /**
     * Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_link = 8;</code>
     */
    protected $headline_offer_link = null;
    /**
     * Mobile Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_mobile_link = 9;</code>
     */
    protected $headline_offer_mobile_link = null;
    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_shipping_price = 41;</code>
     */
    protected $headline_offer_shipping_price = null;
    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 10;</code>
     */
    protected $title = null;
    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     */
    protected $image_link = null;
    /**
     * Additional URL of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     */
    private $additional_image_links;
    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 13;</code>
     */
    protected $description = null;
    /**
     * Product Related Attributes.[14-36]
     * Brand of the item.
     *
     * Generated from protobuf field <code>optional string brand = 14;</code>
     */
    protected $brand = null;
    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 15;</code>
     */
    protected $mpn = null;
    /**
     * Global Trade Item Number
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string gtin = 16;</code>
     */
    protected $gtin = null;
    /**
     * Categories of the item (formatted as in [products data
     * specification](https://support.google.com/merchants/answer/6324406)).
     *
     * Generated from protobuf field <code>repeated string product_types = 36;</code>
     */
    private $product_types;
    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 17;</code>
     */
    protected $google_product_category = null;
    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 18;</code>
     */
    protected $adult = null;
    /**
     * The number of identical products in a merchant-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 19;</code>
     */
    protected $multipack = null;
    /**
     * Whether the item is a merchant-defined bundle. A bundle is a custom
     * grouping of different products sold by a merchant for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 20;</code>
     */
    protected $is_bundle = null;
    /**
     * Target age group of the item.
     *
     * Generated from protobuf field <code>optional string age_group = 21;</code>
     */
    protected $age_group = null;
    /**
     * Color of the item.
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     */
    protected $color = null;
    /**
     * Target gender of the item.
     *
     * Generated from protobuf field <code>optional string gender = 23;</code>
     */
    protected $gender = null;
    /**
     * The material of which the item is made.
     *
     * Generated from protobuf field <code>optional string material = 24;</code>
     */
    protected $material = null;
    /**
     * The item's pattern (e.g. polka dots).
     *
     * Generated from protobuf field <code>optional string pattern = 25;</code>
     */
    protected $pattern = null;
    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value (see
     * [https://support.google.com/merchants/answer/6324492](size definition)).
     *
     * Generated from protobuf field <code>optional string size = 26;</code>
     */
    protected $size = null;
    /**
     * System in which the size is specified. Recommended for apparel items.
     *
     * Generated from protobuf field <code>optional string size_system = 27;</code>
     */
    protected $size_system = null;
    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided (see
     * [https://support.google.com/merchants/answer/6324497](size type)).
     *
     * Generated from protobuf field <code>repeated string size_types = 28;</code>
     */
    private $size_types;
    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 29;</code>
     */
    protected $item_group_id = null;
    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.ProductDetail product_details = 30;</code>
     */
    private $product_details;
    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductWeight product_weight = 31;</code>
     */
    protected $product_weight = null;
    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_length = 32;</code>
     */
    protected $product_length = null;
    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_width = 33;</code>
     */
    protected $product_width = null;
    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_height = 34;</code>
     */
    protected $product_height = null;
    /**
     * Bullet points describing the most relevant highlights of a product.
     *
     * Generated from protobuf field <code>repeated string product_highlights = 35;</code>
     */
    private $product_highlights;
    /**
     * A list of certificates claimed by the CSS for the given product.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.Certification certifications = 39;</code>
     */
    private $certifications;
    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     * Note: It may take 2+ days from the expiration date for the item to
     * actually get deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 40;</code>
     */
    protected $expiration_date = null;
    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     *
     * Generated from protobuf field <code>repeated string included_destinations = 43;</code>
     */
    private $included_destinations;
    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     *
     * Generated from protobuf field <code>repeated string excluded_destinations = 44;</code>
     */
    private $excluded_destinations;
    /**
     * Publication of this item will be temporarily paused.
     *
     * Generated from protobuf field <code>optional string pause = 45;</code>
     */
    protected $pause = null;
    /**
     * Custom label 0 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 46;</code>
     */
    protected $custom_label_0 = null;
    /**
     * Custom label 1 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 47;</code>
     */
    protected $custom_label_1 = null;
    /**
     * Custom label 2 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 48;</code>
     */
    protected $custom_label_2 = null;
    /**
     * Custom label 3 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 49;</code>
     */
    protected $custom_label_3 = null;
    /**
     * Custom label 4 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 50;</code>
     */
    protected $custom_label_4 = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $cpp_link
     *           URL directly linking to your the Product Detail Page of the CSS.
     *     @type string $cpp_mobile_link
     *           URL for the mobile-optimized version of the Product Detail Page of the CSS.
     *     @type string $cpp_ads_redirect
     *           Allows advertisers to override the item URL when the product is shown
     *           within the context of Product Ads.
     *     @type \Google\Shopping\Type\Price $low_price
     *           Low Price of the aggregate offer.
     *     @type \Google\Shopping\Type\Price $high_price
     *           High Price of the aggregate offer.
     *     @type int|string $number_of_offers
     *           The number of aggregate offers.
     *     @type string $headline_offer_condition
     *           Condition of the headline offer.
     *     @type \Google\Shopping\Type\Price $headline_offer_price
     *           Headline Price of the aggregate offer.
     *     @type string $headline_offer_link
     *           Link to the headline offer.
     *     @type string $headline_offer_mobile_link
     *           Mobile Link to the headline offer.
     *     @type \Google\Shopping\Type\Price $headline_offer_shipping_price
     *           Headline Price of the aggregate offer.
     *     @type string $title
     *           Title of the item.
     *     @type string $image_link
     *           URL of an image of the item.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $additional_image_links
     *           Additional URL of images of the item.
     *     @type string $description
     *           Description of the item.
     *     @type string $brand
     *           Product Related Attributes.[14-36]
     *           Brand of the item.
     *     @type string $mpn
     *           Manufacturer Part Number
     *           ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     *           item.
     *     @type string $gtin
     *           Global Trade Item Number
     *           ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     *           item.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_types
     *           Categories of the item (formatted as in [products data
     *           specification](https://support.google.com/merchants/answer/6324406)).
     *     @type string $google_product_category
     *           Google's category of the item (see [Google product
     *           taxonomy](https://support.google.com/merchants/answer/1705911)). When
     *           querying products, this field will contain the user provided value. There
     *           is currently no way to get back the auto assigned google product
     *           categories through the API.
     *     @type bool $adult
     *           Set to true if the item is targeted towards adults.
     *     @type int|string $multipack
     *           The number of identical products in a merchant-defined multipack.
     *     @type bool $is_bundle
     *           Whether the item is a merchant-defined bundle. A bundle is a custom
     *           grouping of different products sold by a merchant for a single price.
     *     @type string $age_group
     *           Target age group of the item.
     *     @type string $color
     *           Color of the item.
     *     @type string $gender
     *           Target gender of the item.
     *     @type string $material
     *           The material of which the item is made.
     *     @type string $pattern
     *           The item's pattern (e.g. polka dots).
     *     @type string $size
     *           Size of the item. Only one value is allowed. For variants with different
     *           sizes, insert a separate product for each size with the same
     *           `itemGroupId` value (see
     *           [https://support.google.com/merchants/answer/6324492](size definition)).
     *     @type string $size_system
     *           System in which the size is specified. Recommended for apparel items.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $size_types
     *           The cut of the item. It can be used to represent combined size types for
     *           apparel items. Maximum two of size types can be provided (see
     *           [https://support.google.com/merchants/answer/6324497](size type)).
     *     @type string $item_group_id
     *           Shared identifier for all variants of the same product.
     *     @type array<\Google\Shopping\Css\V1\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $product_details
     *           Technical specification or additional product details.
     *     @type \Google\Shopping\Css\V1\ProductWeight $product_weight
     *           The weight of the product in the units provided. The value must be
     *           between 0 (exclusive) and 2000 (inclusive).
     *     @type \Google\Shopping\Css\V1\ProductDimension $product_length
     *           The length of the product in the units provided. The value must be
     *           between 0 (exclusive) and 3000 (inclusive).
     *     @type \Google\Shopping\Css\V1\ProductDimension $product_width
     *           The width of the product in the units provided. The value must be between
     *           0 (exclusive) and 3000 (inclusive).
     *     @type \Google\Shopping\Css\V1\ProductDimension $product_height
     *           The height of the product in the units provided. The value must be
     *           between
     *           0 (exclusive) and 3000 (inclusive).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $product_highlights
     *           Bullet points describing the most relevant highlights of a product.
     *     @type array<\Google\Shopping\Css\V1\Certification>|\Google\Protobuf\Internal\RepeatedField $certifications
     *           A list of certificates claimed by the CSS for the given product.
     *     @type \Google\Protobuf\Timestamp $expiration_date
     *           Date on which the item should expire, as specified upon insertion, in
     *           [ISO
     *           8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     *           expiration date is exposed in `productstatuses` as
     *           [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     *           and might be earlier if `expirationDate` is too far in the future.
     *           Note: It may take 2+ days from the expiration date for the item to
     *           actually get deleted.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $included_destinations
     *           The list of destinations to include for this target (corresponds to
     *           checked check boxes in Merchant Center). Default destinations are always
     *           included unless provided in `excludedDestinations`.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $excluded_destinations
     *           The list of destinations to exclude for this target (corresponds to
     *           unchecked check boxes in Merchant Center).
     *     @type string $pause
     *           Publication of this item will be temporarily paused.
     *     @type string $custom_label_0
     *           Custom label 0 for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_1
     *           Custom label 1 for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_2
     *           Custom label 2 for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_3
     *           Custom label 3 for custom grouping of items in a Shopping campaign.
     *     @type string $custom_label_4
     *           Custom label 4 for custom grouping of items in a Shopping campaign.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Css\V1\CssProductCommon::initOnce();
        parent::__construct($data);
    }

    /**
     * URL directly linking to your the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_link = 1;</code>
     * @return string
     */
    public function getCppLink()
    {
        return isset($this->cpp_link) ? $this->cpp_link : '';
    }

    public function hasCppLink()
    {
        return isset($this->cpp_link);
    }

    public function clearCppLink()
    {
        unset($this->cpp_link);
    }

    /**
     * URL directly linking to your the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_link = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setCppLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpp_link = $var;

        return $this;
    }

    /**
     * URL for the mobile-optimized version of the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_mobile_link = 2;</code>
     * @return string
     */
    public function getCppMobileLink()
    {
        return isset($this->cpp_mobile_link) ? $this->cpp_mobile_link : '';
    }

    public function hasCppMobileLink()
    {
        return isset($this->cpp_mobile_link);
    }

    public function clearCppMobileLink()
    {
        unset($this->cpp_mobile_link);
    }

    /**
     * URL for the mobile-optimized version of the Product Detail Page of the CSS.
     *
     * Generated from protobuf field <code>optional string cpp_mobile_link = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setCppMobileLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpp_mobile_link = $var;

        return $this;
    }

    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product Ads.
     *
     * Generated from protobuf field <code>optional string cpp_ads_redirect = 42;</code>
     * @return string
     */
    public function getCppAdsRedirect()
    {
        return isset($this->cpp_ads_redirect) ? $this->cpp_ads_redirect : '';
    }

    public function hasCppAdsRedirect()
    {
        return isset($this->cpp_ads_redirect);
    }

    public function clearCppAdsRedirect()
    {
        unset($this->cpp_ads_redirect);
    }

    /**
     * Allows advertisers to override the item URL when the product is shown
     * within the context of Product Ads.
     *
     * Generated from protobuf field <code>optional string cpp_ads_redirect = 42;</code>
     * @param string $var
     * @return $this
     */
    public function setCppAdsRedirect($var)
    {
        GPBUtil::checkString($var, True);
        $this->cpp_ads_redirect = $var;

        return $this;
    }

    /**
     * Low Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price low_price = 3;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getLowPrice()
    {
        return $this->low_price;
    }

    public function hasLowPrice()
    {
        return isset($this->low_price);
    }

    public function clearLowPrice()
    {
        unset($this->low_price);
    }

    /**
     * Low Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price low_price = 3;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setLowPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->low_price = $var;

        return $this;
    }

    /**
     * High Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price high_price = 4;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getHighPrice()
    {
        return $this->high_price;
    }

    public function hasHighPrice()
    {
        return isset($this->high_price);
    }

    public function clearHighPrice()
    {
        unset($this->high_price);
    }

    /**
     * High Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price high_price = 4;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setHighPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->high_price = $var;

        return $this;
    }

    /**
     * The number of aggregate offers.
     *
     * Generated from protobuf field <code>optional int64 number_of_offers = 5;</code>
     * @return int|string
     */
    public function getNumberOfOffers()
    {
        return isset($this->number_of_offers) ? $this->number_of_offers : 0;
    }

    public function hasNumberOfOffers()
    {
        return isset($this->number_of_offers);
    }

    public function clearNumberOfOffers()
    {
        unset($this->number_of_offers);
    }

    /**
     * The number of aggregate offers.
     *
     * Generated from protobuf field <code>optional int64 number_of_offers = 5;</code>
     * @param int|string $var
     * @return $this
     */
    public function setNumberOfOffers($var)
    {
        GPBUtil::checkInt64($var);
        $this->number_of_offers = $var;

        return $this;
    }

    /**
     * Condition of the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_condition = 6;</code>
     * @return string
     */
    public function getHeadlineOfferCondition()
    {
        return isset($this->headline_offer_condition) ? $this->headline_offer_condition : '';
    }

    public function hasHeadlineOfferCondition()
    {
        return isset($this->headline_offer_condition);
    }

    public function clearHeadlineOfferCondition()
    {
        unset($this->headline_offer_condition);
    }

    /**
     * Condition of the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_condition = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setHeadlineOfferCondition($var)
    {
        GPBUtil::checkString($var, True);
        $this->headline_offer_condition = $var;

        return $this;
    }

    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_price = 7;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getHeadlineOfferPrice()
    {
        return $this->headline_offer_price;
    }

    public function hasHeadlineOfferPrice()
    {
        return isset($this->headline_offer_price);
    }

    public function clearHeadlineOfferPrice()
    {
        unset($this->headline_offer_price);
    }

    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_price = 7;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setHeadlineOfferPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->headline_offer_price = $var;

        return $this;
    }

    /**
     * Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_link = 8;</code>
     * @return string
     */
    public function getHeadlineOfferLink()
    {
        return isset($this->headline_offer_link) ? $this->headline_offer_link : '';
    }

    public function hasHeadlineOfferLink()
    {
        return isset($this->headline_offer_link);
    }

    public function clearHeadlineOfferLink()
    {
        unset($this->headline_offer_link);
    }

    /**
     * Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_link = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setHeadlineOfferLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->headline_offer_link = $var;

        return $this;
    }

    /**
     * Mobile Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_mobile_link = 9;</code>
     * @return string
     */
    public function getHeadlineOfferMobileLink()
    {
        return isset($this->headline_offer_mobile_link) ? $this->headline_offer_mobile_link : '';
    }

    public function hasHeadlineOfferMobileLink()
    {
        return isset($this->headline_offer_mobile_link);
    }

    public function clearHeadlineOfferMobileLink()
    {
        unset($this->headline_offer_mobile_link);
    }

    /**
     * Mobile Link to the headline offer.
     *
     * Generated from protobuf field <code>optional string headline_offer_mobile_link = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setHeadlineOfferMobileLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->headline_offer_mobile_link = $var;

        return $this;
    }

    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_shipping_price = 41;</code>
     * @return \Google\Shopping\Type\Price|null
     */
    public function getHeadlineOfferShippingPrice()
    {
        return $this->headline_offer_shipping_price;
    }

    public function hasHeadlineOfferShippingPrice()
    {
        return isset($this->headline_offer_shipping_price);
    }

    public function clearHeadlineOfferShippingPrice()
    {
        unset($this->headline_offer_shipping_price);
    }

    /**
     * Headline Price of the aggregate offer.
     *
     * Generated from protobuf field <code>.google.shopping.type.Price headline_offer_shipping_price = 41;</code>
     * @param \Google\Shopping\Type\Price $var
     * @return $this
     */
    public function setHeadlineOfferShippingPrice($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Type\Price::class);
        $this->headline_offer_shipping_price = $var;

        return $this;
    }

    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 10;</code>
     * @return string
     */
    public function getTitle()
    {
        return isset($this->title) ? $this->title : '';
    }

    public function hasTitle()
    {
        return isset($this->title);
    }

    public function clearTitle()
    {
        unset($this->title);
    }

    /**
     * Title of the item.
     *
     * Generated from protobuf field <code>optional string title = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     * @return string
     */
    public function getImageLink()
    {
        return isset($this->image_link) ? $this->image_link : '';
    }

    public function hasImageLink()
    {
        return isset($this->image_link);
    }

    public function clearImageLink()
    {
        unset($this->image_link);
    }

    /**
     * URL of an image of the item.
     *
     * Generated from protobuf field <code>optional string image_link = 11;</code>
     * @param string $var
     * @return $this
     */
    public function setImageLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->image_link = $var;

        return $this;
    }

    /**
     * Additional URL of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalImageLinks()
    {
        return $this->additional_image_links;
    }

    /**
     * Additional URL of images of the item.
     *
     * Generated from protobuf field <code>repeated string additional_image_links = 12;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalImageLinks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->additional_image_links = $arr;

        return $this;
    }

    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 13;</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * Description of the item.
     *
     * Generated from protobuf field <code>optional string description = 13;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Product Related Attributes.[14-36]
     * Brand of the item.
     *
     * Generated from protobuf field <code>optional string brand = 14;</code>
     * @return string
     */
    public function getBrand()
    {
        return isset($this->brand) ? $this->brand : '';
    }

    public function hasBrand()
    {
        return isset($this->brand);
    }

    public function clearBrand()
    {
        unset($this->brand);
    }

    /**
     * Product Related Attributes.[14-36]
     * Brand of the item.
     *
     * Generated from protobuf field <code>optional string brand = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setBrand($var)
    {
        GPBUtil::checkString($var, True);
        $this->brand = $var;

        return $this;
    }

    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 15;</code>
     * @return string
     */
    public function getMpn()
    {
        return isset($this->mpn) ? $this->mpn : '';
    }

    public function hasMpn()
    {
        return isset($this->mpn);
    }

    public function clearMpn()
    {
        unset($this->mpn);
    }

    /**
     * Manufacturer Part Number
     * ([MPN](https://support.google.com/merchants/answer/188494#mpn)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string mpn = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setMpn($var)
    {
        GPBUtil::checkString($var, True);
        $this->mpn = $var;

        return $this;
    }

    /**
     * Global Trade Item Number
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string gtin = 16;</code>
     * @return string
     */
    public function getGtin()
    {
        return isset($this->gtin) ? $this->gtin : '';
    }

    public function hasGtin()
    {
        return isset($this->gtin);
    }

    public function clearGtin()
    {
        unset($this->gtin);
    }

    /**
     * Global Trade Item Number
     * ([GTIN](https://support.google.com/merchants/answer/188494#gtin)) of the
     * item.
     *
     * Generated from protobuf field <code>optional string gtin = 16;</code>
     * @param string $var
     * @return $this
     */
    public function setGtin($var)
    {
        GPBUtil::checkString($var, True);
        $this->gtin = $var;

        return $this;
    }

    /**
     * Categories of the item (formatted as in [products data
     * specification](https://support.google.com/merchants/answer/6324406)).
     *
     * Generated from protobuf field <code>repeated string product_types = 36;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductTypes()
    {
        return $this->product_types;
    }

    /**
     * Categories of the item (formatted as in [products data
     * specification](https://support.google.com/merchants/answer/6324406)).
     *
     * Generated from protobuf field <code>repeated string product_types = 36;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_types = $arr;

        return $this;
    }

    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 17;</code>
     * @return string
     */
    public function getGoogleProductCategory()
    {
        return isset($this->google_product_category) ? $this->google_product_category : '';
    }

    public function hasGoogleProductCategory()
    {
        return isset($this->google_product_category);
    }

    public function clearGoogleProductCategory()
    {
        unset($this->google_product_category);
    }

    /**
     * Google's category of the item (see [Google product
     * taxonomy](https://support.google.com/merchants/answer/1705911)). When
     * querying products, this field will contain the user provided value. There
     * is currently no way to get back the auto assigned google product
     * categories through the API.
     *
     * Generated from protobuf field <code>optional string google_product_category = 17;</code>
     * @param string $var
     * @return $this
     */
    public function setGoogleProductCategory($var)
    {
        GPBUtil::checkString($var, True);
        $this->google_product_category = $var;

        return $this;
    }

    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 18;</code>
     * @return bool
     */
    public function getAdult()
    {
        return isset($this->adult) ? $this->adult : false;
    }

    public function hasAdult()
    {
        return isset($this->adult);
    }

    public function clearAdult()
    {
        unset($this->adult);
    }

    /**
     * Set to true if the item is targeted towards adults.
     *
     * Generated from protobuf field <code>optional bool adult = 18;</code>
     * @param bool $var
     * @return $this
     */
    public function setAdult($var)
    {
        GPBUtil::checkBool($var);
        $this->adult = $var;

        return $this;
    }

    /**
     * The number of identical products in a merchant-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 19;</code>
     * @return int|string
     */
    public function getMultipack()
    {
        return isset($this->multipack) ? $this->multipack : 0;
    }

    public function hasMultipack()
    {
        return isset($this->multipack);
    }

    public function clearMultipack()
    {
        unset($this->multipack);
    }

    /**
     * The number of identical products in a merchant-defined multipack.
     *
     * Generated from protobuf field <code>optional int64 multipack = 19;</code>
     * @param int|string $var
     * @return $this
     */
    public function setMultipack($var)
    {
        GPBUtil::checkInt64($var);
        $this->multipack = $var;

        return $this;
    }

    /**
     * Whether the item is a merchant-defined bundle. A bundle is a custom
     * grouping of different products sold by a merchant for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 20;</code>
     * @return bool
     */
    public function getIsBundle()
    {
        return isset($this->is_bundle) ? $this->is_bundle : false;
    }

    public function hasIsBundle()
    {
        return isset($this->is_bundle);
    }

    public function clearIsBundle()
    {
        unset($this->is_bundle);
    }

    /**
     * Whether the item is a merchant-defined bundle. A bundle is a custom
     * grouping of different products sold by a merchant for a single price.
     *
     * Generated from protobuf field <code>optional bool is_bundle = 20;</code>
     * @param bool $var
     * @return $this
     */
    public function setIsBundle($var)
    {
        GPBUtil::checkBool($var);
        $this->is_bundle = $var;

        return $this;
    }

    /**
     * Target age group of the item.
     *
     * Generated from protobuf field <code>optional string age_group = 21;</code>
     * @return string
     */
    public function getAgeGroup()
    {
        return isset($this->age_group) ? $this->age_group : '';
    }

    public function hasAgeGroup()
    {
        return isset($this->age_group);
    }

    public function clearAgeGroup()
    {
        unset($this->age_group);
    }

    /**
     * Target age group of the item.
     *
     * Generated from protobuf field <code>optional string age_group = 21;</code>
     * @param string $var
     * @return $this
     */
    public function setAgeGroup($var)
    {
        GPBUtil::checkString($var, True);
        $this->age_group = $var;

        return $this;
    }

    /**
     * Color of the item.
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     * @return string
     */
    public function getColor()
    {
        return isset($this->color) ? $this->color : '';
    }

    public function hasColor()
    {
        return isset($this->color);
    }

    public function clearColor()
    {
        unset($this->color);
    }

    /**
     * Color of the item.
     *
     * Generated from protobuf field <code>optional string color = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setColor($var)
    {
        GPBUtil::checkString($var, True);
        $this->color = $var;

        return $this;
    }

    /**
     * Target gender of the item.
     *
     * Generated from protobuf field <code>optional string gender = 23;</code>
     * @return string
     */
    public function getGender()
    {
        return isset($this->gender) ? $this->gender : '';
    }

    public function hasGender()
    {
        return isset($this->gender);
    }

    public function clearGender()
    {
        unset($this->gender);
    }

    /**
     * Target gender of the item.
     *
     * Generated from protobuf field <code>optional string gender = 23;</code>
     * @param string $var
     * @return $this
     */
    public function setGender($var)
    {
        GPBUtil::checkString($var, True);
        $this->gender = $var;

        return $this;
    }

    /**
     * The material of which the item is made.
     *
     * Generated from protobuf field <code>optional string material = 24;</code>
     * @return string
     */
    public function getMaterial()
    {
        return isset($this->material) ? $this->material : '';
    }

    public function hasMaterial()
    {
        return isset($this->material);
    }

    public function clearMaterial()
    {
        unset($this->material);
    }

    /**
     * The material of which the item is made.
     *
     * Generated from protobuf field <code>optional string material = 24;</code>
     * @param string $var
     * @return $this
     */
    public function setMaterial($var)
    {
        GPBUtil::checkString($var, True);
        $this->material = $var;

        return $this;
    }

    /**
     * The item's pattern (e.g. polka dots).
     *
     * Generated from protobuf field <code>optional string pattern = 25;</code>
     * @return string
     */
    public function getPattern()
    {
        return isset($this->pattern) ? $this->pattern : '';
    }

    public function hasPattern()
    {
        return isset($this->pattern);
    }

    public function clearPattern()
    {
        unset($this->pattern);
    }

    /**
     * The item's pattern (e.g. polka dots).
     *
     * Generated from protobuf field <code>optional string pattern = 25;</code>
     * @param string $var
     * @return $this
     */
    public function setPattern($var)
    {
        GPBUtil::checkString($var, True);
        $this->pattern = $var;

        return $this;
    }

    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value (see
     * [https://support.google.com/merchants/answer/6324492](size definition)).
     *
     * Generated from protobuf field <code>optional string size = 26;</code>
     * @return string
     */
    public function getSize()
    {
        return isset($this->size) ? $this->size : '';
    }

    public function hasSize()
    {
        return isset($this->size);
    }

    public function clearSize()
    {
        unset($this->size);
    }

    /**
     * Size of the item. Only one value is allowed. For variants with different
     * sizes, insert a separate product for each size with the same
     * `itemGroupId` value (see
     * [https://support.google.com/merchants/answer/6324492](size definition)).
     *
     * Generated from protobuf field <code>optional string size = 26;</code>
     * @param string $var
     * @return $this
     */
    public function setSize($var)
    {
        GPBUtil::checkString($var, True);
        $this->size = $var;

        return $this;
    }

    /**
     * System in which the size is specified. Recommended for apparel items.
     *
     * Generated from protobuf field <code>optional string size_system = 27;</code>
     * @return string
     */
    public function getSizeSystem()
    {
        return isset($this->size_system) ? $this->size_system : '';
    }

    public function hasSizeSystem()
    {
        return isset($this->size_system);
    }

    public function clearSizeSystem()
    {
        unset($this->size_system);
    }

    /**
     * System in which the size is specified. Recommended for apparel items.
     *
     * Generated from protobuf field <code>optional string size_system = 27;</code>
     * @param string $var
     * @return $this
     */
    public function setSizeSystem($var)
    {
        GPBUtil::checkString($var, True);
        $this->size_system = $var;

        return $this;
    }

    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided (see
     * [https://support.google.com/merchants/answer/6324497](size type)).
     *
     * Generated from protobuf field <code>repeated string size_types = 28;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSizeTypes()
    {
        return $this->size_types;
    }

    /**
     * The cut of the item. It can be used to represent combined size types for
     * apparel items. Maximum two of size types can be provided (see
     * [https://support.google.com/merchants/answer/6324497](size type)).
     *
     * Generated from protobuf field <code>repeated string size_types = 28;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSizeTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->size_types = $arr;

        return $this;
    }

    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 29;</code>
     * @return string
     */
    public function getItemGroupId()
    {
        return isset($this->item_group_id) ? $this->item_group_id : '';
    }

    public function hasItemGroupId()
    {
        return isset($this->item_group_id);
    }

    public function clearItemGroupId()
    {
        unset($this->item_group_id);
    }

    /**
     * Shared identifier for all variants of the same product.
     *
     * Generated from protobuf field <code>optional string item_group_id = 29;</code>
     * @param string $var
     * @return $this
     */
    public function setItemGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->item_group_id = $var;

        return $this;
    }

    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.ProductDetail product_details = 30;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductDetails()
    {
        return $this->product_details;
    }

    /**
     * Technical specification or additional product details.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.ProductDetail product_details = 30;</code>
     * @param array<\Google\Shopping\Css\V1\ProductDetail>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductDetails($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Css\V1\ProductDetail::class);
        $this->product_details = $arr;

        return $this;
    }

    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductWeight product_weight = 31;</code>
     * @return \Google\Shopping\Css\V1\ProductWeight|null
     */
    public function getProductWeight()
    {
        return $this->product_weight;
    }

    public function hasProductWeight()
    {
        return isset($this->product_weight);
    }

    public function clearProductWeight()
    {
        unset($this->product_weight);
    }

    /**
     * The weight of the product in the units provided. The value must be
     * between 0 (exclusive) and 2000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductWeight product_weight = 31;</code>
     * @param \Google\Shopping\Css\V1\ProductWeight $var
     * @return $this
     */
    public function setProductWeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Css\V1\ProductWeight::class);
        $this->product_weight = $var;

        return $this;
    }

    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_length = 32;</code>
     * @return \Google\Shopping\Css\V1\ProductDimension|null
     */
    public function getProductLength()
    {
        return $this->product_length;
    }

    public function hasProductLength()
    {
        return isset($this->product_length);
    }

    public function clearProductLength()
    {
        unset($this->product_length);
    }

    /**
     * The length of the product in the units provided. The value must be
     * between 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_length = 32;</code>
     * @param \Google\Shopping\Css\V1\ProductDimension $var
     * @return $this
     */
    public function setProductLength($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Css\V1\ProductDimension::class);
        $this->product_length = $var;

        return $this;
    }

    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_width = 33;</code>
     * @return \Google\Shopping\Css\V1\ProductDimension|null
     */
    public function getProductWidth()
    {
        return $this->product_width;
    }

    public function hasProductWidth()
    {
        return isset($this->product_width);
    }

    public function clearProductWidth()
    {
        unset($this->product_width);
    }

    /**
     * The width of the product in the units provided. The value must be between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_width = 33;</code>
     * @param \Google\Shopping\Css\V1\ProductDimension $var
     * @return $this
     */
    public function setProductWidth($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Css\V1\ProductDimension::class);
        $this->product_width = $var;

        return $this;
    }

    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_height = 34;</code>
     * @return \Google\Shopping\Css\V1\ProductDimension|null
     */
    public function getProductHeight()
    {
        return $this->product_height;
    }

    public function hasProductHeight()
    {
        return isset($this->product_height);
    }

    public function clearProductHeight()
    {
        unset($this->product_height);
    }

    /**
     * The height of the product in the units provided. The value must be
     * between
     * 0 (exclusive) and 3000 (inclusive).
     *
     * Generated from protobuf field <code>.google.shopping.css.v1.ProductDimension product_height = 34;</code>
     * @param \Google\Shopping\Css\V1\ProductDimension $var
     * @return $this
     */
    public function setProductHeight($var)
    {
        GPBUtil::checkMessage($var, \Google\Shopping\Css\V1\ProductDimension::class);
        $this->product_height = $var;

        return $this;
    }

    /**
     * Bullet points describing the most relevant highlights of a product.
     *
     * Generated from protobuf field <code>repeated string product_highlights = 35;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getProductHighlights()
    {
        return $this->product_highlights;
    }

    /**
     * Bullet points describing the most relevant highlights of a product.
     *
     * Generated from protobuf field <code>repeated string product_highlights = 35;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setProductHighlights($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->product_highlights = $arr;

        return $this;
    }

    /**
     * A list of certificates claimed by the CSS for the given product.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.Certification certifications = 39;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertifications()
    {
        return $this->certifications;
    }

    /**
     * A list of certificates claimed by the CSS for the given product.
     *
     * Generated from protobuf field <code>repeated .google.shopping.css.v1.Certification certifications = 39;</code>
     * @param array<\Google\Shopping\Css\V1\Certification>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertifications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Shopping\Css\V1\Certification::class);
        $this->certifications = $arr;

        return $this;
    }

    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     * Note: It may take 2+ days from the expiration date for the item to
     * actually get deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 40;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpirationDate()
    {
        return $this->expiration_date;
    }

    public function hasExpirationDate()
    {
        return isset($this->expiration_date);
    }

    public function clearExpirationDate()
    {
        unset($this->expiration_date);
    }

    /**
     * Date on which the item should expire, as specified upon insertion, in
     * [ISO
     * 8601](http://en.wikipedia.org/wiki/ISO_8601) format. The actual
     * expiration date is exposed in `productstatuses` as
     * [googleExpirationDate](https://support.google.com/merchants/answer/6324499)
     * and might be earlier if `expirationDate` is too far in the future.
     * Note: It may take 2+ days from the expiration date for the item to
     * actually get deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expiration_date = 40;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpirationDate($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expiration_date = $var;

        return $this;
    }

    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     *
     * Generated from protobuf field <code>repeated string included_destinations = 43;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getIncludedDestinations()
    {
        return $this->included_destinations;
    }

    /**
     * The list of destinations to include for this target (corresponds to
     * checked check boxes in Merchant Center). Default destinations are always
     * included unless provided in `excludedDestinations`.
     *
     * Generated from protobuf field <code>repeated string included_destinations = 43;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setIncludedDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->included_destinations = $arr;

        return $this;
    }

    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     *
     * Generated from protobuf field <code>repeated string excluded_destinations = 44;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getExcludedDestinations()
    {
        return $this->excluded_destinations;
    }

    /**
     * The list of destinations to exclude for this target (corresponds to
     * unchecked check boxes in Merchant Center).
     *
     * Generated from protobuf field <code>repeated string excluded_destinations = 44;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setExcludedDestinations($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->excluded_destinations = $arr;

        return $this;
    }

    /**
     * Publication of this item will be temporarily paused.
     *
     * Generated from protobuf field <code>optional string pause = 45;</code>
     * @return string
     */
    public function getPause()
    {
        return isset($this->pause) ? $this->pause : '';
    }

    public function hasPause()
    {
        return isset($this->pause);
    }

    public function clearPause()
    {
        unset($this->pause);
    }

    /**
     * Publication of this item will be temporarily paused.
     *
     * Generated from protobuf field <code>optional string pause = 45;</code>
     * @param string $var
     * @return $this
     */
    public function setPause($var)
    {
        GPBUtil::checkString($var, True);
        $this->pause = $var;

        return $this;
    }

    /**
     * Custom label 0 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 46;</code>
     * @return string
     */
    public function getCustomLabel0()
    {
        return isset($this->custom_label_0) ? $this->custom_label_0 : '';
    }

    public function hasCustomLabel0()
    {
        return isset($this->custom_label_0);
    }

    public function clearCustomLabel0()
    {
        unset($this->custom_label_0);
    }

    /**
     * Custom label 0 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_0 = 46;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel0($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_0 = $var;

        return $this;
    }

    /**
     * Custom label 1 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 47;</code>
     * @return string
     */
    public function getCustomLabel1()
    {
        return isset($this->custom_label_1) ? $this->custom_label_1 : '';
    }

    public function hasCustomLabel1()
    {
        return isset($this->custom_label_1);
    }

    public function clearCustomLabel1()
    {
        unset($this->custom_label_1);
    }

    /**
     * Custom label 1 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_1 = 47;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel1($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_1 = $var;

        return $this;
    }

    /**
     * Custom label 2 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 48;</code>
     * @return string
     */
    public function getCustomLabel2()
    {
        return isset($this->custom_label_2) ? $this->custom_label_2 : '';
    }

    public function hasCustomLabel2()
    {
        return isset($this->custom_label_2);
    }

    public function clearCustomLabel2()
    {
        unset($this->custom_label_2);
    }

    /**
     * Custom label 2 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_2 = 48;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel2($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_2 = $var;

        return $this;
    }

    /**
     * Custom label 3 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 49;</code>
     * @return string
     */
    public function getCustomLabel3()
    {
        return isset($this->custom_label_3) ? $this->custom_label_3 : '';
    }

    public function hasCustomLabel3()
    {
        return isset($this->custom_label_3);
    }

    public function clearCustomLabel3()
    {
        unset($this->custom_label_3);
    }

    /**
     * Custom label 3 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_3 = 49;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel3($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_3 = $var;

        return $this;
    }

    /**
     * Custom label 4 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 50;</code>
     * @return string
     */
    public function getCustomLabel4()
    {
        return isset($this->custom_label_4) ? $this->custom_label_4 : '';
    }

    public function hasCustomLabel4()
    {
        return isset($this->custom_label_4);
    }

    public function clearCustomLabel4()
    {
        unset($this->custom_label_4);
    }

    /**
     * Custom label 4 for custom grouping of items in a Shopping campaign.
     *
     * Generated from protobuf field <code>optional string custom_label_4 = 50;</code>
     * @param string $var
     * @return $this
     */
    public function setCustomLabel4($var)
    {
        GPBUtil::checkString($var, True);
        $this->custom_label_4 = $var;

        return $this;
    }

}

