<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/documentai/v1/document_io.proto

namespace Google\Cloud\DocumentAI\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Config for Document OCR.
 *
 * Generated from protobuf message <code>google.cloud.documentai.v1.OcrConfig</code>
 */
class OcrConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Hints for the OCR model.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.OcrConfig.Hints hints = 2;</code>
     */
    private $hints = null;
    /**
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     *
     * Generated from protobuf field <code>bool enable_native_pdf_parsing = 3;</code>
     */
    private $enable_native_pdf_parsing = false;
    /**
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     *
     * Generated from protobuf field <code>bool enable_image_quality_scores = 4;</code>
     */
    private $enable_image_quality_scores = false;
    /**
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     *
     * Generated from protobuf field <code>repeated string advanced_ocr_options = 5;</code>
     */
    private $advanced_ocr_options;
    /**
     * Includes symbol level OCR information if set to true.
     *
     * Generated from protobuf field <code>bool enable_symbol = 6;</code>
     */
    private $enable_symbol = false;
    /**
     * Turn on font id model and returns font style information.
     *
     * Generated from protobuf field <code>bool compute_style_info = 8;</code>
     */
    private $compute_style_info = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DocumentAI\V1\OcrConfig\Hints $hints
     *           Hints for the OCR model.
     *     @type bool $enable_native_pdf_parsing
     *           Enables special handling for PDFs with existing text information. Results
     *           in better text extraction quality in such PDF inputs.
     *     @type bool $enable_image_quality_scores
     *           Enables intelligent document quality scores after OCR. Can help with
     *           diagnosing why OCR responses are of poor quality for a given input.
     *           Adds additional latency comparable to regular OCR to the process call.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $advanced_ocr_options
     *           A list of advanced OCR options to further fine-tune OCR behavior. Current
     *           valid values are:
     *           - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     *           an alternative to the current ML-based layout detection algorithm.
     *           Customers can choose the best suitable layout algorithm based on their
     *           situation.
     *     @type bool $enable_symbol
     *           Includes symbol level OCR information if set to true.
     *     @type bool $compute_style_info
     *           Turn on font id model and returns font style information.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Documentai\V1\DocumentIo::initOnce();
        parent::__construct($data);
    }

    /**
     * Hints for the OCR model.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.OcrConfig.Hints hints = 2;</code>
     * @return \Google\Cloud\DocumentAI\V1\OcrConfig\Hints|null
     */
    public function getHints()
    {
        return $this->hints;
    }

    public function hasHints()
    {
        return isset($this->hints);
    }

    public function clearHints()
    {
        unset($this->hints);
    }

    /**
     * Hints for the OCR model.
     *
     * Generated from protobuf field <code>.google.cloud.documentai.v1.OcrConfig.Hints hints = 2;</code>
     * @param \Google\Cloud\DocumentAI\V1\OcrConfig\Hints $var
     * @return $this
     */
    public function setHints($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DocumentAI\V1\OcrConfig\Hints::class);
        $this->hints = $var;

        return $this;
    }

    /**
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     *
     * Generated from protobuf field <code>bool enable_native_pdf_parsing = 3;</code>
     * @return bool
     */
    public function getEnableNativePdfParsing()
    {
        return $this->enable_native_pdf_parsing;
    }

    /**
     * Enables special handling for PDFs with existing text information. Results
     * in better text extraction quality in such PDF inputs.
     *
     * Generated from protobuf field <code>bool enable_native_pdf_parsing = 3;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableNativePdfParsing($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_native_pdf_parsing = $var;

        return $this;
    }

    /**
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     *
     * Generated from protobuf field <code>bool enable_image_quality_scores = 4;</code>
     * @return bool
     */
    public function getEnableImageQualityScores()
    {
        return $this->enable_image_quality_scores;
    }

    /**
     * Enables intelligent document quality scores after OCR. Can help with
     * diagnosing why OCR responses are of poor quality for a given input.
     * Adds additional latency comparable to regular OCR to the process call.
     *
     * Generated from protobuf field <code>bool enable_image_quality_scores = 4;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableImageQualityScores($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_image_quality_scores = $var;

        return $this;
    }

    /**
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     *
     * Generated from protobuf field <code>repeated string advanced_ocr_options = 5;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdvancedOcrOptions()
    {
        return $this->advanced_ocr_options;
    }

    /**
     * A list of advanced OCR options to further fine-tune OCR behavior. Current
     * valid values are:
     * - `legacy_layout`: a heuristics layout detection algorithm, which serves as
     * an alternative to the current ML-based layout detection algorithm.
     * Customers can choose the best suitable layout algorithm based on their
     * situation.
     *
     * Generated from protobuf field <code>repeated string advanced_ocr_options = 5;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdvancedOcrOptions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->advanced_ocr_options = $arr;

        return $this;
    }

    /**
     * Includes symbol level OCR information if set to true.
     *
     * Generated from protobuf field <code>bool enable_symbol = 6;</code>
     * @return bool
     */
    public function getEnableSymbol()
    {
        return $this->enable_symbol;
    }

    /**
     * Includes symbol level OCR information if set to true.
     *
     * Generated from protobuf field <code>bool enable_symbol = 6;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableSymbol($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_symbol = $var;

        return $this;
    }

    /**
     * Turn on font id model and returns font style information.
     *
     * Generated from protobuf field <code>bool compute_style_info = 8;</code>
     * @return bool
     */
    public function getComputeStyleInfo()
    {
        return $this->compute_style_info;
    }

    /**
     * Turn on font id model and returns font style information.
     *
     * Generated from protobuf field <code>bool compute_style_info = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setComputeStyleInfo($var)
    {
        GPBUtil::checkBool($var);
        $this->compute_style_info = $var;

        return $this;
    }

}

