<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/talent/v4beta1/profile.proto

namespace Google\Cloud\Talent\V4beta1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A resource that represents the profile for a job candidate (also referred to
 * as a "single-source profile").
 *
 * Generated from protobuf message <code>google.cloud.talent.v4beta1.Profile</code>
 */
class Profile extends \Google\Protobuf\Internal\Message
{
    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/foo/tenants/bar/profiles/baz".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Profile's id in client system, if available. This value is unique for each
     * profile inside a tenant. An error is thrown if another profile with the
     * same external_id is created.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     */
    private $external_id = '';
    /**
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     */
    private $source = '';
    /**
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     */
    private $uri = '';
    /**
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUID is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     */
    private $group_id = '';
    /**
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     */
    private $is_hirable = null;
    /**
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     */
    private $create_time = null;
    /**
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     */
    private $update_time = null;
    /**
     * The timestamp when the profile was last updated as a result of a direct or
     * indirect action by a candidate.
     * These actions include:
     * * Direct actions such as the candidate submitting a new resume as part of a
     * job application to the agency, using a self-service tool such as a website
     * to update their profile, and so on.
     * * Indirect actions by the candidate such as uploading a resume to a job
     * board that is collected by the agency through a feed, providing a resume to
     * a recruiter who then uploads it into the ATS, and so on.
     * * Updates made to the candidate's profile by the recruiter as a result of
     * interacting with the candidate (for example adding a skill or work
     * preference, and so on). Changes to [recruiting_notes][google.cloud.talent.v4beta1.Profile.recruiting_notes] are specifically
     * excluded from this action type.
     * Note: [candidate_update_time][google.cloud.talent.v4beta1.Profile.candidate_update_time] must be greater than or equal to
     * [resume_update_time][google.cloud.talent.v4beta1.Profile.resume_update_time] or an error is thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp candidate_update_time = 67;</code>
     */
    private $candidate_update_time = null;
    /**
     * The timestamp when the candidate's resume was added or updated on the
     * candidate's profile. Whether that resume was directly uploaded by a
     * candidate, pulled from a 3rd party job board feed, added by a recruiter,
     * and so on.
     * If this field is updated, it's expected that [resume][google.cloud.talent.v4beta1.Profile.resume] is provided in
     * the create or update calls.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp resume_update_time = 68;</code>
     */
    private $resume_update_time = null;
    /**
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     */
    private $resume = null;
    /**
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     */
    private $person_names;
    /**
     * The candidate's postal addresses. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Provide [Address.usage][google.cloud.talent.v4beta1.Address.usage] if possible, especially if the address is
     * PERSONAL. During a search only personal addresses are considered. If there
     * is no such address, all addresses with unspecified usage are assumed to be
     * personal.
     * * Provide [Address.current][google.cloud.talent.v4beta1.Address.current] for the current address if possible. During
     * a search, only current addresses are considered. If there is no such
     * address, all addresses are assumed to be current.
     * When displaying a candidate's addresses, it is sometimes desirable to limit
     * the number of addresses shown. In these cases we recommend that you display
     * the addresses in the following order of priority:
     * 1. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not
     * set.
     * 3. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 4. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not set.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     */
    private $addresses;
    /**
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     */
    private $email_addresses;
    /**
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     */
    private $phone_numbers;
    /**
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     */
    private $personal_uris;
    /**
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     */
    private $additional_contact_info;
    /**
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of employment records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     */
    private $employment_records;
    /**
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of education records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     */
    private $education_records;
    /**
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     * The limitation for max number of skills is 500.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     */
    private $skills;
    /**
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     * The limitation for max number of activities is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     */
    private $activities;
    /**
     * The publications published by the candidate.
     * The limitation for max number of publications is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     */
    private $publications;
    /**
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     */
    private $patents;
    /**
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     */
    private $certifications;
    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $applications;
    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $assignments;
    /**
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     */
    private $custom_attributes;
    /**
     * Output only. Indicates if a summarized profile was created as part of the
     * profile creation API call. This flag does not indicate whether a profile is
     * searchable or not.
     *
     * Generated from protobuf field <code>bool processed = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $processed = false;
    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $keyword_snippet = '';
    /**
     * Output only. Candidate's availability signals.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilitySignal availability_signals = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $availability_signals;
    /**
     * Output only. Derived locations of the profile, resolved from [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses].
     * [derived_addresses][google.cloud.talent.v4beta1.Profile.derived_addresses] are exactly matched to [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] in the
     * same order.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Location derived_addresses = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $derived_addresses;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required during profile update.
     *           Resource name assigned to a profile by the API.
     *           The format is
     *           "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     *           for example, "projects/foo/tenants/bar/profiles/baz".
     *     @type string $external_id
     *           Profile's id in client system, if available. This value is unique for each
     *           profile inside a tenant. An error is thrown if another profile with the
     *           same external_id is created.
     *           The maximum number of bytes allowed is 100.
     *     @type string $source
     *           The source description indicating where the profile is acquired.
     *           For example, if a candidate profile is acquired from a resume, the user can
     *           input "resume" here to indicate the source.
     *           The maximum number of bytes allowed is 100.
     *     @type string $uri
     *           The URI set by clients that links to this profile's client-side copy.
     *           The maximum number of bytes allowed is 4000.
     *     @type string $group_id
     *           The cluster id of the profile to associate with other profile(s) for the
     *           same candidate.
     *           This field should be generated by the customer. If a value is not provided,
     *           a random UUID is assigned to this field of the profile.
     *           This is used to link multiple profiles to the same candidate. For example,
     *           a client has a candidate with two profiles, where one was created recently
     *           and the other one was created 5 years ago. These two profiles may be very
     *           different. The clients can create the first profile and get a generated
     *           [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     *           indicating these two profiles are referring to the same candidate.
     *     @type \Google\Protobuf\BoolValue $is_hirable
     *           Indicates the hirable status of the candidate.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           The timestamp when the profile was first created at this source.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           The timestamp when the profile was last updated at this source.
     *     @type \Google\Protobuf\Timestamp $candidate_update_time
     *           The timestamp when the profile was last updated as a result of a direct or
     *           indirect action by a candidate.
     *           These actions include:
     *           * Direct actions such as the candidate submitting a new resume as part of a
     *           job application to the agency, using a self-service tool such as a website
     *           to update their profile, and so on.
     *           * Indirect actions by the candidate such as uploading a resume to a job
     *           board that is collected by the agency through a feed, providing a resume to
     *           a recruiter who then uploads it into the ATS, and so on.
     *           * Updates made to the candidate's profile by the recruiter as a result of
     *           interacting with the candidate (for example adding a skill or work
     *           preference, and so on). Changes to [recruiting_notes][google.cloud.talent.v4beta1.Profile.recruiting_notes] are specifically
     *           excluded from this action type.
     *           Note: [candidate_update_time][google.cloud.talent.v4beta1.Profile.candidate_update_time] must be greater than or equal to
     *           [resume_update_time][google.cloud.talent.v4beta1.Profile.resume_update_time] or an error is thrown.
     *     @type \Google\Protobuf\Timestamp $resume_update_time
     *           The timestamp when the candidate's resume was added or updated on the
     *           candidate's profile. Whether that resume was directly uploaded by a
     *           candidate, pulled from a 3rd party job board feed, added by a recruiter,
     *           and so on.
     *           If this field is updated, it's expected that [resume][google.cloud.talent.v4beta1.Profile.resume] is provided in
     *           the create or update calls.
     *     @type \Google\Cloud\Talent\V4beta1\Resume $resume
     *           The resume representing this profile.
     *     @type \Google\Cloud\Talent\V4beta1\PersonName[]|\Google\Protobuf\Internal\RepeatedField $person_names
     *           The names of the candidate this profile references.
     *           Currently only one person name is supported.
     *     @type \Google\Cloud\Talent\V4beta1\Address[]|\Google\Protobuf\Internal\RepeatedField $addresses
     *           The candidate's postal addresses. It's highly recommended to
     *           input this information as accurately as possible to help improve search
     *           quality. Here are some recommendations:
     *           * Provide [Address.usage][google.cloud.talent.v4beta1.Address.usage] if possible, especially if the address is
     *           PERSONAL. During a search only personal addresses are considered. If there
     *           is no such address, all addresses with unspecified usage are assumed to be
     *           personal.
     *           * Provide [Address.current][google.cloud.talent.v4beta1.Address.current] for the current address if possible. During
     *           a search, only current addresses are considered. If there is no such
     *           address, all addresses are assumed to be current.
     *           When displaying a candidate's addresses, it is sometimes desirable to limit
     *           the number of addresses shown. In these cases we recommend that you display
     *           the addresses in the following order of priority:
     *           1. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     *           2. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not
     *           set.
     *           3. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     *           [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     *           4. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     *           [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not set.
     *     @type \Google\Cloud\Talent\V4beta1\Email[]|\Google\Protobuf\Internal\RepeatedField $email_addresses
     *           The candidate's email addresses.
     *     @type \Google\Cloud\Talent\V4beta1\Phone[]|\Google\Protobuf\Internal\RepeatedField $phone_numbers
     *           The candidate's phone number(s).
     *     @type \Google\Cloud\Talent\V4beta1\PersonalUri[]|\Google\Protobuf\Internal\RepeatedField $personal_uris
     *           The candidate's personal URIs.
     *     @type \Google\Cloud\Talent\V4beta1\AdditionalContactInfo[]|\Google\Protobuf\Internal\RepeatedField $additional_contact_info
     *           Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     *           [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *     @type \Google\Cloud\Talent\V4beta1\EmploymentRecord[]|\Google\Protobuf\Internal\RepeatedField $employment_records
     *           The employment history records of the candidate. It's highly recommended
     *           to input this information as accurately as possible to help improve search
     *           quality. Here are some recommendations:
     *           * Specify the start and end dates of the employment records.
     *           * List different employment types separately, no matter how minor the
     *           change is.
     *           For example, only job title is changed from "software engineer" to "senior
     *           software engineer".
     *           * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     *           possible. If not, it's inferred from user inputs.
     *           The limitation for max number of employment records is 100.
     *     @type \Google\Cloud\Talent\V4beta1\EducationRecord[]|\Google\Protobuf\Internal\RepeatedField $education_records
     *           The education history record of the candidate. It's highly recommended to
     *           input this information as accurately as possible to help improve search
     *           quality. Here are some recommendations:
     *           * Specify the start and end dates of the education records.
     *           * List each education type separately, no matter how minor the change is.
     *           For example, the profile contains the education experience from the same
     *           school but different degrees.
     *           * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     *           possible. If not, it's inferred from user inputs.
     *           The limitation for max number of education records is 100.
     *     @type \Google\Cloud\Talent\V4beta1\Skill[]|\Google\Protobuf\Internal\RepeatedField $skills
     *           The skill set of the candidate. It's highly recommended to provide as
     *           much information as possible to help improve the search quality.
     *           The limitation for max number of skills is 500.
     *     @type \Google\Cloud\Talent\V4beta1\Activity[]|\Google\Protobuf\Internal\RepeatedField $activities
     *           The individual or collaborative activities which the candidate has
     *           participated in, for example, open-source projects, class assignments that
     *           aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     *           The limitation for max number of activities is 50.
     *     @type \Google\Cloud\Talent\V4beta1\Publication[]|\Google\Protobuf\Internal\RepeatedField $publications
     *           The publications published by the candidate.
     *           The limitation for max number of publications is 50.
     *     @type \Google\Cloud\Talent\V4beta1\Patent[]|\Google\Protobuf\Internal\RepeatedField $patents
     *           The patents acquired by the candidate.
     *     @type \Google\Cloud\Talent\V4beta1\Certification[]|\Google\Protobuf\Internal\RepeatedField $certifications
     *           The certifications acquired by the candidate.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $applications
     *           Output only. The resource names of the candidate's applications.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $assignments
     *           Output only. The resource names of the candidate's assignments.
     *     @type array|\Google\Protobuf\Internal\MapField $custom_attributes
     *           A map of fields to hold both filterable and non-filterable custom profile
     *           attributes that aren't covered by the provided structured fields. See
     *           [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     *           At most 100 filterable and at most 100 unfilterable keys are supported. If
     *           limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     *           by default. These are filterable when the `filterable` flag is set to
     *           `true`.
     *           Numeric custom attributes: each key can only map to one numeric value,
     *           otherwise an error is thrown. Client can also filter on numeric custom
     *           attributes using '>', '<' or '=' operators.
     *           String custom attributes: each key can map up to 50 string values. For
     *           filterable string value, each value has a byte size of no more than 256B.
     *           For unfilterable string values, the maximum byte size of a single key is
     *           64B. An error is thrown for any request exceeding the limit.
     *           The maximum total byte size is 10KB.
     *     @type bool $processed
     *           Output only. Indicates if a summarized profile was created as part of the
     *           profile creation API call. This flag does not indicate whether a profile is
     *           searchable or not.
     *     @type string $keyword_snippet
     *           Output only. Keyword snippet shows how the search result is related to a
     *           search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *     @type \Google\Cloud\Talent\V4beta1\AvailabilitySignal[]|\Google\Protobuf\Internal\RepeatedField $availability_signals
     *           Output only. Candidate's availability signals.
     *     @type \Google\Cloud\Talent\V4beta1\Location[]|\Google\Protobuf\Internal\RepeatedField $derived_addresses
     *           Output only. Derived locations of the profile, resolved from [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses].
     *           [derived_addresses][google.cloud.talent.v4beta1.Profile.derived_addresses] are exactly matched to [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] in the
     *           same order.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Talent\V4Beta1\Profile::initOnce();
        parent::__construct($data);
    }

    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/foo/tenants/bar/profiles/baz".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required during profile update.
     * Resource name assigned to a profile by the API.
     * The format is
     * "projects/{project_id}/tenants/{tenant_id}/profiles/{profile_id}",
     * for example, "projects/foo/tenants/bar/profiles/baz".
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Profile's id in client system, if available. This value is unique for each
     * profile inside a tenant. An error is thrown if another profile with the
     * same external_id is created.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     * @return string
     */
    public function getExternalId()
    {
        return $this->external_id;
    }

    /**
     * Profile's id in client system, if available. This value is unique for each
     * profile inside a tenant. An error is thrown if another profile with the
     * same external_id is created.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string external_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setExternalId($var)
    {
        GPBUtil::checkString($var, True);
        $this->external_id = $var;

        return $this;
    }

    /**
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     * @return string
     */
    public function getSource()
    {
        return $this->source;
    }

    /**
     * The source description indicating where the profile is acquired.
     * For example, if a candidate profile is acquired from a resume, the user can
     * input "resume" here to indicate the source.
     * The maximum number of bytes allowed is 100.
     *
     * Generated from protobuf field <code>string source = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setSource($var)
    {
        GPBUtil::checkString($var, True);
        $this->source = $var;

        return $this;
    }

    /**
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * The URI set by clients that links to this profile's client-side copy.
     * The maximum number of bytes allowed is 4000.
     *
     * Generated from protobuf field <code>string uri = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUID is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     * @return string
     */
    public function getGroupId()
    {
        return $this->group_id;
    }

    /**
     * The cluster id of the profile to associate with other profile(s) for the
     * same candidate.
     * This field should be generated by the customer. If a value is not provided,
     * a random UUID is assigned to this field of the profile.
     * This is used to link multiple profiles to the same candidate. For example,
     * a client has a candidate with two profiles, where one was created recently
     * and the other one was created 5 years ago. These two profiles may be very
     * different. The clients can create the first profile and get a generated
     * [group_id][google.cloud.talent.v4beta1.Profile.group_id], and assign it when the second profile is created,
     * indicating these two profiles are referring to the same candidate.
     *
     * Generated from protobuf field <code>string group_id = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->group_id = $var;

        return $this;
    }

    /**
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @return \Google\Protobuf\BoolValue|null
     */
    public function getIsHirable()
    {
        return isset($this->is_hirable) ? $this->is_hirable : null;
    }

    public function hasIsHirable()
    {
        return isset($this->is_hirable);
    }

    public function clearIsHirable()
    {
        unset($this->is_hirable);
    }

    /**
     * Returns the unboxed value from <code>getIsHirable()</code>

     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @return bool|null
     */
    public function getIsHirableValue()
    {
        return $this->readWrapperValue("is_hirable");
    }

    /**
     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @param \Google\Protobuf\BoolValue $var
     * @return $this
     */
    public function setIsHirable($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\BoolValue::class);
        $this->is_hirable = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\BoolValue object.

     * Indicates the hirable status of the candidate.
     *
     * Generated from protobuf field <code>.google.protobuf.BoolValue is_hirable = 6;</code>
     * @param bool|null $var
     * @return $this
     */
    public function setIsHirableValue($var)
    {
        $this->writeWrapperValue("is_hirable", $var);
        return $this;}

    /**
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return isset($this->create_time) ? $this->create_time : null;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * The timestamp when the profile was first created at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return isset($this->update_time) ? $this->update_time : null;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * The timestamp when the profile was last updated at this source.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * The timestamp when the profile was last updated as a result of a direct or
     * indirect action by a candidate.
     * These actions include:
     * * Direct actions such as the candidate submitting a new resume as part of a
     * job application to the agency, using a self-service tool such as a website
     * to update their profile, and so on.
     * * Indirect actions by the candidate such as uploading a resume to a job
     * board that is collected by the agency through a feed, providing a resume to
     * a recruiter who then uploads it into the ATS, and so on.
     * * Updates made to the candidate's profile by the recruiter as a result of
     * interacting with the candidate (for example adding a skill or work
     * preference, and so on). Changes to [recruiting_notes][google.cloud.talent.v4beta1.Profile.recruiting_notes] are specifically
     * excluded from this action type.
     * Note: [candidate_update_time][google.cloud.talent.v4beta1.Profile.candidate_update_time] must be greater than or equal to
     * [resume_update_time][google.cloud.talent.v4beta1.Profile.resume_update_time] or an error is thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp candidate_update_time = 67;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCandidateUpdateTime()
    {
        return isset($this->candidate_update_time) ? $this->candidate_update_time : null;
    }

    public function hasCandidateUpdateTime()
    {
        return isset($this->candidate_update_time);
    }

    public function clearCandidateUpdateTime()
    {
        unset($this->candidate_update_time);
    }

    /**
     * The timestamp when the profile was last updated as a result of a direct or
     * indirect action by a candidate.
     * These actions include:
     * * Direct actions such as the candidate submitting a new resume as part of a
     * job application to the agency, using a self-service tool such as a website
     * to update their profile, and so on.
     * * Indirect actions by the candidate such as uploading a resume to a job
     * board that is collected by the agency through a feed, providing a resume to
     * a recruiter who then uploads it into the ATS, and so on.
     * * Updates made to the candidate's profile by the recruiter as a result of
     * interacting with the candidate (for example adding a skill or work
     * preference, and so on). Changes to [recruiting_notes][google.cloud.talent.v4beta1.Profile.recruiting_notes] are specifically
     * excluded from this action type.
     * Note: [candidate_update_time][google.cloud.talent.v4beta1.Profile.candidate_update_time] must be greater than or equal to
     * [resume_update_time][google.cloud.talent.v4beta1.Profile.resume_update_time] or an error is thrown.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp candidate_update_time = 67;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCandidateUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->candidate_update_time = $var;

        return $this;
    }

    /**
     * The timestamp when the candidate's resume was added or updated on the
     * candidate's profile. Whether that resume was directly uploaded by a
     * candidate, pulled from a 3rd party job board feed, added by a recruiter,
     * and so on.
     * If this field is updated, it's expected that [resume][google.cloud.talent.v4beta1.Profile.resume] is provided in
     * the create or update calls.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp resume_update_time = 68;</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getResumeUpdateTime()
    {
        return isset($this->resume_update_time) ? $this->resume_update_time : null;
    }

    public function hasResumeUpdateTime()
    {
        return isset($this->resume_update_time);
    }

    public function clearResumeUpdateTime()
    {
        unset($this->resume_update_time);
    }

    /**
     * The timestamp when the candidate's resume was added or updated on the
     * candidate's profile. Whether that resume was directly uploaded by a
     * candidate, pulled from a 3rd party job board feed, added by a recruiter,
     * and so on.
     * If this field is updated, it's expected that [resume][google.cloud.talent.v4beta1.Profile.resume] is provided in
     * the create or update calls.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp resume_update_time = 68;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setResumeUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->resume_update_time = $var;

        return $this;
    }

    /**
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     * @return \Google\Cloud\Talent\V4beta1\Resume|null
     */
    public function getResume()
    {
        return isset($this->resume) ? $this->resume : null;
    }

    public function hasResume()
    {
        return isset($this->resume);
    }

    public function clearResume()
    {
        unset($this->resume);
    }

    /**
     * The resume representing this profile.
     *
     * Generated from protobuf field <code>.google.cloud.talent.v4beta1.Resume resume = 53;</code>
     * @param \Google\Cloud\Talent\V4beta1\Resume $var
     * @return $this
     */
    public function setResume($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Talent\V4beta1\Resume::class);
        $this->resume = $var;

        return $this;
    }

    /**
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonNames()
    {
        return $this->person_names;
    }

    /**
     * The names of the candidate this profile references.
     * Currently only one person name is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonName person_names = 11;</code>
     * @param \Google\Cloud\Talent\V4beta1\PersonName[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\PersonName::class);
        $this->person_names = $arr;

        return $this;
    }

    /**
     * The candidate's postal addresses. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Provide [Address.usage][google.cloud.talent.v4beta1.Address.usage] if possible, especially if the address is
     * PERSONAL. During a search only personal addresses are considered. If there
     * is no such address, all addresses with unspecified usage are assumed to be
     * personal.
     * * Provide [Address.current][google.cloud.talent.v4beta1.Address.current] for the current address if possible. During
     * a search, only current addresses are considered. If there is no such
     * address, all addresses are assumed to be current.
     * When displaying a candidate's addresses, it is sometimes desirable to limit
     * the number of addresses shown. In these cases we recommend that you display
     * the addresses in the following order of priority:
     * 1. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not
     * set.
     * 3. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 4. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not set.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * The candidate's postal addresses. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Provide [Address.usage][google.cloud.talent.v4beta1.Address.usage] if possible, especially if the address is
     * PERSONAL. During a search only personal addresses are considered. If there
     * is no such address, all addresses with unspecified usage are assumed to be
     * personal.
     * * Provide [Address.current][google.cloud.talent.v4beta1.Address.current] for the current address if possible. During
     * a search, only current addresses are considered. If there is no such
     * address, all addresses are assumed to be current.
     * When displaying a candidate's addresses, it is sometimes desirable to limit
     * the number of addresses shown. In these cases we recommend that you display
     * the addresses in the following order of priority:
     * 1. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 2. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is PERSONAL and [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not
     * set.
     * 3. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is true.
     * 4. [Address.usage][google.cloud.talent.v4beta1.Address.usage] is CONTACT_INFO_USAGE_UNSPECIFIED and
     * [Address.current][google.cloud.talent.v4beta1.Address.current] is false or not set.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Address addresses = 12;</code>
     * @param \Google\Cloud\Talent\V4beta1\Address[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Address::class);
        $this->addresses = $arr;

        return $this;
    }

    /**
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmailAddresses()
    {
        return $this->email_addresses;
    }

    /**
     * The candidate's email addresses.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Email email_addresses = 13;</code>
     * @param \Google\Cloud\Talent\V4beta1\Email[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmailAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Email::class);
        $this->email_addresses = $arr;

        return $this;
    }

    /**
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPhoneNumbers()
    {
        return $this->phone_numbers;
    }

    /**
     * The candidate's phone number(s).
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Phone phone_numbers = 14;</code>
     * @param \Google\Cloud\Talent\V4beta1\Phone[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPhoneNumbers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Phone::class);
        $this->phone_numbers = $arr;

        return $this;
    }

    /**
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPersonalUris()
    {
        return $this->personal_uris;
    }

    /**
     * The candidate's personal URIs.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.PersonalUri personal_uris = 15;</code>
     * @param \Google\Cloud\Talent\V4beta1\PersonalUri[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPersonalUris($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\PersonalUri::class);
        $this->personal_uris = $arr;

        return $this;
    }

    /**
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalContactInfo()
    {
        return $this->additional_contact_info;
    }

    /**
     * Available contact information besides [addresses][google.cloud.talent.v4beta1.Profile.addresses], [email_addresses][google.cloud.talent.v4beta1.Profile.email_addresses],
     * [phone_numbers][google.cloud.talent.v4beta1.Profile.phone_numbers] and [personal_uris][google.cloud.talent.v4beta1.Profile.personal_uris]. For example, Hang-out, Skype.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AdditionalContactInfo additional_contact_info = 16;</code>
     * @param \Google\Cloud\Talent\V4beta1\AdditionalContactInfo[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalContactInfo($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\AdditionalContactInfo::class);
        $this->additional_contact_info = $arr;

        return $this;
    }

    /**
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of employment records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEmploymentRecords()
    {
        return $this->employment_records;
    }

    /**
     * The employment history records of the candidate. It's highly recommended
     * to input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the employment records.
     * * List different employment types separately, no matter how minor the
     * change is.
     * For example, only job title is changed from "software engineer" to "senior
     * software engineer".
     * * Provide [EmploymentRecord.is_current][google.cloud.talent.v4beta1.EmploymentRecord.is_current] for the current employment if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of employment records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EmploymentRecord employment_records = 17;</code>
     * @param \Google\Cloud\Talent\V4beta1\EmploymentRecord[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEmploymentRecords($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EmploymentRecord::class);
        $this->employment_records = $arr;

        return $this;
    }

    /**
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of education records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEducationRecords()
    {
        return $this->education_records;
    }

    /**
     * The education history record of the candidate. It's highly recommended to
     * input this information as accurately as possible to help improve search
     * quality. Here are some recommendations:
     * * Specify the start and end dates of the education records.
     * * List each education type separately, no matter how minor the change is.
     * For example, the profile contains the education experience from the same
     * school but different degrees.
     * * Provide [EducationRecord.is_current][google.cloud.talent.v4beta1.EducationRecord.is_current] for the current education if
     * possible. If not, it's inferred from user inputs.
     * The limitation for max number of education records is 100.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.EducationRecord education_records = 18;</code>
     * @param \Google\Cloud\Talent\V4beta1\EducationRecord[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEducationRecords($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\EducationRecord::class);
        $this->education_records = $arr;

        return $this;
    }

    /**
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     * The limitation for max number of skills is 500.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSkills()
    {
        return $this->skills;
    }

    /**
     * The skill set of the candidate. It's highly recommended to provide as
     * much information as possible to help improve the search quality.
     * The limitation for max number of skills is 500.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Skill skills = 19;</code>
     * @param \Google\Cloud\Talent\V4beta1\Skill[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSkills($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Skill::class);
        $this->skills = $arr;

        return $this;
    }

    /**
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     * The limitation for max number of activities is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getActivities()
    {
        return $this->activities;
    }

    /**
     * The individual or collaborative activities which the candidate has
     * participated in, for example, open-source projects, class assignments that
     * aren't listed in [employment_records][google.cloud.talent.v4beta1.Profile.employment_records].
     * The limitation for max number of activities is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Activity activities = 20;</code>
     * @param \Google\Cloud\Talent\V4beta1\Activity[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setActivities($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Activity::class);
        $this->activities = $arr;

        return $this;
    }

    /**
     * The publications published by the candidate.
     * The limitation for max number of publications is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPublications()
    {
        return $this->publications;
    }

    /**
     * The publications published by the candidate.
     * The limitation for max number of publications is 50.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Publication publications = 21;</code>
     * @param \Google\Cloud\Talent\V4beta1\Publication[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPublications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Publication::class);
        $this->publications = $arr;

        return $this;
    }

    /**
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPatents()
    {
        return $this->patents;
    }

    /**
     * The patents acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Patent patents = 22;</code>
     * @param \Google\Cloud\Talent\V4beta1\Patent[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPatents($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Patent::class);
        $this->patents = $arr;

        return $this;
    }

    /**
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertifications()
    {
        return $this->certifications;
    }

    /**
     * The certifications acquired by the candidate.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Certification certifications = 23;</code>
     * @param \Google\Cloud\Talent\V4beta1\Certification[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertifications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Certification::class);
        $this->certifications = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApplications()
    {
        return $this->applications;
    }

    /**
     * Output only. The resource names of the candidate's applications.
     *
     * Generated from protobuf field <code>repeated string applications = 47 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApplications($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->applications = $arr;

        return $this;
    }

    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAssignments()
    {
        return $this->assignments;
    }

    /**
     * Output only. The resource names of the candidate's assignments.
     *
     * Generated from protobuf field <code>repeated string assignments = 48 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAssignments($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->assignments = $arr;

        return $this;
    }

    /**
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getCustomAttributes()
    {
        return $this->custom_attributes;
    }

    /**
     * A map of fields to hold both filterable and non-filterable custom profile
     * attributes that aren't covered by the provided structured fields. See
     * [CustomAttribute][google.cloud.talent.v4beta1.CustomAttribute] for more details.
     * At most 100 filterable and at most 100 unfilterable keys are supported. If
     * limit is exceeded, an error is thrown. Custom attributes are `unfilterable`
     * by default. These are filterable when the `filterable` flag is set to
     * `true`.
     * Numeric custom attributes: each key can only map to one numeric value,
     * otherwise an error is thrown. Client can also filter on numeric custom
     * attributes using '>', '<' or '=' operators.
     * String custom attributes: each key can map up to 50 string values. For
     * filterable string value, each value has a byte size of no more than 256B.
     * For unfilterable string values, the maximum byte size of a single key is
     * 64B. An error is thrown for any request exceeding the limit.
     * The maximum total byte size is 10KB.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.talent.v4beta1.CustomAttribute> custom_attributes = 26;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setCustomAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\CustomAttribute::class);
        $this->custom_attributes = $arr;

        return $this;
    }

    /**
     * Output only. Indicates if a summarized profile was created as part of the
     * profile creation API call. This flag does not indicate whether a profile is
     * searchable or not.
     *
     * Generated from protobuf field <code>bool processed = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getProcessed()
    {
        return $this->processed;
    }

    /**
     * Output only. Indicates if a summarized profile was created as part of the
     * profile creation API call. This flag does not indicate whether a profile is
     * searchable or not.
     *
     * Generated from protobuf field <code>bool processed = 27 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setProcessed($var)
    {
        GPBUtil::checkBool($var);
        $this->processed = $var;

        return $this;
    }

    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getKeywordSnippet()
    {
        return $this->keyword_snippet;
    }

    /**
     * Output only. Keyword snippet shows how the search result is related to a
     * search query.  This is only returned in [SearchProfilesResponse][google.cloud.talent.v4beta1.SearchProfilesResponse].
     *
     * Generated from protobuf field <code>string keyword_snippet = 28 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setKeywordSnippet($var)
    {
        GPBUtil::checkString($var, True);
        $this->keyword_snippet = $var;

        return $this;
    }

    /**
     * Output only. Candidate's availability signals.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilitySignal availability_signals = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAvailabilitySignals()
    {
        return $this->availability_signals;
    }

    /**
     * Output only. Candidate's availability signals.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.AvailabilitySignal availability_signals = 70 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Talent\V4beta1\AvailabilitySignal[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAvailabilitySignals($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\AvailabilitySignal::class);
        $this->availability_signals = $arr;

        return $this;
    }

    /**
     * Output only. Derived locations of the profile, resolved from [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses].
     * [derived_addresses][google.cloud.talent.v4beta1.Profile.derived_addresses] are exactly matched to [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] in the
     * same order.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Location derived_addresses = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDerivedAddresses()
    {
        return $this->derived_addresses;
    }

    /**
     * Output only. Derived locations of the profile, resolved from [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses].
     * [derived_addresses][google.cloud.talent.v4beta1.Profile.derived_addresses] are exactly matched to [Profile.addresses][google.cloud.talent.v4beta1.Profile.addresses] in the
     * same order.
     *
     * Generated from protobuf field <code>repeated .google.cloud.talent.v4beta1.Location derived_addresses = 64 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Talent\V4beta1\Location[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDerivedAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Talent\V4beta1\Location::class);
        $this->derived_addresses = $arr;

        return $this;
    }

}

