<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkconnectivity/v1/hub.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkConnectivity\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;

use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;

use Google\ApiCore\PathTemplate;

use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\NetworkConnectivity\V1\CreateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteHubRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\GetHubRequest;
use Google\Cloud\NetworkConnectivity\V1\GetSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\Hub;
use Google\Cloud\NetworkConnectivity\V1\ListHubsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListHubsResponse;
use Google\Cloud\NetworkConnectivity\V1\ListSpokesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListSpokesResponse;
use Google\Cloud\NetworkConnectivity\V1\Spoke;
use Google\Cloud\NetworkConnectivity\V1\UpdateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateSpokeRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Network Connectivity Center is a hub-and-spoke abstraction for network
 * connectivity management in Google Cloud. It reduces operational complexity
 * through a simple, centralized connectivity management model.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $hubServiceClient = new HubServiceClient();
 * try {
 *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
 *     $hubId = 'hub_id';
 *     $hub = new Hub();
 *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'createHub');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $hubServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class HubServiceGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.networkconnectivity.v1.HubService';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'networkconnectivity.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $hubNameTemplate;

    private static $locationNameTemplate;

    private static $spokeNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/hub_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/hub_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/hub_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/hub_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getHubNameTemplate()
    {
        if (self::$hubNameTemplate == null) {
            self::$hubNameTemplate = new PathTemplate(
                'projects/{project}/locations/global/hubs/{hub}'
            );
        }

        return self::$hubNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getSpokeNameTemplate()
    {
        if (self::$spokeNameTemplate == null) {
            self::$spokeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/spokes/{spoke}'
            );
        }

        return self::$spokeNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'hub' => self::getHubNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'spoke' => self::getSpokeNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hub
     * resource.
     *
     * @param string $project
     * @param string $hub
     *
     * @return string The formatted hub resource.
     */
    public static function hubName($project, $hub)
    {
        return self::getHubNameTemplate()->render([
            'project' => $project,
            'hub' => $hub,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a spoke
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $spoke
     *
     * @return string The formatted spoke resource.
     */
    public static function spokeName($project, $location, $spoke)
    {
        return self::getSpokeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'spoke' => $spoke,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - hub: projects/{project}/locations/global/hubs/{hub}
     * - location: projects/{project}/locations/{location}
     * - spoke: projects/{project}/locations/{location}/spokes/{spoke}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkconnectivity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a new hub in the specified project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $hubId = 'hub_id';
     *     $hub = new Hub();
     *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'createHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param string $hubId        Required. A unique identifier for the hub.
     * @param Hub    $hub          Required. The initial values for a new hub.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createHub($parent, $hubId, $hub, array $optionalArgs = [])
    {
        $request = new CreateHubRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setHubId($hubId);
        $request->setHub($hub);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a spoke in the specified project and location.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $spokeId = 'spoke_id';
     *     $spoke = new Spoke();
     *     $operationResponse = $hubServiceClient->createSpoke($formattedParent, $spokeId, $spoke);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->createSpoke($formattedParent, $spokeId, $spoke);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'createSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param string $spokeId      Required. Unique id for the spoke to create.
     * @param Spoke  $spoke        Required. The initial values for a new spoke.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSpoke(
        $parent,
        $spokeId,
        $spoke,
        array $optionalArgs = []
    ) {
        $request = new CreateSpokeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSpokeId($spokeId);
        $request->setSpoke($spoke);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $operationResponse = $hubServiceClient->deleteHub($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->deleteHub($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'deleteHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteHub($name, array $optionalArgs = [])
    {
        $request = new DeleteHubRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes the specified spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $operationResponse = $hubServiceClient->deleteSpoke($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->deleteSpoke($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'deleteSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spoke to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSpoke($name, array $optionalArgs = [])
    {
        $request = new DeleteSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details about the specified hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $response = $hubServiceClient->getHub($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Hub
     *
     * @throws ApiException if the remote call fails
     */
    public function getHub($name, array $optionalArgs = [])
    {
        $request = new GetHubRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetHub',
            Hub::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about the specified spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $response = $hubServiceClient->getSpoke($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spoke resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Spoke
     *
     * @throws ApiException if the remote call fails
     */
    public function getSpoke($name, array $optionalArgs = [])
    {
        $request = new GetSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSpoke',
            Spoke::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists hubs in a given project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listHubs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listHubs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the results listed in the response.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listHubs($parent, array $optionalArgs = [])
    {
        $request = new ListHubsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListHubs',
            $optionalArgs,
            ListHubsResponse::class,
            $request
        );
    }

    /**
     * Lists the spokes in the specified project and location.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listSpokes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listSpokes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the results listed in the response.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSpokes($parent, array $optionalArgs = [])
    {
        $request = new ListSpokesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSpokes',
            $optionalArgs,
            ListSpokesResponse::class,
            $request
        );
    }

    /**
     * Updates the description and/or labels of the specified hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $hub = new Hub();
     *     $operationResponse = $hubServiceClient->updateHub($hub);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->updateHub($hub);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'updateHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param Hub   $hub          Required. The state that the hub should be in after the update.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. In the case of an update to an existing hub, field mask is used to specify
     *           the fields to be overwritten. The fields specified in the update_mask are
     *           relative to the resource, not the full request. A field is overwritten if
     *           it is in the mask. If the user does not provide a mask, then all fields are
     *           overwritten.
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateHub($hub, array $optionalArgs = [])
    {
        $request = new UpdateHubRequest();
        $requestParamHeaders = [];
        $request->setHub($hub);
        $requestParamHeaders['hub.name'] = $hub->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of the specified spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $spoke = new Spoke();
     *     $operationResponse = $hubServiceClient->updateSpoke($spoke);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->updateSpoke($spoke);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'updateSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param Spoke $spoke        Required. The state that the spoke should be in after the update.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. In the case of an update to an existing spoke, field mask is used to
     *           specify the fields to be overwritten. The fields specified in the
     *           update_mask are relative to the resource, not the full request. A field is
     *           overwritten if it is in the mask. If the user does not provide a mask, then
     *           all fields are overwritten.
     *     @type string $requestId
     *           Optional. A unique request ID (optional). If you specify this ID, you can use it
     *           in cases when you need to retry your request. When you need to retry, this
     *           ID lets the server know that it can ignore the request if it has already
     *           been completed. The server guarantees that for at least 60 minutes after
     *           the first request.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSpoke($spoke, array $optionalArgs = [])
    {
        $request = new UpdateSpokeRequest();
        $requestParamHeaders = [];
        $request->setSpoke($spoke);
        $requestParamHeaders['spoke.name'] = $spoke->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }
}
