<?php
/*
 * Copyright 2022 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/dialogflow/v2/conversation_model.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Dialogflow\V2\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;

use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;

use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Dialogflow\V2\ConversationModel;
use Google\Cloud\Dialogflow\V2\ConversationModelEvaluation;
use Google\Cloud\Dialogflow\V2\CreateConversationModelEvaluationRequest;
use Google\Cloud\Dialogflow\V2\CreateConversationModelOperationMetadata;
use Google\Cloud\Dialogflow\V2\CreateConversationModelRequest;
use Google\Cloud\Dialogflow\V2\DeleteConversationModelOperationMetadata;
use Google\Cloud\Dialogflow\V2\DeleteConversationModelRequest;
use Google\Cloud\Dialogflow\V2\DeployConversationModelOperationMetadata;
use Google\Cloud\Dialogflow\V2\DeployConversationModelRequest;
use Google\Cloud\Dialogflow\V2\GetConversationModelEvaluationRequest;
use Google\Cloud\Dialogflow\V2\GetConversationModelRequest;
use Google\Cloud\Dialogflow\V2\ListConversationModelEvaluationsRequest;
use Google\Cloud\Dialogflow\V2\ListConversationModelEvaluationsResponse;
use Google\Cloud\Dialogflow\V2\ListConversationModelsRequest;
use Google\Cloud\Dialogflow\V2\ListConversationModelsResponse;
use Google\Cloud\Dialogflow\V2\UndeployConversationModelOperationMetadata;
use Google\Cloud\Dialogflow\V2\UndeployConversationModelRequest;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\LongRunning\Operation;

/**
 * Service Description: Manages a collection of models for human agent assistant.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $conversationModelsClient = new ConversationModelsClient();
 * try {
 *     $conversationModel = new ConversationModel();
 *     $operationResponse = $conversationModelsClient->createConversationModel($conversationModel);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $conversationModelsClient->createConversationModel($conversationModel);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'createConversationModel');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $conversationModelsClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 */
class ConversationModelsGapicClient
{
    use GapicClientTrait;

    /**
     * The name of the service.
     */
    const SERVICE_NAME = 'google.cloud.dialogflow.v2.ConversationModels';

    /**
     * The default address of the service.
     */
    const SERVICE_ADDRESS = 'dialogflow.googleapis.com';

    /**
     * The default port of the service.
     */
    const DEFAULT_SERVICE_PORT = 443;

    /**
     * The name of the code generator, to be included in the agent header.
     */
    const CODEGEN_NAME = 'gapic';

    /**
     * The default scopes required by the service.
     */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/dialogflow',
    ];

    private static $conversationModelNameTemplate;

    private static $conversationModelEvaluationNameTemplate;

    private static $projectConversationModelNameTemplate;

    private static $projectConversationModelEvaluationNameTemplate;

    private static $projectLocationConversationModelNameTemplate;

    private static $projectLocationConversationModelEvaluationNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/conversation_models_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/conversation_models_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/conversation_models_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/conversation_models_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getConversationModelNameTemplate()
    {
        if (self::$conversationModelNameTemplate == null) {
            self::$conversationModelNameTemplate = new PathTemplate('projects/{project}/locations/{location}/conversationModels/{conversation_model}');
        }

        return self::$conversationModelNameTemplate;
    }

    private static function getConversationModelEvaluationNameTemplate()
    {
        if (self::$conversationModelEvaluationNameTemplate == null) {
            self::$conversationModelEvaluationNameTemplate = new PathTemplate('projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}');
        }

        return self::$conversationModelEvaluationNameTemplate;
    }

    private static function getProjectConversationModelNameTemplate()
    {
        if (self::$projectConversationModelNameTemplate == null) {
            self::$projectConversationModelNameTemplate = new PathTemplate('projects/{project}/conversationModels/{conversation_model}');
        }

        return self::$projectConversationModelNameTemplate;
    }

    private static function getProjectConversationModelEvaluationNameTemplate()
    {
        if (self::$projectConversationModelEvaluationNameTemplate == null) {
            self::$projectConversationModelEvaluationNameTemplate = new PathTemplate('projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}');
        }

        return self::$projectConversationModelEvaluationNameTemplate;
    }

    private static function getProjectLocationConversationModelNameTemplate()
    {
        if (self::$projectLocationConversationModelNameTemplate == null) {
            self::$projectLocationConversationModelNameTemplate = new PathTemplate('projects/{project}/locations/{location}/conversationModels/{conversation_model}');
        }

        return self::$projectLocationConversationModelNameTemplate;
    }

    private static function getProjectLocationConversationModelEvaluationNameTemplate()
    {
        if (self::$projectLocationConversationModelEvaluationNameTemplate == null) {
            self::$projectLocationConversationModelEvaluationNameTemplate = new PathTemplate('projects/{project}/locations/{location}/conversationModels/{conversation_model}/evaluations/{evaluation}');
        }

        return self::$projectLocationConversationModelEvaluationNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'conversationModel' => self::getConversationModelNameTemplate(),
                'conversationModelEvaluation' => self::getConversationModelEvaluationNameTemplate(),
                'projectConversationModel' => self::getProjectConversationModelNameTemplate(),
                'projectConversationModelEvaluation' => self::getProjectConversationModelEvaluationNameTemplate(),
                'projectLocationConversationModel' => self::getProjectLocationConversationModelNameTemplate(),
                'projectLocationConversationModelEvaluation' => self::getProjectLocationConversationModelEvaluationNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversation_model resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversationModel
     *
     * @return string The formatted conversation_model resource.
     */
    public static function conversationModelName($project, $location, $conversationModel)
    {
        return self::getConversationModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation_model' => $conversationModel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * conversation_model_evaluation resource.
     *
     * @param string $project
     * @param string $conversationModel
     * @param string $evaluation
     *
     * @return string The formatted conversation_model_evaluation resource.
     */
    public static function conversationModelEvaluationName($project, $conversationModel, $evaluation)
    {
        return self::getConversationModelEvaluationNameTemplate()->render([
            'project' => $project,
            'conversation_model' => $conversationModel,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_model resource.
     *
     * @param string $project
     * @param string $conversationModel
     *
     * @return string The formatted project_conversation_model resource.
     */
    public static function projectConversationModelName($project, $conversationModel)
    {
        return self::getProjectConversationModelNameTemplate()->render([
            'project' => $project,
            'conversation_model' => $conversationModel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_conversation_model_evaluation resource.
     *
     * @param string $project
     * @param string $conversationModel
     * @param string $evaluation
     *
     * @return string The formatted project_conversation_model_evaluation resource.
     */
    public static function projectConversationModelEvaluationName($project, $conversationModel, $evaluation)
    {
        return self::getProjectConversationModelEvaluationNameTemplate()->render([
            'project' => $project,
            'conversation_model' => $conversationModel,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_model resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversationModel
     *
     * @return string The formatted project_location_conversation_model resource.
     */
    public static function projectLocationConversationModelName($project, $location, $conversationModel)
    {
        return self::getProjectLocationConversationModelNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation_model' => $conversationModel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_conversation_model_evaluation resource.
     *
     * @param string $project
     * @param string $location
     * @param string $conversationModel
     * @param string $evaluation
     *
     * @return string The formatted project_location_conversation_model_evaluation resource.
     */
    public static function projectLocationConversationModelEvaluationName($project, $location, $conversationModel, $evaluation)
    {
        return self::getProjectLocationConversationModelEvaluationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'conversation_model' => $conversationModel,
            'evaluation' => $evaluation,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - conversationModel: projects/{project}/locations/{location}/conversationModels/{conversation_model}
     * - conversationModelEvaluation: projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}
     * - projectConversationModel: projects/{project}/conversationModels/{conversation_model}
     * - projectConversationModelEvaluation: projects/{project}/conversationModels/{conversation_model}/evaluations/{evaluation}
     * - projectLocationConversationModel: projects/{project}/locations/{location}/conversationModels/{conversation_model}
     * - projectLocationConversationModelEvaluation: projects/{project}/locations/{location}/conversationModels/{conversation_model}/evaluations/{evaluation}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException("Template name $template does not exist");
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException("Input did not match any known format. Input: $formattedName");
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $serviceAddress
     *           **Deprecated**. This option will be removed in a future major release. Please
     *           utilize the `$apiEndpoint` option instead.
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'dialogflow.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $serviceAddress setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Creates a model.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: [CreateConversationModelOperationMetadata][google.cloud.dialogflow.v2.CreateConversationModelOperationMetadata]
     * - `response`: [ConversationModel][google.cloud.dialogflow.v2.ConversationModel]
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $conversationModel = new ConversationModel();
     *     $operationResponse = $conversationModelsClient->createConversationModel($conversationModel);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $conversationModelsClient->createConversationModel($conversationModel);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'createConversationModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param ConversationModel $conversationModel Required. The conversation model to create.
     * @param array             $optionalArgs      {
     *     Optional.
     *
     *     @type string $parent
     *           The project to create conversation model for. Format:
     *           `projects/<Project ID>`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createConversationModel($conversationModel, array $optionalArgs = [])
    {
        $request = new CreateConversationModelRequest();
        $requestParamHeaders = [];
        $request->setConversationModel($conversationModel);
        if (isset($optionalArgs['parent'])) {
            $request->setParent($optionalArgs['parent']);
            $requestParamHeaders['parent'] = $optionalArgs['parent'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateConversationModel', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Creates evaluation of a conversation model.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $formattedParent = $conversationModelsClient->conversationModelName('[PROJECT]', '[LOCATION]', '[CONVERSATION_MODEL]');
     *     $conversationModelEvaluation = new ConversationModelEvaluation();
     *     $operationResponse = $conversationModelsClient->createConversationModelEvaluation($formattedParent, $conversationModelEvaluation);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $conversationModelsClient->createConversationModelEvaluation($formattedParent, $conversationModelEvaluation);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'createConversationModelEvaluation');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string                      $parent                      Required. The conversation model resource name. Format:
     *                                                                 `projects/<Project ID>/locations/<Location
     *                                                                 ID>/conversationModels/<Conversation Model ID>`
     * @param ConversationModelEvaluation $conversationModelEvaluation Required. The conversation model evaluation to be created.
     * @param array                       $optionalArgs                {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createConversationModelEvaluation($parent, $conversationModelEvaluation, array $optionalArgs = [])
    {
        $request = new CreateConversationModelEvaluationRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setConversationModelEvaluation($conversationModelEvaluation);
        $requestParamHeaders['parent'] = $parent;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('CreateConversationModelEvaluation', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deletes a model.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: [DeleteConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeleteConversationModelOperationMetadata]
     * - `response`: An [Empty
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $conversationModelsClient->deleteConversationModel($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $conversationModelsClient->deleteConversationModel($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'deleteConversationModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The conversation model to delete. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteConversationModel($name, array $optionalArgs = [])
    {
        $request = new DeleteConversationModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeleteConversationModel', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Deploys a model. If a model is already deployed, deploying it
     * has no effect. A model can only serve prediction requests after it gets
     * deployed. For article suggestion, custom model will not be used unless
     * it is deployed.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: [DeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.DeployConversationModelOperationMetadata]
     * - `response`: An [Empty
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $conversationModelsClient->deployConversationModel($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $conversationModelsClient->deployConversationModel($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'deployConversationModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The conversation model to deploy. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deployConversationModel($name, array $optionalArgs = [])
    {
        $request = new DeployConversationModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('DeployConversationModel', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets conversation model.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $name = 'name';
     *     $response = $conversationModelsClient->getConversationModel($name);
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The conversation model to retrieve. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\ConversationModel
     *
     * @throws ApiException if the remote call fails
     */
    public function getConversationModel($name, array $optionalArgs = [])
    {
        $request = new GetConversationModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetConversationModel', ConversationModel::class, $optionalArgs, $request)->wait();
    }

    /**
     * Gets an evaluation of conversation model.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $name = 'name';
     *     $response = $conversationModelsClient->getConversationModelEvaluation($name);
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The conversation model evaluation resource name. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model
     *                             ID>/evaluations/<Evaluation ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Dialogflow\V2\ConversationModelEvaluation
     *
     * @throws ApiException if the remote call fails
     */
    public function getConversationModelEvaluation($name, array $optionalArgs = [])
    {
        $request = new GetConversationModelEvaluationRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetConversationModelEvaluation', ConversationModelEvaluation::class, $optionalArgs, $request)->wait();
    }

    /**
     * Lists evaluations of a conversation model.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $conversationModelsClient->listConversationModelEvaluations($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $conversationModelsClient->listConversationModelEvaluations($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The conversation model resource name. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConversationModelEvaluations($parent, array $optionalArgs = [])
    {
        $request = new ListConversationModelEvaluationsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListConversationModelEvaluations', $optionalArgs, ListConversationModelEvaluationsResponse::class, $request);
    }

    /**
     * Lists conversation models.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $parent = 'parent';
     *     // Iterate over pages of elements
     *     $pagedResponse = $conversationModelsClient->listConversationModels($parent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $conversationModelsClient->listConversationModels($parent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The project to list all conversation models for.
     *                             Format: `projects/<Project ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listConversationModels($parent, array $optionalArgs = [])
    {
        $request = new ListConversationModelsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListConversationModels', $optionalArgs, ListConversationModelsResponse::class, $request);
    }

    /**
     * Undeploys a model. If the model is not deployed this method has no effect.
     * If the model is currently being used:
     * - For article suggestion, article suggestion will fallback to the default
     * model if model is undeployed.
     *
     * This method is a [long-running
     * operation](https://cloud.google.com/dialogflow/es/docs/how/long-running-operations).
     * The returned `Operation` type has the following method-specific fields:
     *
     * - `metadata`: [UndeployConversationModelOperationMetadata][google.cloud.dialogflow.v2.UndeployConversationModelOperationMetadata]
     * - `response`: An [Empty
     * message](https://developers.google.com/protocol-buffers/docs/reference/google.protobuf#empty)
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $name = 'name';
     *     $operationResponse = $conversationModelsClient->undeployConversationModel($name);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $conversationModelsClient->undeployConversationModel($name);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $conversationModelsClient->resumeOperation($operationName, 'undeployConversationModel');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The conversation model to undeploy. Format:
     *                             `projects/<Project ID>/conversationModels/<Conversation Model ID>`
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function undeployConversationModel($name, array $optionalArgs = [])
    {
        $request = new UndeployConversationModelRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startOperationsCall('UndeployConversationModel', $optionalArgs, $request, $this->getOperationsClient())->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     $response = $conversationModelsClient->getLocation();
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->startCall('GetLocation', Location::class, $optionalArgs, $request, Call::UNARY_CALL, 'google.cloud.location.Locations')->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $conversationModelsClient = new ConversationModelsClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $conversationModelsClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $conversationModelsClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $conversationModelsClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor($requestParamHeaders);
        $optionalArgs['headers'] = isset($optionalArgs['headers']) ? array_merge($requestParams->getHeader(), $optionalArgs['headers']) : $requestParams->getHeader();
        return $this->getPagedListResponse('ListLocations', $optionalArgs, ListLocationsResponse::class, $request, 'google.cloud.location.Locations');
    }
}
