<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/certificatemanager/v1/certificate_manager.proto

namespace Google\Cloud\CertificateManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Defines TLS certificate.
 *
 * Generated from protobuf message <code>google.cloud.certificatemanager.v1.Certificate</code>
 */
class Certificate extends \Google\Protobuf\Internal\Message
{
    /**
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * One or more paragraphs of text description of a certificate.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     */
    private $description = '';
    /**
     * Output only. The creation timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $create_time = null;
    /**
     * Output only. The last update timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $update_time = null;
    /**
     * Set of labels associated with a Certificate.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     */
    private $labels;
    /**
     * Output only. The list of Subject Alternative Names of dnsName type defined in the
     * certificate (see RFC 5280 4.2.1.6).
     * Managed certificates that haven't been provisioned yet have this field
     * populated with a value of the managed.domains field.
     *
     * Generated from protobuf field <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $san_dnsnames;
    /**
     * Output only. The PEM-encoded certificate chain.
     *
     * Generated from protobuf field <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $pem_certificate = '';
    /**
     * Output only. The expiry timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $expire_time = null;
    /**
     * Immutable. The scope of the certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $scope = 0;
    protected $type;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           A user-defined name of the certificate. Certificate names must be unique
     *           globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *     @type string $description
     *           One or more paragraphs of text description of a certificate.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation timestamp of a Certificate.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last update timestamp of a Certificate.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Set of labels associated with a Certificate.
     *     @type \Google\Cloud\CertificateManager\V1\Certificate\SelfManagedCertificate $self_managed
     *           If set, defines data of a self-managed certificate.
     *     @type \Google\Cloud\CertificateManager\V1\Certificate\ManagedCertificate $managed
     *           If set, contains configuration and state of a managed certificate.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $san_dnsnames
     *           Output only. The list of Subject Alternative Names of dnsName type defined in the
     *           certificate (see RFC 5280 4.2.1.6).
     *           Managed certificates that haven't been provisioned yet have this field
     *           populated with a value of the managed.domains field.
     *     @type string $pem_certificate
     *           Output only. The PEM-encoded certificate chain.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. The expiry timestamp of a Certificate.
     *     @type int $scope
     *           Immutable. The scope of the certificate.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Certificatemanager\V1\CertificateManager::initOnce();
        parent::__construct($data);
    }

    /**
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * A user-defined name of the certificate. Certificate names must be unique
     * globally and match pattern `projects/&#42;&#47;locations/&#42;&#47;certificates/&#42;`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * One or more paragraphs of text description of a certificate.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * One or more paragraphs of text description of a certificate.
     *
     * Generated from protobuf field <code>string description = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. The creation timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last update timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last update timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Set of labels associated with a Certificate.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Set of labels associated with a Certificate.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * If set, defines data of a self-managed certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;</code>
     * @return \Google\Cloud\CertificateManager\V1\Certificate\SelfManagedCertificate|null
     */
    public function getSelfManaged()
    {
        return $this->readOneof(5);
    }

    public function hasSelfManaged()
    {
        return $this->hasOneof(5);
    }

    /**
     * If set, defines data of a self-managed certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.SelfManagedCertificate self_managed = 5;</code>
     * @param \Google\Cloud\CertificateManager\V1\Certificate\SelfManagedCertificate $var
     * @return $this
     */
    public function setSelfManaged($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CertificateManager\V1\Certificate\SelfManagedCertificate::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * If set, contains configuration and state of a managed certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     * @return \Google\Cloud\CertificateManager\V1\Certificate\ManagedCertificate|null
     */
    public function getManaged()
    {
        return $this->readOneof(11);
    }

    public function hasManaged()
    {
        return $this->hasOneof(11);
    }

    /**
     * If set, contains configuration and state of a managed certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.ManagedCertificate managed = 11;</code>
     * @param \Google\Cloud\CertificateManager\V1\Certificate\ManagedCertificate $var
     * @return $this
     */
    public function setManaged($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CertificateManager\V1\Certificate\ManagedCertificate::class);
        $this->writeOneof(11, $var);

        return $this;
    }

    /**
     * Output only. The list of Subject Alternative Names of dnsName type defined in the
     * certificate (see RFC 5280 4.2.1.6).
     * Managed certificates that haven't been provisioned yet have this field
     * populated with a value of the managed.domains field.
     *
     * Generated from protobuf field <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSanDnsnames()
    {
        return $this->san_dnsnames;
    }

    /**
     * Output only. The list of Subject Alternative Names of dnsName type defined in the
     * certificate (see RFC 5280 4.2.1.6).
     * Managed certificates that haven't been provisioned yet have this field
     * populated with a value of the managed.domains field.
     *
     * Generated from protobuf field <code>repeated string san_dnsnames = 6 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSanDnsnames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->san_dnsnames = $arr;

        return $this;
    }

    /**
     * Output only. The PEM-encoded certificate chain.
     *
     * Generated from protobuf field <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getPemCertificate()
    {
        return $this->pem_certificate;
    }

    /**
     * Output only. The PEM-encoded certificate chain.
     *
     * Generated from protobuf field <code>string pem_certificate = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setPemCertificate($var)
    {
        GPBUtil::checkString($var, True);
        $this->pem_certificate = $var;

        return $this;
    }

    /**
     * Output only. The expiry timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. The expiry timestamp of a Certificate.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Immutable. The scope of the certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Immutable. The scope of the certificate.
     *
     * Generated from protobuf field <code>.google.cloud.certificatemanager.v1.Certificate.Scope scope = 12 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\CertificateManager\V1\Certificate\Scope::class);
        $this->scope = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getType()
    {
        return $this->whichOneof("type");
    }

}

