<?php
// GENERATED CODE -- DO NOT EDIT!

// Original file comments:
// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
namespace Google\Cloud\Eventarc\Publishing\V1;

/**
 * Eventarc processes events generated by an event provider and delivers them to
 * a subscriber.
 *
 * An event provider is a software-as-a-service (SaaS) system or
 * product that can generate and deliver events through Eventarc.
 *
 * A third-party event provider is an event provider from outside of Google.
 *
 * A partner is a third-party event provider that is integrated with Eventarc.
 *
 * A subscriber is a GCP customer interested in receiving events.
 *
 * Channel is a first-class Eventarc resource that is created and managed
 * by the subscriber in their GCP project. A Channel represents a subscriber's
 * intent to receive events from an event provider. A Channel is associated with
 * exactly one event provider.
 *
 * ChannelConnection is a first-class Eventarc resource that
 * is created and managed by the partner in their GCP project. A
 * ChannelConnection represents a connection between a partner and a
 * subscriber's Channel. A ChannelConnection has a one-to-one mapping with a
 * Channel.
 *
 * Publisher allows an event provider to publish events to Eventarc.
 */
class PublisherGrpcClient extends \Grpc\BaseStub {

    /**
     * @param string $hostname hostname
     * @param array $opts channel options
     * @param \Grpc\Channel $channel (optional) re-use channel object
     */
    public function __construct($hostname, $opts, $channel = null) {
        parent::__construct($hostname, $opts, $channel);
    }

    /**
     * Publish events to a ChannelConnection in a partner's project.
     * @param \Google\Cloud\Eventarc\Publishing\V1\PublishChannelConnectionEventsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function PublishChannelConnectionEvents(\Google\Cloud\Eventarc\Publishing\V1\PublishChannelConnectionEventsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.cloud.eventarc.publishing.v1.Publisher/PublishChannelConnectionEvents',
        $argument,
        ['\Google\Cloud\Eventarc\Publishing\V1\PublishChannelConnectionEventsResponse', 'decode'],
        $metadata, $options);
    }

    /**
     * Publish events to a subscriber's channel.
     * @param \Google\Cloud\Eventarc\Publishing\V1\PublishEventsRequest $argument input argument
     * @param array $metadata metadata
     * @param array $options call options
     * @return \Grpc\UnaryCall
     */
    public function PublishEvents(\Google\Cloud\Eventarc\Publishing\V1\PublishEventsRequest $argument,
      $metadata = [], $options = []) {
        return $this->_simpleRequest('/google.cloud.eventarc.publishing.v1.Publisher/PublishEvents',
        $argument,
        ['\Google\Cloud\Eventarc\Publishing\V1\PublishEventsResponse', 'decode'],
        $metadata, $options);
    }

}
