<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/resourcesettings/v1/resource_settings.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\ResourceSettings\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\ResourceSettings\V1\GetSettingRequest;
use Google\Cloud\ResourceSettings\V1\ListSettingsRequest;
use Google\Cloud\ResourceSettings\V1\Setting;
use Google\Cloud\ResourceSettings\V1\UpdateSettingRequest;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: An interface to interact with resource settings and setting values throughout
 * the resource hierarchy.
 *
 * Services may surface a number of settings for users to control how their
 * resources behave. Values of settings applied on a given Cloud resource are
 * evaluated hierarchically and inherited by all descendants of that resource.
 *
 * For all requests, returns a `google.rpc.Status` with
 * `google.rpc.Code.PERMISSION_DENIED` if the IAM check fails or the `parent`
 * resource is not in a Cloud Organization.
 * For all requests, returns a `google.rpc.Status` with
 * `google.rpc.Code.INVALID_ARGUMENT` if the request is malformed.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This class is currently experimental and may be subject to changes. See {@see
 * \Google\Cloud\ResourceSettings\V1\ResourceSettingsServiceClient} for the stable
 * implementation
 *
 * @experimental
 *
 * @method PromiseInterface getSettingAsync(GetSettingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSettingsAsync(ListSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSettingAsync(UpdateSettingRequest $request, array $optionalArgs = [])
 */
final class ResourceSettingsServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.resourcesettings.v1.ResourceSettingsService';

    /** The default address of the service. */
    private const SERVICE_ADDRESS = 'resourcesettings.googleapis.com';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/resource_settings_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/resource_settings_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/resource_settings_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/resource_settings_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_setting_name resource.
     *
     * @param string $folder
     * @param string $settingName
     *
     * @return string The formatted folder_setting_name resource.
     */
    public static function folderSettingNameName(string $folder, string $settingName): string
    {
        return self::getPathTemplate('folderSettingName')->render([
            'folder' => $folder,
            'setting_name' => $settingName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_setting_name resource.
     *
     * @param string $organization
     * @param string $settingName
     *
     * @return string The formatted organization_setting_name resource.
     */
    public static function organizationSettingNameName(string $organization, string $settingName): string
    {
        return self::getPathTemplate('organizationSettingName')->render([
            'organization' => $organization,
            'setting_name' => $settingName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_number_setting_name resource.
     *
     * @param string $projectNumber
     * @param string $settingName
     *
     * @return string The formatted project_number_setting_name resource.
     */
    public static function projectNumberSettingNameName(string $projectNumber, string $settingName): string
    {
        return self::getPathTemplate('projectNumberSettingName')->render([
            'project_number' => $projectNumber,
            'setting_name' => $settingName,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a setting
     * resource.
     *
     * @param string $projectNumber
     * @param string $settingName
     *
     * @return string The formatted setting resource.
     */
    public static function settingName(string $projectNumber, string $settingName): string
    {
        return self::getPathTemplate('setting')->render([
            'project_number' => $projectNumber,
            'setting_name' => $settingName,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - folderSettingName: folders/{folder}/settings/{setting_name}
     * - organizationSettingName: organizations/{organization}/settings/{setting_name}
     * - projectNumberSettingName: projects/{project_number}/settings/{setting_name}
     * - setting: projects/{project_number}/settings/{setting_name}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'resourcesettings.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Gets a setting.
     *
     * Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
     * setting does not exist.
     *
     * The async variant is {@see ResourceSettingsServiceClient::getSettingAsync()} .
     *
     * @param GetSettingRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Setting
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSetting(GetSettingRequest $request, array $callOptions = []): Setting
    {
        return $this->startApiCall('GetSetting', $request, $callOptions)->wait();
    }

    /**
     * Lists all the settings that are available on the Cloud resource `parent`.
     *
     * The async variant is {@see ResourceSettingsServiceClient::listSettingsAsync()} .
     *
     * @param ListSettingsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSettings(ListSettingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSettings', $request, $callOptions);
    }

    /**
     * Updates a setting.
     *
     * Returns a `google.rpc.Status` with `google.rpc.Code.NOT_FOUND` if the
     * setting does not exist.
     * Returns a `google.rpc.Status` with `google.rpc.Code.FAILED_PRECONDITION` if
     * the setting is flagged as read only.
     * Returns a `google.rpc.Status` with `google.rpc.Code.ABORTED` if the etag
     * supplied in the request does not match the persisted etag of the setting
     * value.
     *
     * On success, the response will contain only `name`, `local_value` and
     * `etag`.  The `metadata` and `effective_value` cannot be updated through
     * this API.
     *
     * Note: the supplied setting will perform a full overwrite of the
     * `local_value` field.
     *
     * The async variant is {@see ResourceSettingsServiceClient::updateSettingAsync()}
     * .
     *
     * @param UpdateSettingRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Setting
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSetting(UpdateSettingRequest $request, array $callOptions = []): Setting
    {
        return $this->startApiCall('UpdateSetting', $request, $callOptions)->wait();
    }
}
