<?php
/*
 * Copyright 2021 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/networkconnectivity/v1/hub.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\NetworkConnectivity\V1\Gapic;

use Google\ApiCore\ApiException;
use Google\ApiCore\Call;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PathTemplate;
use Google\ApiCore\RequestParamsHeaderDescriptor;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\GetPolicyOptions;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\ListLocationsResponse;
use Google\Cloud\Location\Location;
use Google\Cloud\NetworkConnectivity\V1\AcceptHubSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\CreateSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteHubRequest;
use Google\Cloud\NetworkConnectivity\V1\DeleteSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\GetGroupRequest;
use Google\Cloud\NetworkConnectivity\V1\GetHubRequest;
use Google\Cloud\NetworkConnectivity\V1\GetRouteRequest;
use Google\Cloud\NetworkConnectivity\V1\GetRouteTableRequest;
use Google\Cloud\NetworkConnectivity\V1\GetSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\Group;
use Google\Cloud\NetworkConnectivity\V1\Hub;
use Google\Cloud\NetworkConnectivity\V1\ListGroupsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListGroupsResponse;
use Google\Cloud\NetworkConnectivity\V1\ListHubSpokesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListHubSpokesResponse;
use Google\Cloud\NetworkConnectivity\V1\ListHubsRequest;
use Google\Cloud\NetworkConnectivity\V1\ListHubsResponse;
use Google\Cloud\NetworkConnectivity\V1\ListRouteTablesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListRouteTablesResponse;
use Google\Cloud\NetworkConnectivity\V1\ListRoutesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListRoutesResponse;
use Google\Cloud\NetworkConnectivity\V1\ListSpokesRequest;
use Google\Cloud\NetworkConnectivity\V1\ListSpokesResponse;
use Google\Cloud\NetworkConnectivity\V1\RejectHubSpokeRequest;
use Google\Cloud\NetworkConnectivity\V1\Route;
use Google\Cloud\NetworkConnectivity\V1\RouteTable;
use Google\Cloud\NetworkConnectivity\V1\Spoke;
use Google\Cloud\NetworkConnectivity\V1\UpdateHubRequest;
use Google\Cloud\NetworkConnectivity\V1\UpdateSpokeRequest;
use Google\LongRunning\Operation;
use Google\Protobuf\FieldMask;

/**
 * Service Description: Network Connectivity Center is a hub-and-spoke abstraction for network
 * connectivity management in Google Cloud. It reduces operational complexity
 * through a simple, centralized connectivity management model.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods. Sample code to get started:
 *
 * ```
 * $hubServiceClient = new HubServiceClient();
 * try {
 *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
 *     $formattedSpokeUri = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
 *     $operationResponse = $hubServiceClient->acceptHubSpoke($formattedName, $formattedSpokeUri);
 *     $operationResponse->pollUntilComplete();
 *     if ($operationResponse->operationSucceeded()) {
 *         $result = $operationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $operationResponse->getError();
 *         // handleError($error)
 *     }
 *     // Alternatively:
 *     // start the operation, keep the operation name, and resume later
 *     $operationResponse = $hubServiceClient->acceptHubSpoke($formattedName, $formattedSpokeUri);
 *     $operationName = $operationResponse->getName();
 *     // ... do other work
 *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'acceptHubSpoke');
 *     while (!$newOperationResponse->isDone()) {
 *         // ... do other work
 *         $newOperationResponse->reload();
 *     }
 *     if ($newOperationResponse->operationSucceeded()) {
 *         $result = $newOperationResponse->getResult();
 *     // doSomethingWith($result)
 *     } else {
 *         $error = $newOperationResponse->getError();
 *         // handleError($error)
 *     }
 * } finally {
 *     $hubServiceClient->close();
 * }
 * ```
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * This service has a new (beta) implementation. See {@see
 * \Google\Cloud\NetworkConnectivity\V1\Client\HubServiceClient} to use the new
 * surface.
 */
class HubServiceGapicClient
{
    use GapicClientTrait;

    /** The name of the service. */
    const SERVICE_NAME = 'google.cloud.networkconnectivity.v1.HubService';

    /** The default address of the service. */
    const SERVICE_ADDRESS = 'networkconnectivity.googleapis.com';

    /** The default port of the service. */
    const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private static $groupNameTemplate;

    private static $hubNameTemplate;

    private static $hubRouteNameTemplate;

    private static $instanceNameTemplate;

    private static $interconnectAttachmentNameTemplate;

    private static $locationNameTemplate;

    private static $networkNameTemplate;

    private static $routeTableNameTemplate;

    private static $spokeNameTemplate;

    private static $vpnTunnelNameTemplate;

    private static $pathTemplateMap;

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' =>
                self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' =>
                __DIR__ . '/../resources/hub_service_client_config.json',
            'descriptorsConfigPath' =>
                __DIR__ . '/../resources/hub_service_descriptor_config.php',
            'gcpApiConfigPath' =>
                __DIR__ . '/../resources/hub_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ .
                        '/../resources/hub_service_rest_client_config.php',
                ],
            ],
        ];
    }

    private static function getGroupNameTemplate()
    {
        if (self::$groupNameTemplate == null) {
            self::$groupNameTemplate = new PathTemplate(
                'projects/{project}/locations/global/hubs/{hub}/groups/{group}'
            );
        }

        return self::$groupNameTemplate;
    }

    private static function getHubNameTemplate()
    {
        if (self::$hubNameTemplate == null) {
            self::$hubNameTemplate = new PathTemplate(
                'projects/{project}/locations/global/hubs/{hub}'
            );
        }

        return self::$hubNameTemplate;
    }

    private static function getHubRouteNameTemplate()
    {
        if (self::$hubRouteNameTemplate == null) {
            self::$hubRouteNameTemplate = new PathTemplate(
                'projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}/routes/{route}'
            );
        }

        return self::$hubRouteNameTemplate;
    }

    private static function getInstanceNameTemplate()
    {
        if (self::$instanceNameTemplate == null) {
            self::$instanceNameTemplate = new PathTemplate(
                'projects/{project}/zones/{zone}/instances/{instance}'
            );
        }

        return self::$instanceNameTemplate;
    }

    private static function getInterconnectAttachmentNameTemplate()
    {
        if (self::$interconnectAttachmentNameTemplate == null) {
            self::$interconnectAttachmentNameTemplate = new PathTemplate(
                'projects/{project}/regions/{region}/interconnectAttachments/{resource_id}'
            );
        }

        return self::$interconnectAttachmentNameTemplate;
    }

    private static function getLocationNameTemplate()
    {
        if (self::$locationNameTemplate == null) {
            self::$locationNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}'
            );
        }

        return self::$locationNameTemplate;
    }

    private static function getNetworkNameTemplate()
    {
        if (self::$networkNameTemplate == null) {
            self::$networkNameTemplate = new PathTemplate(
                'projects/{project}/global/networks/{resource_id}'
            );
        }

        return self::$networkNameTemplate;
    }

    private static function getRouteTableNameTemplate()
    {
        if (self::$routeTableNameTemplate == null) {
            self::$routeTableNameTemplate = new PathTemplate(
                'projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}'
            );
        }

        return self::$routeTableNameTemplate;
    }

    private static function getSpokeNameTemplate()
    {
        if (self::$spokeNameTemplate == null) {
            self::$spokeNameTemplate = new PathTemplate(
                'projects/{project}/locations/{location}/spokes/{spoke}'
            );
        }

        return self::$spokeNameTemplate;
    }

    private static function getVpnTunnelNameTemplate()
    {
        if (self::$vpnTunnelNameTemplate == null) {
            self::$vpnTunnelNameTemplate = new PathTemplate(
                'projects/{project}/regions/{region}/vpnTunnels/{resource_id}'
            );
        }

        return self::$vpnTunnelNameTemplate;
    }

    private static function getPathTemplateMap()
    {
        if (self::$pathTemplateMap == null) {
            self::$pathTemplateMap = [
                'group' => self::getGroupNameTemplate(),
                'hub' => self::getHubNameTemplate(),
                'hubRoute' => self::getHubRouteNameTemplate(),
                'instance' => self::getInstanceNameTemplate(),
                'interconnectAttachment' => self::getInterconnectAttachmentNameTemplate(),
                'location' => self::getLocationNameTemplate(),
                'network' => self::getNetworkNameTemplate(),
                'routeTable' => self::getRouteTableNameTemplate(),
                'spoke' => self::getSpokeNameTemplate(),
                'vpnTunnel' => self::getVpnTunnelNameTemplate(),
            ];
        }

        return self::$pathTemplateMap;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a group
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $group
     *
     * @return string The formatted group resource.
     */
    public static function groupName($project, $hub, $group)
    {
        return self::getGroupNameTemplate()->render([
            'project' => $project,
            'hub' => $hub,
            'group' => $group,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hub
     * resource.
     *
     * @param string $project
     * @param string $hub
     *
     * @return string The formatted hub resource.
     */
    public static function hubName($project, $hub)
    {
        return self::getHubNameTemplate()->render([
            'project' => $project,
            'hub' => $hub,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a hub_route
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $routeTable
     * @param string $route
     *
     * @return string The formatted hub_route resource.
     */
    public static function hubRouteName($project, $hub, $routeTable, $route)
    {
        return self::getHubRouteNameTemplate()->render([
            'project' => $project,
            'hub' => $hub,
            'route_table' => $routeTable,
            'route' => $route,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a instance
     * resource.
     *
     * @param string $project
     * @param string $zone
     * @param string $instance
     *
     * @return string The formatted instance resource.
     */
    public static function instanceName($project, $zone, $instance)
    {
        return self::getInstanceNameTemplate()->render([
            'project' => $project,
            'zone' => $zone,
            'instance' => $instance,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * interconnect_attachment resource.
     *
     * @param string $project
     * @param string $region
     * @param string $resourceId
     *
     * @return string The formatted interconnect_attachment resource.
     */
    public static function interconnectAttachmentName(
        $project,
        $region,
        $resourceId
    ) {
        return self::getInterconnectAttachmentNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName($project, $location)
    {
        return self::getLocationNameTemplate()->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $resourceId
     *
     * @return string The formatted network resource.
     */
    public static function networkName($project, $resourceId)
    {
        return self::getNetworkNameTemplate()->render([
            'project' => $project,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a route_table
     * resource.
     *
     * @param string $project
     * @param string $hub
     * @param string $routeTable
     *
     * @return string The formatted route_table resource.
     */
    public static function routeTableName($project, $hub, $routeTable)
    {
        return self::getRouteTableNameTemplate()->render([
            'project' => $project,
            'hub' => $hub,
            'route_table' => $routeTable,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a spoke
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $spoke
     *
     * @return string The formatted spoke resource.
     */
    public static function spokeName($project, $location, $spoke)
    {
        return self::getSpokeNameTemplate()->render([
            'project' => $project,
            'location' => $location,
            'spoke' => $spoke,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a vpn_tunnel
     * resource.
     *
     * @param string $project
     * @param string $region
     * @param string $resourceId
     *
     * @return string The formatted vpn_tunnel resource.
     */
    public static function vpnTunnelName($project, $region, $resourceId)
    {
        return self::getVpnTunnelNameTemplate()->render([
            'project' => $project,
            'region' => $region,
            'resource_id' => $resourceId,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - group: projects/{project}/locations/global/hubs/{hub}/groups/{group}
     * - hub: projects/{project}/locations/global/hubs/{hub}
     * - hubRoute: projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}/routes/{route}
     * - instance: projects/{project}/zones/{zone}/instances/{instance}
     * - interconnectAttachment: projects/{project}/regions/{region}/interconnectAttachments/{resource_id}
     * - location: projects/{project}/locations/{location}
     * - network: projects/{project}/global/networks/{resource_id}
     * - routeTable: projects/{project}/locations/global/hubs/{hub}/routeTables/{route_table}
     * - spoke: projects/{project}/locations/{location}/spokes/{spoke}
     * - vpnTunnel: projects/{project}/regions/{region}/vpnTunnels/{resource_id}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName($formattedName, $template = null)
    {
        $templateMap = self::getPathTemplateMap();
        if ($template) {
            if (!isset($templateMap[$template])) {
                throw new ValidationException(
                    "Template name $template does not exist"
                );
            }

            return $templateMap[$template]->match($formattedName);
        }

        foreach ($templateMap as $templateName => $pathTemplate) {
            try {
                return $pathTemplate->match($formattedName);
            } catch (ValidationException $ex) {
                // Swallow the exception to continue trying other path templates
            }
        }

        throw new ValidationException(
            "Input did not match any known format. Input: $formattedName"
        );
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse(
            $operationName,
            $this->getOperationsClient(),
            $options
        );
        $operation->reload();
        return $operation;
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'networkconnectivity.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /**
     * Accepts a proposal to attach a Network Connectivity Center spoke
     * to a hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $formattedSpokeUri = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $operationResponse = $hubServiceClient->acceptHubSpoke($formattedName, $formattedSpokeUri);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->acceptHubSpoke($formattedName, $formattedSpokeUri);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'acceptHubSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub into which to accept the spoke.
     * @param string $spokeUri     Required. The URI of the spoke to accept into the hub.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function acceptHubSpoke($name, $spokeUri, array $optionalArgs = [])
    {
        $request = new AcceptHubSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setSpokeUri($spokeUri);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'AcceptHubSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a new Network Connectivity Center hub in the specified project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $hubId = 'hub_id';
     *     $hub = new Hub();
     *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->createHub($formattedParent, $hubId, $hub);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'createHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param string $hubId        Required. A unique identifier for the hub.
     * @param Hub    $hub          Required. The initial values for a new hub.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createHub($parent, $hubId, $hub, array $optionalArgs = [])
    {
        $request = new CreateHubRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setHubId($hubId);
        $request->setHub($hub);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Creates a Network Connectivity Center spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     $spokeId = 'spoke_id';
     *     $spoke = new Spoke();
     *     $operationResponse = $hubServiceClient->createSpoke($formattedParent, $spokeId, $spoke);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->createSpoke($formattedParent, $spokeId, $spoke);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'createSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param string $spokeId      Required. Unique id for the spoke to create.
     * @param Spoke  $spoke        Required. The initial values for a new spoke.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function createSpoke(
        $parent,
        $spokeId,
        $spoke,
        array $optionalArgs = []
    ) {
        $request = new CreateSpokeRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $request->setSpokeId($spokeId);
        $request->setSpoke($spoke);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'CreateSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a Network Connectivity Center hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $operationResponse = $hubServiceClient->deleteHub($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->deleteHub($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'deleteHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteHub($name, array $optionalArgs = [])
    {
        $request = new DeleteHubRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Deletes a Network Connectivity Center spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $operationResponse = $hubServiceClient->deleteSpoke($formattedName);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->deleteSpoke($formattedName);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'deleteSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         // operation succeeded and returns no value
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spoke to delete.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function deleteSpoke($name, array $optionalArgs = [])
    {
        $request = new DeleteSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'DeleteSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets details about a Network Connectivity Center group.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->groupName('[PROJECT]', '[HUB]', '[GROUP]');
     *     $response = $hubServiceClient->getGroup($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the route table resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Group
     *
     * @throws ApiException if the remote call fails
     */
    public function getGroup($name, array $optionalArgs = [])
    {
        $request = new GetGroupRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetGroup',
            Group::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about a Network Connectivity Center hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $response = $hubServiceClient->getHub($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub resource to get.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Hub
     *
     * @throws ApiException if the remote call fails
     */
    public function getHub($name, array $optionalArgs = [])
    {
        $request = new GetHubRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetHub',
            Hub::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about the specified route.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubRouteName('[PROJECT]', '[HUB]', '[ROUTE_TABLE]', '[ROUTE]');
     *     $response = $hubServiceClient->getRoute($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the route resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Route
     *
     * @throws ApiException if the remote call fails
     */
    public function getRoute($name, array $optionalArgs = [])
    {
        $request = new GetRouteRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRoute',
            Route::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about a Network Connectivity Center route table.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->routeTableName('[PROJECT]', '[HUB]', '[ROUTE_TABLE]');
     *     $response = $hubServiceClient->getRouteTable($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the route table resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\RouteTable
     *
     * @throws ApiException if the remote call fails
     */
    public function getRouteTable($name, array $optionalArgs = [])
    {
        $request = new GetRouteTableRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetRouteTable',
            RouteTable::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Gets details about a Network Connectivity Center spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $response = $hubServiceClient->getSpoke($formattedName);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the spoke resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\NetworkConnectivity\V1\Spoke
     *
     * @throws ApiException if the remote call fails
     */
    public function getSpoke($name, array $optionalArgs = [])
    {
        $request = new GetSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetSpoke',
            Spoke::class,
            $optionalArgs,
            $request
        )->wait();
    }

    /**
     * Lists groups in a given hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listGroups($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listGroups($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listGroups($parent, array $optionalArgs = [])
    {
        $request = new ListGroupsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListGroups',
            $optionalArgs,
            ListGroupsResponse::class,
            $request
        );
    }

    /**
     * Lists the Network Connectivity Center spokes associated with a
     * specified hub and location. The list includes both spokes that are attached
     * to the hub and spokes that have been proposed but not yet accepted.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listHubSpokes($formattedName);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listHubSpokes($formattedName);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string[] $spokeLocations
     *           A list of locations.
     *           Specify one of the following: `[global]`, a single region (for
     *           example, `[us-central1]`), or a combination of
     *           values (for example, `[global, us-central1, us-west1]`).
     *           If the spoke_locations field is populated, the list of results
     *           includes only spokes in the specified location.
     *           If the spoke_locations field is not populated, the list of results
     *           includes spokes in all locations.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by name or create_time.
     *     @type int $view
     *           The view of the spoke to return.
     *           The view that you use determines which spoke fields are included in the
     *           response.
     *           For allowed values, use constants defined on {@see \Google\Cloud\NetworkConnectivity\V1\ListHubSpokesRequest\SpokeView}
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listHubSpokes($name, array $optionalArgs = [])
    {
        $request = new ListHubSpokesRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['spokeLocations'])) {
            $request->setSpokeLocations($optionalArgs['spokeLocations']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        if (isset($optionalArgs['view'])) {
            $request->setView($optionalArgs['view']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListHubSpokes',
            $optionalArgs,
            ListHubSpokesResponse::class,
            $request
        );
    }

    /**
     * Lists the Network Connectivity Center hubs associated with a given project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listHubs($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listHubs($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listHubs($parent, array $optionalArgs = [])
    {
        $request = new ListHubsRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListHubs',
            $optionalArgs,
            ListHubsResponse::class,
            $request
        );
    }

    /**
     * Lists route tables in a given project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listRouteTables($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listRouteTables($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRouteTables($parent, array $optionalArgs = [])
    {
        $request = new ListRouteTablesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRouteTables',
            $optionalArgs,
            ListRouteTablesResponse::class,
            $request
        );
    }

    /**
     * Lists routes in a given project.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->routeTableName('[PROJECT]', '[HUB]', '[ROUTE_TABLE]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listRoutes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listRoutes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource's name.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listRoutes($parent, array $optionalArgs = [])
    {
        $request = new ListRoutesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListRoutes',
            $optionalArgs,
            ListRoutesResponse::class,
            $request
        );
    }

    /**
     * Lists the Network Connectivity Center spokes in a specified project and
     * location.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedParent = $hubServiceClient->locationName('[PROJECT]', '[LOCATION]');
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listSpokes($formattedParent);
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listSpokes($formattedParent);
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $parent       Required. The parent resource.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type string $filter
     *           An expression that filters the list of results.
     *     @type string $orderBy
     *           Sort the results by a certain order.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listSpokes($parent, array $optionalArgs = [])
    {
        $request = new ListSpokesRequest();
        $requestParamHeaders = [];
        $request->setParent($parent);
        $requestParamHeaders['parent'] = $parent;
        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['orderBy'])) {
            $request->setOrderBy($optionalArgs['orderBy']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListSpokes',
            $optionalArgs,
            ListSpokesResponse::class,
            $request
        );
    }

    /**
     * Rejects a Network Connectivity Center spoke from being attached to a hub.
     * If the spoke was previously in the `ACTIVE` state, it
     * transitions to the `INACTIVE` state and is no longer able to
     * connect to other spokes that are attached to the hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $formattedName = $hubServiceClient->hubName('[PROJECT]', '[HUB]');
     *     $formattedSpokeUri = $hubServiceClient->spokeName('[PROJECT]', '[LOCATION]', '[SPOKE]');
     *     $operationResponse = $hubServiceClient->rejectHubSpoke($formattedName, $formattedSpokeUri);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->rejectHubSpoke($formattedName, $formattedSpokeUri);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'rejectHubSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $name         Required. The name of the hub from which to reject the spoke.
     * @param string $spokeUri     Required. The URI of the spoke to reject from the hub.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type string $details
     *           Optional. Additional information provided by the hub administrator.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function rejectHubSpoke($name, $spokeUri, array $optionalArgs = [])
    {
        $request = new RejectHubSpokeRequest();
        $requestParamHeaders = [];
        $request->setName($name);
        $request->setSpokeUri($spokeUri);
        $requestParamHeaders['name'] = $name;
        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        if (isset($optionalArgs['details'])) {
            $request->setDetails($optionalArgs['details']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'RejectHubSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the description and/or labels of a Network Connectivity Center
     * hub.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $hub = new Hub();
     *     $operationResponse = $hubServiceClient->updateHub($hub);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->updateHub($hub);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'updateHub');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param Hub   $hub          Required. The state that the hub should be in after the update.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. In the case of an update to an existing hub, field mask is used
     *           to specify the fields to be overwritten. The fields specified in the
     *           update_mask are relative to the resource, not the full request. A field is
     *           overwritten if it is in the mask. If the user does not provide a mask, then
     *           all fields are overwritten.
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateHub($hub, array $optionalArgs = [])
    {
        $request = new UpdateHubRequest();
        $requestParamHeaders = [];
        $request->setHub($hub);
        $requestParamHeaders['hub.name'] = $hub->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateHub',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Updates the parameters of a Network Connectivity Center spoke.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $spoke = new Spoke();
     *     $operationResponse = $hubServiceClient->updateSpoke($spoke);
     *     $operationResponse->pollUntilComplete();
     *     if ($operationResponse->operationSucceeded()) {
     *         $result = $operationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $operationResponse->getError();
     *         // handleError($error)
     *     }
     *     // Alternatively:
     *     // start the operation, keep the operation name, and resume later
     *     $operationResponse = $hubServiceClient->updateSpoke($spoke);
     *     $operationName = $operationResponse->getName();
     *     // ... do other work
     *     $newOperationResponse = $hubServiceClient->resumeOperation($operationName, 'updateSpoke');
     *     while (!$newOperationResponse->isDone()) {
     *         // ... do other work
     *         $newOperationResponse->reload();
     *     }
     *     if ($newOperationResponse->operationSucceeded()) {
     *         $result = $newOperationResponse->getResult();
     *     // doSomethingWith($result)
     *     } else {
     *         $error = $newOperationResponse->getError();
     *         // handleError($error)
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param Spoke $spoke        Required. The state that the spoke should be in after the update.
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           Optional. In the case of an update to an existing spoke, field mask is used
     *           to specify the fields to be overwritten. The fields specified in the
     *           update_mask are relative to the resource, not the full request. A field is
     *           overwritten if it is in the mask. If the user does not provide a mask, then
     *           all fields are overwritten.
     *     @type string $requestId
     *           Optional. A request ID to identify requests. Specify a unique request ID so
     *           that if you must retry your request, the server knows to ignore the request
     *           if it has already been completed. The server guarantees that a request
     *           doesn't result in creation of duplicate commitments for at least 60
     *           minutes.
     *
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check to see whether the original operation
     *           was received. If it was, the server ignores the second request. This
     *           behavior prevents clients from mistakenly creating duplicate commitments.
     *
     *           The request ID must be a valid UUID, with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\OperationResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function updateSpoke($spoke, array $optionalArgs = [])
    {
        $request = new UpdateSpokeRequest();
        $requestParamHeaders = [];
        $request->setSpoke($spoke);
        $requestParamHeaders['spoke.name'] = $spoke->getName();
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        if (isset($optionalArgs['requestId'])) {
            $request->setRequestId($optionalArgs['requestId']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startOperationsCall(
            'UpdateSpoke',
            $optionalArgs,
            $request,
            $this->getOperationsClient()
        )->wait();
    }

    /**
     * Gets information about a location.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $response = $hubServiceClient->getLocation();
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           Resource name for the location.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Location\Location
     *
     * @throws ApiException if the remote call fails
     */
    public function getLocation(array $optionalArgs = [])
    {
        $request = new GetLocationRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetLocation',
            Location::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.cloud.location.Locations'
        )->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     // Iterate over pages of elements
     *     $pagedResponse = $hubServiceClient->listLocations();
     *     foreach ($pagedResponse->iteratePages() as $page) {
     *         foreach ($page as $element) {
     *             // doSomethingWith($element);
     *         }
     *     }
     *     // Alternatively:
     *     // Iterate through all elements
     *     $pagedResponse = $hubServiceClient->listLocations();
     *     foreach ($pagedResponse->iterateAllElements() as $element) {
     *         // doSomethingWith($element);
     *     }
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param array $optionalArgs {
     *     Optional.
     *
     *     @type string $name
     *           The resource that owns the locations collection, if applicable.
     *     @type string $filter
     *           The standard list filter.
     *     @type int $pageSize
     *           The maximum number of resources contained in the underlying API
     *           response. The API may return fewer values in a page, even if
     *           there are additional values to be retrieved.
     *     @type string $pageToken
     *           A page token is used to specify a page of values to be returned.
     *           If no page token is specified (the default), the first page
     *           of values will be returned. Any page token used here must have
     *           been generated by a previous call to the API.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\ApiCore\PagedListResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function listLocations(array $optionalArgs = [])
    {
        $request = new ListLocationsRequest();
        $requestParamHeaders = [];
        if (isset($optionalArgs['name'])) {
            $request->setName($optionalArgs['name']);
            $requestParamHeaders['name'] = $optionalArgs['name'];
        }

        if (isset($optionalArgs['filter'])) {
            $request->setFilter($optionalArgs['filter']);
        }

        if (isset($optionalArgs['pageSize'])) {
            $request->setPageSize($optionalArgs['pageSize']);
        }

        if (isset($optionalArgs['pageToken'])) {
            $request->setPageToken($optionalArgs['pageToken']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->getPagedListResponse(
            'ListLocations',
            $optionalArgs,
            ListLocationsResponse::class,
            $request,
            'google.cloud.location.Locations'
        );
    }

    /**
     * Gets the access control policy for a resource. Returns an empty policy
    if the resource exists and does not have a policy set.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $response = $hubServiceClient->getIamPolicy($resource);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being requested.
     *                             See the operation documentation for the appropriate value for this field.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type GetPolicyOptions $options
     *           OPTIONAL: A `GetPolicyOptions` object for specifying options to
     *           `GetIamPolicy`.
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function getIamPolicy($resource, array $optionalArgs = [])
    {
        $request = new GetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['options'])) {
            $request->setOptions($optionalArgs['options']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'GetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Sets the access control policy on the specified resource. Replaces
    any existing policy.

    Can return `NOT_FOUND`, `INVALID_ARGUMENT`, and `PERMISSION_DENIED`
    errors.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $policy = new Policy();
     *     $response = $hubServiceClient->setIamPolicy($resource, $policy);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string $resource     REQUIRED: The resource for which the policy is being specified.
     *                             See the operation documentation for the appropriate value for this field.
     * @param Policy $policy       REQUIRED: The complete policy to be applied to the `resource`. The size of
     *                             the policy is limited to a few 10s of KB. An empty policy is a
     *                             valid policy but certain Cloud Platform services (such as Projects)
     *                             might reject them.
     * @param array  $optionalArgs {
     *     Optional.
     *
     *     @type FieldMask $updateMask
     *           OPTIONAL: A FieldMask specifying which fields of the policy to modify. Only
     *           the fields in the mask will be modified. If no mask is provided, the
     *           following default mask is used:
     *
     *           `paths: "bindings, etag"`
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\Policy
     *
     * @throws ApiException if the remote call fails
     */
    public function setIamPolicy($resource, $policy, array $optionalArgs = [])
    {
        $request = new SetIamPolicyRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPolicy($policy);
        $requestParamHeaders['resource'] = $resource;
        if (isset($optionalArgs['updateMask'])) {
            $request->setUpdateMask($optionalArgs['updateMask']);
        }

        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'SetIamPolicy',
            Policy::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }

    /**
     * Returns permissions that a caller has on the specified resource. If the
    resource does not exist, this will return an empty set of
    permissions, not a `NOT_FOUND` error.

    Note: This operation is designed to be used for building
    permission-aware UIs and command-line tools, not for authorization
    checking. This operation may "fail open" without warning.
     *
     * Sample code:
     * ```
     * $hubServiceClient = new HubServiceClient();
     * try {
     *     $resource = 'resource';
     *     $permissions = [];
     *     $response = $hubServiceClient->testIamPermissions($resource, $permissions);
     * } finally {
     *     $hubServiceClient->close();
     * }
     * ```
     *
     * @param string   $resource     REQUIRED: The resource for which the policy detail is being requested.
     *                               See the operation documentation for the appropriate value for this field.
     * @param string[] $permissions  The set of permissions to check for the `resource`. Permissions with
     *                               wildcards (such as '*' or 'storage.*') are not allowed. For more
     *                               information see
     *                               [IAM Overview](https://cloud.google.com/iam/docs/overview#permissions).
     * @param array    $optionalArgs {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return \Google\Cloud\Iam\V1\TestIamPermissionsResponse
     *
     * @throws ApiException if the remote call fails
     */
    public function testIamPermissions(
        $resource,
        $permissions,
        array $optionalArgs = []
    ) {
        $request = new TestIamPermissionsRequest();
        $requestParamHeaders = [];
        $request->setResource($resource);
        $request->setPermissions($permissions);
        $requestParamHeaders['resource'] = $resource;
        $requestParams = new RequestParamsHeaderDescriptor(
            $requestParamHeaders
        );
        $optionalArgs['headers'] = isset($optionalArgs['headers'])
            ? array_merge($requestParams->getHeader(), $optionalArgs['headers'])
            : $requestParams->getHeader();
        return $this->startCall(
            'TestIamPermissions',
            TestIamPermissionsResponse::class,
            $optionalArgs,
            $request,
            Call::UNARY_CALL,
            'google.iam.v1.IAMPolicy'
        )->wait();
    }
}
