<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/audio_config.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Instructs the speech recognizer on how to process the audio content.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.InputAudioConfig</code>
 */
class InputAudioConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $audio_encoding = 0;
    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 2;</code>
     */
    protected $sample_rate_hertz = 0;
    /**
     * Optional. If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 13;</code>
     */
    protected $enable_word_info = false;
    /**
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * Generated from protobuf field <code>repeated string phrase_hints = 4;</code>
     */
    private $phrase_hints;
    /**
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the InputAudioConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 7;</code>
     */
    protected $model = '';
    /**
     * Optional. Which variant of the [Speech
     * model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     */
    protected $model_variant = 0;
    /**
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     *
     * Generated from protobuf field <code>bool single_utterance = 8;</code>
     */
    protected $single_utterance = false;
    /**
     * Configuration of barge-in behavior during the streaming of input audio.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.BargeInConfig barge_in_config = 15;</code>
     */
    protected $barge_in_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $audio_encoding
     *           Required. Audio encoding of the audio content to process.
     *     @type int $sample_rate_hertz
     *           Sample rate (in Hertz) of the audio content sent in the query.
     *           Refer to
     *           [Cloud Speech API
     *           documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     *           more details.
     *     @type bool $enable_word_info
     *           Optional. If `true`, Dialogflow returns
     *           [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     *           [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult]
     *           with information about the recognized speech words, e.g. start and end time
     *           offsets. If false or unspecified, Speech doesn't return any word-level
     *           information.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $phrase_hints
     *           Optional. A list of strings containing words and phrases that the speech
     *           recognizer should recognize with higher likelihood.
     *           See [the Cloud Speech
     *           documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     *           for more details.
     *     @type string $model
     *           Optional. Which Speech model to select for the given request. Select the
     *           model best suited to your domain to get best results. If a model is not
     *           explicitly specified, then Dialogflow auto-selects a model based on other
     *           parameters in the InputAudioConfig and Agent settings.
     *           If enhanced speech model is enabled for the agent and an enhanced
     *           version of the specified model for the language does not exist, then the
     *           speech is recognized using the standard version of the specified model.
     *           Refer to
     *           [Cloud Speech API
     *           documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     *           for more details.
     *           If you specify a model, the following models typically have the best
     *           performance:
     *           - phone_call (best for Agent Assist and telephony)
     *           - latest_short (best for Dialogflow non-telephony)
     *           - command_and_search
     *           Leave this field unspecified to use
     *           [Agent Speech
     *           settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     *           for model selection.
     *     @type int $model_variant
     *           Optional. Which variant of the [Speech
     *           model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     *     @type bool $single_utterance
     *           Optional. If `false` (default), recognition does not cease until the
     *           client closes the stream.
     *           If `true`, the recognizer will detect a single spoken utterance in input
     *           audio. Recognition ceases when it detects the audio's voice has
     *           stopped or paused. In this case, once a detected intent is received, the
     *           client should close the stream and start a new request with a new stream as
     *           needed.
     *           Note: This setting is relevant only for streaming methods.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\BargeInConfig $barge_in_config
     *           Configuration of barge-in behavior during the streaming of input audio.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\AudioConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return int
     */
    public function getAudioEncoding()
    {
        return $this->audio_encoding;
    }

    /**
     * Required. Audio encoding of the audio content to process.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.AudioEncoding audio_encoding = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param int $var
     * @return $this
     */
    public function setAudioEncoding($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\AudioEncoding::class);
        $this->audio_encoding = $var;

        return $this;
    }

    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 2;</code>
     * @return int
     */
    public function getSampleRateHertz()
    {
        return $this->sample_rate_hertz;
    }

    /**
     * Sample rate (in Hertz) of the audio content sent in the query.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics) for
     * more details.
     *
     * Generated from protobuf field <code>int32 sample_rate_hertz = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setSampleRateHertz($var)
    {
        GPBUtil::checkInt32($var);
        $this->sample_rate_hertz = $var;

        return $this;
    }

    /**
     * Optional. If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 13;</code>
     * @return bool
     */
    public function getEnableWordInfo()
    {
        return $this->enable_word_info;
    }

    /**
     * Optional. If `true`, Dialogflow returns
     * [SpeechWordInfo][google.cloud.dialogflow.cx.v3.SpeechWordInfo] in
     * [StreamingRecognitionResult][google.cloud.dialogflow.cx.v3.StreamingRecognitionResult]
     * with information about the recognized speech words, e.g. start and end time
     * offsets. If false or unspecified, Speech doesn't return any word-level
     * information.
     *
     * Generated from protobuf field <code>bool enable_word_info = 13;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnableWordInfo($var)
    {
        GPBUtil::checkBool($var);
        $this->enable_word_info = $var;

        return $this;
    }

    /**
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * Generated from protobuf field <code>repeated string phrase_hints = 4;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPhraseHints()
    {
        return $this->phrase_hints;
    }

    /**
     * Optional. A list of strings containing words and phrases that the speech
     * recognizer should recognize with higher likelihood.
     * See [the Cloud Speech
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#phrase-hints)
     * for more details.
     *
     * Generated from protobuf field <code>repeated string phrase_hints = 4;</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPhraseHints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->phrase_hints = $arr;

        return $this;
    }

    /**
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the InputAudioConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 7;</code>
     * @return string
     */
    public function getModel()
    {
        return $this->model;
    }

    /**
     * Optional. Which Speech model to select for the given request. Select the
     * model best suited to your domain to get best results. If a model is not
     * explicitly specified, then Dialogflow auto-selects a model based on other
     * parameters in the InputAudioConfig and Agent settings.
     * If enhanced speech model is enabled for the agent and an enhanced
     * version of the specified model for the language does not exist, then the
     * speech is recognized using the standard version of the specified model.
     * Refer to
     * [Cloud Speech API
     * documentation](https://cloud.google.com/speech-to-text/docs/basics#select-model)
     * for more details.
     * If you specify a model, the following models typically have the best
     * performance:
     * - phone_call (best for Agent Assist and telephony)
     * - latest_short (best for Dialogflow non-telephony)
     * - command_and_search
     * Leave this field unspecified to use
     * [Agent Speech
     * settings](https://cloud.google.com/dialogflow/cx/docs/concept/agent#settings-speech)
     * for model selection.
     *
     * Generated from protobuf field <code>string model = 7;</code>
     * @param string $var
     * @return $this
     */
    public function setModel($var)
    {
        GPBUtil::checkString($var, True);
        $this->model = $var;

        return $this;
    }

    /**
     * Optional. Which variant of the [Speech
     * model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     * @return int
     */
    public function getModelVariant()
    {
        return $this->model_variant;
    }

    /**
     * Optional. Which variant of the [Speech
     * model][google.cloud.dialogflow.cx.v3.InputAudioConfig.model] to use.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SpeechModelVariant model_variant = 10;</code>
     * @param int $var
     * @return $this
     */
    public function setModelVariant($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Dialogflow\Cx\V3\SpeechModelVariant::class);
        $this->model_variant = $var;

        return $this;
    }

    /**
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     *
     * Generated from protobuf field <code>bool single_utterance = 8;</code>
     * @return bool
     */
    public function getSingleUtterance()
    {
        return $this->single_utterance;
    }

    /**
     * Optional. If `false` (default), recognition does not cease until the
     * client closes the stream.
     * If `true`, the recognizer will detect a single spoken utterance in input
     * audio. Recognition ceases when it detects the audio's voice has
     * stopped or paused. In this case, once a detected intent is received, the
     * client should close the stream and start a new request with a new stream as
     * needed.
     * Note: This setting is relevant only for streaming methods.
     *
     * Generated from protobuf field <code>bool single_utterance = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setSingleUtterance($var)
    {
        GPBUtil::checkBool($var);
        $this->single_utterance = $var;

        return $this;
    }

    /**
     * Configuration of barge-in behavior during the streaming of input audio.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.BargeInConfig barge_in_config = 15;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\BargeInConfig|null
     */
    public function getBargeInConfig()
    {
        return $this->barge_in_config;
    }

    public function hasBargeInConfig()
    {
        return isset($this->barge_in_config);
    }

    public function clearBargeInConfig()
    {
        unset($this->barge_in_config);
    }

    /**
     * Configuration of barge-in behavior during the streaming of input audio.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.BargeInConfig barge_in_config = 15;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\BargeInConfig $var
     * @return $this
     */
    public function setBargeInConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\BargeInConfig::class);
        $this->barge_in_config = $var;

        return $this;
    }

}

