<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/retail/v2/product.proto

namespace Google\Cloud\Retail\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Product captures all metadata information of items to be recommended or
 * searched.
 *
 * Generated from protobuf message <code>google.cloud.retail.v2.Product</code>
 */
class Product extends \Google\Protobuf\Internal\Message
{
    /**
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * The branch ID must be "default_branch".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $name = '';
    /**
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * Property [Product.sku](https://schema.org/sku).
     *
     * Generated from protobuf field <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $id = '';
    /**
     * Immutable. The type of the product. This field is output-only.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    private $type = 0;
    /**
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * Google Merchant Center Property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org Property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * This field must be enabled before it can be used. [Learn
     * more](https://cloud.google.com/recommendations-ai/docs/catalog#item-group-id).
     *
     * Generated from protobuf field <code>string primary_product_id = 4;</code>
     */
    private $primary_product_id = '';
    /**
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * For example, if a shoes product belongs to both
     * ["Shoes & Accessories" -> "Shoes"] and
     * ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
     * represented as:
     *      "categories": [
     *        "Shoes & Accessories > Shoes",
     *        "Sports & Fitness > Athletic Clothing > Shoes"
     *      ]
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     *
     * Generated from protobuf field <code>repeated string categories = 7;</code>
     */
    private $categories;
    /**
     * Required. Product title.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     *
     * Generated from protobuf field <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $title = '';
    /**
     * Product description.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * schema.org property [Product.description](https://schema.org/description).
     *
     * Generated from protobuf field <code>string description = 10;</code>
     */
    private $description = '';
    /**
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     * A maximum of 150 attributes are allowed. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 12;</code>
     */
    private $attributes;
    /**
     * Custom tags associated with the product.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     * Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     *
     * Generated from protobuf field <code>repeated string tags = 13;</code>
     */
    private $tags;
    /**
     * Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     */
    private $price_info = null;
    /**
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available recommendation and search.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_time = 18;</code>
     */
    private $available_time = null;
    /**
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     * Google Merchant Center Property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org Property [Offer.availability](https://schema.org/availability).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     */
    private $availability = 0;
    /**
     * The available quantity of the item.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     */
    private $available_quantity = null;
    /**
     * Canonical URL directly linking to the product detail page.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     *
     * Generated from protobuf field <code>string uri = 22;</code>
     */
    private $uri = '';
    /**
     * Product images for the product.
     * A maximum of 300 images are allowed.
     * Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     */
    private $images;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Immutable. Full resource name of the product, such as
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     *           The branch ID must be "default_branch".
     *     @type string $id
     *           Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     *           the final component of [name][google.cloud.retail.v2.Product.name]. For
     *           example, this field is "id_1", if
     *           [name][google.cloud.retail.v2.Product.name] is
     *           `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     *           This field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Google Merchant Center property
     *           [id](https://support.google.com/merchants/answer/6324405). Schema.org
     *           Property [Product.sku](https://schema.org/sku).
     *     @type int $type
     *           Immutable. The type of the product. This field is output-only.
     *     @type string $primary_product_id
     *           Variant group identifier. Must be an
     *           [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     *           this product. Otherwise, an error is thrown.
     *           For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     *           [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     *           set to the same value as [id][google.cloud.retail.v2.Product.id].
     *           For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     *           be empty. A maximum of 2,000 products are allowed to share the same
     *           [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     *           [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     *           error is returned.
     *           Google Merchant Center Property
     *           [item_group_id](https://support.google.com/merchants/answer/6324507).
     *           Schema.org Property
     *           [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     *           This field must be enabled before it can be used. [Learn
     *           more](https://cloud.google.com/recommendations-ai/docs/catalog#item-group-id).
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $categories
     *           Product categories. This field is repeated for supporting one product
     *           belonging to several parallel categories. Strongly recommended using the
     *           full path for better search / recommendation quality.
     *           To represent full path of category, use '>' sign to separate different
     *           hierarchies. If '>' is part of the category name, please replace it with
     *           other character(s).
     *           For example, if a shoes product belongs to both
     *           ["Shoes & Accessories" -> "Shoes"] and
     *           ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
     *           represented as:
     *                "categories": [
     *                  "Shoes & Accessories > Shoes",
     *                  "Sports & Fitness > Athletic Clothing > Shoes"
     *                ]
     *           Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     *           [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     *           error is returned.
     *           At most 250 values are allowed per
     *           [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     *           Each value must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Google Merchant Center property
     *           [google_product_category][mc_google_product_category]. Schema.org property
     *           [Product.category] (https://schema.org/category).
     *           [mc_google_product_category]:
     *           https://support.google.com/merchants/answer/6324436
     *     @type string $title
     *           Required. Product title.
     *           This field must be a UTF-8 encoded string with a length limit of 128
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Google Merchant Center property
     *           [title](https://support.google.com/merchants/answer/6324415). Schema.org
     *           property [Product.name](https://schema.org/name).
     *     @type string $description
     *           Product description.
     *           This field must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Google Merchant Center property
     *           [description](https://support.google.com/merchants/answer/6324468).
     *           schema.org property [Product.description](https://schema.org/description).
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Highly encouraged. Extra product attributes to be included. For example,
     *           for products, this could include the store name, vendor, style, color, etc.
     *           These are very strong signals for recommendation model, thus we highly
     *           recommend providing the attributes here.
     *           Features that can take on one of a limited number of possible values. Two
     *           types of features can be set are:
     *           Textual features. some examples would be the brand/maker of a product, or
     *           country of a customer. Numerical features. Some examples would be the
     *           height/weight of a product, or age of a customer.
     *           For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     *           "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     *           }`.
     *           A maximum of 150 attributes are allowed. Otherwise, an INVALID_ARGUMENT
     *           error is returned.
     *           The key must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $tags
     *           Custom tags associated with the product.
     *           At most 250 values are allowed per
     *           [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     *           encoded string with a length limit of 1,000 characters. Otherwise, an
     *           INVALID_ARGUMENT error is returned.
     *           This tag can be used for filtering recommendation results by passing the
     *           tag as part of the
     *           [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     *           Google Merchant Center property
     *           [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     *     @type \Google\Cloud\Retail\V2\PriceInfo $price_info
     *           Product price and cost information.
     *           Google Merchant Center property
     *           [price](https://support.google.com/merchants/answer/6324371).
     *     @type \Google\Protobuf\Timestamp $available_time
     *           The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     *           available recommendation and search.
     *     @type int $availability
     *           The online availability of the [Product][google.cloud.retail.v2.Product].
     *           Default to
     *           [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     *           Google Merchant Center Property
     *           [availability](https://support.google.com/merchants/answer/6324448).
     *           Schema.org Property [Offer.availability](https://schema.org/availability).
     *     @type \Google\Protobuf\Int32Value $available_quantity
     *           The available quantity of the item.
     *     @type string $uri
     *           Canonical URL directly linking to the product detail page.
     *           This field must be a UTF-8 encoded string with a length limit of 5,000
     *           characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *           Google Merchant Center property
     *           [link](https://support.google.com/merchants/answer/6324416). Schema.org
     *           property [Offer.url](https://schema.org/url).
     *     @type \Google\Cloud\Retail\V2\Image[]|\Google\Protobuf\Internal\RepeatedField $images
     *           Product images for the product.
     *           A maximum of 300 images are allowed.
     *           Google Merchant Center property
     *           [image_link](https://support.google.com/merchants/answer/6324350).
     *           Schema.org property [Product.image](https://schema.org/image).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Retail\V2\Product::initOnce();
        parent::__construct($data);
    }

    /**
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * The branch ID must be "default_branch".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Immutable. Full resource name of the product, such as
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/product_id`.
     * The branch ID must be "default_branch".
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * Property [Product.sku](https://schema.org/sku).
     *
     * Generated from protobuf field <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * Immutable. [Product][google.cloud.retail.v2.Product] identifier, which is
     * the final component of [name][google.cloud.retail.v2.Product.name]. For
     * example, this field is "id_1", if
     * [name][google.cloud.retail.v2.Product.name] is
     * `projects/&#42;&#47;locations/global/catalogs/default_catalog/branches/default_branch/products/id_1`.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [id](https://support.google.com/merchants/answer/6324405). Schema.org
     * Property [Product.sku](https://schema.org/sku).
     *
     * Generated from protobuf field <code>string id = 2 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * Immutable. The type of the product. This field is output-only.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Immutable. The type of the product. This field is output-only.
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Type type = 3 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\Product\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * Google Merchant Center Property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org Property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * This field must be enabled before it can be used. [Learn
     * more](https://cloud.google.com/recommendations-ai/docs/catalog#item-group-id).
     *
     * Generated from protobuf field <code>string primary_product_id = 4;</code>
     * @return string
     */
    public function getPrimaryProductId()
    {
        return $this->primary_product_id;
    }

    /**
     * Variant group identifier. Must be an
     * [id][google.cloud.retail.v2.Product.id], with the same parent branch with
     * this product. Otherwise, an error is thrown.
     * For [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]s, this field can only be empty or
     * set to the same value as [id][google.cloud.retail.v2.Product.id].
     * For VARIANT [Product][google.cloud.retail.v2.Product]s, this field cannot
     * be empty. A maximum of 2,000 products are allowed to share the same
     * [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product]. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * Google Merchant Center Property
     * [item_group_id](https://support.google.com/merchants/answer/6324507).
     * Schema.org Property
     * [Product.inProductGroupWithID](https://schema.org/inProductGroupWithID).
     * This field must be enabled before it can be used. [Learn
     * more](https://cloud.google.com/recommendations-ai/docs/catalog#item-group-id).
     *
     * Generated from protobuf field <code>string primary_product_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setPrimaryProductId($var)
    {
        GPBUtil::checkString($var, True);
        $this->primary_product_id = $var;

        return $this;
    }

    /**
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * For example, if a shoes product belongs to both
     * ["Shoes & Accessories" -> "Shoes"] and
     * ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
     * represented as:
     *      "categories": [
     *        "Shoes & Accessories > Shoes",
     *        "Sports & Fitness > Athletic Clothing > Shoes"
     *      ]
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     *
     * Generated from protobuf field <code>repeated string categories = 7;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCategories()
    {
        return $this->categories;
    }

    /**
     * Product categories. This field is repeated for supporting one product
     * belonging to several parallel categories. Strongly recommended using the
     * full path for better search / recommendation quality.
     * To represent full path of category, use '>' sign to separate different
     * hierarchies. If '>' is part of the category name, please replace it with
     * other character(s).
     * For example, if a shoes product belongs to both
     * ["Shoes & Accessories" -> "Shoes"] and
     * ["Sports & Fitness" -> "Athletic Clothing" -> "Shoes"], it could be
     * represented as:
     *      "categories": [
     *        "Shoes & Accessories > Shoes",
     *        "Sports & Fitness > Athletic Clothing > Shoes"
     *      ]
     * Must be set for [Type.PRIMARY][google.cloud.retail.v2.Product.Type.PRIMARY]
     * [Product][google.cloud.retail.v2.Product] otherwise an INVALID_ARGUMENT
     * error is returned.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. Empty values are not allowed.
     * Each value must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [google_product_category][mc_google_product_category]. Schema.org property
     * [Product.category] (https://schema.org/category).
     * [mc_google_product_category]:
     * https://support.google.com/merchants/answer/6324436
     *
     * Generated from protobuf field <code>repeated string categories = 7;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCategories($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->categories = $arr;

        return $this;
    }

    /**
     * Required. Product title.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     *
     * Generated from protobuf field <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getTitle()
    {
        return $this->title;
    }

    /**
     * Required. Product title.
     * This field must be a UTF-8 encoded string with a length limit of 128
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [title](https://support.google.com/merchants/answer/6324415). Schema.org
     * property [Product.name](https://schema.org/name).
     *
     * Generated from protobuf field <code>string title = 8 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setTitle($var)
    {
        GPBUtil::checkString($var, True);
        $this->title = $var;

        return $this;
    }

    /**
     * Product description.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * schema.org property [Product.description](https://schema.org/description).
     *
     * Generated from protobuf field <code>string description = 10;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Product description.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [description](https://support.google.com/merchants/answer/6324468).
     * schema.org property [Product.description](https://schema.org/description).
     *
     * Generated from protobuf field <code>string description = 10;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     * A maximum of 150 attributes are allowed. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 12;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Highly encouraged. Extra product attributes to be included. For example,
     * for products, this could include the store name, vendor, style, color, etc.
     * These are very strong signals for recommendation model, thus we highly
     * recommend providing the attributes here.
     * Features that can take on one of a limited number of possible values. Two
     * types of features can be set are:
     * Textual features. some examples would be the brand/maker of a product, or
     * country of a customer. Numerical features. Some examples would be the
     * height/weight of a product, or age of a customer.
     * For example: `{ "vendor": {"text": ["vendor123", "vendor456"]},
     * "lengths_cm": {"numbers":[2.3, 15.4]}, "heights_cm": {"numbers":[8.1, 6.4]}
     * }`.
     * A maximum of 150 attributes are allowed. Otherwise, an INVALID_ARGUMENT
     * error is returned.
     * The key must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.retail.v2.CustomAttribute> attributes = 12;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\CustomAttribute::class);
        $this->attributes = $arr;

        return $this;
    }

    /**
     * Custom tags associated with the product.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     * Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     *
     * Generated from protobuf field <code>repeated string tags = 13;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Custom tags associated with the product.
     * At most 250 values are allowed per
     * [Product][google.cloud.retail.v2.Product]. This value must be a UTF-8
     * encoded string with a length limit of 1,000 characters. Otherwise, an
     * INVALID_ARGUMENT error is returned.
     * This tag can be used for filtering recommendation results by passing the
     * tag as part of the
     * [PredictRequest.filter][google.cloud.retail.v2.PredictRequest.filter].
     * Google Merchant Center property
     * [custom_label_0–4](https://support.google.com/merchants/answer/6324473).
     *
     * Generated from protobuf field <code>repeated string tags = 13;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

    /**
     * Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     * @return \Google\Cloud\Retail\V2\PriceInfo
     */
    public function getPriceInfo()
    {
        return isset($this->price_info) ? $this->price_info : null;
    }

    public function hasPriceInfo()
    {
        return isset($this->price_info);
    }

    public function clearPriceInfo()
    {
        unset($this->price_info);
    }

    /**
     * Product price and cost information.
     * Google Merchant Center property
     * [price](https://support.google.com/merchants/answer/6324371).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.PriceInfo price_info = 14;</code>
     * @param \Google\Cloud\Retail\V2\PriceInfo $var
     * @return $this
     */
    public function setPriceInfo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Retail\V2\PriceInfo::class);
        $this->price_info = $var;

        return $this;
    }

    /**
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available recommendation and search.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_time = 18;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getAvailableTime()
    {
        return isset($this->available_time) ? $this->available_time : null;
    }

    public function hasAvailableTime()
    {
        return isset($this->available_time);
    }

    public function clearAvailableTime()
    {
        unset($this->available_time);
    }

    /**
     * The timestamp when this [Product][google.cloud.retail.v2.Product] becomes
     * available recommendation and search.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp available_time = 18;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setAvailableTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->available_time = $var;

        return $this;
    }

    /**
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     * Google Merchant Center Property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org Property [Offer.availability](https://schema.org/availability).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     * @return int
     */
    public function getAvailability()
    {
        return $this->availability;
    }

    /**
     * The online availability of the [Product][google.cloud.retail.v2.Product].
     * Default to
     * [Availability.IN_STOCK][google.cloud.retail.v2.Product.Availability.IN_STOCK].
     * Google Merchant Center Property
     * [availability](https://support.google.com/merchants/answer/6324448).
     * Schema.org Property [Offer.availability](https://schema.org/availability).
     *
     * Generated from protobuf field <code>.google.cloud.retail.v2.Product.Availability availability = 19;</code>
     * @param int $var
     * @return $this
     */
    public function setAvailability($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Retail\V2\Product\Availability::class);
        $this->availability = $var;

        return $this;
    }

    /**
     * The available quantity of the item.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     * @return \Google\Protobuf\Int32Value
     */
    public function getAvailableQuantity()
    {
        return isset($this->available_quantity) ? $this->available_quantity : null;
    }

    public function hasAvailableQuantity()
    {
        return isset($this->available_quantity);
    }

    public function clearAvailableQuantity()
    {
        unset($this->available_quantity);
    }

    /**
     * Returns the unboxed value from <code>getAvailableQuantity()</code>

     * The available quantity of the item.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     * @return int|null
     */
    public function getAvailableQuantityValue()
    {
        return $this->readWrapperValue("available_quantity");
    }

    /**
     * The available quantity of the item.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     * @param \Google\Protobuf\Int32Value $var
     * @return $this
     */
    public function setAvailableQuantity($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Int32Value::class);
        $this->available_quantity = $var;

        return $this;
    }

    /**
     * Sets the field by wrapping a primitive type in a Google\Protobuf\Int32Value object.

     * The available quantity of the item.
     *
     * Generated from protobuf field <code>.google.protobuf.Int32Value available_quantity = 20;</code>
     * @param int|null $var
     * @return $this
     */
    public function setAvailableQuantityValue($var)
    {
        $this->writeWrapperValue("available_quantity", $var);
        return $this;}

    /**
     * Canonical URL directly linking to the product detail page.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     *
     * Generated from protobuf field <code>string uri = 22;</code>
     * @return string
     */
    public function getUri()
    {
        return $this->uri;
    }

    /**
     * Canonical URL directly linking to the product detail page.
     * This field must be a UTF-8 encoded string with a length limit of 5,000
     * characters. Otherwise, an INVALID_ARGUMENT error is returned.
     * Google Merchant Center property
     * [link](https://support.google.com/merchants/answer/6324416). Schema.org
     * property [Offer.url](https://schema.org/url).
     *
     * Generated from protobuf field <code>string uri = 22;</code>
     * @param string $var
     * @return $this
     */
    public function setUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->uri = $var;

        return $this;
    }

    /**
     * Product images for the product.
     * A maximum of 300 images are allowed.
     * Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getImages()
    {
        return $this->images;
    }

    /**
     * Product images for the product.
     * A maximum of 300 images are allowed.
     * Google Merchant Center property
     * [image_link](https://support.google.com/merchants/answer/6324350).
     * Schema.org property [Product.image](https://schema.org/image).
     *
     * Generated from protobuf field <code>repeated .google.cloud.retail.v2.Image images = 23;</code>
     * @param \Google\Cloud\Retail\V2\Image[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setImages($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Retail\V2\Image::class);
        $this->images = $arr;

        return $this;
    }

}

