<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/container/v1/cluster_service.proto

namespace Google\Cloud\Container\V1\NodePool;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * These upgrade settings control the level of parallelism and the level of
 * disruption caused by an upgrade.
 * maxUnavailable controls the number of nodes that can be simultaneously
 * unavailable.
 * maxSurge controls the number of additional nodes that can be added to the
 * node pool temporarily for the time of the upgrade to increase the number of
 * available nodes.
 * (maxUnavailable + maxSurge) determines the level of parallelism (how many
 * nodes are being upgraded at the same time).
 * Note: upgrades inevitably introduce some disruption since workloads need to
 * be moved from old nodes to new, upgraded ones. Even if maxUnavailable=0,
 * this holds true. (Disruption stays within the limits of
 * PodDisruptionBudget, if it is configured.)
 * Consider a hypothetical node pool with 5 nodes having maxSurge=2,
 * maxUnavailable=1. This means the upgrade process upgrades 3 nodes
 * simultaneously. It creates 2 additional (upgraded) nodes, then it brings
 * down 3 old (not yet upgraded) nodes at the same time. This ensures that
 * there are always at least 4 nodes available.
 *
 * Generated from protobuf message <code>google.container.v1.NodePool.UpgradeSettings</code>
 */
class UpgradeSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * The maximum number of nodes that can be created beyond the current size
     * of the node pool during the upgrade process.
     *
     * Generated from protobuf field <code>int32 max_surge = 1;</code>
     */
    private $max_surge = 0;
    /**
     * The maximum number of nodes that can be simultaneously unavailable during
     * the upgrade process. A node is considered available if its status is
     * Ready.
     *
     * Generated from protobuf field <code>int32 max_unavailable = 2;</code>
     */
    private $max_unavailable = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int $max_surge
     *           The maximum number of nodes that can be created beyond the current size
     *           of the node pool during the upgrade process.
     *     @type int $max_unavailable
     *           The maximum number of nodes that can be simultaneously unavailable during
     *           the upgrade process. A node is considered available if its status is
     *           Ready.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Container\V1\ClusterService::initOnce();
        parent::__construct($data);
    }

    /**
     * The maximum number of nodes that can be created beyond the current size
     * of the node pool during the upgrade process.
     *
     * Generated from protobuf field <code>int32 max_surge = 1;</code>
     * @return int
     */
    public function getMaxSurge()
    {
        return $this->max_surge;
    }

    /**
     * The maximum number of nodes that can be created beyond the current size
     * of the node pool during the upgrade process.
     *
     * Generated from protobuf field <code>int32 max_surge = 1;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxSurge($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_surge = $var;

        return $this;
    }

    /**
     * The maximum number of nodes that can be simultaneously unavailable during
     * the upgrade process. A node is considered available if its status is
     * Ready.
     *
     * Generated from protobuf field <code>int32 max_unavailable = 2;</code>
     * @return int
     */
    public function getMaxUnavailable()
    {
        return $this->max_unavailable;
    }

    /**
     * The maximum number of nodes that can be simultaneously unavailable during
     * the upgrade process. A node is considered available if its status is
     * Ready.
     *
     * Generated from protobuf field <code>int32 max_unavailable = 2;</code>
     * @param int $var
     * @return $this
     */
    public function setMaxUnavailable($var)
    {
        GPBUtil::checkInt32($var);
        $this->max_unavailable = $var;

        return $this;
    }

}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(UpgradeSettings::class, \Google\Cloud\Container\V1\NodePool_UpgradeSettings::class);

