<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/storage/control/v2/storage_control.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Storage\Control\V2\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Storage\Control\V2\AnywhereCache;
use Google\Cloud\Storage\Control\V2\CreateAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\CreateFolderRequest;
use Google\Cloud\Storage\Control\V2\CreateManagedFolderRequest;
use Google\Cloud\Storage\Control\V2\DeleteFolderRequest;
use Google\Cloud\Storage\Control\V2\DeleteManagedFolderRequest;
use Google\Cloud\Storage\Control\V2\DisableAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\Folder;
use Google\Cloud\Storage\Control\V2\GetAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\GetFolderIntelligenceConfigRequest;
use Google\Cloud\Storage\Control\V2\GetFolderRequest;
use Google\Cloud\Storage\Control\V2\GetManagedFolderRequest;
use Google\Cloud\Storage\Control\V2\GetOrganizationIntelligenceConfigRequest;
use Google\Cloud\Storage\Control\V2\GetProjectIntelligenceConfigRequest;
use Google\Cloud\Storage\Control\V2\GetStorageLayoutRequest;
use Google\Cloud\Storage\Control\V2\IntelligenceConfig;
use Google\Cloud\Storage\Control\V2\ListAnywhereCachesRequest;
use Google\Cloud\Storage\Control\V2\ListFoldersRequest;
use Google\Cloud\Storage\Control\V2\ListManagedFoldersRequest;
use Google\Cloud\Storage\Control\V2\ManagedFolder;
use Google\Cloud\Storage\Control\V2\PauseAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\RenameFolderRequest;
use Google\Cloud\Storage\Control\V2\ResumeAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\StorageLayout;
use Google\Cloud\Storage\Control\V2\UpdateAnywhereCacheRequest;
use Google\Cloud\Storage\Control\V2\UpdateFolderIntelligenceConfigRequest;
use Google\Cloud\Storage\Control\V2\UpdateOrganizationIntelligenceConfigRequest;
use Google\Cloud\Storage\Control\V2\UpdateProjectIntelligenceConfigRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: StorageControl service includes selected control plane operations.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<OperationResponse> createAnywhereCacheAsync(CreateAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Folder> createFolderAsync(CreateFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ManagedFolder> createManagedFolderAsync(CreateManagedFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteFolderAsync(DeleteFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteManagedFolderAsync(DeleteManagedFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AnywhereCache> disableAnywhereCacheAsync(DisableAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AnywhereCache> getAnywhereCacheAsync(GetAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Folder> getFolderAsync(GetFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> getFolderIntelligenceConfigAsync(GetFolderIntelligenceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<ManagedFolder> getManagedFolderAsync(GetManagedFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> getOrganizationIntelligenceConfigAsync(GetOrganizationIntelligenceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> getProjectIntelligenceConfigAsync(GetProjectIntelligenceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<StorageLayout> getStorageLayoutAsync(GetStorageLayoutRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listAnywhereCachesAsync(ListAnywhereCachesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listFoldersAsync(ListFoldersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listManagedFoldersAsync(ListManagedFoldersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AnywhereCache> pauseAnywhereCacheAsync(PauseAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> renameFolderAsync(RenameFolderRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<AnywhereCache> resumeAnywhereCacheAsync(ResumeAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<OperationResponse> updateAnywhereCacheAsync(UpdateAnywhereCacheRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> updateFolderIntelligenceConfigAsync(UpdateFolderIntelligenceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> updateOrganizationIntelligenceConfigAsync(UpdateOrganizationIntelligenceConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<IntelligenceConfig> updateProjectIntelligenceConfigAsync(UpdateProjectIntelligenceConfigRequest $request, array $optionalArgs = [])
 */
final class StorageControlClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.storage.control.v2.StorageControl';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'storage.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'storage.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/cloud-platform.read-only',
        'https://www.googleapis.com/auth/devstorage.full_control',
        'https://www.googleapis.com/auth/devstorage.read_only',
        'https://www.googleapis.com/auth/devstorage.read_write',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/storage_control_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/storage_control_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/storage_control_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/storage_control_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * anywhere_cache resource.
     *
     * @param string $project
     * @param string $bucket
     * @param string $anywhereCache
     *
     * @return string The formatted anywhere_cache resource.
     */
    public static function anywhereCacheName(string $project, string $bucket, string $anywhereCache): string
    {
        return self::getPathTemplate('anywhereCache')->render([
            'project' => $project,
            'bucket' => $bucket,
            'anywhere_cache' => $anywhereCache,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a bucket
     * resource.
     *
     * @param string $project
     * @param string $bucket
     *
     * @return string The formatted bucket resource.
     */
    public static function bucketName(string $project, string $bucket): string
    {
        return self::getPathTemplate('bucket')->render([
            'project' => $project,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $project
     * @param string $bucket
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $project, string $bucket, string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'project' => $project,
            'bucket' => $bucket,
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_location_intelligenceConfig resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted folder_location_intelligenceConfig resource.
     */
    public static function folderLocationIntelligenceConfigName(string $folder, string $location): string
    {
        return self::getPathTemplate('folderLocationIntelligenceConfig')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * intelligence_config resource.
     *
     * @param string $folder
     * @param string $location
     *
     * @return string The formatted intelligence_config resource.
     */
    public static function intelligenceConfigName(string $folder, string $location): string
    {
        return self::getPathTemplate('intelligenceConfig')->render([
            'folder' => $folder,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * managed_folder resource.
     *
     * @param string $project
     * @param string $bucket
     * @param string $managedFolder
     *
     * @return string The formatted managed_folder resource.
     */
    public static function managedFolderName(string $project, string $bucket, string $managedFolder): string
    {
        return self::getPathTemplate('managedFolder')->render([
            'project' => $project,
            'bucket' => $bucket,
            'managed_folder' => $managedFolder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * org_location_intelligenceConfig resource.
     *
     * @param string $org
     * @param string $location
     *
     * @return string The formatted org_location_intelligenceConfig resource.
     */
    public static function orgLocationIntelligenceConfigName(string $org, string $location): string
    {
        return self::getPathTemplate('orgLocationIntelligenceConfig')->render([
            'org' => $org,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_location_intelligenceConfig resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted project_location_intelligenceConfig resource.
     */
    public static function projectLocationIntelligenceConfigName(string $project, string $location): string
    {
        return self::getPathTemplate('projectLocationIntelligenceConfig')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * storage_layout resource.
     *
     * @param string $project
     * @param string $bucket
     *
     * @return string The formatted storage_layout resource.
     */
    public static function storageLayoutName(string $project, string $bucket): string
    {
        return self::getPathTemplate('storageLayout')->render([
            'project' => $project,
            'bucket' => $bucket,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - anywhereCache: projects/{project}/buckets/{bucket}/anywhereCaches/{anywhere_cache}
     * - bucket: projects/{project}/buckets/{bucket}
     * - folder: projects/{project}/buckets/{bucket}/folders/{folder=**}
     * - folderLocationIntelligenceConfig: folders/{folder}/locations/{location}/intelligenceConfig
     * - intelligenceConfig: folders/{folder}/locations/{location}/intelligenceConfig
     * - managedFolder: projects/{project}/buckets/{bucket}/managedFolders/{managed_folder=**}
     * - orgLocationIntelligenceConfig: organizations/{org}/locations/{location}/intelligenceConfig
     * - projectLocationIntelligenceConfig: projects/{project}/locations/{location}/intelligenceConfig
     * - storageLayout: projects/{project}/buckets/{bucket}/storageLayout
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'storage.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Creates an Anywhere Cache instance.
     *
     * The async variant is {@see StorageControlClient::createAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/create_anywhere_cache.php
     *
     * @param CreateAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAnywhereCache(CreateAnywhereCacheRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Creates a new folder. This operation is only applicable to a hierarchical
     * namespace enabled bucket.
     *
     * The async variant is {@see StorageControlClient::createFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/create_folder.php
     *
     * @param CreateFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Folder
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createFolder(CreateFolderRequest $request, array $callOptions = []): Folder
    {
        return $this->startApiCall('CreateFolder', $request, $callOptions)->wait();
    }

    /**
     * Creates a new managed folder.
     *
     * The async variant is {@see StorageControlClient::createManagedFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/create_managed_folder.php
     *
     * @param CreateManagedFolderRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ManagedFolder
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createManagedFolder(CreateManagedFolderRequest $request, array $callOptions = []): ManagedFolder
    {
        return $this->startApiCall('CreateManagedFolder', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes an empty folder. This operation is only applicable to a
     * hierarchical namespace enabled bucket.
     *
     * The async variant is {@see StorageControlClient::deleteFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/delete_folder.php
     *
     * @param DeleteFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteFolder(DeleteFolderRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteFolder', $request, $callOptions)->wait();
    }

    /**
     * Permanently deletes an empty managed folder.
     *
     * The async variant is {@see StorageControlClient::deleteManagedFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/delete_managed_folder.php
     *
     * @param DeleteManagedFolderRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteManagedFolder(DeleteManagedFolderRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteManagedFolder', $request, $callOptions)->wait();
    }

    /**
     * Disables an Anywhere Cache instance. A disabled instance is read-only. The
     * disablement could be revoked by calling ResumeAnywhereCache. The cache
     * instance will be deleted automatically if it remains in the disabled state
     * for at least one hour.
     *
     * The async variant is {@see StorageControlClient::disableAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/disable_anywhere_cache.php
     *
     * @param DisableAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnywhereCache
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function disableAnywhereCache(DisableAnywhereCacheRequest $request, array $callOptions = []): AnywhereCache
    {
        return $this->startApiCall('DisableAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Gets an Anywhere Cache instance.
     *
     * The async variant is {@see StorageControlClient::getAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_anywhere_cache.php
     *
     * @param GetAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnywhereCache
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAnywhereCache(GetAnywhereCacheRequest $request, array $callOptions = []): AnywhereCache
    {
        return $this->startApiCall('GetAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for the specified folder. This operation is only
     * applicable to a hierarchical namespace enabled bucket.
     *
     * The async variant is {@see StorageControlClient::getFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_folder.php
     *
     * @param GetFolderRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Folder
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFolder(GetFolderRequest $request, array $callOptions = []): Folder
    {
        return $this->startApiCall('GetFolder', $request, $callOptions)->wait();
    }

    /**
     * Returns the Folder scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::getFolderIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_folder_intelligence_config.php
     *
     * @param GetFolderIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getFolderIntelligenceConfig(
        GetFolderIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('GetFolderIntelligenceConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns metadata for the specified managed folder.
     *
     * The async variant is {@see StorageControlClient::getManagedFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_managed_folder.php
     *
     * @param GetManagedFolderRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ManagedFolder
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getManagedFolder(GetManagedFolderRequest $request, array $callOptions = []): ManagedFolder
    {
        return $this->startApiCall('GetManagedFolder', $request, $callOptions)->wait();
    }

    /**
     * Returns the Organization scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::getOrganizationIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_organization_intelligence_config.php
     *
     * @param GetOrganizationIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getOrganizationIntelligenceConfig(
        GetOrganizationIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('GetOrganizationIntelligenceConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the Project scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::getProjectIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_project_intelligence_config.php
     *
     * @param GetProjectIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getProjectIntelligenceConfig(
        GetProjectIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('GetProjectIntelligenceConfig', $request, $callOptions)->wait();
    }

    /**
     * Returns the storage layout configuration for a given bucket.
     *
     * The async variant is {@see StorageControlClient::getStorageLayoutAsync()} .
     *
     * @example samples/V2/StorageControlClient/get_storage_layout.php
     *
     * @param GetStorageLayoutRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return StorageLayout
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getStorageLayout(GetStorageLayoutRequest $request, array $callOptions = []): StorageLayout
    {
        return $this->startApiCall('GetStorageLayout', $request, $callOptions)->wait();
    }

    /**
     * Lists Anywhere Cache instances for a given bucket.
     *
     * The async variant is {@see StorageControlClient::listAnywhereCachesAsync()} .
     *
     * @example samples/V2/StorageControlClient/list_anywhere_caches.php
     *
     * @param ListAnywhereCachesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAnywhereCaches(ListAnywhereCachesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAnywhereCaches', $request, $callOptions);
    }

    /**
     * Retrieves a list of folders. This operation is only applicable to a
     * hierarchical namespace enabled bucket.
     *
     * The async variant is {@see StorageControlClient::listFoldersAsync()} .
     *
     * @example samples/V2/StorageControlClient/list_folders.php
     *
     * @param ListFoldersRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listFolders(ListFoldersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListFolders', $request, $callOptions);
    }

    /**
     * Retrieves a list of managed folders for a given bucket.
     *
     * The async variant is {@see StorageControlClient::listManagedFoldersAsync()} .
     *
     * @example samples/V2/StorageControlClient/list_managed_folders.php
     *
     * @param ListManagedFoldersRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listManagedFolders(ListManagedFoldersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListManagedFolders', $request, $callOptions);
    }

    /**
     * Pauses an Anywhere Cache instance.
     *
     * The async variant is {@see StorageControlClient::pauseAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/pause_anywhere_cache.php
     *
     * @param PauseAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnywhereCache
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pauseAnywhereCache(PauseAnywhereCacheRequest $request, array $callOptions = []): AnywhereCache
    {
        return $this->startApiCall('PauseAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Renames a source folder to a destination folder. This operation is only
     * applicable to a hierarchical namespace enabled bucket. During a rename, the
     * source and destination folders are locked until the long running operation
     * completes.
     *
     * The async variant is {@see StorageControlClient::renameFolderAsync()} .
     *
     * @example samples/V2/StorageControlClient/rename_folder.php
     *
     * @param RenameFolderRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function renameFolder(RenameFolderRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RenameFolder', $request, $callOptions)->wait();
    }

    /**
     * Resumes a disabled or paused Anywhere Cache instance.
     *
     * The async variant is {@see StorageControlClient::resumeAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/resume_anywhere_cache.php
     *
     * @param ResumeAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AnywhereCache
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resumeAnywhereCache(ResumeAnywhereCacheRequest $request, array $callOptions = []): AnywhereCache
    {
        return $this->startApiCall('ResumeAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Updates an Anywhere Cache instance. Mutable fields include `ttl` and
     * `admission_policy`.
     *
     * The async variant is {@see StorageControlClient::updateAnywhereCacheAsync()} .
     *
     * @example samples/V2/StorageControlClient/update_anywhere_cache.php
     *
     * @param UpdateAnywhereCacheRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAnywhereCache(UpdateAnywhereCacheRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAnywhereCache', $request, $callOptions)->wait();
    }

    /**
     * Updates the Folder scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::updateFolderIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/update_folder_intelligence_config.php
     *
     * @param UpdateFolderIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateFolderIntelligenceConfig(
        UpdateFolderIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('UpdateFolderIntelligenceConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the Organization scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::updateOrganizationIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/update_organization_intelligence_config.php
     *
     * @param UpdateOrganizationIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateOrganizationIntelligenceConfig(
        UpdateOrganizationIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('UpdateOrganizationIntelligenceConfig', $request, $callOptions)->wait();
    }

    /**
     * Updates the Project scoped singleton IntelligenceConfig resource.
     *
     * The async variant is
     * {@see StorageControlClient::updateProjectIntelligenceConfigAsync()} .
     *
     * @example samples/V2/StorageControlClient/update_project_intelligence_config.php
     *
     * @param UpdateProjectIntelligenceConfigRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return IntelligenceConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateProjectIntelligenceConfig(
        UpdateProjectIntelligenceConfigRequest $request,
        array $callOptions = []
    ): IntelligenceConfig {
        return $this->startApiCall('UpdateProjectIntelligenceConfig', $request, $callOptions)->wait();
    }
}
