<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/spanner/v1/spanner.proto

namespace Google\Cloud\Spanner\V1\ReadRequest;

use UnexpectedValueException;

/**
 * A lock hint mechanism for reads done within a transaction.
 *
 * Protobuf type <code>google.spanner.v1.ReadRequest.LockHint</code>
 */
class LockHint
{
    /**
     * Default value.
     * LOCK_HINT_UNSPECIFIED is equivalent to LOCK_HINT_SHARED.
     *
     * Generated from protobuf enum <code>LOCK_HINT_UNSPECIFIED = 0;</code>
     */
    const LOCK_HINT_UNSPECIFIED = 0;
    /**
     * Acquire shared locks.
     * By default when you perform a read as part of a read-write transaction,
     * Spanner acquires shared read locks, which allows other reads to still
     * access the data until your transaction is ready to commit. When your
     * transaction is committing and writes are being applied, the transaction
     * attempts to upgrade to an exclusive lock for any data you are writing.
     * For more information about locks, see [Lock
     * modes](https://cloud.google.com/spanner/docs/introspection/lock-statistics#explain-lock-modes).
     *
     * Generated from protobuf enum <code>LOCK_HINT_SHARED = 1;</code>
     */
    const LOCK_HINT_SHARED = 1;
    /**
     * Acquire exclusive locks.
     * Requesting exclusive locks is beneficial if you observe high write
     * contention, which means you notice that multiple transactions are
     * concurrently trying to read and write to the same data, resulting in a
     * large number of aborts. This problem occurs when two transactions
     * initially acquire shared locks and then both try to upgrade to exclusive
     * locks at the same time. In this situation both transactions are waiting
     * for the other to give up their lock, resulting in a deadlocked situation.
     * Spanner is able to detect this occurring and force one of the
     * transactions to abort. However, this is a slow and expensive operation
     * and results in lower performance. In this case it makes sense to acquire
     * exclusive locks at the start of the transaction because then when
     * multiple transactions try to act on the same data, they automatically get
     * serialized. Each transaction waits its turn to acquire the lock and
     * avoids getting into deadlock situations.
     * Because the exclusive lock hint is just a hint, it should not be
     * considered equivalent to a mutex. In other words, you should not use
     * Spanner exclusive locks as a mutual exclusion mechanism for the execution
     * of code outside of Spanner.
     * **Note:** Request exclusive locks judiciously because they block others
     * from reading that data for the entire transaction, rather than just when
     * the writes are being performed. Unless you observe high write contention,
     * you should use the default of shared read locks so you don't prematurely
     * block other clients from reading the data that you're writing to.
     *
     * Generated from protobuf enum <code>LOCK_HINT_EXCLUSIVE = 2;</code>
     */
    const LOCK_HINT_EXCLUSIVE = 2;

    private static $valueToName = [
        self::LOCK_HINT_UNSPECIFIED => 'LOCK_HINT_UNSPECIFIED',
        self::LOCK_HINT_SHARED => 'LOCK_HINT_SHARED',
        self::LOCK_HINT_EXCLUSIVE => 'LOCK_HINT_EXCLUSIVE',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LockHint::class, \Google\Cloud\Spanner\V1\ReadRequest_LockHint::class);

