<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkservices/v1/gateway.proto

namespace Google\Cloud\NetworkServices\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Gateway represents the configuration for a proxy, typically a load balancer.
 * It captures the ip:port over which the services are exposed by the proxy,
 * along with any policy configurations. Routes have reference to to Gateways to
 * dictate how requests should be routed by this Gateway.
 *
 * Generated from protobuf message <code>google.cloud.networkservices.v1.Gateway</code>
 */
class Gateway extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $self_link = '';
    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     */
    protected $type = 0;
    /**
     * Optional. Zero or one IPv4 or IPv6 address on which the Gateway will
     * receive the traffic. When no address is provided, an IP from the subnetwork
     * is allocated
     * This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
     *
     * Generated from protobuf field <code>repeated string addresses = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $addresses;
    /**
     * Required. One or more port numbers (1-65535), on which the Gateway will
     * receive traffic. The proxy binds to the specified ports.
     * Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and
     * support multiple ports.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $ports;
    /**
     * Optional. Scope determines how configuration across multiple Gateway
     * instances are merged. The configuration for multiple Gateway instances with
     * the same scope will be merged as presented as a single configuration to the
     * proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $scope = '';
    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $server_tls_policy = '';
    /**
     * Optional. A fully-qualified Certificates URL reference. The proxy presents
     * a Certificate (selected based on SNI) when establishing a TLS connection.
     * This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>repeated string certificate_urls = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $certificate_urls;
    /**
     * Optional. A fully-qualified GatewaySecurityPolicy URL reference.
     * Defines how a server should apply security policy to inbound
     * (VM to Proxy) initiated connections.
     * For example:
     * `projects/&#42;&#47;locations/&#42;&#47;gatewaySecurityPolicies/swg-policy`.
     * This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string gateway_security_policy = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $gateway_security_policy = '';
    /**
     * Optional. The relative resource name identifying the VPC network that is
     * using this configuration. For example:
     * `projects/&#42;&#47;global/networks/network-1`.
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string network = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $network = '';
    /**
     * Optional. The relative resource name identifying  the subnetwork in which
     * this SWG is allocated. For example:
     * `projects/&#42;&#47;regions/us-central1/subnetworks/network-1`
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY".
     *
     * Generated from protobuf field <code>string subnetwork = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    protected $subnetwork = '';
    /**
     * Optional. The IP Version that will be used by this gateway. Valid options
     * are IPV4 or IPV6. Default is IPV4.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.IpVersion ip_version = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ip_version = 0;
    /**
     * Optional. Determines if envoy will insert internal debug headers into
     * upstream requests. Other Envoy headers may still be injected. By default,
     * envoy will not insert any debug headers.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkservices.v1.EnvoyHeaders envoy_headers = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $envoy_headers = null;
    /**
     * Optional. The routing mode of the Gateway.
     * This field is configurable only for gateways of type SECURE_WEB_GATEWAY.
     * This field is required for gateways of type SECURE_WEB_GATEWAY.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.RoutingMode routing_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $routing_mode = 0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Name of the Gateway resource. It matches pattern
     *           `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *     @type string $self_link
     *           Output only. Server-defined URL of this resource
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the resource was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the resource was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Set of label tags associated with the Gateway resource.
     *     @type string $description
     *           Optional. A free-text description of the resource. Max length 1024
     *           characters.
     *     @type int $type
     *           Immutable. The type of the customer managed gateway.
     *           This field is required. If unspecified, an error is returned.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $addresses
     *           Optional. Zero or one IPv4 or IPv6 address on which the Gateway will
     *           receive the traffic. When no address is provided, an IP from the subnetwork
     *           is allocated
     *           This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     *           Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
     *     @type array<int>|\Google\Protobuf\Internal\RepeatedField $ports
     *           Required. One or more port numbers (1-65535), on which the Gateway will
     *           receive traffic. The proxy binds to the specified ports.
     *           Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
     *           Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and
     *           support multiple ports.
     *     @type string $scope
     *           Optional. Scope determines how configuration across multiple Gateway
     *           instances are merged. The configuration for multiple Gateway instances with
     *           the same scope will be merged as presented as a single configuration to the
     *           proxy/load balancer.
     *           Max length 64 characters.
     *           Scope should start with a letter and can only have letters, numbers,
     *           hyphens.
     *     @type string $server_tls_policy
     *           Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     *           TLS traffic is terminated. If empty, TLS termination is disabled.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $certificate_urls
     *           Optional. A fully-qualified Certificates URL reference. The proxy presents
     *           a Certificate (selected based on SNI) when establishing a TLS connection.
     *           This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     *     @type string $gateway_security_policy
     *           Optional. A fully-qualified GatewaySecurityPolicy URL reference.
     *           Defines how a server should apply security policy to inbound
     *           (VM to Proxy) initiated connections.
     *           For example:
     *           `projects/&#42;&#47;locations/&#42;&#47;gatewaySecurityPolicies/swg-policy`.
     *           This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *     @type string $network
     *           Optional. The relative resource name identifying the VPC network that is
     *           using this configuration. For example:
     *           `projects/&#42;&#47;global/networks/network-1`.
     *           Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *     @type string $subnetwork
     *           Optional. The relative resource name identifying  the subnetwork in which
     *           this SWG is allocated. For example:
     *           `projects/&#42;&#47;regions/us-central1/subnetworks/network-1`
     *           Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY".
     *     @type int $ip_version
     *           Optional. The IP Version that will be used by this gateway. Valid options
     *           are IPV4 or IPV6. Default is IPV4.
     *     @type int $envoy_headers
     *           Optional. Determines if envoy will insert internal debug headers into
     *           upstream requests. Other Envoy headers may still be injected. By default,
     *           envoy will not insert any debug headers.
     *     @type int $routing_mode
     *           Optional. The routing mode of the Gateway.
     *           This field is configurable only for gateways of type SECURE_WEB_GATEWAY.
     *           This field is required for gateways of type SECURE_WEB_GATEWAY.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkservices\V1\Gateway::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Name of the Gateway resource. It matches pattern
     * `projects/&#42;&#47;locations/&#42;&#47;gateways/<gateway_name>`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getSelfLink()
    {
        return $this->self_link;
    }

    /**
     * Output only. Server-defined URL of this resource
     *
     * Generated from protobuf field <code>string self_link = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setSelfLink($var)
    {
        GPBUtil::checkString($var, True);
        $this->self_link = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the resource was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the resource was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Set of label tags associated with the Gateway resource.
     *
     * Generated from protobuf field <code>map<string, string> labels = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. A free-text description of the resource. Max length 1024
     * characters.
     *
     * Generated from protobuf field <code>string description = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @return int
     */
    public function getType()
    {
        return $this->type;
    }

    /**
     * Immutable. The type of the customer managed gateway.
     * This field is required. If unspecified, an error is returned.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.Type type = 6 [(.google.api.field_behavior) = IMMUTABLE];</code>
     * @param int $var
     * @return $this
     */
    public function setType($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\Gateway\Type::class);
        $this->type = $var;

        return $this;
    }

    /**
     * Optional. Zero or one IPv4 or IPv6 address on which the Gateway will
     * receive the traffic. When no address is provided, an IP from the subnetwork
     * is allocated
     * This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
     *
     * Generated from protobuf field <code>repeated string addresses = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAddresses()
    {
        return $this->addresses;
    }

    /**
     * Optional. Zero or one IPv4 or IPv6 address on which the Gateway will
     * receive the traffic. When no address is provided, an IP from the subnetwork
     * is allocated
     * This field only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6.
     *
     * Generated from protobuf field <code>repeated string addresses = 7 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAddresses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->addresses = $arr;

        return $this;
    }

    /**
     * Required. One or more port numbers (1-65535), on which the Gateway will
     * receive traffic. The proxy binds to the specified ports.
     * Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and
     * support multiple ports.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPorts()
    {
        return $this->ports;
    }

    /**
     * Required. One or more port numbers (1-65535), on which the Gateway will
     * receive traffic. The proxy binds to the specified ports.
     * Gateways of type 'SECURE_WEB_GATEWAY' are limited to 1 port.
     * Gateways of type 'OPEN_MESH' listen on 0.0.0.0 for IPv4 and :: for IPv6 and
     * support multiple ports.
     *
     * Generated from protobuf field <code>repeated int32 ports = 11 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<int>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPorts($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::INT32);
        $this->ports = $arr;

        return $this;
    }

    /**
     * Optional. Scope determines how configuration across multiple Gateway
     * instances are merged. The configuration for multiple Gateway instances with
     * the same scope will be merged as presented as a single configuration to the
     * proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getScope()
    {
        return $this->scope;
    }

    /**
     * Optional. Scope determines how configuration across multiple Gateway
     * instances are merged. The configuration for multiple Gateway instances with
     * the same scope will be merged as presented as a single configuration to the
     * proxy/load balancer.
     * Max length 64 characters.
     * Scope should start with a letter and can only have letters, numbers,
     * hyphens.
     *
     * Generated from protobuf field <code>string scope = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setScope($var)
    {
        GPBUtil::checkString($var, True);
        $this->scope = $var;

        return $this;
    }

    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getServerTlsPolicy()
    {
        return $this->server_tls_policy;
    }

    /**
     * Optional. A fully-qualified ServerTLSPolicy URL reference. Specifies how
     * TLS traffic is terminated. If empty, TLS termination is disabled.
     *
     * Generated from protobuf field <code>string server_tls_policy = 9 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setServerTlsPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_tls_policy = $var;

        return $this;
    }

    /**
     * Optional. A fully-qualified Certificates URL reference. The proxy presents
     * a Certificate (selected based on SNI) when establishing a TLS connection.
     * This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>repeated string certificate_urls = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCertificateUrls()
    {
        return $this->certificate_urls;
    }

    /**
     * Optional. A fully-qualified Certificates URL reference. The proxy presents
     * a Certificate (selected based on SNI) when establishing a TLS connection.
     * This feature only applies to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>repeated string certificate_urls = 14 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCertificateUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->certificate_urls = $arr;

        return $this;
    }

    /**
     * Optional. A fully-qualified GatewaySecurityPolicy URL reference.
     * Defines how a server should apply security policy to inbound
     * (VM to Proxy) initiated connections.
     * For example:
     * `projects/&#42;&#47;locations/&#42;&#47;gatewaySecurityPolicies/swg-policy`.
     * This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string gateway_security_policy = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getGatewaySecurityPolicy()
    {
        return $this->gateway_security_policy;
    }

    /**
     * Optional. A fully-qualified GatewaySecurityPolicy URL reference.
     * Defines how a server should apply security policy to inbound
     * (VM to Proxy) initiated connections.
     * For example:
     * `projects/&#42;&#47;locations/&#42;&#47;gatewaySecurityPolicies/swg-policy`.
     * This policy is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string gateway_security_policy = 18 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setGatewaySecurityPolicy($var)
    {
        GPBUtil::checkString($var, True);
        $this->gateway_security_policy = $var;

        return $this;
    }

    /**
     * Optional. The relative resource name identifying the VPC network that is
     * using this configuration. For example:
     * `projects/&#42;&#47;global/networks/network-1`.
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string network = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->network;
    }

    /**
     * Optional. The relative resource name identifying the VPC network that is
     * using this configuration. For example:
     * `projects/&#42;&#47;global/networks/network-1`.
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY'.
     *
     * Generated from protobuf field <code>string network = 16 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->network = $var;

        return $this;
    }

    /**
     * Optional. The relative resource name identifying  the subnetwork in which
     * this SWG is allocated. For example:
     * `projects/&#42;&#47;regions/us-central1/subnetworks/network-1`
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY".
     *
     * Generated from protobuf field <code>string subnetwork = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getSubnetwork()
    {
        return $this->subnetwork;
    }

    /**
     * Optional. The relative resource name identifying  the subnetwork in which
     * this SWG is allocated. For example:
     * `projects/&#42;&#47;regions/us-central1/subnetworks/network-1`
     * Currently, this field is specific to gateways of type 'SECURE_WEB_GATEWAY".
     *
     * Generated from protobuf field <code>string subnetwork = 17 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setSubnetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->subnetwork = $var;

        return $this;
    }

    /**
     * Optional. The IP Version that will be used by this gateway. Valid options
     * are IPV4 or IPV6. Default is IPV4.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.IpVersion ip_version = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getIpVersion()
    {
        return $this->ip_version;
    }

    /**
     * Optional. The IP Version that will be used by this gateway. Valid options
     * are IPV4 or IPV6. Default is IPV4.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.IpVersion ip_version = 21 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setIpVersion($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\Gateway\IpVersion::class);
        $this->ip_version = $var;

        return $this;
    }

    /**
     * Optional. Determines if envoy will insert internal debug headers into
     * upstream requests. Other Envoy headers may still be injected. By default,
     * envoy will not insert any debug headers.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkservices.v1.EnvoyHeaders envoy_headers = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getEnvoyHeaders()
    {
        return isset($this->envoy_headers) ? $this->envoy_headers : 0;
    }

    public function hasEnvoyHeaders()
    {
        return isset($this->envoy_headers);
    }

    public function clearEnvoyHeaders()
    {
        unset($this->envoy_headers);
    }

    /**
     * Optional. Determines if envoy will insert internal debug headers into
     * upstream requests. Other Envoy headers may still be injected. By default,
     * envoy will not insert any debug headers.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkservices.v1.EnvoyHeaders envoy_headers = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setEnvoyHeaders($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\EnvoyHeaders::class);
        $this->envoy_headers = $var;

        return $this;
    }

    /**
     * Optional. The routing mode of the Gateway.
     * This field is configurable only for gateways of type SECURE_WEB_GATEWAY.
     * This field is required for gateways of type SECURE_WEB_GATEWAY.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.RoutingMode routing_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getRoutingMode()
    {
        return $this->routing_mode;
    }

    /**
     * Optional. The routing mode of the Gateway.
     * This field is configurable only for gateways of type SECURE_WEB_GATEWAY.
     * This field is required for gateways of type SECURE_WEB_GATEWAY.
     *
     * Generated from protobuf field <code>.google.cloud.networkservices.v1.Gateway.RoutingMode routing_mode = 32 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setRoutingMode($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkServices\V1\Gateway\RoutingMode::class);
        $this->routing_mode = $var;

        return $this;
    }

}

