<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/apihub/v1/common_fields.proto

namespace Google\Cloud\ApiHub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Details of the deployment where APIs are hosted.
 * A deployment could represent an Apigee proxy, API gateway, other Google Cloud
 * services or non-Google Cloud services as well. A deployment entity is a root
 * level entity in the API hub and exists independent of any API.
 *
 * Generated from protobuf message <code>google.cloud.apihub.v1.Deployment</code>
 */
class Deployment extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The name of the deployment.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Required. The display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Optional. The description of the deployment.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = '';
    /**
     * Optional. The documentation of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $documentation = null;
    /**
     * Required. The type of deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-deployment-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues deployment_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $deployment_type = null;
    /**
     * Required. A URI to the runtime resource. This URI can be used to manage the
     * resource. For example, if the runtime resource is of type APIGEE_PROXY,
     * then this field will contain the URI to the management UI of the proxy.
     *
     * Generated from protobuf field <code>string resource_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $resource_uri = '';
    /**
     * Required. The endpoints at which this deployment resource is listening for
     * API requests. This could be a list of complete URIs, hostnames or an IP
     * addresses.
     *
     * Generated from protobuf field <code>repeated string endpoints = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $endpoints;
    /**
     * Output only. The API versions linked to this deployment.
     * Note: A particular deployment could be linked to multiple different API
     * versions (of same or different APIs).
     *
     * Generated from protobuf field <code>repeated string api_versions = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $api_versions;
    /**
     * Output only. The time at which the deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time at which the deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. The SLO for this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-slo`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues slo = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $slo = null;
    /**
     * Optional. The environment mapping to this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-environment`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues environment = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $environment = null;
    /**
     * Optional. The list of user defined attributes associated with the
     * deployment resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $attributes;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The name of the deployment.
     *           Format:
     *           `projects/{project}/locations/{location}/deployments/{deployment}`
     *     @type string $display_name
     *           Required. The display name of the deployment.
     *     @type string $description
     *           Optional. The description of the deployment.
     *     @type \Google\Cloud\ApiHub\V1\Documentation $documentation
     *           Optional. The documentation of the deployment.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $deployment_type
     *           Required. The type of deployment.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-deployment-type`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type string $resource_uri
     *           Required. A URI to the runtime resource. This URI can be used to manage the
     *           resource. For example, if the runtime resource is of type APIGEE_PROXY,
     *           then this field will contain the URI to the management UI of the proxy.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $endpoints
     *           Required. The endpoints at which this deployment resource is listening for
     *           API requests. This could be a list of complete URIs, hostnames or an IP
     *           addresses.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $api_versions
     *           Output only. The API versions linked to this deployment.
     *           Note: A particular deployment could be linked to multiple different API
     *           versions (of same or different APIs).
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time at which the deployment was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time at which the deployment was last updated.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $slo
     *           Optional. The SLO for this deployment.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-slo`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type \Google\Cloud\ApiHub\V1\AttributeValues $environment
     *           Optional. The environment mapping to this deployment.
     *           This maps to the following system defined attribute:
     *           `projects/{project}/locations/{location}/attributes/system-environment`
     *           attribute.
     *           The number of values for this attribute will be based on the
     *           cardinality of the attribute. The same can be retrieved via GetAttribute
     *           API. All values should be from the list of allowed values defined for the
     *           attribute.
     *     @type array|\Google\Protobuf\Internal\MapField $attributes
     *           Optional. The list of user defined attributes associated with the
     *           deployment resource. The key is the attribute name. It will be of the
     *           format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     *           The value is the attribute values associated with the resource.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Apihub\V1\CommonFields::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The name of the deployment.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The name of the deployment.
     * Format:
     * `projects/{project}/locations/{location}/deployments/{deployment}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The display name of the deployment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Optional. The description of the deployment.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * Optional. The description of the deployment.
     *
     * Generated from protobuf field <code>string description = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The documentation of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\Documentation|null
     */
    public function getDocumentation()
    {
        return $this->documentation;
    }

    public function hasDocumentation()
    {
        return isset($this->documentation);
    }

    public function clearDocumentation()
    {
        unset($this->documentation);
    }

    /**
     * Optional. The documentation of the deployment.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.Documentation documentation = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\Documentation $var
     * @return $this
     */
    public function setDocumentation($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\Documentation::class);
        $this->documentation = $var;

        return $this;
    }

    /**
     * Required. The type of deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-deployment-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues deployment_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getDeploymentType()
    {
        return $this->deployment_type;
    }

    public function hasDeploymentType()
    {
        return isset($this->deployment_type);
    }

    public function clearDeploymentType()
    {
        unset($this->deployment_type);
    }

    /**
     * Required. The type of deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-deployment-type`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues deployment_type = 5 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setDeploymentType($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->deployment_type = $var;

        return $this;
    }

    /**
     * Required. A URI to the runtime resource. This URI can be used to manage the
     * resource. For example, if the runtime resource is of type APIGEE_PROXY,
     * then this field will contain the URI to the management UI of the proxy.
     *
     * Generated from protobuf field <code>string resource_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getResourceUri()
    {
        return $this->resource_uri;
    }

    /**
     * Required. A URI to the runtime resource. This URI can be used to manage the
     * resource. For example, if the runtime resource is of type APIGEE_PROXY,
     * then this field will contain the URI to the management UI of the proxy.
     *
     * Generated from protobuf field <code>string resource_uri = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setResourceUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->resource_uri = $var;

        return $this;
    }

    /**
     * Required. The endpoints at which this deployment resource is listening for
     * API requests. This could be a list of complete URIs, hostnames or an IP
     * addresses.
     *
     * Generated from protobuf field <code>repeated string endpoints = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getEndpoints()
    {
        return $this->endpoints;
    }

    /**
     * Required. The endpoints at which this deployment resource is listening for
     * API requests. This could be a list of complete URIs, hostnames or an IP
     * addresses.
     *
     * Generated from protobuf field <code>repeated string endpoints = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setEndpoints($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->endpoints = $arr;

        return $this;
    }

    /**
     * Output only. The API versions linked to this deployment.
     * Note: A particular deployment could be linked to multiple different API
     * versions (of same or different APIs).
     *
     * Generated from protobuf field <code>repeated string api_versions = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getApiVersions()
    {
        return $this->api_versions;
    }

    /**
     * Output only. The API versions linked to this deployment.
     * Note: A particular deployment could be linked to multiple different API
     * versions (of same or different APIs).
     *
     * Generated from protobuf field <code>repeated string api_versions = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setApiVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->api_versions = $arr;

        return $this;
    }

    /**
     * Output only. The time at which the deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time at which the deployment was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time at which the deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time at which the deployment was last updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. The SLO for this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-slo`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues slo = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getSlo()
    {
        return $this->slo;
    }

    public function hasSlo()
    {
        return isset($this->slo);
    }

    public function clearSlo()
    {
        unset($this->slo);
    }

    /**
     * Optional. The SLO for this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-slo`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues slo = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setSlo($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->slo = $var;

        return $this;
    }

    /**
     * Optional. The environment mapping to this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-environment`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues environment = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\ApiHub\V1\AttributeValues|null
     */
    public function getEnvironment()
    {
        return $this->environment;
    }

    public function hasEnvironment()
    {
        return isset($this->environment);
    }

    public function clearEnvironment()
    {
        unset($this->environment);
    }

    /**
     * Optional. The environment mapping to this deployment.
     * This maps to the following system defined attribute:
     * `projects/{project}/locations/{location}/attributes/system-environment`
     * attribute.
     * The number of values for this attribute will be based on the
     * cardinality of the attribute. The same can be retrieved via GetAttribute
     * API. All values should be from the list of allowed values defined for the
     * attribute.
     *
     * Generated from protobuf field <code>.google.cloud.apihub.v1.AttributeValues environment = 12 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\ApiHub\V1\AttributeValues $var
     * @return $this
     */
    public function setEnvironment($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->environment = $var;

        return $this;
    }

    /**
     * Optional. The list of user defined attributes associated with the
     * deployment resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAttributes()
    {
        return $this->attributes;
    }

    /**
     * Optional. The list of user defined attributes associated with the
     * deployment resource. The key is the attribute name. It will be of the
     * format: `projects/{project}/locations/{location}/attributes/{attribute}`.
     * The value is the attribute values associated with the resource.
     *
     * Generated from protobuf field <code>map<string, .google.cloud.apihub.v1.AttributeValues> attributes = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAttributes($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\ApiHub\V1\AttributeValues::class);
        $this->attributes = $arr;

        return $this;
    }

}

