<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/migrationcenter/v1/migrationcenter.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\MigrationCenter\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Location\GetLocationRequest;
use Google\Cloud\Location\ListLocationsRequest;
use Google\Cloud\Location\Location;
use Google\Cloud\MigrationCenter\V1\AddAssetsToGroupRequest;
use Google\Cloud\MigrationCenter\V1\AggregateAssetsValuesRequest;
use Google\Cloud\MigrationCenter\V1\AggregateAssetsValuesResponse;
use Google\Cloud\MigrationCenter\V1\Asset;
use Google\Cloud\MigrationCenter\V1\BatchDeleteAssetsRequest;
use Google\Cloud\MigrationCenter\V1\BatchUpdateAssetsRequest;
use Google\Cloud\MigrationCenter\V1\BatchUpdateAssetsResponse;
use Google\Cloud\MigrationCenter\V1\CreateGroupRequest;
use Google\Cloud\MigrationCenter\V1\CreateImportDataFileRequest;
use Google\Cloud\MigrationCenter\V1\CreateImportJobRequest;
use Google\Cloud\MigrationCenter\V1\CreatePreferenceSetRequest;
use Google\Cloud\MigrationCenter\V1\CreateReportConfigRequest;
use Google\Cloud\MigrationCenter\V1\CreateReportRequest;
use Google\Cloud\MigrationCenter\V1\CreateSourceRequest;
use Google\Cloud\MigrationCenter\V1\DeleteAssetRequest;
use Google\Cloud\MigrationCenter\V1\DeleteGroupRequest;
use Google\Cloud\MigrationCenter\V1\DeleteImportDataFileRequest;
use Google\Cloud\MigrationCenter\V1\DeleteImportJobRequest;
use Google\Cloud\MigrationCenter\V1\DeletePreferenceSetRequest;
use Google\Cloud\MigrationCenter\V1\DeleteReportConfigRequest;
use Google\Cloud\MigrationCenter\V1\DeleteReportRequest;
use Google\Cloud\MigrationCenter\V1\DeleteSourceRequest;
use Google\Cloud\MigrationCenter\V1\ErrorFrame;
use Google\Cloud\MigrationCenter\V1\GetAssetRequest;
use Google\Cloud\MigrationCenter\V1\GetErrorFrameRequest;
use Google\Cloud\MigrationCenter\V1\GetGroupRequest;
use Google\Cloud\MigrationCenter\V1\GetImportDataFileRequest;
use Google\Cloud\MigrationCenter\V1\GetImportJobRequest;
use Google\Cloud\MigrationCenter\V1\GetPreferenceSetRequest;
use Google\Cloud\MigrationCenter\V1\GetReportConfigRequest;
use Google\Cloud\MigrationCenter\V1\GetReportRequest;
use Google\Cloud\MigrationCenter\V1\GetSettingsRequest;
use Google\Cloud\MigrationCenter\V1\GetSourceRequest;
use Google\Cloud\MigrationCenter\V1\Group;
use Google\Cloud\MigrationCenter\V1\ImportDataFile;
use Google\Cloud\MigrationCenter\V1\ImportJob;
use Google\Cloud\MigrationCenter\V1\ListAssetsRequest;
use Google\Cloud\MigrationCenter\V1\ListErrorFramesRequest;
use Google\Cloud\MigrationCenter\V1\ListGroupsRequest;
use Google\Cloud\MigrationCenter\V1\ListImportDataFilesRequest;
use Google\Cloud\MigrationCenter\V1\ListImportJobsRequest;
use Google\Cloud\MigrationCenter\V1\ListPreferenceSetsRequest;
use Google\Cloud\MigrationCenter\V1\ListReportConfigsRequest;
use Google\Cloud\MigrationCenter\V1\ListReportsRequest;
use Google\Cloud\MigrationCenter\V1\ListSourcesRequest;
use Google\Cloud\MigrationCenter\V1\PreferenceSet;
use Google\Cloud\MigrationCenter\V1\RemoveAssetsFromGroupRequest;
use Google\Cloud\MigrationCenter\V1\Report;
use Google\Cloud\MigrationCenter\V1\ReportAssetFramesRequest;
use Google\Cloud\MigrationCenter\V1\ReportAssetFramesResponse;
use Google\Cloud\MigrationCenter\V1\ReportConfig;
use Google\Cloud\MigrationCenter\V1\RunImportJobRequest;
use Google\Cloud\MigrationCenter\V1\Settings;
use Google\Cloud\MigrationCenter\V1\Source;
use Google\Cloud\MigrationCenter\V1\UpdateAssetRequest;
use Google\Cloud\MigrationCenter\V1\UpdateGroupRequest;
use Google\Cloud\MigrationCenter\V1\UpdateImportJobRequest;
use Google\Cloud\MigrationCenter\V1\UpdatePreferenceSetRequest;
use Google\Cloud\MigrationCenter\V1\UpdateSettingsRequest;
use Google\Cloud\MigrationCenter\V1\UpdateSourceRequest;
use Google\Cloud\MigrationCenter\V1\ValidateImportJobRequest;
use Google\LongRunning\Client\OperationsClient;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: Service describing handlers for resources.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface addAssetsToGroupAsync(AddAssetsToGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface aggregateAssetsValuesAsync(AggregateAssetsValuesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchDeleteAssetsAsync(BatchDeleteAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface batchUpdateAssetsAsync(BatchUpdateAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createGroupAsync(CreateGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createImportDataFileAsync(CreateImportDataFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createImportJobAsync(CreateImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createPreferenceSetAsync(CreatePreferenceSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createReportAsync(CreateReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createReportConfigAsync(CreateReportConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createSourceAsync(CreateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAssetAsync(DeleteAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGroupAsync(DeleteGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteImportDataFileAsync(DeleteImportDataFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteImportJobAsync(DeleteImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deletePreferenceSetAsync(DeletePreferenceSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteReportAsync(DeleteReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteReportConfigAsync(DeleteReportConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteSourceAsync(DeleteSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAssetAsync(GetAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getErrorFrameAsync(GetErrorFrameRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGroupAsync(GetGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getImportDataFileAsync(GetImportDataFileRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getImportJobAsync(GetImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getPreferenceSetAsync(GetPreferenceSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getReportAsync(GetReportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getReportConfigAsync(GetReportConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSettingsAsync(GetSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getSourceAsync(GetSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAssetsAsync(ListAssetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listErrorFramesAsync(ListErrorFramesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGroupsAsync(ListGroupsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listImportDataFilesAsync(ListImportDataFilesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listImportJobsAsync(ListImportJobsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listPreferenceSetsAsync(ListPreferenceSetsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listReportConfigsAsync(ListReportConfigsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listReportsAsync(ListReportsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listSourcesAsync(ListSourcesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface removeAssetsFromGroupAsync(RemoveAssetsFromGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface reportAssetFramesAsync(ReportAssetFramesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface runImportJobAsync(RunImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAssetAsync(UpdateAssetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGroupAsync(UpdateGroupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateImportJobAsync(UpdateImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updatePreferenceSetAsync(UpdatePreferenceSetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSettingsAsync(UpdateSettingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateSourceAsync(UpdateSourceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface validateImportJobAsync(ValidateImportJobRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getLocationAsync(GetLocationRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listLocationsAsync(ListLocationsRequest $request, array $optionalArgs = [])
 */
final class MigrationCenterClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.migrationcenter.v1.MigrationCenter';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'migrationcenter.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'migrationcenter.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/migration_center_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/migration_center_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/migration_center_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/migration_center_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning'])
            ? $this->descriptors[$methodName]['longRunning']
            : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Create the default operation client for the service.
     *
     * @param array $options ClientOptions for the client.
     *
     * @return OperationsClient
     */
    private function createOperationsClient(array $options)
    {
        // Unset client-specific configuration options
        unset($options['serviceName'], $options['clientConfig'], $options['descriptorsConfigPath']);

        if (isset($options['operationsClient'])) {
            return $options['operationsClient'];
        }

        return new OperationsClient($options);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a asset
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $asset
     *
     * @return string The formatted asset resource.
     */
    public static function assetName(string $project, string $location, string $asset): string
    {
        return self::getPathTemplate('asset')->render([
            'project' => $project,
            'location' => $location,
            'asset' => $asset,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a error_frame
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     * @param string $errorFrame
     *
     * @return string The formatted error_frame resource.
     */
    public static function errorFrameName(string $project, string $location, string $source, string $errorFrame): string
    {
        return self::getPathTemplate('errorFrame')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
            'error_frame' => $errorFrame,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a group
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $group
     *
     * @return string The formatted group resource.
     */
    public static function groupName(string $project, string $location, string $group): string
    {
        return self::getPathTemplate('group')->render([
            'project' => $project,
            'location' => $location,
            'group' => $group,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * import_data_file resource.
     *
     * @param string $project
     * @param string $location
     * @param string $importJob
     * @param string $importDataFile
     *
     * @return string The formatted import_data_file resource.
     */
    public static function importDataFileName(
        string $project,
        string $location,
        string $importJob,
        string $importDataFile
    ): string {
        return self::getPathTemplate('importDataFile')->render([
            'project' => $project,
            'location' => $location,
            'import_job' => $importJob,
            'import_data_file' => $importDataFile,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a import_job
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $importJob
     *
     * @return string The formatted import_job resource.
     */
    public static function importJobName(string $project, string $location, string $importJob): string
    {
        return self::getPathTemplate('importJob')->render([
            'project' => $project,
            'location' => $location,
            'import_job' => $importJob,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a location
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted location resource.
     */
    public static function locationName(string $project, string $location): string
    {
        return self::getPathTemplate('location')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * preference_set resource.
     *
     * @param string $project
     * @param string $location
     * @param string $preferenceSet
     *
     * @return string The formatted preference_set resource.
     */
    public static function preferenceSetName(string $project, string $location, string $preferenceSet): string
    {
        return self::getPathTemplate('preferenceSet')->render([
            'project' => $project,
            'location' => $location,
            'preference_set' => $preferenceSet,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a report
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $reportConfig
     * @param string $report
     *
     * @return string The formatted report resource.
     */
    public static function reportName(string $project, string $location, string $reportConfig, string $report): string
    {
        return self::getPathTemplate('report')->render([
            'project' => $project,
            'location' => $location,
            'report_config' => $reportConfig,
            'report' => $report,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * report_config resource.
     *
     * @param string $project
     * @param string $location
     * @param string $reportConfig
     *
     * @return string The formatted report_config resource.
     */
    public static function reportConfigName(string $project, string $location, string $reportConfig): string
    {
        return self::getPathTemplate('reportConfig')->render([
            'project' => $project,
            'location' => $location,
            'report_config' => $reportConfig,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a settings
     * resource.
     *
     * @param string $project
     * @param string $location
     *
     * @return string The formatted settings resource.
     */
    public static function settingsName(string $project, string $location): string
    {
        return self::getPathTemplate('settings')->render([
            'project' => $project,
            'location' => $location,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a source
     * resource.
     *
     * @param string $project
     * @param string $location
     * @param string $source
     *
     * @return string The formatted source resource.
     */
    public static function sourceName(string $project, string $location, string $source): string
    {
        return self::getPathTemplate('source')->render([
            'project' => $project,
            'location' => $location,
            'source' => $source,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - asset: projects/{project}/locations/{location}/assets/{asset}
     * - errorFrame: projects/{project}/locations/{location}/sources/{source}/errorFrames/{error_frame}
     * - group: projects/{project}/locations/{location}/groups/{group}
     * - importDataFile: projects/{project}/locations/{location}/importJobs/{import_job}/importDataFiles/{import_data_file}
     * - importJob: projects/{project}/locations/{location}/importJobs/{import_job}
     * - location: projects/{project}/locations/{location}
     * - preferenceSet: projects/{project}/locations/{location}/preferenceSets/{preference_set}
     * - report: projects/{project}/locations/{location}/reportConfigs/{report_config}/reports/{report}
     * - reportConfig: projects/{project}/locations/{location}/reportConfigs/{report_config}
     * - settings: projects/{project}/locations/{location}/settings
     * - source: projects/{project}/locations/{location}/sources/{source}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'migrationcenter.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Adds assets to a group.
     *
     * The async variant is {@see MigrationCenterClient::addAssetsToGroupAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/add_assets_to_group.php
     *
     * @param AddAssetsToGroupRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addAssetsToGroup(AddAssetsToGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('AddAssetsToGroup', $request, $callOptions)->wait();
    }

    /**
     * Aggregates the requested fields based on provided function.
     *
     * The async variant is {@see MigrationCenterClient::aggregateAssetsValuesAsync()}
     * .
     *
     * @example samples/V1/MigrationCenterClient/aggregate_assets_values.php
     *
     * @param AggregateAssetsValuesRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AggregateAssetsValuesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function aggregateAssetsValues(
        AggregateAssetsValuesRequest $request,
        array $callOptions = []
    ): AggregateAssetsValuesResponse {
        return $this->startApiCall('AggregateAssetsValues', $request, $callOptions)->wait();
    }

    /**
     * Deletes list of Assets.
     *
     * The async variant is {@see MigrationCenterClient::batchDeleteAssetsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/batch_delete_assets.php
     *
     * @param BatchDeleteAssetsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchDeleteAssets(BatchDeleteAssetsRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('BatchDeleteAssets', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a list of assets.
     *
     * The async variant is {@see MigrationCenterClient::batchUpdateAssetsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/batch_update_assets.php
     *
     * @param BatchUpdateAssetsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return BatchUpdateAssetsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function batchUpdateAssets(
        BatchUpdateAssetsRequest $request,
        array $callOptions = []
    ): BatchUpdateAssetsResponse {
        return $this->startApiCall('BatchUpdateAssets', $request, $callOptions)->wait();
    }

    /**
     * Creates a new group in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::createGroupAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_group.php
     *
     * @param CreateGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGroup(CreateGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGroup', $request, $callOptions)->wait();
    }

    /**
     * Creates an import data file.
     *
     * The async variant is {@see MigrationCenterClient::createImportDataFileAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_import_data_file.php
     *
     * @param CreateImportDataFileRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createImportDataFile(
        CreateImportDataFileRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('CreateImportDataFile', $request, $callOptions)->wait();
    }

    /**
     * Creates an import job.
     *
     * The async variant is {@see MigrationCenterClient::createImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_import_job.php
     *
     * @param CreateImportJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createImportJob(CreateImportJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateImportJob', $request, $callOptions)->wait();
    }

    /**
     * Creates a new preference set in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::createPreferenceSetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_preference_set.php
     *
     * @param CreatePreferenceSetRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createPreferenceSet(CreatePreferenceSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreatePreferenceSet', $request, $callOptions)->wait();
    }

    /**
     * Creates a report.
     *
     * The async variant is {@see MigrationCenterClient::createReportAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_report.php
     *
     * @param CreateReportRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReport(CreateReportRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateReport', $request, $callOptions)->wait();
    }

    /**
     * Creates a report configuration.
     *
     * The async variant is {@see MigrationCenterClient::createReportConfigAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_report_config.php
     *
     * @param CreateReportConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createReportConfig(CreateReportConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateReportConfig', $request, $callOptions)->wait();
    }

    /**
     * Creates a new source in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::createSourceAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/create_source.php
     *
     * @param CreateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createSource(CreateSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateSource', $request, $callOptions)->wait();
    }

    /**
     * Deletes an asset.
     *
     * The async variant is {@see MigrationCenterClient::deleteAssetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_asset.php
     *
     * @param DeleteAssetRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAsset(DeleteAssetRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteAsset', $request, $callOptions)->wait();
    }

    /**
     * Deletes a group.
     *
     * The async variant is {@see MigrationCenterClient::deleteGroupAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_group.php
     *
     * @param DeleteGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGroup(DeleteGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGroup', $request, $callOptions)->wait();
    }

    /**
     * Delete an import data file.
     *
     * The async variant is {@see MigrationCenterClient::deleteImportDataFileAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_import_data_file.php
     *
     * @param DeleteImportDataFileRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteImportDataFile(
        DeleteImportDataFileRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('DeleteImportDataFile', $request, $callOptions)->wait();
    }

    /**
     * Deletes an import job.
     *
     * The async variant is {@see MigrationCenterClient::deleteImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_import_job.php
     *
     * @param DeleteImportJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteImportJob(DeleteImportJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteImportJob', $request, $callOptions)->wait();
    }

    /**
     * Deletes a preference set.
     *
     * The async variant is {@see MigrationCenterClient::deletePreferenceSetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_preference_set.php
     *
     * @param DeletePreferenceSetRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deletePreferenceSet(DeletePreferenceSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeletePreferenceSet', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Report.
     *
     * The async variant is {@see MigrationCenterClient::deleteReportAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_report.php
     *
     * @param DeleteReportRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReport(DeleteReportRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteReport', $request, $callOptions)->wait();
    }

    /**
     * Deletes a ReportConfig.
     *
     * The async variant is {@see MigrationCenterClient::deleteReportConfigAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_report_config.php
     *
     * @param DeleteReportConfigRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteReportConfig(DeleteReportConfigRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteReportConfig', $request, $callOptions)->wait();
    }

    /**
     * Deletes a source.
     *
     * The async variant is {@see MigrationCenterClient::deleteSourceAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/delete_source.php
     *
     * @param DeleteSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteSource(DeleteSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteSource', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of an asset.
     *
     * The async variant is {@see MigrationCenterClient::getAssetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_asset.php
     *
     * @param GetAssetRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Asset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAsset(GetAssetRequest $request, array $callOptions = []): Asset
    {
        return $this->startApiCall('GetAsset', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of an error frame.
     *
     * The async variant is {@see MigrationCenterClient::getErrorFrameAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_error_frame.php
     *
     * @param GetErrorFrameRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ErrorFrame
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getErrorFrame(GetErrorFrameRequest $request, array $callOptions = []): ErrorFrame
    {
        return $this->startApiCall('GetErrorFrame', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a group.
     *
     * The async variant is {@see MigrationCenterClient::getGroupAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_group.php
     *
     * @param GetGroupRequest $request     A request to house fields associated with the call.
     * @param array           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Group
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGroup(GetGroupRequest $request, array $callOptions = []): Group
    {
        return $this->startApiCall('GetGroup', $request, $callOptions)->wait();
    }

    /**
     * Gets an import data file.
     *
     * The async variant is {@see MigrationCenterClient::getImportDataFileAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_import_data_file.php
     *
     * @param GetImportDataFileRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ImportDataFile
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getImportDataFile(GetImportDataFileRequest $request, array $callOptions = []): ImportDataFile
    {
        return $this->startApiCall('GetImportDataFile', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of an import job.
     *
     * The async variant is {@see MigrationCenterClient::getImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_import_job.php
     *
     * @param GetImportJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ImportJob
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getImportJob(GetImportJobRequest $request, array $callOptions = []): ImportJob
    {
        return $this->startApiCall('GetImportJob', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a preference set.
     *
     * The async variant is {@see MigrationCenterClient::getPreferenceSetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_preference_set.php
     *
     * @param GetPreferenceSetRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PreferenceSet
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getPreferenceSet(GetPreferenceSetRequest $request, array $callOptions = []): PreferenceSet
    {
        return $this->startApiCall('GetPreferenceSet', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single Report.
     *
     * The async variant is {@see MigrationCenterClient::getReportAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_report.php
     *
     * @param GetReportRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Report
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReport(GetReportRequest $request, array $callOptions = []): Report
    {
        return $this->startApiCall('GetReport', $request, $callOptions)->wait();
    }

    /**
     * Gets details of a single ReportConfig.
     *
     * The async variant is {@see MigrationCenterClient::getReportConfigAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_report_config.php
     *
     * @param GetReportConfigRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReportConfig
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getReportConfig(GetReportConfigRequest $request, array $callOptions = []): ReportConfig
    {
        return $this->startApiCall('GetReportConfig', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of regional settings.
     *
     * The async variant is {@see MigrationCenterClient::getSettingsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_settings.php
     *
     * @param GetSettingsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Settings
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSettings(GetSettingsRequest $request, array $callOptions = []): Settings
    {
        return $this->startApiCall('GetSettings', $request, $callOptions)->wait();
    }

    /**
     * Gets the details of a source.
     *
     * The async variant is {@see MigrationCenterClient::getSourceAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_source.php
     *
     * @param GetSourceRequest $request     A request to house fields associated with the call.
     * @param array            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Source
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getSource(GetSourceRequest $request, array $callOptions = []): Source
    {
        return $this->startApiCall('GetSource', $request, $callOptions)->wait();
    }

    /**
     * Lists all the assets in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::listAssetsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_assets.php
     *
     * @param ListAssetsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAssets(ListAssetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAssets', $request, $callOptions);
    }

    /**
     * Lists all error frames in a given source and location.
     *
     * The async variant is {@see MigrationCenterClient::listErrorFramesAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_error_frames.php
     *
     * @param ListErrorFramesRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listErrorFrames(ListErrorFramesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListErrorFrames', $request, $callOptions);
    }

    /**
     * Lists all groups in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::listGroupsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_groups.php
     *
     * @param ListGroupsRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGroups(ListGroupsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGroups', $request, $callOptions);
    }

    /**
     * List import data files.
     *
     * The async variant is {@see MigrationCenterClient::listImportDataFilesAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_import_data_files.php
     *
     * @param ListImportDataFilesRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listImportDataFiles(ListImportDataFilesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListImportDataFiles', $request, $callOptions);
    }

    /**
     * Lists all import jobs.
     *
     * The async variant is {@see MigrationCenterClient::listImportJobsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_import_jobs.php
     *
     * @param ListImportJobsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listImportJobs(ListImportJobsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListImportJobs', $request, $callOptions);
    }

    /**
     * Lists all the preference sets in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::listPreferenceSetsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_preference_sets.php
     *
     * @param ListPreferenceSetsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listPreferenceSets(ListPreferenceSetsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListPreferenceSets', $request, $callOptions);
    }

    /**
     * Lists ReportConfigs in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::listReportConfigsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_report_configs.php
     *
     * @param ListReportConfigsRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReportConfigs(ListReportConfigsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReportConfigs', $request, $callOptions);
    }

    /**
     * Lists Reports in a given ReportConfig.
     *
     * The async variant is {@see MigrationCenterClient::listReportsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_reports.php
     *
     * @param ListReportsRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listReports(ListReportsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListReports', $request, $callOptions);
    }

    /**
     * Lists all the sources in a given project and location.
     *
     * The async variant is {@see MigrationCenterClient::listSourcesAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_sources.php
     *
     * @param ListSourcesRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listSources(ListSourcesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListSources', $request, $callOptions);
    }

    /**
     * Removes assets from a group.
     *
     * The async variant is {@see MigrationCenterClient::removeAssetsFromGroupAsync()}
     * .
     *
     * @example samples/V1/MigrationCenterClient/remove_assets_from_group.php
     *
     * @param RemoveAssetsFromGroupRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function removeAssetsFromGroup(
        RemoveAssetsFromGroupRequest $request,
        array $callOptions = []
    ): OperationResponse {
        return $this->startApiCall('RemoveAssetsFromGroup', $request, $callOptions)->wait();
    }

    /**
     * Reports a set of frames.
     *
     * The async variant is {@see MigrationCenterClient::reportAssetFramesAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/report_asset_frames.php
     *
     * @param ReportAssetFramesRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ReportAssetFramesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reportAssetFrames(
        ReportAssetFramesRequest $request,
        array $callOptions = []
    ): ReportAssetFramesResponse {
        return $this->startApiCall('ReportAssetFrames', $request, $callOptions)->wait();
    }

    /**
     * Runs an import job.
     *
     * The async variant is {@see MigrationCenterClient::runImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/run_import_job.php
     *
     * @param RunImportJobRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function runImportJob(RunImportJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('RunImportJob', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of an asset.
     *
     * The async variant is {@see MigrationCenterClient::updateAssetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_asset.php
     *
     * @param UpdateAssetRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Asset
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAsset(UpdateAssetRequest $request, array $callOptions = []): Asset
    {
        return $this->startApiCall('UpdateAsset', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a group.
     *
     * The async variant is {@see MigrationCenterClient::updateGroupAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_group.php
     *
     * @param UpdateGroupRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGroup(UpdateGroupRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGroup', $request, $callOptions)->wait();
    }

    /**
     * Updates an import job.
     *
     * The async variant is {@see MigrationCenterClient::updateImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_import_job.php
     *
     * @param UpdateImportJobRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateImportJob(UpdateImportJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateImportJob', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a preference set.
     *
     * The async variant is {@see MigrationCenterClient::updatePreferenceSetAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_preference_set.php
     *
     * @param UpdatePreferenceSetRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updatePreferenceSet(UpdatePreferenceSetRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdatePreferenceSet', $request, $callOptions)->wait();
    }

    /**
     * Updates the regional-level project settings.
     *
     * The async variant is {@see MigrationCenterClient::updateSettingsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_settings.php
     *
     * @param UpdateSettingsRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSettings(UpdateSettingsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSettings', $request, $callOptions)->wait();
    }

    /**
     * Updates the parameters of a source.
     *
     * The async variant is {@see MigrationCenterClient::updateSourceAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/update_source.php
     *
     * @param UpdateSourceRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateSource(UpdateSourceRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateSource', $request, $callOptions)->wait();
    }

    /**
     * Validates an import job.
     *
     * The async variant is {@see MigrationCenterClient::validateImportJobAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/validate_import_job.php
     *
     * @param ValidateImportJobRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function validateImportJob(ValidateImportJobRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ValidateImportJob', $request, $callOptions)->wait();
    }

    /**
     * Gets information about a location.
     *
     * The async variant is {@see MigrationCenterClient::getLocationAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/get_location.php
     *
     * @param GetLocationRequest $request     A request to house fields associated with the call.
     * @param array              $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Location
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLocation(GetLocationRequest $request, array $callOptions = []): Location
    {
        return $this->startApiCall('GetLocation', $request, $callOptions)->wait();
    }

    /**
     * Lists information about the supported locations for this service.
     *
     * The async variant is {@see MigrationCenterClient::listLocationsAsync()} .
     *
     * @example samples/V1/MigrationCenterClient/list_locations.php
     *
     * @param ListLocationsRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listLocations(ListLocationsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListLocations', $request, $callOptions);
    }
}
