<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/session.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Represents the parameters of a conversational query.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.QueryParameters</code>
 */
class QueryParameters extends \Google\Protobuf\Internal\Message
{
    /**
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     *
     * Generated from protobuf field <code>string time_zone = 1;</code>
     */
    protected $time_zone = '';
    /**
     * The geo location of this conversational query.
     *
     * Generated from protobuf field <code>.google.type.LatLng geo_location = 2;</code>
     */
    protected $geo_location = null;
    /**
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;</code>
     */
    private $session_entity_types;
    /**
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 4;</code>
     */
    protected $payload = null;
    /**
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 5;</code>
     */
    protected $parameters = null;
    /**
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to
     * override the [current page][QueryResult.current_page] in the session.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/pages/<Page ID>`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases,
     * [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page]
     * and [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters]
     * should be configured together to direct a session to a specific state.
     *
     * Generated from protobuf field <code>string current_page = 6 [(.google.api.resource_reference) = {</code>
     */
    protected $current_page = '';
    /**
     * Whether to disable webhook calls for this request.
     *
     * Generated from protobuf field <code>bool disable_webhook = 7;</code>
     */
    protected $disable_webhook = false;
    /**
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     *
     * Generated from protobuf field <code>bool analyze_query_text_sentiment = 8;</code>
     */
    protected $analyze_query_text_sentiment = false;
    /**
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     *
     * Generated from protobuf field <code>map<string, string> webhook_headers = 10;</code>
     */
    private $webhook_headers;
    /**
     * A list of flow versions to override for the request.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/versions/<Version ID>`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     *
     * Generated from protobuf field <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = {</code>
     */
    private $flow_versions;
    /**
     * The channel which this query is for.
     * If specified, only the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] associated
     * with the channel will be returned. If no
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] is
     * associated with the channel, it falls back to the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel.
     * If unspecified, the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel will be returned.
     *
     * Generated from protobuf field <code>string channel = 15;</code>
     */
    protected $channel = '';
    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow session remains active and its data is stored for
     * 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $session_ttl = null;
    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $end_user_metadata = null;
    /**
     * Optional. Search configuration for UCS search queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SearchConfig search_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $search_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $time_zone
     *           The time zone of this conversational query from the [time zone
     *           database](https://www.iana.org/time-zones), e.g., America/New_York,
     *           Europe/Paris. If not provided, the time zone specified in the agent is
     *           used.
     *     @type \Google\Type\LatLng $geo_location
     *           The geo location of this conversational query.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\SessionEntityType>|\Google\Protobuf\Internal\RepeatedField $session_entity_types
     *           Additional session entity types to replace or extend developer entity types
     *           with. The entity synonyms apply to all languages and persist for the
     *           session of this query.
     *     @type \Google\Protobuf\Struct $payload
     *           This field can be used to pass custom data into the webhook associated with
     *           the agent. Arbitrary JSON objects are supported.
     *           Some integrations that query a Dialogflow agent may provide additional
     *           information in the payload.
     *           In particular, for the Dialogflow Phone Gateway integration, this field has
     *           the form:
     *           ```
     *           {
     *            "telephony": {
     *              "caller_id": "+18558363987"
     *            }
     *           }
     *           ```
     *     @type \Google\Protobuf\Struct $parameters
     *           Additional parameters to be put into [session
     *           parameters][SessionInfo.parameters]. To remove a
     *           parameter from the session, clients should explicitly set the parameter
     *           value to null.
     *           You can reference the session parameters in the agent with the following
     *           format: $session.params.parameter-id.
     *           Depending on your protocol or client library language, this is a
     *           map, associative array, symbol table, dictionary, or JSON object
     *           composed of a collection of (MapKey, MapValue) pairs:
     *           * MapKey type: string
     *           * MapKey value: parameter name
     *           * MapValue type: If parameter's entity type is a composite entity then use
     *           map, otherwise, depending on the parameter value type, it could be one of
     *           string, number, boolean, null, list or map.
     *           * MapValue value: If parameter's entity type is a composite entity then use
     *           map from composite entity property names to property values, otherwise,
     *           use parameter value.
     *     @type string $current_page
     *           The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to
     *           override the [current page][QueryResult.current_page] in the session.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/flows/<Flow ID>/pages/<Page ID>`.
     *           If `current_page` is specified, the previous state of the session will be
     *           ignored by Dialogflow, including the [previous
     *           page][QueryResult.current_page] and the [previous session
     *           parameters][QueryResult.parameters].
     *           In most cases,
     *           [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page]
     *           and [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters]
     *           should be configured together to direct a session to a specific state.
     *     @type bool $disable_webhook
     *           Whether to disable webhook calls for this request.
     *     @type bool $analyze_query_text_sentiment
     *           Configures whether sentiment analysis should be performed. If not
     *           provided, sentiment analysis is not performed.
     *     @type array|\Google\Protobuf\Internal\MapField $webhook_headers
     *           This field can be used to pass HTTP headers for a webhook
     *           call. These headers will be sent to webhook along with the headers that
     *           have been configured through Dialogflow web console. The headers defined
     *           within this field will overwrite the headers configured through Dialogflow
     *           console if there is a conflict. Header names are case-insensitive.
     *           Google's specified headers are not allowed. Including: "Host",
     *           "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     *           "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $flow_versions
     *           A list of flow versions to override for the request.
     *           Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     *           ID>/flows/<Flow ID>/versions/<Version ID>`.
     *           If version 1 of flow X is included in this list, the traffic of
     *           flow X will go through version 1 regardless of the version configuration in
     *           the environment. Each flow can have at most one version specified in this
     *           list.
     *     @type string $channel
     *           The channel which this query is for.
     *           If specified, only the
     *           [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] associated
     *           with the channel will be returned. If no
     *           [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] is
     *           associated with the channel, it falls back to the
     *           [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     *           unspecified channel.
     *           If unspecified, the
     *           [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     *           unspecified channel will be returned.
     *     @type \Google\Protobuf\Duration $session_ttl
     *           Optional. Configure lifetime of the Dialogflow session.
     *           By default, a Dialogflow session remains active and its data is stored for
     *           30 minutes after the last request is sent for the session.
     *           This value should be no longer than 1 day.
     *     @type \Google\Protobuf\Struct $end_user_metadata
     *           Optional. Information about the end-user to improve the relevance and
     *           accuracy of generative answers.
     *           This will be interpreted and used by a language model, so, for good
     *           results, the data should be self-descriptive, and in a simple structure.
     *           Example:
     *           ```json
     *           {
     *             "subscription plan": "Business Premium Plus",
     *             "devices owned": [
     *               {"model": "Google Pixel 7"},
     *               {"model": "Google Pixel Tablet"}
     *             ]
     *           }
     *           ```
     *     @type \Google\Cloud\Dialogflow\Cx\V3\SearchConfig $search_config
     *           Optional. Search configuration for UCS search queries.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Session::initOnce();
        parent::__construct($data);
    }

    /**
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     *
     * Generated from protobuf field <code>string time_zone = 1;</code>
     * @return string
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    /**
     * The time zone of this conversational query from the [time zone
     * database](https://www.iana.org/time-zones), e.g., America/New_York,
     * Europe/Paris. If not provided, the time zone specified in the agent is
     * used.
     *
     * Generated from protobuf field <code>string time_zone = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkString($var, True);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * The geo location of this conversational query.
     *
     * Generated from protobuf field <code>.google.type.LatLng geo_location = 2;</code>
     * @return \Google\Type\LatLng|null
     */
    public function getGeoLocation()
    {
        return $this->geo_location;
    }

    public function hasGeoLocation()
    {
        return isset($this->geo_location);
    }

    public function clearGeoLocation()
    {
        unset($this->geo_location);
    }

    /**
     * The geo location of this conversational query.
     *
     * Generated from protobuf field <code>.google.type.LatLng geo_location = 2;</code>
     * @param \Google\Type\LatLng $var
     * @return $this
     */
    public function setGeoLocation($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\LatLng::class);
        $this->geo_location = $var;

        return $this;
    }

    /**
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSessionEntityTypes()
    {
        return $this->session_entity_types;
    }

    /**
     * Additional session entity types to replace or extend developer entity types
     * with. The entity synonyms apply to all languages and persist for the
     * session of this query.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.SessionEntityType session_entity_types = 3;</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\SessionEntityType>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSessionEntityTypes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\SessionEntityType::class);
        $this->session_entity_types = $arr;

        return $this;
    }

    /**
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 4;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getPayload()
    {
        return $this->payload;
    }

    public function hasPayload()
    {
        return isset($this->payload);
    }

    public function clearPayload()
    {
        unset($this->payload);
    }

    /**
     * This field can be used to pass custom data into the webhook associated with
     * the agent. Arbitrary JSON objects are supported.
     * Some integrations that query a Dialogflow agent may provide additional
     * information in the payload.
     * In particular, for the Dialogflow Phone Gateway integration, this field has
     * the form:
     * ```
     * {
     *  "telephony": {
     *    "caller_id": "+18558363987"
     *  }
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct payload = 4;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setPayload($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->payload = $var;

        return $this;
    }

    /**
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 5;</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getParameters()
    {
        return $this->parameters;
    }

    public function hasParameters()
    {
        return isset($this->parameters);
    }

    public function clearParameters()
    {
        unset($this->parameters);
    }

    /**
     * Additional parameters to be put into [session
     * parameters][SessionInfo.parameters]. To remove a
     * parameter from the session, clients should explicitly set the parameter
     * value to null.
     * You can reference the session parameters in the agent with the following
     * format: $session.params.parameter-id.
     * Depending on your protocol or client library language, this is a
     * map, associative array, symbol table, dictionary, or JSON object
     * composed of a collection of (MapKey, MapValue) pairs:
     * * MapKey type: string
     * * MapKey value: parameter name
     * * MapValue type: If parameter's entity type is a composite entity then use
     * map, otherwise, depending on the parameter value type, it could be one of
     * string, number, boolean, null, list or map.
     * * MapValue value: If parameter's entity type is a composite entity then use
     * map from composite entity property names to property values, otherwise,
     * use parameter value.
     *
     * Generated from protobuf field <code>.google.protobuf.Struct parameters = 5;</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setParameters($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->parameters = $var;

        return $this;
    }

    /**
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to
     * override the [current page][QueryResult.current_page] in the session.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/pages/<Page ID>`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases,
     * [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page]
     * and [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters]
     * should be configured together to direct a session to a specific state.
     *
     * Generated from protobuf field <code>string current_page = 6 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getCurrentPage()
    {
        return $this->current_page;
    }

    /**
     * The unique identifier of the [page][google.cloud.dialogflow.cx.v3.Page] to
     * override the [current page][QueryResult.current_page] in the session.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/pages/<Page ID>`.
     * If `current_page` is specified, the previous state of the session will be
     * ignored by Dialogflow, including the [previous
     * page][QueryResult.current_page] and the [previous session
     * parameters][QueryResult.parameters].
     * In most cases,
     * [current_page][google.cloud.dialogflow.cx.v3.QueryParameters.current_page]
     * and [parameters][google.cloud.dialogflow.cx.v3.QueryParameters.parameters]
     * should be configured together to direct a session to a specific state.
     *
     * Generated from protobuf field <code>string current_page = 6 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setCurrentPage($var)
    {
        GPBUtil::checkString($var, True);
        $this->current_page = $var;

        return $this;
    }

    /**
     * Whether to disable webhook calls for this request.
     *
     * Generated from protobuf field <code>bool disable_webhook = 7;</code>
     * @return bool
     */
    public function getDisableWebhook()
    {
        return $this->disable_webhook;
    }

    /**
     * Whether to disable webhook calls for this request.
     *
     * Generated from protobuf field <code>bool disable_webhook = 7;</code>
     * @param bool $var
     * @return $this
     */
    public function setDisableWebhook($var)
    {
        GPBUtil::checkBool($var);
        $this->disable_webhook = $var;

        return $this;
    }

    /**
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     *
     * Generated from protobuf field <code>bool analyze_query_text_sentiment = 8;</code>
     * @return bool
     */
    public function getAnalyzeQueryTextSentiment()
    {
        return $this->analyze_query_text_sentiment;
    }

    /**
     * Configures whether sentiment analysis should be performed. If not
     * provided, sentiment analysis is not performed.
     *
     * Generated from protobuf field <code>bool analyze_query_text_sentiment = 8;</code>
     * @param bool $var
     * @return $this
     */
    public function setAnalyzeQueryTextSentiment($var)
    {
        GPBUtil::checkBool($var);
        $this->analyze_query_text_sentiment = $var;

        return $this;
    }

    /**
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     *
     * Generated from protobuf field <code>map<string, string> webhook_headers = 10;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getWebhookHeaders()
    {
        return $this->webhook_headers;
    }

    /**
     * This field can be used to pass HTTP headers for a webhook
     * call. These headers will be sent to webhook along with the headers that
     * have been configured through Dialogflow web console. The headers defined
     * within this field will overwrite the headers configured through Dialogflow
     * console if there is a conflict. Header names are case-insensitive.
     * Google's specified headers are not allowed. Including: "Host",
     * "Content-Length", "Connection", "From", "User-Agent", "Accept-Encoding",
     * "If-Modified-Since", "If-None-Match", "X-Forwarded-For", etc.
     *
     * Generated from protobuf field <code>map<string, string> webhook_headers = 10;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setWebhookHeaders($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->webhook_headers = $arr;

        return $this;
    }

    /**
     * A list of flow versions to override for the request.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/versions/<Version ID>`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     *
     * Generated from protobuf field <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = {</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getFlowVersions()
    {
        return $this->flow_versions;
    }

    /**
     * A list of flow versions to override for the request.
     * Format: `projects/<Project ID>/locations/<Location ID>/agents/<Agent
     * ID>/flows/<Flow ID>/versions/<Version ID>`.
     * If version 1 of flow X is included in this list, the traffic of
     * flow X will go through version 1 regardless of the version configuration in
     * the environment. Each flow can have at most one version specified in this
     * list.
     *
     * Generated from protobuf field <code>repeated string flow_versions = 14 [(.google.api.resource_reference) = {</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setFlowVersions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->flow_versions = $arr;

        return $this;
    }

    /**
     * The channel which this query is for.
     * If specified, only the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] associated
     * with the channel will be returned. If no
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] is
     * associated with the channel, it falls back to the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel.
     * If unspecified, the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel will be returned.
     *
     * Generated from protobuf field <code>string channel = 15;</code>
     * @return string
     */
    public function getChannel()
    {
        return $this->channel;
    }

    /**
     * The channel which this query is for.
     * If specified, only the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] associated
     * with the channel will be returned. If no
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] is
     * associated with the channel, it falls back to the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel.
     * If unspecified, the
     * [ResponseMessage][google.cloud.dialogflow.cx.v3.ResponseMessage] with
     * unspecified channel will be returned.
     *
     * Generated from protobuf field <code>string channel = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setChannel($var)
    {
        GPBUtil::checkString($var, True);
        $this->channel = $var;

        return $this;
    }

    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow session remains active and its data is stored for
     * 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getSessionTtl()
    {
        return $this->session_ttl;
    }

    public function hasSessionTtl()
    {
        return isset($this->session_ttl);
    }

    public function clearSessionTtl()
    {
        unset($this->session_ttl);
    }

    /**
     * Optional. Configure lifetime of the Dialogflow session.
     * By default, a Dialogflow session remains active and its data is stored for
     * 30 minutes after the last request is sent for the session.
     * This value should be no longer than 1 day.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration session_ttl = 16 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setSessionTtl($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->session_ttl = $var;

        return $this;
    }

    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Struct|null
     */
    public function getEndUserMetadata()
    {
        return $this->end_user_metadata;
    }

    public function hasEndUserMetadata()
    {
        return isset($this->end_user_metadata);
    }

    public function clearEndUserMetadata()
    {
        unset($this->end_user_metadata);
    }

    /**
     * Optional. Information about the end-user to improve the relevance and
     * accuracy of generative answers.
     * This will be interpreted and used by a language model, so, for good
     * results, the data should be self-descriptive, and in a simple structure.
     * Example:
     * ```json
     * {
     *   "subscription plan": "Business Premium Plus",
     *   "devices owned": [
     *     {"model": "Google Pixel 7"},
     *     {"model": "Google Pixel Tablet"}
     *   ]
     * }
     * ```
     *
     * Generated from protobuf field <code>.google.protobuf.Struct end_user_metadata = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Struct $var
     * @return $this
     */
    public function setEndUserMetadata($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Struct::class);
        $this->end_user_metadata = $var;

        return $this;
    }

    /**
     * Optional. Search configuration for UCS search queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SearchConfig search_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\SearchConfig|null
     */
    public function getSearchConfig()
    {
        return $this->search_config;
    }

    public function hasSearchConfig()
    {
        return isset($this->search_config);
    }

    public function clearSearchConfig()
    {
        unset($this->search_config);
    }

    /**
     * Optional. Search configuration for UCS search queries.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.SearchConfig search_config = 20 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\SearchConfig $var
     * @return $this
     */
    public function setSearchConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\SearchConfig::class);
        $this->search_config = $var;

        return $this;
    }

}

