<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/devtools/cloudbuild/v2/repositories.proto

namespace Google\Cloud\Build\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for connections to gitlab.com or an instance of GitLab
 * Enterprise.
 *
 * Generated from protobuf message <code>google.devtools.cloudbuild.v2.GitLabConfig</code>
 */
class GitLabConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     *
     * Generated from protobuf field <code>string host_uri = 1;</code>
     */
    private $host_uri = '';
    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    private $webhook_secret_secret_version = '';
    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $read_authorizer_credential = null;
    /**
     * Required. A GitLab personal access token with the `api` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $authorizer_credential = null;
    /**
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;</code>
     */
    private $service_directory_config = null;
    /**
     * SSL certificate to use for requests to GitLab Enterprise.
     *
     * Generated from protobuf field <code>string ssl_ca = 6;</code>
     */
    private $ssl_ca = '';
    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $server_version = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $host_uri
     *           The URI of the GitLab Enterprise host this connection is for.
     *           If not specified, the default value is https://gitlab.com.
     *     @type string $webhook_secret_secret_version
     *           Required. Immutable. SecretManager resource containing the webhook secret
     *           of a GitLab Enterprise project, formatted as
     *           `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *     @type \Google\Cloud\Build\V2\UserCredential $read_authorizer_credential
     *           Required. A GitLab personal access token with the minimum `read_api` scope
     *           access.
     *     @type \Google\Cloud\Build\V2\UserCredential $authorizer_credential
     *           Required. A GitLab personal access token with the `api` scope access.
     *     @type \Google\Cloud\Build\V2\ServiceDirectoryConfig $service_directory_config
     *           Configuration for using Service Directory to privately connect to a GitLab
     *           Enterprise server. This should only be set if the GitLab Enterprise server
     *           is hosted on-premises and not reachable by public internet. If this field
     *           is left empty, calls to the GitLab Enterprise server will be made over the
     *           public internet.
     *     @type string $ssl_ca
     *           SSL certificate to use for requests to GitLab Enterprise.
     *     @type string $server_version
     *           Output only. Version of the GitLab Enterprise server running on the
     *           `host_uri`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Devtools\Cloudbuild\V2\Repositories::initOnce();
        parent::__construct($data);
    }

    /**
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     *
     * Generated from protobuf field <code>string host_uri = 1;</code>
     * @return string
     */
    public function getHostUri()
    {
        return $this->host_uri;
    }

    /**
     * The URI of the GitLab Enterprise host this connection is for.
     * If not specified, the default value is https://gitlab.com.
     *
     * Generated from protobuf field <code>string host_uri = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setHostUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->host_uri = $var;

        return $this;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWebhookSecretSecretVersion()
    {
        return $this->webhook_secret_secret_version;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * of a GitLab Enterprise project, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWebhookSecretSecretVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->webhook_secret_secret_version = $var;

        return $this;
    }

    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Build\V2\UserCredential|null
     */
    public function getReadAuthorizerCredential()
    {
        return $this->read_authorizer_credential;
    }

    public function hasReadAuthorizerCredential()
    {
        return isset($this->read_authorizer_credential);
    }

    public function clearReadAuthorizerCredential()
    {
        unset($this->read_authorizer_credential);
    }

    /**
     * Required. A GitLab personal access token with the minimum `read_api` scope
     * access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Build\V2\UserCredential $var
     * @return $this
     */
    public function setReadAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\UserCredential::class);
        $this->read_authorizer_credential = $var;

        return $this;
    }

    /**
     * Required. A GitLab personal access token with the `api` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Build\V2\UserCredential|null
     */
    public function getAuthorizerCredential()
    {
        return $this->authorizer_credential;
    }

    public function hasAuthorizerCredential()
    {
        return isset($this->authorizer_credential);
    }

    public function clearAuthorizerCredential()
    {
        unset($this->authorizer_credential);
    }

    /**
     * Required. A GitLab personal access token with the `api` scope access.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Build\V2\UserCredential $var
     * @return $this
     */
    public function setAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\UserCredential::class);
        $this->authorizer_credential = $var;

        return $this;
    }

    /**
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;</code>
     * @return \Google\Cloud\Build\V2\ServiceDirectoryConfig|null
     */
    public function getServiceDirectoryConfig()
    {
        return $this->service_directory_config;
    }

    public function hasServiceDirectoryConfig()
    {
        return isset($this->service_directory_config);
    }

    public function clearServiceDirectoryConfig()
    {
        unset($this->service_directory_config);
    }

    /**
     * Configuration for using Service Directory to privately connect to a GitLab
     * Enterprise server. This should only be set if the GitLab Enterprise server
     * is hosted on-premises and not reachable by public internet. If this field
     * is left empty, calls to the GitLab Enterprise server will be made over the
     * public internet.
     *
     * Generated from protobuf field <code>.google.devtools.cloudbuild.v2.ServiceDirectoryConfig service_directory_config = 5;</code>
     * @param \Google\Cloud\Build\V2\ServiceDirectoryConfig $var
     * @return $this
     */
    public function setServiceDirectoryConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Build\V2\ServiceDirectoryConfig::class);
        $this->service_directory_config = $var;

        return $this;
    }

    /**
     * SSL certificate to use for requests to GitLab Enterprise.
     *
     * Generated from protobuf field <code>string ssl_ca = 6;</code>
     * @return string
     */
    public function getSslCa()
    {
        return $this->ssl_ca;
    }

    /**
     * SSL certificate to use for requests to GitLab Enterprise.
     *
     * Generated from protobuf field <code>string ssl_ca = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setSslCa($var)
    {
        GPBUtil::checkString($var, True);
        $this->ssl_ca = $var;

        return $this;
    }

    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getServerVersion()
    {
        return $this->server_version;
    }

    /**
     * Output only. Version of the GitLab Enterprise server running on the
     * `host_uri`.
     *
     * Generated from protobuf field <code>string server_version = 7 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setServerVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->server_version = $var;

        return $this;
    }

}

