<?php
/*
 * Copyright 2023 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/identity/accesscontextmanager/v1/access_context_manager.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Identity\AccessContextManager\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\LongRunning\OperationsClient;
use Google\ApiCore\OperationResponse;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Iam\V1\GetIamPolicyRequest;
use Google\Cloud\Iam\V1\Policy;
use Google\Cloud\Iam\V1\SetIamPolicyRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsRequest;
use Google\Cloud\Iam\V1\TestIamPermissionsResponse;
use Google\Identity\AccessContextManager\V1\AccessLevel;
use Google\Identity\AccessContextManager\V1\AccessPolicy;
use Google\Identity\AccessContextManager\V1\CommitServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\CommitServicePerimetersResponse;
use Google\Identity\AccessContextManager\V1\CreateAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\CreateGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\CreateServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\DeleteAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\DeleteAccessPolicyRequest;
use Google\Identity\AccessContextManager\V1\DeleteGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\DeleteServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\GcpUserAccessBinding;
use Google\Identity\AccessContextManager\V1\GetAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\GetAccessPolicyRequest;
use Google\Identity\AccessContextManager\V1\GetGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\GetServicePerimeterRequest;
use Google\Identity\AccessContextManager\V1\ListAccessLevelsRequest;
use Google\Identity\AccessContextManager\V1\ListAccessPoliciesRequest;
use Google\Identity\AccessContextManager\V1\ListGcpUserAccessBindingsRequest;
use Google\Identity\AccessContextManager\V1\ListServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\ReplaceAccessLevelsRequest;
use Google\Identity\AccessContextManager\V1\ReplaceAccessLevelsResponse;
use Google\Identity\AccessContextManager\V1\ReplaceServicePerimetersRequest;
use Google\Identity\AccessContextManager\V1\ReplaceServicePerimetersResponse;
use Google\Identity\AccessContextManager\V1\ServicePerimeter;
use Google\Identity\AccessContextManager\V1\UpdateAccessLevelRequest;
use Google\Identity\AccessContextManager\V1\UpdateAccessPolicyRequest;
use Google\Identity\AccessContextManager\V1\UpdateGcpUserAccessBindingRequest;
use Google\Identity\AccessContextManager\V1\UpdateServicePerimeterRequest;
use Google\LongRunning\Operation;
use GuzzleHttp\Promise\PromiseInterface;

/**
 * Service Description: API for setting [access levels]
 * [google.identity.accesscontextmanager.v1.AccessLevel] and [service
 * perimeters] [google.identity.accesscontextmanager.v1.ServicePerimeter]
 * for Google Cloud projects. Each organization has one [access policy]
 * [google.identity.accesscontextmanager.v1.AccessPolicy] that contains the
 * [access levels] [google.identity.accesscontextmanager.v1.AccessLevel]
 * and [service perimeters]
 * [google.identity.accesscontextmanager.v1.ServicePerimeter]. This
 * [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy] is
 * applicable to all resources in the organization.
 * AccessPolicies
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface commitServicePerimetersAsync(CommitServicePerimetersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAccessLevelAsync(CreateAccessLevelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createAccessPolicyAsync(AccessPolicy $request, array $optionalArgs = [])
 * @method PromiseInterface createGcpUserAccessBindingAsync(CreateGcpUserAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface createServicePerimeterAsync(CreateServicePerimeterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAccessLevelAsync(DeleteAccessLevelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteAccessPolicyAsync(DeleteAccessPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteGcpUserAccessBindingAsync(DeleteGcpUserAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface deleteServicePerimeterAsync(DeleteServicePerimeterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAccessLevelAsync(GetAccessLevelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getAccessPolicyAsync(GetAccessPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getGcpUserAccessBindingAsync(GetGcpUserAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getIamPolicyAsync(GetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface getServicePerimeterAsync(GetServicePerimeterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAccessLevelsAsync(ListAccessLevelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listAccessPoliciesAsync(ListAccessPoliciesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listGcpUserAccessBindingsAsync(ListGcpUserAccessBindingsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface listServicePerimetersAsync(ListServicePerimetersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface replaceAccessLevelsAsync(ReplaceAccessLevelsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface replaceServicePerimetersAsync(ReplaceServicePerimetersRequest $request, array $optionalArgs = [])
 * @method PromiseInterface setIamPolicyAsync(SetIamPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface testIamPermissionsAsync(TestIamPermissionsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAccessLevelAsync(UpdateAccessLevelRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateAccessPolicyAsync(UpdateAccessPolicyRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateGcpUserAccessBindingAsync(UpdateGcpUserAccessBindingRequest $request, array $optionalArgs = [])
 * @method PromiseInterface updateServicePerimeterAsync(UpdateServicePerimeterRequest $request, array $optionalArgs = [])
 */
final class AccessContextManagerClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.identity.accesscontextmanager.v1.AccessContextManager';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'accesscontextmanager.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'accesscontextmanager.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
    ];

    private $operationsClient;

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/access_context_manager_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/access_context_manager_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/access_context_manager_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/access_context_manager_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Return an OperationsClient object with the same endpoint as $this.
     *
     * @return OperationsClient
     */
    public function getOperationsClient()
    {
        return $this->operationsClient;
    }

    /**
     * Resume an existing long running operation that was previously started by a long
     * running API method. If $methodName is not provided, or does not match a long
     * running API method, then the operation can still be resumed, but the
     * OperationResponse object will not deserialize the final response.
     *
     * @param string $operationName The name of the long running operation
     * @param string $methodName    The name of the method used to start the operation
     *
     * @return OperationResponse
     */
    public function resumeOperation($operationName, $methodName = null)
    {
        $options = isset($this->descriptors[$methodName]['longRunning']) ? $this->descriptors[$methodName]['longRunning'] : [];
        $operation = new OperationResponse($operationName, $this->getOperationsClient(), $options);
        $operation->reload();
        return $operation;
    }

    /**
     * Formats a string containing the fully-qualified path to represent a access_level
     * resource.
     *
     * @param string $accessPolicy
     * @param string $accessLevel
     *
     * @return string The formatted access_level resource.
     */
    public static function accessLevelName(string $accessPolicy, string $accessLevel): string
    {
        return self::getPathTemplate('accessLevel')->render([
            'access_policy' => $accessPolicy,
            'access_level' => $accessLevel,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * access_policy resource.
     *
     * @param string $accessPolicy
     *
     * @return string The formatted access_policy resource.
     */
    public static function accessPolicyName(string $accessPolicy): string
    {
        return self::getPathTemplate('accessPolicy')->render([
            'access_policy' => $accessPolicy,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * gcp_user_access_binding resource.
     *
     * @param string $organization
     * @param string $gcpUserAccessBinding
     *
     * @return string The formatted gcp_user_access_binding resource.
     */
    public static function gcpUserAccessBindingName(string $organization, string $gcpUserAccessBinding): string
    {
        return self::getPathTemplate('gcpUserAccessBinding')->render([
            'organization' => $organization,
            'gcp_user_access_binding' => $gcpUserAccessBinding,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * service_perimeter resource.
     *
     * @param string $accessPolicy
     * @param string $servicePerimeter
     *
     * @return string The formatted service_perimeter resource.
     */
    public static function servicePerimeterName(string $accessPolicy, string $servicePerimeter): string
    {
        return self::getPathTemplate('servicePerimeter')->render([
            'access_policy' => $accessPolicy,
            'service_perimeter' => $servicePerimeter,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - accessLevel: accessPolicies/{access_policy}/accessLevels/{access_level}
     * - accessPolicy: accessPolicies/{access_policy}
     * - gcpUserAccessBinding: organizations/{organization}/gcpUserAccessBindings/{gcp_user_access_binding}
     * - organization: organizations/{organization}
     * - servicePerimeter: accessPolicies/{access_policy}/servicePerimeters/{service_perimeter}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string $formattedName The formatted name string
     * @param string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'accesscontextmanager.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
        $this->operationsClient = $this->createOperationsClient($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Commits the dry-run specification for all the [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an
     * [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
     * A commit operation on a service perimeter involves copying its `spec` field
     * to the `status` field of the service perimeter. Only [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] with
     * `use_explicit_dry_run_spec` field set to true are affected by a commit
     * operation. The long-running operation from this RPC has a successful
     * status after the dry-run specifications for all the [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] have been
     * committed. If a commit fails, it causes the long-running operation to
     * return an error response and the entire commit operation is cancelled.
     * When successful, the Operation.response field contains
     * CommitServicePerimetersResponse. The `dry_run` and the `spec` fields are
     * cleared after a successful commit operation.
     *
     * The async variant is
     * {@see AccessContextManagerClient::commitServicePerimetersAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/commit_service_perimeters.php
     *
     * @param CommitServicePerimetersRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function commitServicePerimeters(CommitServicePerimetersRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CommitServicePerimeters', $request, $callOptions)->wait();
    }

    /**
     * Creates an [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
     * operation from this RPC has a successful status after the [access
     * level] [google.identity.accesscontextmanager.v1.AccessLevel]
     * propagates to long-lasting storage. If [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] contain
     * errors, an error response is returned for the first error encountered.
     *
     * The async variant is {@see AccessContextManagerClient::createAccessLevelAsync()}
     * .
     *
     * @example samples/V1/AccessContextManagerClient/create_access_level.php
     *
     * @param CreateAccessLevelRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAccessLevel(CreateAccessLevelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAccessLevel', $request, $callOptions)->wait();
    }

    /**
     * Creates an access policy. This method fails if the organization already has
     * an access policy. The long-running operation has a successful status
     * after the access policy propagates to long-lasting storage.
     * Syntactic and basic semantic errors are returned in `metadata` as a
     * BadRequest proto.
     *
     * The async variant is
     * {@see AccessContextManagerClient::createAccessPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/create_access_policy.php
     *
     * @param AccessPolicy $request     A request to house fields associated with the call.
     * @param array        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createAccessPolicy(AccessPolicy $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateAccessPolicy', $request, $callOptions)->wait();
    }

    /**
     * Creates a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding]. If the
     * client specifies a [name]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.name],
     * the server ignores it. Fails if a resource already exists with the same
     * [group_key]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding.group_key].
     * Completion of this long-running operation does not necessarily signify that
     * the new binding is deployed onto all affected users, which may take more
     * time.
     *
     * The async variant is
     * {@see AccessContextManagerClient::createGcpUserAccessBindingAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/create_gcp_user_access_binding.php
     *
     * @param CreateGcpUserAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createGcpUserAccessBinding(CreateGcpUserAccessBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateGcpUserAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Creates a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
     * long-running operation from this RPC has a successful status after the
     * [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]
     * propagates to long-lasting storage. If a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
     * errors, an error response is returned for the first error encountered.
     *
     * The async variant is
     * {@see AccessContextManagerClient::createServicePerimeterAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/create_service_perimeter.php
     *
     * @param CreateServicePerimeterRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createServicePerimeter(CreateServicePerimeterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('CreateServicePerimeter', $request, $callOptions)->wait();
    }

    /**
     * Deletes an [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
     * name. The long-running operation from this RPC has a successful status
     * after the [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] has been removed
     * from long-lasting storage.
     *
     * The async variant is {@see AccessContextManagerClient::deleteAccessLevelAsync()}
     * .
     *
     * @example samples/V1/AccessContextManagerClient/delete_access_level.php
     *
     * @param DeleteAccessLevelRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAccessLevel(DeleteAccessLevelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAccessLevel', $request, $callOptions)->wait();
    }

    /**
     * Deletes an [access policy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] based on the
     * resource name. The long-running operation has a successful status after the
     * [access policy] [google.identity.accesscontextmanager.v1.AccessPolicy]
     * is removed from long-lasting storage.
     *
     * The async variant is
     * {@see AccessContextManagerClient::deleteAccessPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/delete_access_policy.php
     *
     * @param DeleteAccessPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteAccessPolicy(DeleteAccessPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteAccessPolicy', $request, $callOptions)->wait();
    }

    /**
     * Deletes a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
     * Completion of this long-running operation does not necessarily signify that
     * the binding deletion is deployed onto all affected users, which may take
     * more time.
     *
     * The async variant is
     * {@see AccessContextManagerClient::deleteGcpUserAccessBindingAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/delete_gcp_user_access_binding.php
     *
     * @param DeleteGcpUserAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteGcpUserAccessBinding(DeleteGcpUserAccessBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteGcpUserAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Deletes a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
     * resource name. The long-running operation from this RPC has a successful
     * status after the [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] is removed from
     * long-lasting storage.
     *
     * The async variant is
     * {@see AccessContextManagerClient::deleteServicePerimeterAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/delete_service_perimeter.php
     *
     * @param DeleteServicePerimeterRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteServicePerimeter(DeleteServicePerimeterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('DeleteServicePerimeter', $request, $callOptions)->wait();
    }

    /**
     * Gets an [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] based on the resource
     * name.
     *
     * The async variant is {@see AccessContextManagerClient::getAccessLevelAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/get_access_level.php
     *
     * @param GetAccessLevelRequest $request     A request to house fields associated with the call.
     * @param array                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AccessLevel
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAccessLevel(GetAccessLevelRequest $request, array $callOptions = []): AccessLevel
    {
        return $this->startApiCall('GetAccessLevel', $request, $callOptions)->wait();
    }

    /**
     * Returns an [access policy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] based on the name.
     *
     * The async variant is {@see AccessContextManagerClient::getAccessPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/get_access_policy.php
     *
     * @param GetAccessPolicyRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return AccessPolicy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getAccessPolicy(GetAccessPolicyRequest $request, array $callOptions = []): AccessPolicy
    {
        return $this->startApiCall('GetAccessPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets the [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] with
     * the given name.
     *
     * The async variant is
     * {@see AccessContextManagerClient::getGcpUserAccessBindingAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/get_gcp_user_access_binding.php
     *
     * @param GetGcpUserAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return GcpUserAccessBinding
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getGcpUserAccessBinding(GetGcpUserAccessBindingRequest $request, array $callOptions = []): GcpUserAccessBinding
    {
        return $this->startApiCall('GetGcpUserAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Gets the IAM policy for the specified Access Context Manager
     * [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
     *
     * The async variant is {@see AccessContextManagerClient::getIamPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/get_iam_policy.php
     *
     * @param GetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getIamPolicy(GetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('GetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Gets a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] based on the
     * resource name.
     *
     * The async variant is
     * {@see AccessContextManagerClient::getServicePerimeterAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/get_service_perimeter.php
     *
     * @param GetServicePerimeterRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return ServicePerimeter
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getServicePerimeter(GetServicePerimeterRequest $request, array $callOptions = []): ServicePerimeter
    {
        return $this->startApiCall('GetServicePerimeter', $request, $callOptions)->wait();
    }

    /**
     * Lists all [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] for an access
     * policy.
     *
     * The async variant is {@see AccessContextManagerClient::listAccessLevelsAsync()}
     * .
     *
     * @example samples/V1/AccessContextManagerClient/list_access_levels.php
     *
     * @param ListAccessLevelsRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAccessLevels(ListAccessLevelsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccessLevels', $request, $callOptions);
    }

    /**
     * Lists all [access policies]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] in an
     * organization.
     *
     * The async variant is
     * {@see AccessContextManagerClient::listAccessPoliciesAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/list_access_policies.php
     *
     * @param ListAccessPoliciesRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listAccessPolicies(ListAccessPoliciesRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListAccessPolicies', $request, $callOptions);
    }

    /**
     * Lists all [GcpUserAccessBindings]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding] for a
     * Google Cloud organization.
     *
     * The async variant is
     * {@see AccessContextManagerClient::listGcpUserAccessBindingsAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/list_gcp_user_access_bindings.php
     *
     * @param ListGcpUserAccessBindingsRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listGcpUserAccessBindings(ListGcpUserAccessBindingsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListGcpUserAccessBindings', $request, $callOptions);
    }

    /**
     * Lists all [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] for an
     * access policy.
     *
     * The async variant is
     * {@see AccessContextManagerClient::listServicePerimetersAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/list_service_perimeters.php
     *
     * @param ListServicePerimetersRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServicePerimeters(ListServicePerimetersRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListServicePerimeters', $request, $callOptions);
    }

    /**
     * Replaces all existing [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] in an [access
     * policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with
     * the [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] provided. This
     * is done atomically. The long-running operation from this RPC has a
     * successful status after all replacements propagate to long-lasting
     * storage. If the replacement contains errors, an error response is returned
     * for the first error encountered.  Upon error, the replacement is cancelled,
     * and existing [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] are not
     * affected. The Operation.response field contains
     * ReplaceAccessLevelsResponse. Removing [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] contained in existing
     * [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] result in an
     * error.
     *
     * The async variant is
     * {@see AccessContextManagerClient::replaceAccessLevelsAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/replace_access_levels.php
     *
     * @param ReplaceAccessLevelsRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function replaceAccessLevels(ReplaceAccessLevelsRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ReplaceAccessLevels', $request, $callOptions)->wait();
    }

    /**
     * Replace all existing [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] in an [access
     * policy] [google.identity.accesscontextmanager.v1.AccessPolicy] with the
     * [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] provided. This
     * is done atomically. The long-running operation from this RPC has a
     * successful status after all replacements propagate to long-lasting storage.
     * Replacements containing errors result in an error response for the first
     * error encountered. Upon an error, replacement are cancelled and existing
     * [service perimeters]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] are not
     * affected. The Operation.response field contains
     * ReplaceServicePerimetersResponse.
     *
     * The async variant is
     * {@see AccessContextManagerClient::replaceServicePerimetersAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/replace_service_perimeters.php
     *
     * @param ReplaceServicePerimetersRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function replaceServicePerimeters(ReplaceServicePerimetersRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('ReplaceServicePerimeters', $request, $callOptions)->wait();
    }

    /**
     * Sets the IAM policy for the specified Access Context Manager
     * [access policy][google.identity.accesscontextmanager.v1.AccessPolicy].
     * This method replaces the existing IAM policy on the access policy. The IAM
     * policy controls the set of users who can perform specific operations on the
     * Access Context Manager [access
     * policy][google.identity.accesscontextmanager.v1.AccessPolicy].
     *
     * The async variant is {@see AccessContextManagerClient::setIamPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/set_iam_policy.php
     *
     * @param SetIamPolicyRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Policy
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function setIamPolicy(SetIamPolicyRequest $request, array $callOptions = []): Policy
    {
        return $this->startApiCall('SetIamPolicy', $request, $callOptions)->wait();
    }

    /**
     * Returns the IAM permissions that the caller has on the specified Access
     * Context Manager resource. The resource can be an
     * [AccessPolicy][google.identity.accesscontextmanager.v1.AccessPolicy],
     * [AccessLevel][google.identity.accesscontextmanager.v1.AccessLevel], or
     * [ServicePerimeter][google.identity.accesscontextmanager.v1.ServicePerimeter
     * ]. This method does not support other resources.
     *
     * The async variant is
     * {@see AccessContextManagerClient::testIamPermissionsAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/test_iam_permissions.php
     *
     * @param TestIamPermissionsRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return TestIamPermissionsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function testIamPermissions(TestIamPermissionsRequest $request, array $callOptions = []): TestIamPermissionsResponse
    {
        return $this->startApiCall('TestIamPermissions', $request, $callOptions)->wait();
    }

    /**
     * Updates an [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel]. The long-running
     * operation from this RPC has a successful status after the changes to
     * the [access level]
     * [google.identity.accesscontextmanager.v1.AccessLevel] propagate
     * to long-lasting storage. If [access levels]
     * [google.identity.accesscontextmanager.v1.AccessLevel] contain
     * errors, an error response is returned for the first error encountered.
     *
     * The async variant is {@see AccessContextManagerClient::updateAccessLevelAsync()}
     * .
     *
     * @example samples/V1/AccessContextManagerClient/update_access_level.php
     *
     * @param UpdateAccessLevelRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAccessLevel(UpdateAccessLevelRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAccessLevel', $request, $callOptions)->wait();
    }

    /**
     * Updates an [access policy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy]. The
     * long-running operation from this RPC has a successful status after the
     * changes to the [access policy]
     * [google.identity.accesscontextmanager.v1.AccessPolicy] propagate
     * to long-lasting storage.
     *
     * The async variant is
     * {@see AccessContextManagerClient::updateAccessPolicyAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/update_access_policy.php
     *
     * @param UpdateAccessPolicyRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateAccessPolicy(UpdateAccessPolicyRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateAccessPolicy', $request, $callOptions)->wait();
    }

    /**
     * Updates a [GcpUserAccessBinding]
     * [google.identity.accesscontextmanager.v1.GcpUserAccessBinding].
     * Completion of this long-running operation does not necessarily signify that
     * the changed binding is deployed onto all affected users, which may take
     * more time.
     *
     * The async variant is
     * {@see AccessContextManagerClient::updateGcpUserAccessBindingAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/update_gcp_user_access_binding.php
     *
     * @param UpdateGcpUserAccessBindingRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateGcpUserAccessBinding(UpdateGcpUserAccessBindingRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateGcpUserAccessBinding', $request, $callOptions)->wait();
    }

    /**
     * Updates a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]. The
     * long-running operation from this RPC has a successful status after the
     * [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter]
     * propagates to long-lasting storage. If a [service perimeter]
     * [google.identity.accesscontextmanager.v1.ServicePerimeter] contains
     * errors, an error response is returned for the first error encountered.
     *
     * The async variant is
     * {@see AccessContextManagerClient::updateServicePerimeterAsync()} .
     *
     * @example samples/V1/AccessContextManagerClient/update_service_perimeter.php
     *
     * @param UpdateServicePerimeterRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return OperationResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateServicePerimeter(UpdateServicePerimeterRequest $request, array $callOptions = []): OperationResponse
    {
        return $this->startApiCall('UpdateServicePerimeter', $request, $callOptions)->wait();
    }
}
