<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/monitoring/v3/alert.proto

namespace Google\Cloud\Monitoring\V3\AlertPolicy;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A condition is a true/false test that determines when an alerting policy
 * should open an incident. If a condition evaluates to true, it signifies
 * that something is wrong.
 *
 * Generated from protobuf message <code>google.monitoring.v3.AlertPolicy.Condition</code>
 */
class Condition extends \Google\Protobuf\Internal\Message
{
    /**
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     *
     * Generated from protobuf field <code>string name = 12;</code>
     */
    protected $name = '';
    /**
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     */
    protected $display_name = '';
    protected $condition;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required if the condition exists. The unique resource name for this
     *           condition. Its format is:
     *               projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     *           `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     *           condition is created as part of a new or updated alerting policy.
     *           When calling the
     *           [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     *           method, do not include the `name` field in the conditions of the
     *           requested alerting policy. Cloud Monitoring creates the
     *           condition identifiers and includes them in the new policy.
     *           When calling the
     *           [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     *           method to update a policy, including a condition `name` causes the
     *           existing condition to be updated. Conditions without names are added to
     *           the updated policy. Existing conditions are deleted if they are not
     *           updated.
     *           Best practice is to preserve `[CONDITION_ID]` if you make only small
     *           changes, such as those to condition thresholds, durations, or trigger
     *           values.  Otherwise, treat the change as a new condition and let the
     *           existing condition be deleted.
     *     @type string $display_name
     *           A short name or phrase used to identify the condition in dashboards,
     *           notifications, and incidents. To avoid confusion, don't use the same
     *           display name for multiple conditions in the same policy.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricThreshold $condition_threshold
     *           A condition that compares a time series against a threshold.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricAbsence $condition_absent
     *           A condition that checks that a time series continues to
     *           receive new data points.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\LogMatch $condition_matched_log
     *           A condition that checks for log messages matching given constraints. If
     *           set, no other conditions can be present.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MonitoringQueryLanguageCondition $condition_monitoring_query_language
     *           A condition that uses the Monitoring Query Language to define
     *           alerts.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\PrometheusQueryLanguageCondition $condition_prometheus_query_language
     *           A condition that uses the Prometheus query language to define alerts.
     *     @type \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition $condition_sql
     *           A condition that periodically evaluates a SQL query result.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Monitoring\V3\Alert::initOnce();
        parent::__construct($data);
    }

    /**
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     *
     * Generated from protobuf field <code>string name = 12;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required if the condition exists. The unique resource name for this
     * condition. Its format is:
     *     projects/[PROJECT_ID_OR_NUMBER]/alertPolicies/[POLICY_ID]/conditions/[CONDITION_ID]
     * `[CONDITION_ID]` is assigned by Cloud Monitoring when the
     * condition is created as part of a new or updated alerting policy.
     * When calling the
     * [alertPolicies.create][google.monitoring.v3.AlertPolicyService.CreateAlertPolicy]
     * method, do not include the `name` field in the conditions of the
     * requested alerting policy. Cloud Monitoring creates the
     * condition identifiers and includes them in the new policy.
     * When calling the
     * [alertPolicies.update][google.monitoring.v3.AlertPolicyService.UpdateAlertPolicy]
     * method to update a policy, including a condition `name` causes the
     * existing condition to be updated. Conditions without names are added to
     * the updated policy. Existing conditions are deleted if they are not
     * updated.
     * Best practice is to preserve `[CONDITION_ID]` if you make only small
     * changes, such as those to condition thresholds, durations, or trigger
     * values.  Otherwise, treat the change as a new condition and let the
     * existing condition be deleted.
     *
     * Generated from protobuf field <code>string name = 12;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * A short name or phrase used to identify the condition in dashboards,
     * notifications, and incidents. To avoid confusion, don't use the same
     * display name for multiple conditions in the same policy.
     *
     * Generated from protobuf field <code>string display_name = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * A condition that compares a time series against a threshold.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricThreshold|null
     */
    public function getConditionThreshold()
    {
        return $this->readOneof(1);
    }

    public function hasConditionThreshold()
    {
        return $this->hasOneof(1);
    }

    /**
     * A condition that compares a time series against a threshold.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MetricThreshold condition_threshold = 1;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricThreshold $var
     * @return $this
     */
    public function setConditionThreshold($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricThreshold::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * A condition that checks that a time series continues to
     * receive new data points.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricAbsence|null
     */
    public function getConditionAbsent()
    {
        return $this->readOneof(2);
    }

    public function hasConditionAbsent()
    {
        return $this->hasOneof(2);
    }

    /**
     * A condition that checks that a time series continues to
     * receive new data points.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MetricAbsence condition_absent = 2;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricAbsence $var
     * @return $this
     */
    public function setConditionAbsent($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MetricAbsence::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\LogMatch|null
     */
    public function getConditionMatchedLog()
    {
        return $this->readOneof(20);
    }

    public function hasConditionMatchedLog()
    {
        return $this->hasOneof(20);
    }

    /**
     * A condition that checks for log messages matching given constraints. If
     * set, no other conditions can be present.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.LogMatch condition_matched_log = 20;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\LogMatch $var
     * @return $this
     */
    public function setConditionMatchedLog($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\LogMatch::class);
        $this->writeOneof(20, $var);

        return $this;
    }

    /**
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MonitoringQueryLanguageCondition|null
     */
    public function getConditionMonitoringQueryLanguage()
    {
        return $this->readOneof(19);
    }

    public function hasConditionMonitoringQueryLanguage()
    {
        return $this->hasOneof(19);
    }

    /**
     * A condition that uses the Monitoring Query Language to define
     * alerts.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.MonitoringQueryLanguageCondition condition_monitoring_query_language = 19;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MonitoringQueryLanguageCondition $var
     * @return $this
     */
    public function setConditionMonitoringQueryLanguage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\MonitoringQueryLanguageCondition::class);
        $this->writeOneof(19, $var);

        return $this;
    }

    /**
     * A condition that uses the Prometheus query language to define alerts.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\PrometheusQueryLanguageCondition|null
     */
    public function getConditionPrometheusQueryLanguage()
    {
        return $this->readOneof(21);
    }

    public function hasConditionPrometheusQueryLanguage()
    {
        return $this->hasOneof(21);
    }

    /**
     * A condition that uses the Prometheus query language to define alerts.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.PrometheusQueryLanguageCondition condition_prometheus_query_language = 21;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\PrometheusQueryLanguageCondition $var
     * @return $this
     */
    public function setConditionPrometheusQueryLanguage($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\PrometheusQueryLanguageCondition::class);
        $this->writeOneof(21, $var);

        return $this;
    }

    /**
     * A condition that periodically evaluates a SQL query result.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     * @return \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition|null
     */
    public function getConditionSql()
    {
        return $this->readOneof(22);
    }

    public function hasConditionSql()
    {
        return $this->hasOneof(22);
    }

    /**
     * A condition that periodically evaluates a SQL query result.
     *
     * Generated from protobuf field <code>.google.monitoring.v3.AlertPolicy.Condition.SqlCondition condition_sql = 22;</code>
     * @param \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition $var
     * @return $this
     */
    public function setConditionSql($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Monitoring\V3\AlertPolicy\Condition\SqlCondition::class);
        $this->writeOneof(22, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getCondition()
    {
        return $this->whichOneof("condition");
    }

}


