<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/gkemulticloud/v1/aws_resources.proto

namespace Google\Cloud\GkeMultiCloud\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * ClusterNetworking defines cluster-wide networking configuration.
 * Anthos clusters on AWS run on a single VPC. This includes control
 * plane replicas and node pool nodes.
 *
 * Generated from protobuf message <code>google.cloud.gkemulticloud.v1.AwsClusterNetworking</code>
 */
class AwsClusterNetworking extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The VPC associated with the cluster. All component clusters
     * (i.e. control plane and node pools) run on a single VPC.
     * This field cannot be changed after creation.
     *
     * Generated from protobuf field <code>string vpc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $vpc_id = '';
    /**
     * Required. All pods in the cluster are assigned an IPv4 address from these
     * ranges. Only a single range is supported. This field cannot be changed
     * after creation.
     *
     * Generated from protobuf field <code>repeated string pod_address_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $pod_address_cidr_blocks;
    /**
     * Required. All services in the cluster are assigned an IPv4 address from
     * these ranges. Only a single range is supported. This field cannot be
     * changed after creation.
     *
     * Generated from protobuf field <code>repeated string service_address_cidr_blocks = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $service_address_cidr_blocks;
    /**
     * Optional. Disable the per node pool subnet security group rules on the
     * control plane security group. When set to true, you must also provide one
     * or more security groups that ensure node pools are able to send requests to
     * the control plane on TCP/443 and TCP/8132. Failure to do so may result in
     * unavailable node pools.
     *
     * Generated from protobuf field <code>bool per_node_pool_sg_rules_disabled = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $per_node_pool_sg_rules_disabled = false;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $vpc_id
     *           Required. The VPC associated with the cluster. All component clusters
     *           (i.e. control plane and node pools) run on a single VPC.
     *           This field cannot be changed after creation.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $pod_address_cidr_blocks
     *           Required. All pods in the cluster are assigned an IPv4 address from these
     *           ranges. Only a single range is supported. This field cannot be changed
     *           after creation.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $service_address_cidr_blocks
     *           Required. All services in the cluster are assigned an IPv4 address from
     *           these ranges. Only a single range is supported. This field cannot be
     *           changed after creation.
     *     @type bool $per_node_pool_sg_rules_disabled
     *           Optional. Disable the per node pool subnet security group rules on the
     *           control plane security group. When set to true, you must also provide one
     *           or more security groups that ensure node pools are able to send requests to
     *           the control plane on TCP/443 and TCP/8132. Failure to do so may result in
     *           unavailable node pools.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Gkemulticloud\V1\AwsResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The VPC associated with the cluster. All component clusters
     * (i.e. control plane and node pools) run on a single VPC.
     * This field cannot be changed after creation.
     *
     * Generated from protobuf field <code>string vpc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVpcId()
    {
        return $this->vpc_id;
    }

    /**
     * Required. The VPC associated with the cluster. All component clusters
     * (i.e. control plane and node pools) run on a single VPC.
     * This field cannot be changed after creation.
     *
     * Generated from protobuf field <code>string vpc_id = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVpcId($var)
    {
        GPBUtil::checkString($var, True);
        $this->vpc_id = $var;

        return $this;
    }

    /**
     * Required. All pods in the cluster are assigned an IPv4 address from these
     * ranges. Only a single range is supported. This field cannot be changed
     * after creation.
     *
     * Generated from protobuf field <code>repeated string pod_address_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPodAddressCidrBlocks()
    {
        return $this->pod_address_cidr_blocks;
    }

    /**
     * Required. All pods in the cluster are assigned an IPv4 address from these
     * ranges. Only a single range is supported. This field cannot be changed
     * after creation.
     *
     * Generated from protobuf field <code>repeated string pod_address_cidr_blocks = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPodAddressCidrBlocks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->pod_address_cidr_blocks = $arr;

        return $this;
    }

    /**
     * Required. All services in the cluster are assigned an IPv4 address from
     * these ranges. Only a single range is supported. This field cannot be
     * changed after creation.
     *
     * Generated from protobuf field <code>repeated string service_address_cidr_blocks = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getServiceAddressCidrBlocks()
    {
        return $this->service_address_cidr_blocks;
    }

    /**
     * Required. All services in the cluster are assigned an IPv4 address from
     * these ranges. Only a single range is supported. This field cannot be
     * changed after creation.
     *
     * Generated from protobuf field <code>repeated string service_address_cidr_blocks = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setServiceAddressCidrBlocks($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->service_address_cidr_blocks = $arr;

        return $this;
    }

    /**
     * Optional. Disable the per node pool subnet security group rules on the
     * control plane security group. When set to true, you must also provide one
     * or more security groups that ensure node pools are able to send requests to
     * the control plane on TCP/443 and TCP/8132. Failure to do so may result in
     * unavailable node pools.
     *
     * Generated from protobuf field <code>bool per_node_pool_sg_rules_disabled = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getPerNodePoolSgRulesDisabled()
    {
        return $this->per_node_pool_sg_rules_disabled;
    }

    /**
     * Optional. Disable the per node pool subnet security group rules on the
     * control plane security group. When set to true, you must also provide one
     * or more security groups that ensure node pools are able to send requests to
     * the control plane on TCP/443 and TCP/8132. Failure to do so may result in
     * unavailable node pools.
     *
     * Generated from protobuf field <code>bool per_node_pool_sg_rules_disabled = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setPerNodePoolSgRulesDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->per_node_pool_sg_rules_disabled = $var;

        return $this;
    }

}

