<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/bigquery/datatransfer/v1/transfer.proto

namespace Google\Cloud\BigQuery\DataTransfer\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * V2 options customizing different types of data transfer schedule.
 * This field supports existing time-based and manual transfer schedule. Also
 * supports Event-Driven transfer schedule. ScheduleOptionsV2 cannot be used
 * together with ScheduleOptions/Schedule.
 *
 * Generated from protobuf message <code>google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2</code>
 */
class ScheduleOptionsV2 extends \Google\Protobuf\Internal\Message
{
    protected $schedule;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\TimeBasedSchedule $time_based_schedule
     *           Time based transfer schedule options. This is the default schedule
     *           option.
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\ManualSchedule $manual_schedule
     *           Manual transfer schedule. If set, the transfer run will not be
     *           auto-scheduled by the system, unless the client invokes
     *           StartManualTransferRuns.  This is equivalent to
     *           disable_auto_scheduling = true.
     *     @type \Google\Cloud\BigQuery\DataTransfer\V1\EventDrivenSchedule $event_driven_schedule
     *           Event driven transfer schedule options. If set, the transfer will be
     *           scheduled upon events arrial.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Bigquery\Datatransfer\V1\Transfer::initOnce();
        parent::__construct($data);
    }

    /**
     * Time based transfer schedule options. This is the default schedule
     * option.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;</code>
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\TimeBasedSchedule|null
     */
    public function getTimeBasedSchedule()
    {
        return $this->readOneof(1);
    }

    public function hasTimeBasedSchedule()
    {
        return $this->hasOneof(1);
    }

    /**
     * Time based transfer schedule options. This is the default schedule
     * option.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\TimeBasedSchedule $var
     * @return $this
     */
    public function setTimeBasedSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\DataTransfer\V1\TimeBasedSchedule::class);
        $this->writeOneof(1, $var);

        return $this;
    }

    /**
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\ManualSchedule|null
     */
    public function getManualSchedule()
    {
        return $this->readOneof(2);
    }

    public function hasManualSchedule()
    {
        return $this->hasOneof(2);
    }

    /**
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\ManualSchedule $var
     * @return $this
     */
    public function setManualSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\DataTransfer\V1\ManualSchedule::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;</code>
     * @return \Google\Cloud\BigQuery\DataTransfer\V1\EventDrivenSchedule|null
     */
    public function getEventDrivenSchedule()
    {
        return $this->readOneof(3);
    }

    public function hasEventDrivenSchedule()
    {
        return $this->hasOneof(3);
    }

    /**
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     *
     * Generated from protobuf field <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;</code>
     * @param \Google\Cloud\BigQuery\DataTransfer\V1\EventDrivenSchedule $var
     * @return $this
     */
    public function setEventDrivenSchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\BigQuery\DataTransfer\V1\EventDrivenSchedule::class);
        $this->writeOneof(3, $var);

        return $this;
    }

    /**
     * @return string
     */
    public function getSchedule()
    {
        return $this->whichOneof("schedule");
    }

}

