<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/alloydb/v1/resources.proto

namespace Google\Cloud\AlloyDb\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Message describing the user-specified automated backup policy.
 * All fields in the automated backup policy are optional. Defaults for each
 * field are provided if they are not set.
 *
 * Generated from protobuf message <code>google.cloud.alloydb.v1.AutomatedBackupPolicy</code>
 */
class AutomatedBackupPolicy extends \Google\Protobuf\Internal\Message
{
    /**
     * Whether automated automated backups are enabled. If not set, defaults to
     * true.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     */
    protected $enabled = null;
    /**
     * The length of the time window during which a backup can be
     * taken. If a backup does not succeed within this time window, it will be
     * canceled and considered failed.
     * The backup window must be at least 5 minutes long. There is no upper bound
     * on the window. If not set, it defaults to 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration backup_window = 3;</code>
     */
    protected $backup_window = null;
    /**
     * Optional. The encryption config can be specified to encrypt the
     * backups with a customer-managed encryption key (CMEK). When this field is
     * not specified, the backup will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $encryption_config = null;
    /**
     * The location where the backup will be stored. Currently, the only supported
     * option is to store the backup in the same region as the cluster.
     * If empty, defaults to the region of the cluster.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     */
    protected $location = '';
    /**
     * Labels to apply to backups created using this configuration.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     */
    private $labels;
    protected $schedule;
    protected $retention;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\WeeklySchedule $weekly_schedule
     *           Weekly schedule for the Backup.
     *     @type \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\TimeBasedRetention $time_based_retention
     *           Time-based Backup retention policy.
     *     @type \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\QuantityBasedRetention $quantity_based_retention
     *           Quantity-based Backup retention policy to retain recent backups.
     *     @type bool $enabled
     *           Whether automated automated backups are enabled. If not set, defaults to
     *           true.
     *     @type \Google\Protobuf\Duration $backup_window
     *           The length of the time window during which a backup can be
     *           taken. If a backup does not succeed within this time window, it will be
     *           canceled and considered failed.
     *           The backup window must be at least 5 minutes long. There is no upper bound
     *           on the window. If not set, it defaults to 1 hour.
     *     @type \Google\Cloud\AlloyDb\V1\EncryptionConfig $encryption_config
     *           Optional. The encryption config can be specified to encrypt the
     *           backups with a customer-managed encryption key (CMEK). When this field is
     *           not specified, the backup will then use default encryption scheme to
     *           protect the user data.
     *     @type string $location
     *           The location where the backup will be stored. Currently, the only supported
     *           option is to store the backup in the same region as the cluster.
     *           If empty, defaults to the region of the cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels to apply to backups created using this configuration.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Alloydb\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Weekly schedule for the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.WeeklySchedule weekly_schedule = 2;</code>
     * @return \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\WeeklySchedule|null
     */
    public function getWeeklySchedule()
    {
        return $this->readOneof(2);
    }

    public function hasWeeklySchedule()
    {
        return $this->hasOneof(2);
    }

    /**
     * Weekly schedule for the Backup.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.WeeklySchedule weekly_schedule = 2;</code>
     * @param \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\WeeklySchedule $var
     * @return $this
     */
    public function setWeeklySchedule($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\WeeklySchedule::class);
        $this->writeOneof(2, $var);

        return $this;
    }

    /**
     * Time-based Backup retention policy.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.TimeBasedRetention time_based_retention = 4;</code>
     * @return \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\TimeBasedRetention|null
     */
    public function getTimeBasedRetention()
    {
        return $this->readOneof(4);
    }

    public function hasTimeBasedRetention()
    {
        return $this->hasOneof(4);
    }

    /**
     * Time-based Backup retention policy.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.TimeBasedRetention time_based_retention = 4;</code>
     * @param \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\TimeBasedRetention $var
     * @return $this
     */
    public function setTimeBasedRetention($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\TimeBasedRetention::class);
        $this->writeOneof(4, $var);

        return $this;
    }

    /**
     * Quantity-based Backup retention policy to retain recent backups.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.QuantityBasedRetention quantity_based_retention = 5;</code>
     * @return \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\QuantityBasedRetention|null
     */
    public function getQuantityBasedRetention()
    {
        return $this->readOneof(5);
    }

    public function hasQuantityBasedRetention()
    {
        return $this->hasOneof(5);
    }

    /**
     * Quantity-based Backup retention policy to retain recent backups.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.AutomatedBackupPolicy.QuantityBasedRetention quantity_based_retention = 5;</code>
     * @param \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\QuantityBasedRetention $var
     * @return $this
     */
    public function setQuantityBasedRetention($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\AutomatedBackupPolicy\QuantityBasedRetention::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Whether automated automated backups are enabled. If not set, defaults to
     * true.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     * @return bool
     */
    public function getEnabled()
    {
        return isset($this->enabled) ? $this->enabled : false;
    }

    public function hasEnabled()
    {
        return isset($this->enabled);
    }

    public function clearEnabled()
    {
        unset($this->enabled);
    }

    /**
     * Whether automated automated backups are enabled. If not set, defaults to
     * true.
     *
     * Generated from protobuf field <code>optional bool enabled = 1;</code>
     * @param bool $var
     * @return $this
     */
    public function setEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->enabled = $var;

        return $this;
    }

    /**
     * The length of the time window during which a backup can be
     * taken. If a backup does not succeed within this time window, it will be
     * canceled and considered failed.
     * The backup window must be at least 5 minutes long. There is no upper bound
     * on the window. If not set, it defaults to 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration backup_window = 3;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getBackupWindow()
    {
        return $this->backup_window;
    }

    public function hasBackupWindow()
    {
        return isset($this->backup_window);
    }

    public function clearBackupWindow()
    {
        unset($this->backup_window);
    }

    /**
     * The length of the time window during which a backup can be
     * taken. If a backup does not succeed within this time window, it will be
     * canceled and considered failed.
     * The backup window must be at least 5 minutes long. There is no upper bound
     * on the window. If not set, it defaults to 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration backup_window = 3;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setBackupWindow($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->backup_window = $var;

        return $this;
    }

    /**
     * Optional. The encryption config can be specified to encrypt the
     * backups with a customer-managed encryption key (CMEK). When this field is
     * not specified, the backup will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\AlloyDb\V1\EncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return $this->encryption_config;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. The encryption config can be specified to encrypt the
     * backups with a customer-managed encryption key (CMEK). When this field is
     * not specified, the backup will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.alloydb.v1.EncryptionConfig encryption_config = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\AlloyDb\V1\EncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\AlloyDb\V1\EncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

    /**
     * The location where the backup will be stored. Currently, the only supported
     * option is to store the backup in the same region as the cluster.
     * If empty, defaults to the region of the cluster.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @return string
     */
    public function getLocation()
    {
        return $this->location;
    }

    /**
     * The location where the backup will be stored. Currently, the only supported
     * option is to store the backup in the same region as the cluster.
     * If empty, defaults to the region of the cluster.
     *
     * Generated from protobuf field <code>string location = 6;</code>
     * @param string $var
     * @return $this
     */
    public function setLocation($var)
    {
        GPBUtil::checkString($var, True);
        $this->location = $var;

        return $this;
    }

    /**
     * Labels to apply to backups created using this configuration.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels to apply to backups created using this configuration.
     *
     * Generated from protobuf field <code>map<string, string> labels = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * @return string
     */
    public function getSchedule()
    {
        return $this->whichOneof("schedule");
    }

    /**
     * @return string
     */
    public function getRetention()
    {
        return $this->whichOneof("retention");
    }

}

