<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/asset/v1/assets.proto

namespace Google\Cloud\Asset\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Cloud asset. This includes all Google Cloud Platform resources,
 * Cloud IAM policies, and other non-GCP assets.
 *
 * Generated from protobuf message <code>google.cloud.asset.v1.Asset</code>
 */
class Asset extends \Google\Protobuf\Internal\Message
{
    /**
     * The full name of the asset. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    private $name = '';
    /**
     * Type of the asset. Example: "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     */
    private $asset_type = '';
    /**
     * Representation of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.Resource resource = 3;</code>
     */
    private $resource = null;
    /**
     * Representation of the actual Cloud IAM policy set on a cloud resource. For
     * each resource, there must be at most one Cloud IAM policy set on it.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy iam_policy = 4;</code>
     */
    private $iam_policy = null;
    /**
     * Asset's ancestry path in Cloud Resource Manager (CRM) hierarchy,
     * represented as a list of relative resource names. Ancestry path starts with
     * the closest CRM ancestor and ends at root. If the asset is a CRM
     * project/folder/organization, this starts from the asset itself.
     * Example: ["projects/123456789", "folders/5432", "organizations/1234"]
     *
     * Generated from protobuf field <code>repeated string ancestors = 10;</code>
     */
    private $ancestors;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The full name of the asset. For example:
     *           `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     *           See [Resource
     *           Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     *           for more information.
     *     @type string $asset_type
     *           Type of the asset. Example: "compute.googleapis.com/Disk".
     *     @type \Google\Cloud\Asset\V1\Resource $resource
     *           Representation of the resource.
     *     @type \Google\Cloud\Iam\V1\Policy $iam_policy
     *           Representation of the actual Cloud IAM policy set on a cloud resource. For
     *           each resource, there must be at most one Cloud IAM policy set on it.
     *     @type string[]|\Google\Protobuf\Internal\RepeatedField $ancestors
     *           Asset's ancestry path in Cloud Resource Manager (CRM) hierarchy,
     *           represented as a list of relative resource names. Ancestry path starts with
     *           the closest CRM ancestor and ends at root. If the asset is a CRM
     *           project/folder/organization, this starts from the asset itself.
     *           Example: ["projects/123456789", "folders/5432", "organizations/1234"]
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Asset\V1\Assets::initOnce();
        parent::__construct($data);
    }

    /**
     * The full name of the asset. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The full name of the asset. For example:
     * `//compute.googleapis.com/projects/my_project_123/zones/zone1/instances/instance1`.
     * See [Resource
     * Names](https://cloud.google.com/apis/design/resource_names#full_resource_name)
     * for more information.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Type of the asset. Example: "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     * @return string
     */
    public function getAssetType()
    {
        return $this->asset_type;
    }

    /**
     * Type of the asset. Example: "compute.googleapis.com/Disk".
     *
     * Generated from protobuf field <code>string asset_type = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAssetType($var)
    {
        GPBUtil::checkString($var, True);
        $this->asset_type = $var;

        return $this;
    }

    /**
     * Representation of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.Resource resource = 3;</code>
     * @return \Google\Cloud\Asset\V1\Resource
     */
    public function getResource()
    {
        return $this->resource;
    }

    /**
     * Representation of the resource.
     *
     * Generated from protobuf field <code>.google.cloud.asset.v1.Resource resource = 3;</code>
     * @param \Google\Cloud\Asset\V1\Resource $var
     * @return $this
     */
    public function setResource($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Asset\V1\Resource::class);
        $this->resource = $var;

        return $this;
    }

    /**
     * Representation of the actual Cloud IAM policy set on a cloud resource. For
     * each resource, there must be at most one Cloud IAM policy set on it.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy iam_policy = 4;</code>
     * @return \Google\Cloud\Iam\V1\Policy
     */
    public function getIamPolicy()
    {
        return $this->iam_policy;
    }

    /**
     * Representation of the actual Cloud IAM policy set on a cloud resource. For
     * each resource, there must be at most one Cloud IAM policy set on it.
     *
     * Generated from protobuf field <code>.google.iam.v1.Policy iam_policy = 4;</code>
     * @param \Google\Cloud\Iam\V1\Policy $var
     * @return $this
     */
    public function setIamPolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iam\V1\Policy::class);
        $this->iam_policy = $var;

        return $this;
    }

    /**
     * Asset's ancestry path in Cloud Resource Manager (CRM) hierarchy,
     * represented as a list of relative resource names. Ancestry path starts with
     * the closest CRM ancestor and ends at root. If the asset is a CRM
     * project/folder/organization, this starts from the asset itself.
     * Example: ["projects/123456789", "folders/5432", "organizations/1234"]
     *
     * Generated from protobuf field <code>repeated string ancestors = 10;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAncestors()
    {
        return $this->ancestors;
    }

    /**
     * Asset's ancestry path in Cloud Resource Manager (CRM) hierarchy,
     * represented as a list of relative resource names. Ancestry path starts with
     * the closest CRM ancestor and ends at root. If the asset is a CRM
     * project/folder/organization, this starts from the asset itself.
     * Example: ["projects/123456789", "folders/5432", "organizations/1234"]
     *
     * Generated from protobuf field <code>repeated string ancestors = 10;</code>
     * @param string[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAncestors($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->ancestors = $arr;

        return $this;
    }

}

