<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/managedkafka/v1/resources.proto

namespace Google\Cloud\ManagedKafka\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The configuration of a Virtual Private Cloud (VPC) network that can access
 * the Kafka Connect cluster.
 *
 * Generated from protobuf message <code>google.cloud.managedkafka.v1.ConnectNetworkConfig</code>
 */
class ConnectNetworkConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. VPC subnet to make available to the Kafka Connect cluster.
     * Structured like:
     * projects/{project}/regions/{region}/subnetworks/{subnet_id}
     * It is used to create a Private Service Connect (PSC) interface for the
     * Kafka Connect workers. It must be located in the same region as the
     * Kafka Connect cluster.
     * The CIDR range of the subnet must be within the IPv4 address ranges for
     * private networks, as specified in RFC 1918. The primary subnet CIDR range
     * must have a minimum size of /22 (1024 addresses).
     *
     * Generated from protobuf field <code>string primary_subnet = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $primary_subnet = '';
    /**
     * Optional. Additional subnets may be specified. They may be in another
     * region, but must be in the same VPC network. The Connect workers can
     * communicate with network endpoints in either the primary or additional
     * subnets.
     *
     * Generated from protobuf field <code>repeated string additional_subnets = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $additional_subnets;
    /**
     * Optional. Additional DNS domain names from the subnet's network to be made
     * visible to the Connect Cluster. When using MirrorMaker2, it's necessary to
     * add the bootstrap address's dns domain name of the target cluster to make
     * it visible to the connector. For example:
     * my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
     *
     * Generated from protobuf field <code>repeated string dns_domain_names = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $dns_domain_names;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $primary_subnet
     *           Required. VPC subnet to make available to the Kafka Connect cluster.
     *           Structured like:
     *           projects/{project}/regions/{region}/subnetworks/{subnet_id}
     *           It is used to create a Private Service Connect (PSC) interface for the
     *           Kafka Connect workers. It must be located in the same region as the
     *           Kafka Connect cluster.
     *           The CIDR range of the subnet must be within the IPv4 address ranges for
     *           private networks, as specified in RFC 1918. The primary subnet CIDR range
     *           must have a minimum size of /22 (1024 addresses).
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $additional_subnets
     *           Optional. Additional subnets may be specified. They may be in another
     *           region, but must be in the same VPC network. The Connect workers can
     *           communicate with network endpoints in either the primary or additional
     *           subnets.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $dns_domain_names
     *           Optional. Additional DNS domain names from the subnet's network to be made
     *           visible to the Connect Cluster. When using MirrorMaker2, it's necessary to
     *           add the bootstrap address's dns domain name of the target cluster to make
     *           it visible to the connector. For example:
     *           my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Managedkafka\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. VPC subnet to make available to the Kafka Connect cluster.
     * Structured like:
     * projects/{project}/regions/{region}/subnetworks/{subnet_id}
     * It is used to create a Private Service Connect (PSC) interface for the
     * Kafka Connect workers. It must be located in the same region as the
     * Kafka Connect cluster.
     * The CIDR range of the subnet must be within the IPv4 address ranges for
     * private networks, as specified in RFC 1918. The primary subnet CIDR range
     * must have a minimum size of /22 (1024 addresses).
     *
     * Generated from protobuf field <code>string primary_subnet = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getPrimarySubnet()
    {
        return $this->primary_subnet;
    }

    /**
     * Required. VPC subnet to make available to the Kafka Connect cluster.
     * Structured like:
     * projects/{project}/regions/{region}/subnetworks/{subnet_id}
     * It is used to create a Private Service Connect (PSC) interface for the
     * Kafka Connect workers. It must be located in the same region as the
     * Kafka Connect cluster.
     * The CIDR range of the subnet must be within the IPv4 address ranges for
     * private networks, as specified in RFC 1918. The primary subnet CIDR range
     * must have a minimum size of /22 (1024 addresses).
     *
     * Generated from protobuf field <code>string primary_subnet = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setPrimarySubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->primary_subnet = $var;

        return $this;
    }

    /**
     * Optional. Additional subnets may be specified. They may be in another
     * region, but must be in the same VPC network. The Connect workers can
     * communicate with network endpoints in either the primary or additional
     * subnets.
     *
     * Generated from protobuf field <code>repeated string additional_subnets = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getAdditionalSubnets()
    {
        return $this->additional_subnets;
    }

    /**
     * Optional. Additional subnets may be specified. They may be in another
     * region, but must be in the same VPC network. The Connect workers can
     * communicate with network endpoints in either the primary or additional
     * subnets.
     *
     * Generated from protobuf field <code>repeated string additional_subnets = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setAdditionalSubnets($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->additional_subnets = $arr;

        return $this;
    }

    /**
     * Optional. Additional DNS domain names from the subnet's network to be made
     * visible to the Connect Cluster. When using MirrorMaker2, it's necessary to
     * add the bootstrap address's dns domain name of the target cluster to make
     * it visible to the connector. For example:
     * my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
     *
     * Generated from protobuf field <code>repeated string dns_domain_names = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getDnsDomainNames()
    {
        return $this->dns_domain_names;
    }

    /**
     * Optional. Additional DNS domain names from the subnet's network to be made
     * visible to the Connect Cluster. When using MirrorMaker2, it's necessary to
     * add the bootstrap address's dns domain name of the target cluster to make
     * it visible to the connector. For example:
     * my-kafka-cluster.us-central1.managedkafka.my-project.cloud.goog
     *
     * Generated from protobuf field <code>repeated string dns_domain_names = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setDnsDomainNames($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->dns_domain_names = $arr;

        return $this;
    }

}

