<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/essentialcontacts/v1/service.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\EssentialContacts\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\PagedListResponse;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\EssentialContacts\V1\ComputeContactsRequest;
use Google\Cloud\EssentialContacts\V1\Contact;
use Google\Cloud\EssentialContacts\V1\CreateContactRequest;
use Google\Cloud\EssentialContacts\V1\DeleteContactRequest;
use Google\Cloud\EssentialContacts\V1\GetContactRequest;
use Google\Cloud\EssentialContacts\V1\ListContactsRequest;
use Google\Cloud\EssentialContacts\V1\SendTestMessageRequest;
use Google\Cloud\EssentialContacts\V1\UpdateContactRequest;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description: Manages contacts for important Google Cloud notifications.
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<PagedListResponse> computeContactsAsync(ComputeContactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Contact> createContactAsync(CreateContactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> deleteContactAsync(DeleteContactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Contact> getContactAsync(GetContactRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<PagedListResponse> listContactsAsync(ListContactsRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<void> sendTestMessageAsync(SendTestMessageRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Contact> updateContactAsync(UpdateContactRequest $request, array $optionalArgs = [])
 */
final class EssentialContactsServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.essentialcontacts.v1.EssentialContactsService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'essentialcontacts.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'essentialcontacts.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = ['https://www.googleapis.com/auth/cloud-platform'];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/essential_contacts_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/essential_contacts_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/essential_contacts_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' =>
                        __DIR__ . '/../resources/essential_contacts_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a contact
     * resource.
     *
     * @param string $project
     * @param string $contact
     *
     * @return string The formatted contact resource.
     */
    public static function contactName(string $project, string $contact): string
    {
        return self::getPathTemplate('contact')->render([
            'project' => $project,
            'contact' => $contact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a folder
     * resource.
     *
     * @param string $folder
     *
     * @return string The formatted folder resource.
     */
    public static function folderName(string $folder): string
    {
        return self::getPathTemplate('folder')->render([
            'folder' => $folder,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * folder_contact resource.
     *
     * @param string $folder
     * @param string $contact
     *
     * @return string The formatted folder_contact resource.
     */
    public static function folderContactName(string $folder, string $contact): string
    {
        return self::getPathTemplate('folderContact')->render([
            'folder' => $folder,
            'contact' => $contact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a organization
     * resource.
     *
     * @param string $organization
     *
     * @return string The formatted organization resource.
     */
    public static function organizationName(string $organization): string
    {
        return self::getPathTemplate('organization')->render([
            'organization' => $organization,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * organization_contact resource.
     *
     * @param string $organization
     * @param string $contact
     *
     * @return string The formatted organization_contact resource.
     */
    public static function organizationContactName(string $organization, string $contact): string
    {
        return self::getPathTemplate('organizationContact')->render([
            'organization' => $organization,
            'contact' => $contact,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a project
     * resource.
     *
     * @param string $project
     *
     * @return string The formatted project resource.
     */
    public static function projectName(string $project): string
    {
        return self::getPathTemplate('project')->render([
            'project' => $project,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a
     * project_contact resource.
     *
     * @param string $project
     * @param string $contact
     *
     * @return string The formatted project_contact resource.
     */
    public static function projectContactName(string $project, string $contact): string
    {
        return self::getPathTemplate('projectContact')->render([
            'project' => $project,
            'contact' => $contact,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - contact: projects/{project}/contacts/{contact}
     * - folder: folders/{folder}
     * - folderContact: folders/{folder}/contacts/{contact}
     * - organization: organizations/{organization}
     * - organizationContact: organizations/{organization}/contacts/{contact}
     * - project: projects/{project}
     * - projectContact: projects/{project}/contacts/{contact}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'essentialcontacts.googleapis.com:443'.
     *     @type string|array|FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           The credentials to be used by the client to authorize API calls. This option
     *           accepts either a path to a credentials file, or a decoded credentials file as a
     *           PHP array.
     *           *Advanced usage*: In addition, this option can also accept a pre-constructed
     *           {@see \Google\Auth\FetchAuthTokenInterface} object or
     *           {@see \Google\ApiCore\CredentialsWrapper} object. Note that when one of these
     *           objects are provided, any settings in $credentialsConfig will be ignored.
     *           *Important*: If you accept a credential configuration (credential
     *           JSON/File/Stream) from an external source for authentication to Google Cloud
     *           Platform, you must validate it before providing it to any Google API or library.
     *           Providing an unvalidated credential configuration to Google APIs can compromise
     *           the security of your systems and data. For more information {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Lists all contacts for the resource that are subscribed to the
     * specified notification categories, including contacts inherited from
     * any parent resources.
     *
     * The async variant is
     * {@see EssentialContactsServiceClient::computeContactsAsync()} .
     *
     * @example samples/V1/EssentialContactsServiceClient/compute_contacts.php
     *
     * @param ComputeContactsRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function computeContacts(ComputeContactsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ComputeContacts', $request, $callOptions);
    }

    /**
     * Adds a new contact for a resource.
     *
     * The async variant is {@see EssentialContactsServiceClient::createContactAsync()}
     * .
     *
     * @example samples/V1/EssentialContactsServiceClient/create_contact.php
     *
     * @param CreateContactRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Contact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createContact(CreateContactRequest $request, array $callOptions = []): Contact
    {
        return $this->startApiCall('CreateContact', $request, $callOptions)->wait();
    }

    /**
     * Deletes a contact.
     *
     * The async variant is {@see EssentialContactsServiceClient::deleteContactAsync()}
     * .
     *
     * @example samples/V1/EssentialContactsServiceClient/delete_contact.php
     *
     * @param DeleteContactRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function deleteContact(DeleteContactRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('DeleteContact', $request, $callOptions)->wait();
    }

    /**
     * Gets a single contact.
     *
     * The async variant is {@see EssentialContactsServiceClient::getContactAsync()} .
     *
     * @example samples/V1/EssentialContactsServiceClient/get_contact.php
     *
     * @param GetContactRequest $request     A request to house fields associated with the call.
     * @param array             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Contact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getContact(GetContactRequest $request, array $callOptions = []): Contact
    {
        return $this->startApiCall('GetContact', $request, $callOptions)->wait();
    }

    /**
     * Lists the contacts that have been set on a resource.
     *
     * The async variant is {@see EssentialContactsServiceClient::listContactsAsync()}
     * .
     *
     * @example samples/V1/EssentialContactsServiceClient/list_contacts.php
     *
     * @param ListContactsRequest $request     A request to house fields associated with the call.
     * @param array               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return PagedListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listContacts(ListContactsRequest $request, array $callOptions = []): PagedListResponse
    {
        return $this->startApiCall('ListContacts', $request, $callOptions);
    }

    /**
     * Allows a contact admin to send a test message to contact to verify that it
     * has been configured correctly.
     *
     * The async variant is
     * {@see EssentialContactsServiceClient::sendTestMessageAsync()} .
     *
     * @example samples/V1/EssentialContactsServiceClient/send_test_message.php
     *
     * @param SendTestMessageRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function sendTestMessage(SendTestMessageRequest $request, array $callOptions = []): void
    {
        $this->startApiCall('SendTestMessage', $request, $callOptions)->wait();
    }

    /**
     * Updates a contact.
     * Note: A contact's email address cannot be changed.
     *
     * The async variant is {@see EssentialContactsServiceClient::updateContactAsync()}
     * .
     *
     * @example samples/V1/EssentialContactsServiceClient/update_contact.php
     *
     * @param UpdateContactRequest $request     A request to house fields associated with the call.
     * @param array                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Contact
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function updateContact(UpdateContactRequest $request, array $callOptions = []): Contact
    {
        return $this->startApiCall('UpdateContact', $request, $callOptions)->wait();
    }
}
