<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/audio_config.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration of the barge-in behavior. Barge-in instructs the API to return
 * a detected utterance at a proper time while the client is playing back the
 * response audio from a previous request. When the client sees the
 * utterance, it should stop the playback and immediately get ready for
 * receiving the responses for the current request.
 * The barge-in handling requires the client to start streaming audio input
 * as soon as it starts playing back the audio from the previous response. The
 * playback is modeled into two phases:
 * * No barge-in phase: which goes first and during which speech detection
 *   should not be carried out.
 * * Barge-in phase: which follows the no barge-in phase and during which
 *   the API starts speech detection and may inform the client that an utterance
 *   has been detected. Note that no-speech event is not expected in this
 *   phase.
 * The client provides this configuration in terms of the durations of those
 * two phases. The durations are measured in terms of the audio length from the
 * the start of the input audio.
 * No-speech event is a response with END_OF_UTTERANCE without any transcript
 * following up.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.BargeInConfig</code>
 */
class BargeInConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     */
    protected $no_barge_in_duration = null;
    /**
     * Total duration for the playback at the beginning of the input audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_duration = 2;</code>
     */
    protected $total_duration = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Protobuf\Duration $no_barge_in_duration
     *           Duration that is not eligible for barge-in at the beginning of the input
     *           audio.
     *     @type \Google\Protobuf\Duration $total_duration
     *           Total duration for the playback at the beginning of the input audio.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\AudioConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getNoBargeInDuration()
    {
        return $this->no_barge_in_duration;
    }

    public function hasNoBargeInDuration()
    {
        return isset($this->no_barge_in_duration);
    }

    public function clearNoBargeInDuration()
    {
        unset($this->no_barge_in_duration);
    }

    /**
     * Duration that is not eligible for barge-in at the beginning of the input
     * audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration no_barge_in_duration = 1;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setNoBargeInDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->no_barge_in_duration = $var;

        return $this;
    }

    /**
     * Total duration for the playback at the beginning of the input audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_duration = 2;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getTotalDuration()
    {
        return $this->total_duration;
    }

    public function hasTotalDuration()
    {
        return isset($this->total_duration);
    }

    public function clearTotalDuration()
    {
        unset($this->total_duration);
    }

    /**
     * Total duration for the playback at the beginning of the input audio.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration total_duration = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setTotalDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->total_duration = $var;

        return $this;
    }

}

