<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/iot/v1/resources.proto

namespace Google\Cloud\Iot\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The device resource.
 *
 * Generated from protobuf message <code>google.cloud.iot.v1.Device</code>
 */
class Device extends \Google\Protobuf\Internal\Message
{
    /**
     * The user-defined device identifier. The device ID must be unique
     * within a device registry.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     */
    private $id = '';
    /**
     * The resource path name. For example,
     * `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
     * `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
     * When `name` is populated as a response from the service, it always ends
     * in the device numeric ID.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     */
    private $name = '';
    /**
     * [Output only] A server-defined unique numeric ID for the device. This is a
     * more compact way to identify devices, and it is globally unique.
     *
     * Generated from protobuf field <code>uint64 num_id = 3;</code>
     */
    private $num_id = 0;
    /**
     * The credentials used to authenticate this device. To allow credential
     * rotation without interruption, multiple device credentials can be bound to
     * this device. No more than 3 credentials can be bound to a single device at
     * a time. When new credentials are added to a device, they are verified
     * against the registry credentials. For details, see the description of the
     * `DeviceRegistry.credentials` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.iot.v1.DeviceCredential credentials = 12;</code>
     */
    private $credentials;
    /**
     * [Output only] The last time an MQTT `PINGREQ` was received. This field
     * applies only to devices connecting through MQTT. MQTT clients usually only
     * send `PINGREQ` messages if the connection is idle, and no other messages
     * have been sent. Timestamps are periodically collected and written to
     * storage; they may be stale by a few minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_heartbeat_time = 7;</code>
     */
    private $last_heartbeat_time = null;
    /**
     * [Output only] The last time a telemetry event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_event_time = 8;</code>
     */
    private $last_event_time = null;
    /**
     * [Output only] The last time a state event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_state_time = 20;</code>
     */
    private $last_state_time = null;
    /**
     * [Output only] The last time a cloud-to-device config version acknowledgment
     * was received from the device. This field is only for configurations
     * sent through MQTT.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_ack_time = 14;</code>
     */
    private $last_config_ack_time = null;
    /**
     * [Output only] The last time a cloud-to-device config version was sent to
     * the device.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_send_time = 18;</code>
     */
    private $last_config_send_time = null;
    /**
     * If a device is blocked, connections or requests from this device will fail.
     * Can be used to temporarily prevent the device from connecting if, for
     * example, the sensor is generating bad data and needs maintenance.
     *
     * Generated from protobuf field <code>bool blocked = 19;</code>
     */
    private $blocked = false;
    /**
     * [Output only] The time the most recent error occurred, such as a failure to
     * publish to Cloud Pub/Sub. This field is the timestamp of
     * 'last_error_status'.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_error_time = 10;</code>
     */
    private $last_error_time = null;
    /**
     * [Output only] The error message of the most recent error, such as a failure
     * to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
     * field. If no errors have occurred, this field has an empty message
     * and the status code 0 == OK. Otherwise, this field is expected to have a
     * status code other than OK.
     *
     * Generated from protobuf field <code>.google.rpc.Status last_error_status = 11;</code>
     */
    private $last_error_status = null;
    /**
     * The most recent device configuration, which is eventually sent from
     * Cloud IoT Core to the device. If not present on creation, the
     * configuration will be initialized with an empty payload and version value
     * of `1`. To update this field after creation, use the
     * `DeviceManager.ModifyCloudToDeviceConfig` method.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceConfig config = 13;</code>
     */
    private $config = null;
    /**
     * [Output only] The state most recently received from the device. If no state
     * has been reported, this field is not present.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceState state = 16;</code>
     */
    private $state = null;
    /**
     * **Beta Feature**
     * The logging verbosity for device activity. If unspecified,
     * DeviceRegistry.log_level will be used.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.LogLevel log_level = 21;</code>
     */
    private $log_level = 0;
    /**
     * The metadata key-value pairs assigned to the device. This metadata is not
     * interpreted or indexed by Cloud IoT Core. It can be used to add contextual
     * information for the device.
     * Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
     * be less than 128 bytes in length.
     * Values are free-form strings. Each value must be less than or equal to 32
     * KB in size.
     * The total size of all keys and values must be less than 256 KB, and the
     * maximum number of key-value pairs is 500.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 17;</code>
     */
    private $metadata;
    /**
     * Gateway-related configuration and state.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.GatewayConfig gateway_config = 24;</code>
     */
    private $gateway_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $id
     *           The user-defined device identifier. The device ID must be unique
     *           within a device registry.
     *     @type string $name
     *           The resource path name. For example,
     *           `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
     *           `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
     *           When `name` is populated as a response from the service, it always ends
     *           in the device numeric ID.
     *     @type int|string $num_id
     *           [Output only] A server-defined unique numeric ID for the device. This is a
     *           more compact way to identify devices, and it is globally unique.
     *     @type \Google\Cloud\Iot\V1\DeviceCredential[]|\Google\Protobuf\Internal\RepeatedField $credentials
     *           The credentials used to authenticate this device. To allow credential
     *           rotation without interruption, multiple device credentials can be bound to
     *           this device. No more than 3 credentials can be bound to a single device at
     *           a time. When new credentials are added to a device, they are verified
     *           against the registry credentials. For details, see the description of the
     *           `DeviceRegistry.credentials` field.
     *     @type \Google\Protobuf\Timestamp $last_heartbeat_time
     *           [Output only] The last time an MQTT `PINGREQ` was received. This field
     *           applies only to devices connecting through MQTT. MQTT clients usually only
     *           send `PINGREQ` messages if the connection is idle, and no other messages
     *           have been sent. Timestamps are periodically collected and written to
     *           storage; they may be stale by a few minutes.
     *     @type \Google\Protobuf\Timestamp $last_event_time
     *           [Output only] The last time a telemetry event was received. Timestamps are
     *           periodically collected and written to storage; they may be stale by a few
     *           minutes.
     *     @type \Google\Protobuf\Timestamp $last_state_time
     *           [Output only] The last time a state event was received. Timestamps are
     *           periodically collected and written to storage; they may be stale by a few
     *           minutes.
     *     @type \Google\Protobuf\Timestamp $last_config_ack_time
     *           [Output only] The last time a cloud-to-device config version acknowledgment
     *           was received from the device. This field is only for configurations
     *           sent through MQTT.
     *     @type \Google\Protobuf\Timestamp $last_config_send_time
     *           [Output only] The last time a cloud-to-device config version was sent to
     *           the device.
     *     @type bool $blocked
     *           If a device is blocked, connections or requests from this device will fail.
     *           Can be used to temporarily prevent the device from connecting if, for
     *           example, the sensor is generating bad data and needs maintenance.
     *     @type \Google\Protobuf\Timestamp $last_error_time
     *           [Output only] The time the most recent error occurred, such as a failure to
     *           publish to Cloud Pub/Sub. This field is the timestamp of
     *           'last_error_status'.
     *     @type \Google\Rpc\Status $last_error_status
     *           [Output only] The error message of the most recent error, such as a failure
     *           to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
     *           field. If no errors have occurred, this field has an empty message
     *           and the status code 0 == OK. Otherwise, this field is expected to have a
     *           status code other than OK.
     *     @type \Google\Cloud\Iot\V1\DeviceConfig $config
     *           The most recent device configuration, which is eventually sent from
     *           Cloud IoT Core to the device. If not present on creation, the
     *           configuration will be initialized with an empty payload and version value
     *           of `1`. To update this field after creation, use the
     *           `DeviceManager.ModifyCloudToDeviceConfig` method.
     *     @type \Google\Cloud\Iot\V1\DeviceState $state
     *           [Output only] The state most recently received from the device. If no state
     *           has been reported, this field is not present.
     *     @type int $log_level
     *           **Beta Feature**
     *           The logging verbosity for device activity. If unspecified,
     *           DeviceRegistry.log_level will be used.
     *     @type array|\Google\Protobuf\Internal\MapField $metadata
     *           The metadata key-value pairs assigned to the device. This metadata is not
     *           interpreted or indexed by Cloud IoT Core. It can be used to add contextual
     *           information for the device.
     *           Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
     *           be less than 128 bytes in length.
     *           Values are free-form strings. Each value must be less than or equal to 32
     *           KB in size.
     *           The total size of all keys and values must be less than 256 KB, and the
     *           maximum number of key-value pairs is 500.
     *     @type \Google\Cloud\Iot\V1\GatewayConfig $gateway_config
     *           Gateway-related configuration and state.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Iot\V1\Resources::initOnce();
        parent::__construct($data);
    }

    /**
     * The user-defined device identifier. The device ID must be unique
     * within a device registry.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @return string
     */
    public function getId()
    {
        return $this->id;
    }

    /**
     * The user-defined device identifier. The device ID must be unique
     * within a device registry.
     *
     * Generated from protobuf field <code>string id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setId($var)
    {
        GPBUtil::checkString($var, True);
        $this->id = $var;

        return $this;
    }

    /**
     * The resource path name. For example,
     * `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
     * `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
     * When `name` is populated as a response from the service, it always ends
     * in the device numeric ID.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The resource path name. For example,
     * `projects/p1/locations/us-central1/registries/registry0/devices/dev0` or
     * `projects/p1/locations/us-central1/registries/registry0/devices/{num_id}`.
     * When `name` is populated as a response from the service, it always ends
     * in the device numeric ID.
     *
     * Generated from protobuf field <code>string name = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * [Output only] A server-defined unique numeric ID for the device. This is a
     * more compact way to identify devices, and it is globally unique.
     *
     * Generated from protobuf field <code>uint64 num_id = 3;</code>
     * @return int|string
     */
    public function getNumId()
    {
        return $this->num_id;
    }

    /**
     * [Output only] A server-defined unique numeric ID for the device. This is a
     * more compact way to identify devices, and it is globally unique.
     *
     * Generated from protobuf field <code>uint64 num_id = 3;</code>
     * @param int|string $var
     * @return $this
     */
    public function setNumId($var)
    {
        GPBUtil::checkUint64($var);
        $this->num_id = $var;

        return $this;
    }

    /**
     * The credentials used to authenticate this device. To allow credential
     * rotation without interruption, multiple device credentials can be bound to
     * this device. No more than 3 credentials can be bound to a single device at
     * a time. When new credentials are added to a device, they are verified
     * against the registry credentials. For details, see the description of the
     * `DeviceRegistry.credentials` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.iot.v1.DeviceCredential credentials = 12;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getCredentials()
    {
        return $this->credentials;
    }

    /**
     * The credentials used to authenticate this device. To allow credential
     * rotation without interruption, multiple device credentials can be bound to
     * this device. No more than 3 credentials can be bound to a single device at
     * a time. When new credentials are added to a device, they are verified
     * against the registry credentials. For details, see the description of the
     * `DeviceRegistry.credentials` field.
     *
     * Generated from protobuf field <code>repeated .google.cloud.iot.v1.DeviceCredential credentials = 12;</code>
     * @param \Google\Cloud\Iot\V1\DeviceCredential[]|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setCredentials($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Iot\V1\DeviceCredential::class);
        $this->credentials = $arr;

        return $this;
    }

    /**
     * [Output only] The last time an MQTT `PINGREQ` was received. This field
     * applies only to devices connecting through MQTT. MQTT clients usually only
     * send `PINGREQ` messages if the connection is idle, and no other messages
     * have been sent. Timestamps are periodically collected and written to
     * storage; they may be stale by a few minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_heartbeat_time = 7;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastHeartbeatTime()
    {
        return $this->last_heartbeat_time;
    }

    /**
     * [Output only] The last time an MQTT `PINGREQ` was received. This field
     * applies only to devices connecting through MQTT. MQTT clients usually only
     * send `PINGREQ` messages if the connection is idle, and no other messages
     * have been sent. Timestamps are periodically collected and written to
     * storage; they may be stale by a few minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_heartbeat_time = 7;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastHeartbeatTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_heartbeat_time = $var;

        return $this;
    }

    /**
     * [Output only] The last time a telemetry event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_event_time = 8;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastEventTime()
    {
        return $this->last_event_time;
    }

    /**
     * [Output only] The last time a telemetry event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_event_time = 8;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastEventTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_event_time = $var;

        return $this;
    }

    /**
     * [Output only] The last time a state event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_state_time = 20;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastStateTime()
    {
        return $this->last_state_time;
    }

    /**
     * [Output only] The last time a state event was received. Timestamps are
     * periodically collected and written to storage; they may be stale by a few
     * minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_state_time = 20;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastStateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_state_time = $var;

        return $this;
    }

    /**
     * [Output only] The last time a cloud-to-device config version acknowledgment
     * was received from the device. This field is only for configurations
     * sent through MQTT.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_ack_time = 14;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastConfigAckTime()
    {
        return $this->last_config_ack_time;
    }

    /**
     * [Output only] The last time a cloud-to-device config version acknowledgment
     * was received from the device. This field is only for configurations
     * sent through MQTT.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_ack_time = 14;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastConfigAckTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_config_ack_time = $var;

        return $this;
    }

    /**
     * [Output only] The last time a cloud-to-device config version was sent to
     * the device.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_send_time = 18;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastConfigSendTime()
    {
        return $this->last_config_send_time;
    }

    /**
     * [Output only] The last time a cloud-to-device config version was sent to
     * the device.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_config_send_time = 18;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastConfigSendTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_config_send_time = $var;

        return $this;
    }

    /**
     * If a device is blocked, connections or requests from this device will fail.
     * Can be used to temporarily prevent the device from connecting if, for
     * example, the sensor is generating bad data and needs maintenance.
     *
     * Generated from protobuf field <code>bool blocked = 19;</code>
     * @return bool
     */
    public function getBlocked()
    {
        return $this->blocked;
    }

    /**
     * If a device is blocked, connections or requests from this device will fail.
     * Can be used to temporarily prevent the device from connecting if, for
     * example, the sensor is generating bad data and needs maintenance.
     *
     * Generated from protobuf field <code>bool blocked = 19;</code>
     * @param bool $var
     * @return $this
     */
    public function setBlocked($var)
    {
        GPBUtil::checkBool($var);
        $this->blocked = $var;

        return $this;
    }

    /**
     * [Output only] The time the most recent error occurred, such as a failure to
     * publish to Cloud Pub/Sub. This field is the timestamp of
     * 'last_error_status'.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_error_time = 10;</code>
     * @return \Google\Protobuf\Timestamp
     */
    public function getLastErrorTime()
    {
        return $this->last_error_time;
    }

    /**
     * [Output only] The time the most recent error occurred, such as a failure to
     * publish to Cloud Pub/Sub. This field is the timestamp of
     * 'last_error_status'.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp last_error_time = 10;</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setLastErrorTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->last_error_time = $var;

        return $this;
    }

    /**
     * [Output only] The error message of the most recent error, such as a failure
     * to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
     * field. If no errors have occurred, this field has an empty message
     * and the status code 0 == OK. Otherwise, this field is expected to have a
     * status code other than OK.
     *
     * Generated from protobuf field <code>.google.rpc.Status last_error_status = 11;</code>
     * @return \Google\Rpc\Status
     */
    public function getLastErrorStatus()
    {
        return $this->last_error_status;
    }

    /**
     * [Output only] The error message of the most recent error, such as a failure
     * to publish to Cloud Pub/Sub. 'last_error_time' is the timestamp of this
     * field. If no errors have occurred, this field has an empty message
     * and the status code 0 == OK. Otherwise, this field is expected to have a
     * status code other than OK.
     *
     * Generated from protobuf field <code>.google.rpc.Status last_error_status = 11;</code>
     * @param \Google\Rpc\Status $var
     * @return $this
     */
    public function setLastErrorStatus($var)
    {
        GPBUtil::checkMessage($var, \Google\Rpc\Status::class);
        $this->last_error_status = $var;

        return $this;
    }

    /**
     * The most recent device configuration, which is eventually sent from
     * Cloud IoT Core to the device. If not present on creation, the
     * configuration will be initialized with an empty payload and version value
     * of `1`. To update this field after creation, use the
     * `DeviceManager.ModifyCloudToDeviceConfig` method.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceConfig config = 13;</code>
     * @return \Google\Cloud\Iot\V1\DeviceConfig
     */
    public function getConfig()
    {
        return $this->config;
    }

    /**
     * The most recent device configuration, which is eventually sent from
     * Cloud IoT Core to the device. If not present on creation, the
     * configuration will be initialized with an empty payload and version value
     * of `1`. To update this field after creation, use the
     * `DeviceManager.ModifyCloudToDeviceConfig` method.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceConfig config = 13;</code>
     * @param \Google\Cloud\Iot\V1\DeviceConfig $var
     * @return $this
     */
    public function setConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iot\V1\DeviceConfig::class);
        $this->config = $var;

        return $this;
    }

    /**
     * [Output only] The state most recently received from the device. If no state
     * has been reported, this field is not present.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceState state = 16;</code>
     * @return \Google\Cloud\Iot\V1\DeviceState
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * [Output only] The state most recently received from the device. If no state
     * has been reported, this field is not present.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.DeviceState state = 16;</code>
     * @param \Google\Cloud\Iot\V1\DeviceState $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iot\V1\DeviceState::class);
        $this->state = $var;

        return $this;
    }

    /**
     * **Beta Feature**
     * The logging verbosity for device activity. If unspecified,
     * DeviceRegistry.log_level will be used.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.LogLevel log_level = 21;</code>
     * @return int
     */
    public function getLogLevel()
    {
        return $this->log_level;
    }

    /**
     * **Beta Feature**
     * The logging verbosity for device activity. If unspecified,
     * DeviceRegistry.log_level will be used.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.LogLevel log_level = 21;</code>
     * @param int $var
     * @return $this
     */
    public function setLogLevel($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Iot\V1\LogLevel::class);
        $this->log_level = $var;

        return $this;
    }

    /**
     * The metadata key-value pairs assigned to the device. This metadata is not
     * interpreted or indexed by Cloud IoT Core. It can be used to add contextual
     * information for the device.
     * Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
     * be less than 128 bytes in length.
     * Values are free-form strings. Each value must be less than or equal to 32
     * KB in size.
     * The total size of all keys and values must be less than 256 KB, and the
     * maximum number of key-value pairs is 500.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 17;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getMetadata()
    {
        return $this->metadata;
    }

    /**
     * The metadata key-value pairs assigned to the device. This metadata is not
     * interpreted or indexed by Cloud IoT Core. It can be used to add contextual
     * information for the device.
     * Keys must conform to the regular expression [a-zA-Z][a-zA-Z0-9-_.+~%]+ and
     * be less than 128 bytes in length.
     * Values are free-form strings. Each value must be less than or equal to 32
     * KB in size.
     * The total size of all keys and values must be less than 256 KB, and the
     * maximum number of key-value pairs is 500.
     *
     * Generated from protobuf field <code>map<string, string> metadata = 17;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setMetadata($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata = $arr;

        return $this;
    }

    /**
     * Gateway-related configuration and state.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.GatewayConfig gateway_config = 24;</code>
     * @return \Google\Cloud\Iot\V1\GatewayConfig
     */
    public function getGatewayConfig()
    {
        return $this->gateway_config;
    }

    /**
     * Gateway-related configuration and state.
     *
     * Generated from protobuf field <code>.google.cloud.iot.v1.GatewayConfig gateway_config = 24;</code>
     * @param \Google\Cloud\Iot\V1\GatewayConfig $var
     * @return $this
     */
    public function setGatewayConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Iot\V1\GatewayConfig::class);
        $this->gateway_config = $var;

        return $this;
    }

}

