<?php
/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/*
 * GENERATED CODE WARNING
 * Generated by gapic-generator-php from the file
 * https://github.com/googleapis/googleapis/blob/master/google/cloud/sql/v1/cloud_sql_instances.proto
 * Updates to the above are reflected here through a refresh process.
 */

namespace Google\Cloud\Sql\V1\Client;

use Google\ApiCore\ApiException;
use Google\ApiCore\CredentialsWrapper;
use Google\ApiCore\GapicClientTrait;
use Google\ApiCore\Options\ClientOptions;
use Google\ApiCore\ResourceHelperTrait;
use Google\ApiCore\RetrySettings;
use Google\ApiCore\Transport\TransportInterface;
use Google\ApiCore\ValidationException;
use Google\Auth\FetchAuthTokenInterface;
use Google\Cloud\Sql\V1\DatabaseInstance;
use Google\Cloud\Sql\V1\InstancesListEntraIdCertificatesResponse;
use Google\Cloud\Sql\V1\InstancesListResponse;
use Google\Cloud\Sql\V1\InstancesListServerCasResponse;
use Google\Cloud\Sql\V1\InstancesListServerCertificatesResponse;
use Google\Cloud\Sql\V1\Operation;
use Google\Cloud\Sql\V1\SqlInstancesAcquireSsrsLeaseRequest;
use Google\Cloud\Sql\V1\SqlInstancesAcquireSsrsLeaseResponse;
use Google\Cloud\Sql\V1\SqlInstancesAddEntraIdCertificateRequest;
use Google\Cloud\Sql\V1\SqlInstancesAddServerCaRequest;
use Google\Cloud\Sql\V1\SqlInstancesAddServerCertificateRequest;
use Google\Cloud\Sql\V1\SqlInstancesCloneRequest;
use Google\Cloud\Sql\V1\SqlInstancesCreateEphemeralCertRequest;
use Google\Cloud\Sql\V1\SqlInstancesDeleteRequest;
use Google\Cloud\Sql\V1\SqlInstancesDemoteMasterRequest;
use Google\Cloud\Sql\V1\SqlInstancesDemoteRequest;
use Google\Cloud\Sql\V1\SqlInstancesExecuteSqlRequest;
use Google\Cloud\Sql\V1\SqlInstancesExecuteSqlResponse;
use Google\Cloud\Sql\V1\SqlInstancesExportRequest;
use Google\Cloud\Sql\V1\SqlInstancesFailoverRequest;
use Google\Cloud\Sql\V1\SqlInstancesGetDiskShrinkConfigRequest;
use Google\Cloud\Sql\V1\SqlInstancesGetDiskShrinkConfigResponse;
use Google\Cloud\Sql\V1\SqlInstancesGetLatestRecoveryTimeRequest;
use Google\Cloud\Sql\V1\SqlInstancesGetLatestRecoveryTimeResponse;
use Google\Cloud\Sql\V1\SqlInstancesGetRequest;
use Google\Cloud\Sql\V1\SqlInstancesImportRequest;
use Google\Cloud\Sql\V1\SqlInstancesInsertRequest;
use Google\Cloud\Sql\V1\SqlInstancesListEntraIdCertificatesRequest;
use Google\Cloud\Sql\V1\SqlInstancesListRequest;
use Google\Cloud\Sql\V1\SqlInstancesListServerCasRequest;
use Google\Cloud\Sql\V1\SqlInstancesListServerCertificatesRequest;
use Google\Cloud\Sql\V1\SqlInstancesPatchRequest;
use Google\Cloud\Sql\V1\SqlInstancesPerformDiskShrinkRequest;
use Google\Cloud\Sql\V1\SqlInstancesPointInTimeRestoreRequest;
use Google\Cloud\Sql\V1\SqlInstancesPreCheckMajorVersionUpgradeRequest;
use Google\Cloud\Sql\V1\SqlInstancesPromoteReplicaRequest;
use Google\Cloud\Sql\V1\SqlInstancesReencryptRequest;
use Google\Cloud\Sql\V1\SqlInstancesReleaseSsrsLeaseRequest;
use Google\Cloud\Sql\V1\SqlInstancesReleaseSsrsLeaseResponse;
use Google\Cloud\Sql\V1\SqlInstancesRescheduleMaintenanceRequest;
use Google\Cloud\Sql\V1\SqlInstancesResetReplicaSizeRequest;
use Google\Cloud\Sql\V1\SqlInstancesResetSslConfigRequest;
use Google\Cloud\Sql\V1\SqlInstancesRestartRequest;
use Google\Cloud\Sql\V1\SqlInstancesRestoreBackupRequest;
use Google\Cloud\Sql\V1\SqlInstancesRotateEntraIdCertificateRequest;
use Google\Cloud\Sql\V1\SqlInstancesRotateServerCaRequest;
use Google\Cloud\Sql\V1\SqlInstancesRotateServerCertificateRequest;
use Google\Cloud\Sql\V1\SqlInstancesStartExternalSyncRequest;
use Google\Cloud\Sql\V1\SqlInstancesStartReplicaRequest;
use Google\Cloud\Sql\V1\SqlInstancesStopReplicaRequest;
use Google\Cloud\Sql\V1\SqlInstancesSwitchoverRequest;
use Google\Cloud\Sql\V1\SqlInstancesTruncateLogRequest;
use Google\Cloud\Sql\V1\SqlInstancesUpdateRequest;
use Google\Cloud\Sql\V1\SqlInstancesVerifyExternalSyncSettingsRequest;
use Google\Cloud\Sql\V1\SqlInstancesVerifyExternalSyncSettingsResponse;
use Google\Cloud\Sql\V1\SslCert;
use GuzzleHttp\Promise\PromiseInterface;
use Psr\Log\LoggerInterface;

/**
 * Service Description:
 *
 * This class provides the ability to make remote calls to the backing service through method
 * calls that map to API methods.
 *
 * Many parameters require resource names to be formatted in a particular way. To
 * assist with these names, this class includes a format method for each type of
 * name, and additionally a parseName method to extract the individual identifiers
 * contained within formatted names that are returned by the API.
 *
 * @method PromiseInterface<SqlInstancesAcquireSsrsLeaseResponse> acquireSsrsLeaseAsync(SqlInstancesAcquireSsrsLeaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> addEntraIdCertificateAsync(SqlInstancesAddEntraIdCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> addServerCaAsync(SqlInstancesAddServerCaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> addServerCertificateAsync(SqlInstancesAddServerCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> cloneAsync(SqlInstancesCloneRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SslCert> createEphemeralAsync(SqlInstancesCreateEphemeralCertRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> deleteAsync(SqlInstancesDeleteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> demoteAsync(SqlInstancesDemoteRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> demoteMasterAsync(SqlInstancesDemoteMasterRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SqlInstancesExecuteSqlResponse> executeSqlAsync(SqlInstancesExecuteSqlRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> exportAsync(SqlInstancesExportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> failoverAsync(SqlInstancesFailoverRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<DatabaseInstance> getAsync(SqlInstancesGetRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SqlInstancesGetDiskShrinkConfigResponse> getDiskShrinkConfigAsync(SqlInstancesGetDiskShrinkConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SqlInstancesGetLatestRecoveryTimeResponse> getLatestRecoveryTimeAsync(SqlInstancesGetLatestRecoveryTimeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> importAsync(SqlInstancesImportRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> insertAsync(SqlInstancesInsertRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InstancesListResponse> listAsync(SqlInstancesListRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InstancesListEntraIdCertificatesResponse> listEntraIdCertificatesAsync(SqlInstancesListEntraIdCertificatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InstancesListServerCasResponse> listServerCasAsync(SqlInstancesListServerCasRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<InstancesListServerCertificatesResponse> listServerCertificatesAsync(SqlInstancesListServerCertificatesRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> patchAsync(SqlInstancesPatchRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> performDiskShrinkAsync(SqlInstancesPerformDiskShrinkRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> pointInTimeRestoreAsync(SqlInstancesPointInTimeRestoreRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> preCheckMajorVersionUpgradeAsync(SqlInstancesPreCheckMajorVersionUpgradeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> promoteReplicaAsync(SqlInstancesPromoteReplicaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> reencryptAsync(SqlInstancesReencryptRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SqlInstancesReleaseSsrsLeaseResponse> releaseSsrsLeaseAsync(SqlInstancesReleaseSsrsLeaseRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> rescheduleMaintenanceAsync(SqlInstancesRescheduleMaintenanceRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> resetReplicaSizeAsync(SqlInstancesResetReplicaSizeRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> resetSslConfigAsync(SqlInstancesResetSslConfigRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> restartAsync(SqlInstancesRestartRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> restoreBackupAsync(SqlInstancesRestoreBackupRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> rotateEntraIdCertificateAsync(SqlInstancesRotateEntraIdCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> rotateServerCaAsync(SqlInstancesRotateServerCaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> rotateServerCertificateAsync(SqlInstancesRotateServerCertificateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> startExternalSyncAsync(SqlInstancesStartExternalSyncRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> startReplicaAsync(SqlInstancesStartReplicaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> stopReplicaAsync(SqlInstancesStopReplicaRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> switchoverAsync(SqlInstancesSwitchoverRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> truncateLogAsync(SqlInstancesTruncateLogRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<Operation> updateAsync(SqlInstancesUpdateRequest $request, array $optionalArgs = [])
 * @method PromiseInterface<SqlInstancesVerifyExternalSyncSettingsResponse> verifyExternalSyncSettingsAsync(SqlInstancesVerifyExternalSyncSettingsRequest $request, array $optionalArgs = [])
 */
final class SqlInstancesServiceClient
{
    use GapicClientTrait;
    use ResourceHelperTrait;

    /** The name of the service. */
    private const SERVICE_NAME = 'google.cloud.sql.v1.SqlInstancesService';

    /**
     * The default address of the service.
     *
     * @deprecated SERVICE_ADDRESS_TEMPLATE should be used instead.
     */
    private const SERVICE_ADDRESS = 'sqladmin.googleapis.com';

    /** The address template of the service. */
    private const SERVICE_ADDRESS_TEMPLATE = 'sqladmin.UNIVERSE_DOMAIN';

    /** The default port of the service. */
    private const DEFAULT_SERVICE_PORT = 443;

    /** The name of the code generator, to be included in the agent header. */
    private const CODEGEN_NAME = 'gapic';

    /** The default scopes required by the service. */
    public static $serviceScopes = [
        'https://www.googleapis.com/auth/cloud-platform',
        'https://www.googleapis.com/auth/sqlservice.admin',
    ];

    private static function getClientDefaults()
    {
        return [
            'serviceName' => self::SERVICE_NAME,
            'apiEndpoint' => self::SERVICE_ADDRESS . ':' . self::DEFAULT_SERVICE_PORT,
            'clientConfig' => __DIR__ . '/../resources/sql_instances_service_client_config.json',
            'descriptorsConfigPath' => __DIR__ . '/../resources/sql_instances_service_descriptor_config.php',
            'gcpApiConfigPath' => __DIR__ . '/../resources/sql_instances_service_grpc_config.json',
            'credentialsConfig' => [
                'defaultScopes' => self::$serviceScopes,
            ],
            'transportConfig' => [
                'rest' => [
                    'restClientConfigPath' => __DIR__ . '/../resources/sql_instances_service_rest_client_config.php',
                ],
            ],
        ];
    }

    /**
     * Formats a string containing the fully-qualified path to represent a backup
     * resource.
     *
     * @param string $project
     * @param string $backup
     *
     * @return string The formatted backup resource.
     */
    public static function backupName(string $project, string $backup): string
    {
        return self::getPathTemplate('backup')->render([
            'project' => $project,
            'backup' => $backup,
        ]);
    }

    /**
     * Formats a string containing the fully-qualified path to represent a network
     * resource.
     *
     * @param string $project
     * @param string $network
     *
     * @return string The formatted network resource.
     */
    public static function networkName(string $project, string $network): string
    {
        return self::getPathTemplate('network')->render([
            'project' => $project,
            'network' => $network,
        ]);
    }

    /**
     * Parses a formatted name string and returns an associative array of the components in the name.
     * The following name formats are supported:
     * Template: Pattern
     * - backup: projects/{project}/backups/{backup}
     * - network: projects/{project}/global/networks/{network}
     *
     * The optional $template argument can be supplied to specify a particular pattern,
     * and must match one of the templates listed above. If no $template argument is
     * provided, or if the $template argument does not match one of the templates
     * listed, then parseName will check each of the supported templates, and return
     * the first match.
     *
     * @param string  $formattedName The formatted name string
     * @param ?string $template      Optional name of template to match
     *
     * @return array An associative array from name component IDs to component values.
     *
     * @throws ValidationException If $formattedName could not be matched.
     */
    public static function parseName(string $formattedName, ?string $template = null): array
    {
        return self::parseFormattedName($formattedName, $template);
    }

    /**
     * Constructor.
     *
     * @param array|ClientOptions $options {
     *     Optional. Options for configuring the service API wrapper.
     *
     *     @type string $apiEndpoint
     *           The address of the API remote host. May optionally include the port, formatted
     *           as "<uri>:<port>". Default 'sqladmin.googleapis.com:443'.
     *     @type FetchAuthTokenInterface|CredentialsWrapper $credentials
     *           This option should only be used with a pre-constructed
     *           {@see FetchAuthTokenInterface} or {@see CredentialsWrapper} object. Note that
     *           when one of these objects are provided, any settings in $credentialsConfig will
     *           be ignored.
     *           **Important**: If you are providing a path to a credentials file, or a decoded
     *           credentials file as a PHP array, this usage is now DEPRECATED. Providing an
     *           unvalidated credential configuration to Google APIs can compromise the security
     *           of your systems and data. It is recommended to create the credentials explicitly
     *           ```
     *           use Google\Auth\Credentials\ServiceAccountCredentials;
     *           use Google\Cloud\Sql\V1\SqlInstancesServiceClient;
     *           $creds = new ServiceAccountCredentials($scopes, $json);
     *           $options = new SqlInstancesServiceClient(['credentials' => $creds]);
     *           ```
     *           {@see
     *           https://cloud.google.com/docs/authentication/external/externally-sourced-credentials}
     *     @type array $credentialsConfig
     *           Options used to configure credentials, including auth token caching, for the
     *           client. For a full list of supporting configuration options, see
     *           {@see \Google\ApiCore\CredentialsWrapper::build()} .
     *     @type bool $disableRetries
     *           Determines whether or not retries defined by the client configuration should be
     *           disabled. Defaults to `false`.
     *     @type string|array $clientConfig
     *           Client method configuration, including retry settings. This option can be either
     *           a path to a JSON file, or a PHP array containing the decoded JSON data. By
     *           default this settings points to the default client config file, which is
     *           provided in the resources folder.
     *     @type string|TransportInterface $transport
     *           The transport used for executing network requests. May be either the string
     *           `rest` or `grpc`. Defaults to `grpc` if gRPC support is detected on the system.
     *           *Advanced usage*: Additionally, it is possible to pass in an already
     *           instantiated {@see \Google\ApiCore\Transport\TransportInterface} object. Note
     *           that when this object is provided, any settings in $transportConfig, and any
     *           $apiEndpoint setting, will be ignored.
     *     @type array $transportConfig
     *           Configuration options that will be used to construct the transport. Options for
     *           each supported transport type should be passed in a key for that transport. For
     *           example:
     *           $transportConfig = [
     *               'grpc' => [...],
     *               'rest' => [...],
     *           ];
     *           See the {@see \Google\ApiCore\Transport\GrpcTransport::build()} and
     *           {@see \Google\ApiCore\Transport\RestTransport::build()} methods for the
     *           supported options.
     *     @type callable $clientCertSource
     *           A callable which returns the client cert as a string. This can be used to
     *           provide a certificate and private key to the transport layer for mTLS.
     *     @type false|LoggerInterface $logger
     *           A PSR-3 compliant logger. If set to false, logging is disabled, ignoring the
     *           'GOOGLE_SDK_PHP_LOGGING' environment flag
     *     @type string $universeDomain
     *           The service domain for the client. Defaults to 'googleapis.com'.
     * }
     *
     * @throws ValidationException
     */
    public function __construct(array|ClientOptions $options = [])
    {
        $clientOptions = $this->buildClientOptions($options);
        $this->setClientOptions($clientOptions);
    }

    /** Handles execution of the async variants for each documented method. */
    public function __call($method, $args)
    {
        if (substr($method, -5) !== 'Async') {
            trigger_error('Call to undefined method ' . __CLASS__ . "::$method()", E_USER_ERROR);
        }

        array_unshift($args, substr($method, 0, -5));
        return call_user_func_array([$this, 'startAsyncCall'], $args);
    }

    /**
     * Acquire a lease for the setup of SQL Server Reporting Services (SSRS).
     *
     * The async variant is {@see SqlInstancesServiceClient::acquireSsrsLeaseAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/acquire_ssrs_lease.php
     *
     * @param SqlInstancesAcquireSsrsLeaseRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesAcquireSsrsLeaseResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function acquireSsrsLease(
        SqlInstancesAcquireSsrsLeaseRequest $request,
        array $callOptions = []
    ): SqlInstancesAcquireSsrsLeaseResponse {
        return $this->startApiCall('AcquireSsrsLease', $request, $callOptions)->wait();
    }

    /**
     * Adds a new Entra ID certificate for the specified instance. If an Entra ID
     * certificate was previously added but never used in a certificate rotation,
     * this operation replaces that version.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::addEntraIdCertificateAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/add_entra_id_certificate.php
     *
     * @param SqlInstancesAddEntraIdCertificateRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addEntraIdCertificate(
        SqlInstancesAddEntraIdCertificateRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('AddEntraIdCertificate', $request, $callOptions)->wait();
    }

    /**
     * Adds a new trusted Certificate Authority (CA) version for the specified
     * instance. Required to prepare for a certificate rotation. If a CA version
     * was previously added but never used in a certificate rotation, this
     * operation replaces that version. There cannot be more than one CA version
     * waiting to be rotated in. For instances that have enabled Certificate
     * Authority Service (CAS) based server CA, use AddServerCertificate to add a
     * new server certificate.
     *
     * The async variant is {@see SqlInstancesServiceClient::addServerCaAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/add_server_ca.php
     *
     * @param SqlInstancesAddServerCaRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addServerCa(SqlInstancesAddServerCaRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('AddServerCa', $request, $callOptions)->wait();
    }

    /**
     * Add a new trusted server certificate version for the specified instance
     * using Certificate Authority Service (CAS) server CA. Required to prepare
     * for a certificate rotation. If a server certificate version was previously
     * added but never used in a certificate rotation, this operation replaces
     * that version. There cannot be more than one certificate version waiting to
     * be rotated in. For instances not using CAS server CA, use AddServerCa
     * instead.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::addServerCertificateAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/add_server_certificate.php
     *
     * @param SqlInstancesAddServerCertificateRequest $request     A request to house fields associated with the call.
     * @param array                                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function addServerCertificate(
        SqlInstancesAddServerCertificateRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('AddServerCertificate', $request, $callOptions)->wait();
    }

    /**
     * Creates a Cloud SQL instance as a clone of the source instance. Using this
     * operation might cause your instance to restart.
     *
     * The async variant is {@see SqlInstancesServiceClient::cloneAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/clone.php
     *
     * @param SqlInstancesCloneRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function clone(SqlInstancesCloneRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Clone', $request, $callOptions)->wait();
    }

    /**
     * Generates a short-lived X509 certificate containing the provided public key
     * and signed by a private key specific to the target instance. Users may use
     * the certificate to authenticate as themselves when connecting to the
     * database.
     *
     * The async variant is {@see SqlInstancesServiceClient::createEphemeralAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/create_ephemeral.php
     *
     * @param SqlInstancesCreateEphemeralCertRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SslCert
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function createEphemeral(SqlInstancesCreateEphemeralCertRequest $request, array $callOptions = []): SslCert
    {
        return $this->startApiCall('CreateEphemeral', $request, $callOptions)->wait();
    }

    /**
     * Deletes a Cloud SQL instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::deleteAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/delete.php
     *
     * @param SqlInstancesDeleteRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function delete(SqlInstancesDeleteRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Delete', $request, $callOptions)->wait();
    }

    /**
     * Demotes an existing standalone instance to be a Cloud SQL read replica
     * for an external database server.
     *
     * The async variant is {@see SqlInstancesServiceClient::demoteAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/demote.php
     *
     * @param SqlInstancesDemoteRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function demote(SqlInstancesDemoteRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Demote', $request, $callOptions)->wait();
    }

    /**
     * Demotes the stand-alone instance to be a Cloud SQL read replica for an
     * external database server.
     *
     * The async variant is {@see SqlInstancesServiceClient::demoteMasterAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/demote_master.php
     *
     * @param SqlInstancesDemoteMasterRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function demoteMaster(SqlInstancesDemoteMasterRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('DemoteMaster', $request, $callOptions)->wait();
    }

    /**
     * Execute SQL statements.
     *
     * The async variant is {@see SqlInstancesServiceClient::executeSqlAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/execute_sql.php
     *
     * @param SqlInstancesExecuteSqlRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesExecuteSqlResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function executeSql(
        SqlInstancesExecuteSqlRequest $request,
        array $callOptions = []
    ): SqlInstancesExecuteSqlResponse {
        return $this->startApiCall('ExecuteSql', $request, $callOptions)->wait();
    }

    /**
     * Exports data from a Cloud SQL instance to a Cloud Storage bucket as a SQL
     * dump or CSV file.
     *
     * The async variant is {@see SqlInstancesServiceClient::exportAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/export.php
     *
     * @param SqlInstancesExportRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function export(SqlInstancesExportRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Export', $request, $callOptions)->wait();
    }

    /**
     * Initiates a manual failover of a high availability (HA) primary instance
     * to a standby instance, which becomes the primary instance. Users are
     * then rerouted to the new primary. For more information, see the
     * [Overview of high
     * availability](https://cloud.google.com/sql/docs/mysql/high-availability)
     * page in the Cloud SQL documentation.
     * If using Legacy HA (MySQL only), this causes the instance to failover to
     * its failover replica instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::failoverAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/failover.php
     *
     * @param SqlInstancesFailoverRequest $request     A request to house fields associated with the call.
     * @param array                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function failover(SqlInstancesFailoverRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Failover', $request, $callOptions)->wait();
    }

    /**
     * Retrieves a resource containing information about a Cloud SQL instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::getAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/get.php
     *
     * @param SqlInstancesGetRequest $request     A request to house fields associated with the call.
     * @param array                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return DatabaseInstance
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function get(SqlInstancesGetRequest $request, array $callOptions = []): DatabaseInstance
    {
        return $this->startApiCall('Get', $request, $callOptions)->wait();
    }

    /**
     * Get Disk Shrink Config for a given instance.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::getDiskShrinkConfigAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/get_disk_shrink_config.php
     *
     * @param SqlInstancesGetDiskShrinkConfigRequest $request     A request to house fields associated with the call.
     * @param array                                  $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesGetDiskShrinkConfigResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getDiskShrinkConfig(
        SqlInstancesGetDiskShrinkConfigRequest $request,
        array $callOptions = []
    ): SqlInstancesGetDiskShrinkConfigResponse {
        return $this->startApiCall('GetDiskShrinkConfig', $request, $callOptions)->wait();
    }

    /**
     * Get Latest Recovery Time for a given instance.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::getLatestRecoveryTimeAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/get_latest_recovery_time.php
     *
     * @param SqlInstancesGetLatestRecoveryTimeRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesGetLatestRecoveryTimeResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function getLatestRecoveryTime(
        SqlInstancesGetLatestRecoveryTimeRequest $request,
        array $callOptions = []
    ): SqlInstancesGetLatestRecoveryTimeResponse {
        return $this->startApiCall('GetLatestRecoveryTime', $request, $callOptions)->wait();
    }

    /**
     * Imports data into a Cloud SQL instance from a SQL dump  or CSV file in
     * Cloud Storage.
     *
     * The async variant is {@see SqlInstancesServiceClient::importAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/import.php
     *
     * @param SqlInstancesImportRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function import(SqlInstancesImportRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Import', $request, $callOptions)->wait();
    }

    /**
     * Creates a new Cloud SQL instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::insertAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/insert.php
     *
     * @param SqlInstancesInsertRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function insert(SqlInstancesInsertRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Insert', $request, $callOptions)->wait();
    }

    /**
     * Lists instances under a given project.
     *
     * The async variant is {@see SqlInstancesServiceClient::listAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/list.php
     *
     * @param SqlInstancesListRequest $request     A request to house fields associated with the call.
     * @param array                   $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstancesListResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function list(SqlInstancesListRequest $request, array $callOptions = []): InstancesListResponse
    {
        return $this->startApiCall('List', $request, $callOptions)->wait();
    }

    /**
     * Lists all versions of EntraID certificates for the specified instance.
     * There can be up to three sets of certificates listed: the certificate that
     * is currently in use, a future that has been added but not yet used to sign
     * a certificate, and a certificate that has been rotated out.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::listEntraIdCertificatesAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/list_entra_id_certificates.php
     *
     * @param SqlInstancesListEntraIdCertificatesRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstancesListEntraIdCertificatesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listEntraIdCertificates(
        SqlInstancesListEntraIdCertificatesRequest $request,
        array $callOptions = []
    ): InstancesListEntraIdCertificatesResponse {
        return $this->startApiCall('ListEntraIdCertificates', $request, $callOptions)->wait();
    }

    /**
     * Lists all of the trusted Certificate Authorities (CAs) for the specified
     * instance. There can be up to three CAs listed: the CA that was used to sign
     * the certificate that is currently in use, a CA that has been added but not
     * yet used to sign a certificate, and a CA used to sign a certificate that
     * has previously rotated out.
     *
     * The async variant is {@see SqlInstancesServiceClient::listServerCasAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/list_server_cas.php
     *
     * @param SqlInstancesListServerCasRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstancesListServerCasResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServerCas(
        SqlInstancesListServerCasRequest $request,
        array $callOptions = []
    ): InstancesListServerCasResponse {
        return $this->startApiCall('ListServerCas', $request, $callOptions)->wait();
    }

    /**
     * Lists all versions of server certificates and certificate authorities (CAs)
     * for the specified instance. There can be up to three sets of certs listed:
     * the certificate that is currently in use, a future that has been added but
     * not yet used to sign a certificate, and a certificate that has been rotated
     * out. For instances not using Certificate Authority Service (CAS) server CA,
     * use ListServerCas instead.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::listServerCertificatesAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/list_server_certificates.php
     *
     * @param SqlInstancesListServerCertificatesRequest $request     A request to house fields associated with the call.
     * @param array                                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return InstancesListServerCertificatesResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function listServerCertificates(
        SqlInstancesListServerCertificatesRequest $request,
        array $callOptions = []
    ): InstancesListServerCertificatesResponse {
        return $this->startApiCall('ListServerCertificates', $request, $callOptions)->wait();
    }

    /**
     * Partially updates settings of a Cloud SQL instance by merging the request
     * with the current configuration. This method supports patch semantics.
     *
     * The async variant is {@see SqlInstancesServiceClient::patchAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/patch.php
     *
     * @param SqlInstancesPatchRequest $request     A request to house fields associated with the call.
     * @param array                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function patch(SqlInstancesPatchRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Patch', $request, $callOptions)->wait();
    }

    /**
     * Perform Disk Shrink on primary instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::performDiskShrinkAsync()}
     * .
     *
     * @example samples/V1/SqlInstancesServiceClient/perform_disk_shrink.php
     *
     * @param SqlInstancesPerformDiskShrinkRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function performDiskShrink(SqlInstancesPerformDiskShrinkRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('PerformDiskShrink', $request, $callOptions)->wait();
    }

    /**
     * Point in time restore for an instance managed by Google Cloud Backup and
     * Disaster Recovery.
     *
     * The async variant is {@see SqlInstancesServiceClient::pointInTimeRestoreAsync()}
     * .
     *
     * @example samples/V1/SqlInstancesServiceClient/point_in_time_restore.php
     *
     * @param SqlInstancesPointInTimeRestoreRequest $request     A request to house fields associated with the call.
     * @param array                                 $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function pointInTimeRestore(
        SqlInstancesPointInTimeRestoreRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('PointInTimeRestore', $request, $callOptions)->wait();
    }

    /**
     * Execute MVU Pre-checks
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::preCheckMajorVersionUpgradeAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/pre_check_major_version_upgrade.php
     *
     * @param SqlInstancesPreCheckMajorVersionUpgradeRequest $request     A request to house fields associated with the call.
     * @param array                                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function preCheckMajorVersionUpgrade(
        SqlInstancesPreCheckMajorVersionUpgradeRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('PreCheckMajorVersionUpgrade', $request, $callOptions)->wait();
    }

    /**
     * Promotes the read replica instance to be an independent Cloud SQL
     * primary instance.
     * Using this operation might cause your instance to restart.
     *
     * The async variant is {@see SqlInstancesServiceClient::promoteReplicaAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/promote_replica.php
     *
     * @param SqlInstancesPromoteReplicaRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function promoteReplica(SqlInstancesPromoteReplicaRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('PromoteReplica', $request, $callOptions)->wait();
    }

    /**
     * Reencrypt CMEK instance with latest key version.
     *
     * The async variant is {@see SqlInstancesServiceClient::reencryptAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/reencrypt.php
     *
     * @param SqlInstancesReencryptRequest $request     A request to house fields associated with the call.
     * @param array                        $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function reencrypt(SqlInstancesReencryptRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Reencrypt', $request, $callOptions)->wait();
    }

    /**
     * Release a lease for the setup of SQL Server Reporting Services (SSRS).
     *
     * The async variant is {@see SqlInstancesServiceClient::releaseSsrsLeaseAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/release_ssrs_lease.php
     *
     * @param SqlInstancesReleaseSsrsLeaseRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesReleaseSsrsLeaseResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function releaseSsrsLease(
        SqlInstancesReleaseSsrsLeaseRequest $request,
        array $callOptions = []
    ): SqlInstancesReleaseSsrsLeaseResponse {
        return $this->startApiCall('ReleaseSsrsLease', $request, $callOptions)->wait();
    }

    /**
     * Reschedules the maintenance on the given instance.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::rescheduleMaintenanceAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/reschedule_maintenance.php
     *
     * @param SqlInstancesRescheduleMaintenanceRequest $request     A request to house fields associated with the call.
     * @param array                                    $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rescheduleMaintenance(
        SqlInstancesRescheduleMaintenanceRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('RescheduleMaintenance', $request, $callOptions)->wait();
    }

    /**
     * Reset Replica Size to primary instance disk size.
     *
     * The async variant is {@see SqlInstancesServiceClient::resetReplicaSizeAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/reset_replica_size.php
     *
     * @param SqlInstancesResetReplicaSizeRequest $request     A request to house fields associated with the call.
     * @param array                               $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetReplicaSize(SqlInstancesResetReplicaSizeRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('ResetReplicaSize', $request, $callOptions)->wait();
    }

    /**
     * Deletes all client certificates and generates a new server SSL certificate
     * for the instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::resetSslConfigAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/reset_ssl_config.php
     *
     * @param SqlInstancesResetSslConfigRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function resetSslConfig(SqlInstancesResetSslConfigRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('ResetSslConfig', $request, $callOptions)->wait();
    }

    /**
     * Restarts a Cloud SQL instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::restartAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/restart.php
     *
     * @param SqlInstancesRestartRequest $request     A request to house fields associated with the call.
     * @param array                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restart(SqlInstancesRestartRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Restart', $request, $callOptions)->wait();
    }

    /**
     * Restores a backup of a Cloud SQL instance. Using this operation might cause
     * your instance to restart.
     *
     * The async variant is {@see SqlInstancesServiceClient::restoreBackupAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/restore_backup.php
     *
     * @param SqlInstancesRestoreBackupRequest $request     A request to house fields associated with the call.
     * @param array                            $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function restoreBackup(SqlInstancesRestoreBackupRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('RestoreBackup', $request, $callOptions)->wait();
    }

    /**
     * Rotates the server certificate version to one previously added with the
     * addEntraIdCertificate method.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::rotateEntraIdCertificateAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/rotate_entra_id_certificate.php
     *
     * @param SqlInstancesRotateEntraIdCertificateRequest $request     A request to house fields associated with the call.
     * @param array                                       $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rotateEntraIdCertificate(
        SqlInstancesRotateEntraIdCertificateRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('RotateEntraIdCertificate', $request, $callOptions)->wait();
    }

    /**
     * Rotates the server certificate to one signed by the Certificate Authority
     * (CA) version previously added with the addServerCA method. For instances
     * that have enabled Certificate Authority Service (CAS) based server CA,
     * use RotateServerCertificate to rotate the server certificate.
     *
     * The async variant is {@see SqlInstancesServiceClient::rotateServerCaAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/rotate_server_ca.php
     *
     * @param SqlInstancesRotateServerCaRequest $request     A request to house fields associated with the call.
     * @param array                             $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rotateServerCa(SqlInstancesRotateServerCaRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('RotateServerCa', $request, $callOptions)->wait();
    }

    /**
     * Rotates the server certificate version to one previously added with the
     * addServerCertificate method. For instances not using Certificate Authority
     * Service (CAS) server CA, use RotateServerCa instead.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::rotateServerCertificateAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/rotate_server_certificate.php
     *
     * @param SqlInstancesRotateServerCertificateRequest $request     A request to house fields associated with the call.
     * @param array                                      $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function rotateServerCertificate(
        SqlInstancesRotateServerCertificateRequest $request,
        array $callOptions = []
    ): Operation {
        return $this->startApiCall('RotateServerCertificate', $request, $callOptions)->wait();
    }

    /**
     * Start External primary instance migration.
     *
     * The async variant is {@see SqlInstancesServiceClient::startExternalSyncAsync()}
     * .
     *
     * @example samples/V1/SqlInstancesServiceClient/start_external_sync.php
     *
     * @param SqlInstancesStartExternalSyncRequest $request     A request to house fields associated with the call.
     * @param array                                $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startExternalSync(SqlInstancesStartExternalSyncRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('StartExternalSync', $request, $callOptions)->wait();
    }

    /**
     * Starts the replication in the read replica instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::startReplicaAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/start_replica.php
     *
     * @param SqlInstancesStartReplicaRequest $request     A request to house fields associated with the call.
     * @param array                           $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function startReplica(SqlInstancesStartReplicaRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('StartReplica', $request, $callOptions)->wait();
    }

    /**
     * Stops the replication in the read replica instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::stopReplicaAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/stop_replica.php
     *
     * @param SqlInstancesStopReplicaRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function stopReplica(SqlInstancesStopReplicaRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('StopReplica', $request, $callOptions)->wait();
    }

    /**
     * Switches over from the primary instance to the DR replica
     * instance.
     *
     * The async variant is {@see SqlInstancesServiceClient::switchoverAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/switchover.php
     *
     * @param SqlInstancesSwitchoverRequest $request     A request to house fields associated with the call.
     * @param array                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function switchover(SqlInstancesSwitchoverRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Switchover', $request, $callOptions)->wait();
    }

    /**
     * Truncate MySQL general and slow query log tables
     * MySQL only.
     *
     * The async variant is {@see SqlInstancesServiceClient::truncateLogAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/truncate_log.php
     *
     * @param SqlInstancesTruncateLogRequest $request     A request to house fields associated with the call.
     * @param array                          $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function truncateLog(SqlInstancesTruncateLogRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('TruncateLog', $request, $callOptions)->wait();
    }

    /**
     * Updates settings of a Cloud SQL instance. Using this operation might cause
     * your instance to restart.
     *
     * The async variant is {@see SqlInstancesServiceClient::updateAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/update.php
     *
     * @param SqlInstancesUpdateRequest $request     A request to house fields associated with the call.
     * @param array                     $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return Operation
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function update(SqlInstancesUpdateRequest $request, array $callOptions = []): Operation
    {
        return $this->startApiCall('Update', $request, $callOptions)->wait();
    }

    /**
     * Verify External primary instance external sync settings.
     *
     * The async variant is
     * {@see SqlInstancesServiceClient::verifyExternalSyncSettingsAsync()} .
     *
     * @example samples/V1/SqlInstancesServiceClient/verify_external_sync_settings.php
     *
     * @param SqlInstancesVerifyExternalSyncSettingsRequest $request     A request to house fields associated with the call.
     * @param array                                         $callOptions {
     *     Optional.
     *
     *     @type RetrySettings|array $retrySettings
     *           Retry settings to use for this call. Can be a {@see RetrySettings} object, or an
     *           associative array of retry settings parameters. See the documentation on
     *           {@see RetrySettings} for example usage.
     * }
     *
     * @return SqlInstancesVerifyExternalSyncSettingsResponse
     *
     * @throws ApiException Thrown if the API call fails.
     */
    public function verifyExternalSyncSettings(
        SqlInstancesVerifyExternalSyncSettingsRequest $request,
        array $callOptions = []
    ): SqlInstancesVerifyExternalSyncSettingsResponse {
        return $this->startApiCall('VerifyExternalSyncSettings', $request, $callOptions)->wait();
    }
}
