<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/shopping/merchant/accounts/v1/accounts.proto

namespace Google\Shopping\Merchant\Accounts\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * The `Account` message represents a business's account within Shopping
 * Ads. It's the primary entity for managing product data, settings, and
 * interactions with Google's services and external providers.
 * Accounts can operate as standalone entities or be part of a advanced account
 * structure. In an advanced account setup the parent account manages multiple
 * sub-accounts.
 * Establishing an account involves configuring attributes like the account
 * name, time zone, and language preferences.
 * The `Account` message is the parent entity for many other resources, for
 * example, `AccountRelationship`, `Homepage`, `BusinessInfo` and so on.
 *
 * Generated from protobuf message <code>google.shopping.merchant.accounts.v1.Account</code>
 */
class Account extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the account.
     * Format: `accounts/{account}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The ID of the account.
     *
     * Generated from protobuf field <code>int64 account_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $account_id = 0;
    /**
     * Required. A human-readable name of the account. See
     * [store name](https://support.google.com/merchants/answer/160556) and
     * [business name](https://support.google.com/merchants/answer/12159159) for
     * more information.
     *
     * Generated from protobuf field <code>string account_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $account_name = '';
    /**
     * Optional. Whether this account contains adult content.
     *
     * Generated from protobuf field <code>optional bool adult_content = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $adult_content = null;
    /**
     * Output only. Whether this is a test account.
     *
     * Generated from protobuf field <code>bool test_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $test_account = false;
    /**
     * Required. The time zone of the account.
     * On writes, `time_zone` sets both the `reporting_time_zone` and the
     * `display_time_zone`.
     * For reads, `time_zone` always returns the `display_time_zone`. If
     * `display_time_zone` doesn't exist for your account, `time_zone` is empty.
     * The `version` field is not supported, won't be set in responses and will be
     * silently ignored if specified in requests.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $time_zone = null;
    /**
     * Required. The account's [BCP-47 language
     * code](https://tools.ietf.org/html/bcp47), such as `en-US` or `sr-Latn`.
     *
     * Generated from protobuf field <code>string language_code = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $language_code = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. The resource name of the account.
     *           Format: `accounts/{account}`
     *     @type int|string $account_id
     *           Output only. The ID of the account.
     *     @type string $account_name
     *           Required. A human-readable name of the account. See
     *           [store name](https://support.google.com/merchants/answer/160556) and
     *           [business name](https://support.google.com/merchants/answer/12159159) for
     *           more information.
     *     @type bool $adult_content
     *           Optional. Whether this account contains adult content.
     *     @type bool $test_account
     *           Output only. Whether this is a test account.
     *     @type \Google\Type\TimeZone $time_zone
     *           Required. The time zone of the account.
     *           On writes, `time_zone` sets both the `reporting_time_zone` and the
     *           `display_time_zone`.
     *           For reads, `time_zone` always returns the `display_time_zone`. If
     *           `display_time_zone` doesn't exist for your account, `time_zone` is empty.
     *           The `version` field is not supported, won't be set in responses and will be
     *           silently ignored if specified in requests.
     *     @type string $language_code
     *           Required. The account's [BCP-47 language
     *           code](https://tools.ietf.org/html/bcp47), such as `en-US` or `sr-Latn`.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Shopping\Merchant\Accounts\V1\Accounts::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. The resource name of the account.
     * Format: `accounts/{account}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the account.
     * Format: `accounts/{account}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The ID of the account.
     *
     * Generated from protobuf field <code>int64 account_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getAccountId()
    {
        return $this->account_id;
    }

    /**
     * Output only. The ID of the account.
     *
     * Generated from protobuf field <code>int64 account_id = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setAccountId($var)
    {
        GPBUtil::checkInt64($var);
        $this->account_id = $var;

        return $this;
    }

    /**
     * Required. A human-readable name of the account. See
     * [store name](https://support.google.com/merchants/answer/160556) and
     * [business name](https://support.google.com/merchants/answer/12159159) for
     * more information.
     *
     * Generated from protobuf field <code>string account_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAccountName()
    {
        return $this->account_name;
    }

    /**
     * Required. A human-readable name of the account. See
     * [store name](https://support.google.com/merchants/answer/160556) and
     * [business name](https://support.google.com/merchants/answer/12159159) for
     * more information.
     *
     * Generated from protobuf field <code>string account_name = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAccountName($var)
    {
        GPBUtil::checkString($var, True);
        $this->account_name = $var;

        return $this;
    }

    /**
     * Optional. Whether this account contains adult content.
     *
     * Generated from protobuf field <code>optional bool adult_content = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getAdultContent()
    {
        return isset($this->adult_content) ? $this->adult_content : false;
    }

    public function hasAdultContent()
    {
        return isset($this->adult_content);
    }

    public function clearAdultContent()
    {
        unset($this->adult_content);
    }

    /**
     * Optional. Whether this account contains adult content.
     *
     * Generated from protobuf field <code>optional bool adult_content = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setAdultContent($var)
    {
        GPBUtil::checkBool($var);
        $this->adult_content = $var;

        return $this;
    }

    /**
     * Output only. Whether this is a test account.
     *
     * Generated from protobuf field <code>bool test_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getTestAccount()
    {
        return $this->test_account;
    }

    /**
     * Output only. Whether this is a test account.
     *
     * Generated from protobuf field <code>bool test_account = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setTestAccount($var)
    {
        GPBUtil::checkBool($var);
        $this->test_account = $var;

        return $this;
    }

    /**
     * Required. The time zone of the account.
     * On writes, `time_zone` sets both the `reporting_time_zone` and the
     * `display_time_zone`.
     * For reads, `time_zone` always returns the `display_time_zone`. If
     * `display_time_zone` doesn't exist for your account, `time_zone` is empty.
     * The `version` field is not supported, won't be set in responses and will be
     * silently ignored if specified in requests.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Type\TimeZone|null
     */
    public function getTimeZone()
    {
        return $this->time_zone;
    }

    public function hasTimeZone()
    {
        return isset($this->time_zone);
    }

    public function clearTimeZone()
    {
        unset($this->time_zone);
    }

    /**
     * Required. The time zone of the account.
     * On writes, `time_zone` sets both the `reporting_time_zone` and the
     * `display_time_zone`.
     * For reads, `time_zone` always returns the `display_time_zone`. If
     * `display_time_zone` doesn't exist for your account, `time_zone` is empty.
     * The `version` field is not supported, won't be set in responses and will be
     * silently ignored if specified in requests.
     *
     * Generated from protobuf field <code>.google.type.TimeZone time_zone = 6 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Type\TimeZone $var
     * @return $this
     */
    public function setTimeZone($var)
    {
        GPBUtil::checkMessage($var, \Google\Type\TimeZone::class);
        $this->time_zone = $var;

        return $this;
    }

    /**
     * Required. The account's [BCP-47 language
     * code](https://tools.ietf.org/html/bcp47), such as `en-US` or `sr-Latn`.
     *
     * Generated from protobuf field <code>string language_code = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getLanguageCode()
    {
        return $this->language_code;
    }

    /**
     * Required. The account's [BCP-47 language
     * code](https://tools.ietf.org/html/bcp47), such as `en-US` or `sr-Latn`.
     *
     * Generated from protobuf field <code>string language_code = 7 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setLanguageCode($var)
    {
        GPBUtil::checkString($var, True);
        $this->language_code = $var;

        return $this;
    }

}

