<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/run/v2/instance.proto

namespace Google\Cloud\Run\V2;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A Cloud Run Instance represents a single group of containers running in a
 * region.
 *
 * Generated from protobuf message <code>google.cloud.run.v2.Instance</code>
 */
class Instance extends \Google\Protobuf\Internal\Message
{
    /**
     * The fully qualified name of this Instance. In CreateInstanceRequest, this
     * field is ignored, and instead composed from CreateInstanceRequest.parent
     * and CreateInstanceRequest.instance_id.
     * Format:
     * projects/{project}/locations/{location}/instances/{instance_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * User-provided description of the Instance. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     */
    protected $description = '';
    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $uid = '';
    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $generation = 0;
    /**
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     */
    private $labels;
    /**
     * Generated from protobuf field <code>map<string, string> annotations = 7;</code>
     */
    private $annotations;
    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Output only. The deletion time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $delete_time = null;
    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $expire_time = null;
    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $creator = '';
    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $last_modifier = '';
    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 14;</code>
     */
    protected $client = '';
    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 15;</code>
     */
    protected $client_version = '';
    /**
     * The launch stage as defined by [Google Cloud Platform
     *  Launch Stages](https://cloud.google.com/terms/launch-stages).
     *  Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *  is assumed.
     *  Set the launch stage to a preview stage on input to allow use of preview
     *  features in that stage. On read (or output), describes whether the
     *  resource uses preview features.
     * <p>
     *  For example, if ALPHA is provided as input, but only BETA and GA-level
     *  features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16;</code>
     */
    protected $launch_stage = 0;
    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     */
    protected $binary_authorization = null;
    /**
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $vpc_access = null;
    /**
     * Generated from protobuf field <code>string service_account = 19;</code>
     */
    protected $service_account = '';
    /**
     * Required. Holds the single container that defines the unit of execution for
     * this Instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 20 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private $containers;
    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 21;</code>
     */
    private $volumes;
    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 22 [(.google.api.resource_reference) = {</code>
     */
    protected $encryption_key = '';
    /**
     * The action to take if the encryption key is revoked.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 24;</code>
     */
    protected $encryption_key_revocation_action = 0;
    /**
     * If encryption_key_revocation_action is SHUTDOWN, the duration before
     * shutting down all instances. The minimum increment is 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration encryption_key_shutdown_duration = 25;</code>
     */
    protected $encryption_key_shutdown_duration = null;
    /**
     * Optional. The node selector for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.NodeSelector node_selector = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $node_selector = null;
    /**
     * Optional. True if GPU zonal redundancy is disabled on this instance.
     *
     * Generated from protobuf field <code>optional bool gpu_zonal_redundancy_disabled = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $gpu_zonal_redundancy_disabled = null;
    /**
     * Optional. Provides the ingress settings for this Instance. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $ingress = 0;
    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this Instance. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $invoker_iam_disabled = false;
    /**
     * Optional. IAP settings on the Instance.
     *
     * Generated from protobuf field <code>bool iap_enabled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $iap_enabled = false;
    /**
     * Output only. The generation of this Instance currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $observed_generation = 0;
    /**
     * Output only. The Google Console URI to obtain logs for the Instance.
     *
     * Generated from protobuf field <code>string log_uri = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $log_uri = '';
    /**
     * Output only. The Condition of this Instance, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $terminal_condition = null;
    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Instance does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $conditions;
    /**
     * Output only. Status information for each of the specified containers. The
     * status includes the resolved digest for specified images.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.ContainerStatus container_statuses = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $container_statuses;
    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $satisfies_pzs = false;
    /**
     * Output only. All URLs serving traffic for this Instance.
     *
     * Generated from protobuf field <code>repeated string urls = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $urls;
    /**
     * Output only. Returns true if the Instance is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Instance is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Instance to
     * the desired serving state. This process is called reconciliation. While
     * reconciliation is in process, `observed_generation` will have a transient
     * value that might mismatch the intended state.
     *  Once reconciliation is over (and this field is false), there are two
     * possible outcomes: reconciliation succeeded and the serving state matches
     * the Instance, or there was an error, and reconciliation failed. This state
     * can be found in `terminal_condition.state`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $reconciling = false;
    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The fully qualified name of this Instance. In CreateInstanceRequest, this
     *           field is ignored, and instead composed from CreateInstanceRequest.parent
     *           and CreateInstanceRequest.instance_id.
     *           Format:
     *           projects/{project}/locations/{location}/instances/{instance_id}
     *     @type string $description
     *           User-provided description of the Instance. This field currently has a
     *           512-character limit.
     *     @type string $uid
     *           Output only. Server assigned unique identifier for the trigger. The value
     *           is a UUID4 string and guaranteed to remain unchanged until the resource is
     *           deleted.
     *     @type int|string $generation
     *           Output only. A number that monotonically increases every time the user
     *           modifies the desired state.
     *           Please note that unlike v1, this is an int64 value. As with most Google
     *           APIs, its JSON representation will be a `string` instead of an `integer`.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The creation time.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The last-modified time.
     *     @type \Google\Protobuf\Timestamp $delete_time
     *           Output only. The deletion time.
     *     @type \Google\Protobuf\Timestamp $expire_time
     *           Output only. For a deleted resource, the time after which it will be
     *           permamently deleted.
     *     @type string $creator
     *           Output only. Email address of the authenticated creator.
     *     @type string $last_modifier
     *           Output only. Email address of the last authenticated modifier.
     *     @type string $client
     *           Arbitrary identifier for the API client.
     *     @type string $client_version
     *           Arbitrary version identifier for the API client.
     *     @type int $launch_stage
     *           The launch stage as defined by [Google Cloud Platform
     *            Launch Stages](https://cloud.google.com/terms/launch-stages).
     *            Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *            is assumed.
     *            Set the launch stage to a preview stage on input to allow use of preview
     *            features in that stage. On read (or output), describes whether the
     *            resource uses preview features.
     *           <p>
     *            For example, if ALPHA is provided as input, but only BETA and GA-level
     *            features are used, this field will be BETA on output.
     *     @type \Google\Cloud\Run\V2\BinaryAuthorization $binary_authorization
     *           Settings for the Binary Authorization feature.
     *     @type \Google\Cloud\Run\V2\VpcAccess $vpc_access
     *           Optional. VPC Access configuration to use for this Revision. For more
     *           information, visit
     *           https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *     @type string $service_account
     *     @type array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $containers
     *           Required. Holds the single container that defines the unit of execution for
     *           this Instance.
     *     @type array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $volumes
     *           A list of Volumes to make available to containers.
     *     @type string $encryption_key
     *           A reference to a customer managed encryption key (CMEK) to use to encrypt
     *           this container image. For more information, go to
     *           https://cloud.google.com/run/docs/securing/using-cmek
     *     @type int $encryption_key_revocation_action
     *           The action to take if the encryption key is revoked.
     *     @type \Google\Protobuf\Duration $encryption_key_shutdown_duration
     *           If encryption_key_revocation_action is SHUTDOWN, the duration before
     *           shutting down all instances. The minimum increment is 1 hour.
     *     @type \Google\Cloud\Run\V2\NodeSelector $node_selector
     *           Optional. The node selector for the instance.
     *     @type bool $gpu_zonal_redundancy_disabled
     *           Optional. True if GPU zonal redundancy is disabled on this instance.
     *     @type int $ingress
     *           Optional. Provides the ingress settings for this Instance. On output,
     *           returns the currently observed ingress settings, or
     *           INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *     @type bool $invoker_iam_disabled
     *           Optional. Disables IAM permission check for run.routes.invoke for callers
     *           of this Instance. For more information, visit
     *           https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *     @type bool $iap_enabled
     *           Optional. IAP settings on the Instance.
     *     @type int|string $observed_generation
     *           Output only. The generation of this Instance currently serving traffic. See
     *           comments in `reconciling` for additional information on reconciliation
     *           process in Cloud Run. Please note that unlike v1, this is an int64 value.
     *           As with most Google APIs, its JSON representation will be a `string`
     *           instead of an `integer`.
     *     @type string $log_uri
     *           Output only. The Google Console URI to obtain logs for the Instance.
     *     @type \Google\Cloud\Run\V2\Condition $terminal_condition
     *           Output only. The Condition of this Instance, containing its readiness
     *           status, and detailed error information in case it did not reach a serving
     *           state. See comments in `reconciling` for additional information on
     *           reconciliation process in Cloud Run.
     *     @type array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $conditions
     *           Output only. The Conditions of all other associated sub-resources. They
     *           contain additional diagnostics information in case the Instance does not
     *           reach its Serving state. See comments in `reconciling` for additional
     *           information on reconciliation process in Cloud Run.
     *     @type array<\Google\Cloud\Run\V2\ContainerStatus>|\Google\Protobuf\Internal\RepeatedField $container_statuses
     *           Output only. Status information for each of the specified containers. The
     *           status includes the resolved digest for specified images.
     *     @type bool $satisfies_pzs
     *           Output only. Reserved for future use.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $urls
     *           Output only. All URLs serving traffic for this Instance.
     *     @type bool $reconciling
     *           Output only. Returns true if the Instance is currently being acted upon by
     *           the system to bring it into the desired state.
     *           When a new Instance is created, or an existing one is updated, Cloud Run
     *           will asynchronously perform all necessary steps to bring the Instance to
     *           the desired serving state. This process is called reconciliation. While
     *           reconciliation is in process, `observed_generation` will have a transient
     *           value that might mismatch the intended state.
     *            Once reconciliation is over (and this field is false), there are two
     *           possible outcomes: reconciliation succeeded and the serving state matches
     *           the Instance, or there was an error, and reconciliation failed. This state
     *           can be found in `terminal_condition.state`.
     *     @type string $etag
     *           Optional. A system-generated fingerprint for this version of the
     *           resource. May be used to detect modification conflict during updates.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Run\V2\Instance::initOnce();
        parent::__construct($data);
    }

    /**
     * The fully qualified name of this Instance. In CreateInstanceRequest, this
     * field is ignored, and instead composed from CreateInstanceRequest.parent
     * and CreateInstanceRequest.instance_id.
     * Format:
     * projects/{project}/locations/{location}/instances/{instance_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The fully qualified name of this Instance. In CreateInstanceRequest, this
     * field is ignored, and instead composed from CreateInstanceRequest.parent
     * and CreateInstanceRequest.instance_id.
     * Format:
     * projects/{project}/locations/{location}/instances/{instance_id}
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * User-provided description of the Instance. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @return string
     */
    public function getDescription()
    {
        return $this->description;
    }

    /**
     * User-provided description of the Instance. This field currently has a
     * 512-character limit.
     *
     * Generated from protobuf field <code>string description = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getUid()
    {
        return $this->uid;
    }

    /**
     * Output only. Server assigned unique identifier for the trigger. The value
     * is a UUID4 string and guaranteed to remain unchanged until the resource is
     * deleted.
     *
     * Generated from protobuf field <code>string uid = 4 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setUid($var)
    {
        GPBUtil::checkString($var, True);
        $this->uid = $var;

        return $this;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getGeneration()
    {
        return $this->generation;
    }

    /**
     * Output only. A number that monotonically increases every time the user
     * modifies the desired state.
     * Please note that unlike v1, this is an int64 value. As with most Google
     * APIs, its JSON representation will be a `string` instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 generation = 5 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->generation = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Generated from protobuf field <code>map<string, string> labels = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>map<string, string> annotations = 7;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Generated from protobuf field <code>map<string, string> annotations = 7;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The creation time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 8 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The last-modified time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Output only. The deletion time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getDeleteTime()
    {
        return $this->delete_time;
    }

    public function hasDeleteTime()
    {
        return isset($this->delete_time);
    }

    public function clearDeleteTime()
    {
        unset($this->delete_time);
    }

    /**
     * Output only. The deletion time.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp delete_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setDeleteTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->delete_time = $var;

        return $this;
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getExpireTime()
    {
        return $this->expire_time;
    }

    public function hasExpireTime()
    {
        return isset($this->expire_time);
    }

    public function clearExpireTime()
    {
        unset($this->expire_time);
    }

    /**
     * Output only. For a deleted resource, the time after which it will be
     * permamently deleted.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp expire_time = 11 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setExpireTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->expire_time = $var;

        return $this;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getCreator()
    {
        return $this->creator;
    }

    /**
     * Output only. Email address of the authenticated creator.
     *
     * Generated from protobuf field <code>string creator = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setCreator($var)
    {
        GPBUtil::checkString($var, True);
        $this->creator = $var;

        return $this;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLastModifier()
    {
        return $this->last_modifier;
    }

    /**
     * Output only. Email address of the last authenticated modifier.
     *
     * Generated from protobuf field <code>string last_modifier = 13 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLastModifier($var)
    {
        GPBUtil::checkString($var, True);
        $this->last_modifier = $var;

        return $this;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 14;</code>
     * @return string
     */
    public function getClient()
    {
        return $this->client;
    }

    /**
     * Arbitrary identifier for the API client.
     *
     * Generated from protobuf field <code>string client = 14;</code>
     * @param string $var
     * @return $this
     */
    public function setClient($var)
    {
        GPBUtil::checkString($var, True);
        $this->client = $var;

        return $this;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 15;</code>
     * @return string
     */
    public function getClientVersion()
    {
        return $this->client_version;
    }

    /**
     * Arbitrary version identifier for the API client.
     *
     * Generated from protobuf field <code>string client_version = 15;</code>
     * @param string $var
     * @return $this
     */
    public function setClientVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->client_version = $var;

        return $this;
    }

    /**
     * The launch stage as defined by [Google Cloud Platform
     *  Launch Stages](https://cloud.google.com/terms/launch-stages).
     *  Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *  is assumed.
     *  Set the launch stage to a preview stage on input to allow use of preview
     *  features in that stage. On read (or output), describes whether the
     *  resource uses preview features.
     * <p>
     *  For example, if ALPHA is provided as input, but only BETA and GA-level
     *  features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16;</code>
     * @return int
     */
    public function getLaunchStage()
    {
        return $this->launch_stage;
    }

    /**
     * The launch stage as defined by [Google Cloud Platform
     *  Launch Stages](https://cloud.google.com/terms/launch-stages).
     *  Cloud Run supports `ALPHA`, `BETA`, and `GA`. If no value is specified, GA
     *  is assumed.
     *  Set the launch stage to a preview stage on input to allow use of preview
     *  features in that stage. On read (or output), describes whether the
     *  resource uses preview features.
     * <p>
     *  For example, if ALPHA is provided as input, but only BETA and GA-level
     *  features are used, this field will be BETA on output.
     *
     * Generated from protobuf field <code>.google.api.LaunchStage launch_stage = 16;</code>
     * @param int $var
     * @return $this
     */
    public function setLaunchStage($var)
    {
        GPBUtil::checkEnum($var, \Google\Api\LaunchStage::class);
        $this->launch_stage = $var;

        return $this;
    }

    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     * @return \Google\Cloud\Run\V2\BinaryAuthorization|null
     */
    public function getBinaryAuthorization()
    {
        return $this->binary_authorization;
    }

    public function hasBinaryAuthorization()
    {
        return isset($this->binary_authorization);
    }

    public function clearBinaryAuthorization()
    {
        unset($this->binary_authorization);
    }

    /**
     * Settings for the Binary Authorization feature.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.BinaryAuthorization binary_authorization = 17;</code>
     * @param \Google\Cloud\Run\V2\BinaryAuthorization $var
     * @return $this
     */
    public function setBinaryAuthorization($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\BinaryAuthorization::class);
        $this->binary_authorization = $var;

        return $this;
    }

    /**
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\VpcAccess|null
     */
    public function getVpcAccess()
    {
        return $this->vpc_access;
    }

    public function hasVpcAccess()
    {
        return isset($this->vpc_access);
    }

    public function clearVpcAccess()
    {
        unset($this->vpc_access);
    }

    /**
     * Optional. VPC Access configuration to use for this Revision. For more
     * information, visit
     * https://cloud.google.com/run/docs/configuring/connecting-vpc.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.VpcAccess vpc_access = 18 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\VpcAccess $var
     * @return $this
     */
    public function setVpcAccess($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\VpcAccess::class);
        $this->vpc_access = $var;

        return $this;
    }

    /**
     * Generated from protobuf field <code>string service_account = 19;</code>
     * @return string
     */
    public function getServiceAccount()
    {
        return $this->service_account;
    }

    /**
     * Generated from protobuf field <code>string service_account = 19;</code>
     * @param string $var
     * @return $this
     */
    public function setServiceAccount($var)
    {
        GPBUtil::checkString($var, True);
        $this->service_account = $var;

        return $this;
    }

    /**
     * Required. Holds the single container that defines the unit of execution for
     * this Instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 20 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainers()
    {
        return $this->containers;
    }

    /**
     * Required. Holds the single container that defines the unit of execution for
     * this Instance.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Container containers = 20 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param array<\Google\Cloud\Run\V2\Container>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainers($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Container::class);
        $this->containers = $arr;

        return $this;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 21;</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getVolumes()
    {
        return $this->volumes;
    }

    /**
     * A list of Volumes to make available to containers.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Volume volumes = 21;</code>
     * @param array<\Google\Cloud\Run\V2\Volume>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setVolumes($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Volume::class);
        $this->volumes = $arr;

        return $this;
    }

    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 22 [(.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getEncryptionKey()
    {
        return $this->encryption_key;
    }

    /**
     * A reference to a customer managed encryption key (CMEK) to use to encrypt
     * this container image. For more information, go to
     * https://cloud.google.com/run/docs/securing/using-cmek
     *
     * Generated from protobuf field <code>string encryption_key = 22 [(.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setEncryptionKey($var)
    {
        GPBUtil::checkString($var, True);
        $this->encryption_key = $var;

        return $this;
    }

    /**
     * The action to take if the encryption key is revoked.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 24;</code>
     * @return int
     */
    public function getEncryptionKeyRevocationAction()
    {
        return $this->encryption_key_revocation_action;
    }

    /**
     * The action to take if the encryption key is revoked.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.EncryptionKeyRevocationAction encryption_key_revocation_action = 24;</code>
     * @param int $var
     * @return $this
     */
    public function setEncryptionKeyRevocationAction($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Run\V2\EncryptionKeyRevocationAction::class);
        $this->encryption_key_revocation_action = $var;

        return $this;
    }

    /**
     * If encryption_key_revocation_action is SHUTDOWN, the duration before
     * shutting down all instances. The minimum increment is 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration encryption_key_shutdown_duration = 25;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getEncryptionKeyShutdownDuration()
    {
        return $this->encryption_key_shutdown_duration;
    }

    public function hasEncryptionKeyShutdownDuration()
    {
        return isset($this->encryption_key_shutdown_duration);
    }

    public function clearEncryptionKeyShutdownDuration()
    {
        unset($this->encryption_key_shutdown_duration);
    }

    /**
     * If encryption_key_revocation_action is SHUTDOWN, the duration before
     * shutting down all instances. The minimum increment is 1 hour.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration encryption_key_shutdown_duration = 25;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setEncryptionKeyShutdownDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->encryption_key_shutdown_duration = $var;

        return $this;
    }

    /**
     * Optional. The node selector for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.NodeSelector node_selector = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\Run\V2\NodeSelector|null
     */
    public function getNodeSelector()
    {
        return $this->node_selector;
    }

    public function hasNodeSelector()
    {
        return isset($this->node_selector);
    }

    public function clearNodeSelector()
    {
        unset($this->node_selector);
    }

    /**
     * Optional. The node selector for the instance.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.NodeSelector node_selector = 26 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\Run\V2\NodeSelector $var
     * @return $this
     */
    public function setNodeSelector($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\NodeSelector::class);
        $this->node_selector = $var;

        return $this;
    }

    /**
     * Optional. True if GPU zonal redundancy is disabled on this instance.
     *
     * Generated from protobuf field <code>optional bool gpu_zonal_redundancy_disabled = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getGpuZonalRedundancyDisabled()
    {
        return isset($this->gpu_zonal_redundancy_disabled) ? $this->gpu_zonal_redundancy_disabled : false;
    }

    public function hasGpuZonalRedundancyDisabled()
    {
        return isset($this->gpu_zonal_redundancy_disabled);
    }

    public function clearGpuZonalRedundancyDisabled()
    {
        unset($this->gpu_zonal_redundancy_disabled);
    }

    /**
     * Optional. True if GPU zonal redundancy is disabled on this instance.
     *
     * Generated from protobuf field <code>optional bool gpu_zonal_redundancy_disabled = 27 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setGpuZonalRedundancyDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->gpu_zonal_redundancy_disabled = $var;

        return $this;
    }

    /**
     * Optional. Provides the ingress settings for this Instance. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getIngress()
    {
        return $this->ingress;
    }

    /**
     * Optional. Provides the ingress settings for this Instance. On output,
     * returns the currently observed ingress settings, or
     * INGRESS_TRAFFIC_UNSPECIFIED if no revision is active.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.IngressTraffic ingress = 28 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setIngress($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\Run\V2\IngressTraffic::class);
        $this->ingress = $var;

        return $this;
    }

    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this Instance. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getInvokerIamDisabled()
    {
        return $this->invoker_iam_disabled;
    }

    /**
     * Optional. Disables IAM permission check for run.routes.invoke for callers
     * of this Instance. For more information, visit
     * https://cloud.google.com/run/docs/securing/managing-access#invoker_check.
     *
     * Generated from protobuf field <code>bool invoker_iam_disabled = 29 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setInvokerIamDisabled($var)
    {
        GPBUtil::checkBool($var);
        $this->invoker_iam_disabled = $var;

        return $this;
    }

    /**
     * Optional. IAP settings on the Instance.
     *
     * Generated from protobuf field <code>bool iap_enabled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getIapEnabled()
    {
        return $this->iap_enabled;
    }

    /**
     * Optional. IAP settings on the Instance.
     *
     * Generated from protobuf field <code>bool iap_enabled = 30 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setIapEnabled($var)
    {
        GPBUtil::checkBool($var);
        $this->iap_enabled = $var;

        return $this;
    }

    /**
     * Output only. The generation of this Instance currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int|string
     */
    public function getObservedGeneration()
    {
        return $this->observed_generation;
    }

    /**
     * Output only. The generation of this Instance currently serving traffic. See
     * comments in `reconciling` for additional information on reconciliation
     * process in Cloud Run. Please note that unlike v1, this is an int64 value.
     * As with most Google APIs, its JSON representation will be a `string`
     * instead of an `integer`.
     *
     * Generated from protobuf field <code>int64 observed_generation = 40 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int|string $var
     * @return $this
     */
    public function setObservedGeneration($var)
    {
        GPBUtil::checkInt64($var);
        $this->observed_generation = $var;

        return $this;
    }

    /**
     * Output only. The Google Console URI to obtain logs for the Instance.
     *
     * Generated from protobuf field <code>string log_uri = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getLogUri()
    {
        return $this->log_uri;
    }

    /**
     * Output only. The Google Console URI to obtain logs for the Instance.
     *
     * Generated from protobuf field <code>string log_uri = 41 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setLogUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->log_uri = $var;

        return $this;
    }

    /**
     * Output only. The Condition of this Instance, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Cloud\Run\V2\Condition|null
     */
    public function getTerminalCondition()
    {
        return $this->terminal_condition;
    }

    public function hasTerminalCondition()
    {
        return isset($this->terminal_condition);
    }

    public function clearTerminalCondition()
    {
        unset($this->terminal_condition);
    }

    /**
     * Output only. The Condition of this Instance, containing its readiness
     * status, and detailed error information in case it did not reach a serving
     * state. See comments in `reconciling` for additional information on
     * reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>.google.cloud.run.v2.Condition terminal_condition = 42 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Cloud\Run\V2\Condition $var
     * @return $this
     */
    public function setTerminalCondition($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Run\V2\Condition::class);
        $this->terminal_condition = $var;

        return $this;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Instance does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getConditions()
    {
        return $this->conditions;
    }

    /**
     * Output only. The Conditions of all other associated sub-resources. They
     * contain additional diagnostics information in case the Instance does not
     * reach its Serving state. See comments in `reconciling` for additional
     * information on reconciliation process in Cloud Run.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.Condition conditions = 43 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\Condition>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setConditions($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\Condition::class);
        $this->conditions = $arr;

        return $this;
    }

    /**
     * Output only. Status information for each of the specified containers. The
     * status includes the resolved digest for specified images.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.ContainerStatus container_statuses = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getContainerStatuses()
    {
        return $this->container_statuses;
    }

    /**
     * Output only. Status information for each of the specified containers. The
     * status includes the resolved digest for specified images.
     *
     * Generated from protobuf field <code>repeated .google.cloud.run.v2.ContainerStatus container_statuses = 44 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<\Google\Cloud\Run\V2\ContainerStatus>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setContainerStatuses($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Run\V2\ContainerStatus::class);
        $this->container_statuses = $arr;

        return $this;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Output only. Reserved for future use.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 46 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Output only. All URLs serving traffic for this Instance.
     *
     * Generated from protobuf field <code>repeated string urls = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getUrls()
    {
        return $this->urls;
    }

    /**
     * Output only. All URLs serving traffic for this Instance.
     *
     * Generated from protobuf field <code>repeated string urls = 45 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setUrls($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->urls = $arr;

        return $this;
    }

    /**
     * Output only. Returns true if the Instance is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Instance is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Instance to
     * the desired serving state. This process is called reconciliation. While
     * reconciliation is in process, `observed_generation` will have a transient
     * value that might mismatch the intended state.
     *  Once reconciliation is over (and this field is false), there are two
     * possible outcomes: reconciliation succeeded and the serving state matches
     * the Instance, or there was an error, and reconciliation failed. This state
     * can be found in `terminal_condition.state`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return bool
     */
    public function getReconciling()
    {
        return $this->reconciling;
    }

    /**
     * Output only. Returns true if the Instance is currently being acted upon by
     * the system to bring it into the desired state.
     * When a new Instance is created, or an existing one is updated, Cloud Run
     * will asynchronously perform all necessary steps to bring the Instance to
     * the desired serving state. This process is called reconciliation. While
     * reconciliation is in process, `observed_generation` will have a transient
     * value that might mismatch the intended state.
     *  Once reconciliation is over (and this field is false), there are two
     * possible outcomes: reconciliation succeeded and the serving state matches
     * the Instance, or there was an error, and reconciliation failed. This state
     * can be found in `terminal_condition.state`.
     *
     * Generated from protobuf field <code>bool reconciling = 98 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param bool $var
     * @return $this
     */
    public function setReconciling($var)
    {
        GPBUtil::checkBool($var);
        $this->reconciling = $var;

        return $this;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. A system-generated fingerprint for this version of the
     * resource. May be used to detect modification conflict during updates.
     *
     * Generated from protobuf field <code>string etag = 99 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

}

