<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/pubsub/v1/pubsub.proto

namespace Google\Cloud\PubSub\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A topic resource.
 *
 * Generated from protobuf message <code>google.pubsub.v1.Topic</code>
 */
class Topic extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Identifier. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     */
    private $name = '';
    /**
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $message_storage_policy = null;
    /**
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     *
     * Generated from protobuf field <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     */
    private $kms_key_name = '';
    /**
     * Optional. Settings for validating messages published against a schema.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $schema_settings = null;
    /**
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $satisfies_pzs = false;
    /**
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $message_retention_duration = null;
    /**
     * Output only. An output-only field indicating the state of the topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    private $state = 0;
    /**
     * Optional. Settings for ingestion from a data source into this topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $ingestion_data_source_settings = null;
    /**
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     *
     * Generated from protobuf field <code>repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $message_transforms;
    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     *   "123/environment": "production",
     *   "123/costCenter": "marketing"
     * See https://docs.cloud.google.com/pubsub/docs/tags for more information on
     * using tags with Pub/Sub resources.
     *
     * Generated from protobuf field <code>map<string, string> tags = 14 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $tags;

    /**
     * @param string $name Required. Identifier. The name of the topic. It must have the format
     *                     `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     *                     and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     *                     underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     *                     signs (`%`). It must be between 3 and 255 characters in length, and it
     *                     must not start with `"goog"`.
     *
     * @return \Google\Cloud\PubSub\V1\Topic
     *
     * @experimental
     */
    public static function build(string $name): self
    {
        return (new self())
            ->setName($name);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Required. Identifier. The name of the topic. It must have the format
     *           `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     *           and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     *           underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     *           signs (`%`). It must be between 3 and 255 characters in length, and it
     *           must not start with `"goog"`.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. See [Creating and managing labels]
     *           (https://cloud.google.com/pubsub/docs/labels).
     *     @type \Google\Cloud\PubSub\V1\MessageStoragePolicy $message_storage_policy
     *           Optional. Policy constraining the set of Google Cloud Platform regions
     *           where messages published to the topic may be stored. If not present, then
     *           no constraints are in effect.
     *     @type string $kms_key_name
     *           Optional. The resource name of the Cloud KMS CryptoKey to be used to
     *           protect access to messages published on this topic.
     *           The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     *     @type \Google\Cloud\PubSub\V1\SchemaSettings $schema_settings
     *           Optional. Settings for validating messages published against a schema.
     *     @type bool $satisfies_pzs
     *           Optional. Reserved for future use. This field is set only in responses from
     *           the server; it is ignored if it is set in any requests.
     *     @type \Google\Protobuf\Duration $message_retention_duration
     *           Optional. Indicates the minimum duration to retain a message after it is
     *           published to the topic. If this field is set, messages published to the
     *           topic in the last `message_retention_duration` are always available to
     *           subscribers. For instance, it allows any attached subscription to [seek to
     *           a
     *           timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     *           that is up to `message_retention_duration` in the past. If this field is
     *           not set, message retention is controlled by settings on individual
     *           subscriptions. Cannot be more than 31 days or less than 10 minutes.
     *     @type int $state
     *           Output only. An output-only field indicating the state of the topic.
     *     @type \Google\Cloud\PubSub\V1\IngestionDataSourceSettings $ingestion_data_source_settings
     *           Optional. Settings for ingestion from a data source into this topic.
     *     @type array<\Google\Cloud\PubSub\V1\MessageTransform>|\Google\Protobuf\Internal\RepeatedField $message_transforms
     *           Optional. Transforms to be applied to messages published to the topic.
     *           Transforms are applied in the order specified.
     *     @type array|\Google\Protobuf\Internal\MapField $tags
     *           Optional. Input only. Immutable. Tag keys/values directly bound to this
     *           resource. For example:
     *             "123/environment": "production",
     *             "123/costCenter": "marketing"
     *           See https://docs.cloud.google.com/pubsub/docs/tags for more information on
     *           using tags with Pub/Sub resources.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Pubsub\V1\Pubsub::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Identifier. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Required. Identifier. The name of the topic. It must have the format
     * `"projects/{project}/topics/{topic}"`. `{topic}` must start with a letter,
     * and contain only letters (`[A-Za-z]`), numbers (`[0-9]`), dashes (`-`),
     * underscores (`_`), periods (`.`), tildes (`~`), plus (`+`) or percent
     * signs (`%`). It must be between 3 and 255 characters in length, and it
     * must not start with `"goog"`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. See [Creating and managing labels]
     * (https://cloud.google.com/pubsub/docs/labels).
     *
     * Generated from protobuf field <code>map<string, string> labels = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\MessageStoragePolicy|null
     */
    public function getMessageStoragePolicy()
    {
        return $this->message_storage_policy;
    }

    public function hasMessageStoragePolicy()
    {
        return isset($this->message_storage_policy);
    }

    public function clearMessageStoragePolicy()
    {
        unset($this->message_storage_policy);
    }

    /**
     * Optional. Policy constraining the set of Google Cloud Platform regions
     * where messages published to the topic may be stored. If not present, then
     * no constraints are in effect.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.MessageStoragePolicy message_storage_policy = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\MessageStoragePolicy $var
     * @return $this
     */
    public function setMessageStoragePolicy($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\MessageStoragePolicy::class);
        $this->message_storage_policy = $var;

        return $this;
    }

    /**
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     *
     * Generated from protobuf field <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getKmsKeyName()
    {
        return $this->kms_key_name;
    }

    /**
     * Optional. The resource name of the Cloud KMS CryptoKey to be used to
     * protect access to messages published on this topic.
     * The expected format is `projects/&#42;&#47;locations/&#42;&#47;keyRings/&#42;&#47;cryptoKeys/&#42;`.
     *
     * Generated from protobuf field <code>string kms_key_name = 5 [(.google.api.field_behavior) = OPTIONAL, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setKmsKeyName($var)
    {
        GPBUtil::checkString($var, True);
        $this->kms_key_name = $var;

        return $this;
    }

    /**
     * Optional. Settings for validating messages published against a schema.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\SchemaSettings|null
     */
    public function getSchemaSettings()
    {
        return $this->schema_settings;
    }

    public function hasSchemaSettings()
    {
        return isset($this->schema_settings);
    }

    public function clearSchemaSettings()
    {
        unset($this->schema_settings);
    }

    /**
     * Optional. Settings for validating messages published against a schema.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.SchemaSettings schema_settings = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\SchemaSettings $var
     * @return $this
     */
    public function setSchemaSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\SchemaSettings::class);
        $this->schema_settings = $var;

        return $this;
    }

    /**
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getSatisfiesPzs()
    {
        return $this->satisfies_pzs;
    }

    /**
     * Optional. Reserved for future use. This field is set only in responses from
     * the server; it is ignored if it is set in any requests.
     *
     * Generated from protobuf field <code>bool satisfies_pzs = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setSatisfiesPzs($var)
    {
        GPBUtil::checkBool($var);
        $this->satisfies_pzs = $var;

        return $this;
    }

    /**
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getMessageRetentionDuration()
    {
        return $this->message_retention_duration;
    }

    public function hasMessageRetentionDuration()
    {
        return isset($this->message_retention_duration);
    }

    public function clearMessageRetentionDuration()
    {
        unset($this->message_retention_duration);
    }

    /**
     * Optional. Indicates the minimum duration to retain a message after it is
     * published to the topic. If this field is set, messages published to the
     * topic in the last `message_retention_duration` are always available to
     * subscribers. For instance, it allows any attached subscription to [seek to
     * a
     * timestamp](https://cloud.google.com/pubsub/docs/replay-overview#seek_to_a_time)
     * that is up to `message_retention_duration` in the past. If this field is
     * not set, message retention is controlled by settings on individual
     * subscriptions. Cannot be more than 31 days or less than 10 minutes.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration message_retention_duration = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setMessageRetentionDuration($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->message_retention_duration = $var;

        return $this;
    }

    /**
     * Output only. An output-only field indicating the state of the topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getState()
    {
        return $this->state;
    }

    /**
     * Output only. An output-only field indicating the state of the topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.Topic.State state = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\PubSub\V1\Topic\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. Settings for ingestion from a data source into this topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\PubSub\V1\IngestionDataSourceSettings|null
     */
    public function getIngestionDataSourceSettings()
    {
        return $this->ingestion_data_source_settings;
    }

    public function hasIngestionDataSourceSettings()
    {
        return isset($this->ingestion_data_source_settings);
    }

    public function clearIngestionDataSourceSettings()
    {
        unset($this->ingestion_data_source_settings);
    }

    /**
     * Optional. Settings for ingestion from a data source into this topic.
     *
     * Generated from protobuf field <code>.google.pubsub.v1.IngestionDataSourceSettings ingestion_data_source_settings = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\PubSub\V1\IngestionDataSourceSettings $var
     * @return $this
     */
    public function setIngestionDataSourceSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\PubSub\V1\IngestionDataSourceSettings::class);
        $this->ingestion_data_source_settings = $var;

        return $this;
    }

    /**
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     *
     * Generated from protobuf field <code>repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMessageTransforms()
    {
        return $this->message_transforms;
    }

    /**
     * Optional. Transforms to be applied to messages published to the topic.
     * Transforms are applied in the order specified.
     *
     * Generated from protobuf field <code>repeated .google.pubsub.v1.MessageTransform message_transforms = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\PubSub\V1\MessageTransform>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMessageTransforms($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\PubSub\V1\MessageTransform::class);
        $this->message_transforms = $arr;

        return $this;
    }

    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     *   "123/environment": "production",
     *   "123/costCenter": "marketing"
     * See https://docs.cloud.google.com/pubsub/docs/tags for more information on
     * using tags with Pub/Sub resources.
     *
     * Generated from protobuf field <code>map<string, string> tags = 14 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getTags()
    {
        return $this->tags;
    }

    /**
     * Optional. Input only. Immutable. Tag keys/values directly bound to this
     * resource. For example:
     *   "123/environment": "production",
     *   "123/costCenter": "marketing"
     * See https://docs.cloud.google.com/pubsub/docs/tags for more information on
     * using tags with Pub/Sub resources.
     *
     * Generated from protobuf field <code>map<string, string> tags = 14 [(.google.api.field_behavior) = INPUT_ONLY, (.google.api.field_behavior) = IMMUTABLE, (.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setTags($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->tags = $arr;

        return $this;
    }

}

