<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/privilegedaccessmanager/v1/privilegedaccessmanager.proto

namespace Google\Cloud\PrivilegedAccessManager\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A manual approval workflow where users who are designated as approvers
 * need to call the `ApproveGrant`/`DenyGrant` APIs for a grant. The workflow
 * can consist of multiple serial steps where each step defines who can act as
 * approver in that step and how many of those users should approve before the
 * workflow moves to the next step.
 * This can be used to create approval workflows such as:
 * * Require an approval from any user in a group G.
 * * Require an approval from any k number of users from a Group G.
 * * Require an approval from any user in a group G and then from a user U.
 * A single user might be part of the `approvers` ACL for multiple steps in this
 * workflow, but they can only approve once and that approval is only considered
 * to satisfy the approval step at which it was granted.
 *
 * Generated from protobuf message <code>google.cloud.privilegedaccessmanager.v1.ManualApprovals</code>
 */
class ManualApprovals extends \Google\Protobuf\Internal\Message
{
    /**
     * Optional. Do the approvers need to provide a justification for their
     * actions?
     *
     * Generated from protobuf field <code>bool require_approver_justification = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $require_approver_justification = false;
    /**
     * Optional. List of approval steps in this workflow. These steps are followed
     * in the specified order sequentially. Only 1 step is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step steps = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $steps;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type bool $require_approver_justification
     *           Optional. Do the approvers need to provide a justification for their
     *           actions?
     *     @type array<\Google\Cloud\PrivilegedAccessManager\V1\ManualApprovals\Step>|\Google\Protobuf\Internal\RepeatedField $steps
     *           Optional. List of approval steps in this workflow. These steps are followed
     *           in the specified order sequentially. Only 1 step is supported.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Privilegedaccessmanager\V1\Privilegedaccessmanager::initOnce();
        parent::__construct($data);
    }

    /**
     * Optional. Do the approvers need to provide a justification for their
     * actions?
     *
     * Generated from protobuf field <code>bool require_approver_justification = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return bool
     */
    public function getRequireApproverJustification()
    {
        return $this->require_approver_justification;
    }

    /**
     * Optional. Do the approvers need to provide a justification for their
     * actions?
     *
     * Generated from protobuf field <code>bool require_approver_justification = 1 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param bool $var
     * @return $this
     */
    public function setRequireApproverJustification($var)
    {
        GPBUtil::checkBool($var);
        $this->require_approver_justification = $var;

        return $this;
    }

    /**
     * Optional. List of approval steps in this workflow. These steps are followed
     * in the specified order sequentially. Only 1 step is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step steps = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getSteps()
    {
        return $this->steps;
    }

    /**
     * Optional. List of approval steps in this workflow. These steps are followed
     * in the specified order sequentially. Only 1 step is supported.
     *
     * Generated from protobuf field <code>repeated .google.cloud.privilegedaccessmanager.v1.ManualApprovals.Step steps = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\PrivilegedAccessManager\V1\ManualApprovals\Step>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setSteps($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\PrivilegedAccessManager\V1\ManualApprovals\Step::class);
        $this->steps = $arr;

        return $this;
    }

}

