<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/osconfig/v1/vulnerability.proto

namespace Google\Cloud\OsConfig\V1\VulnerabilityReport\Vulnerability;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * OS inventory item that is affected by a vulnerability or fixed as a
 * result of a vulnerability.
 *
 * Generated from protobuf message <code>google.cloud.osconfig.v1.VulnerabilityReport.Vulnerability.Item</code>
 */
class Item extends \Google\Protobuf\Internal\Message
{
    /**
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some
     * operating systems, this field might be empty.
     *
     * Generated from protobuf field <code>string installed_inventory_item_id = 1;</code>
     */
    protected $installed_inventory_item_id = '';
    /**
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     *
     * Generated from protobuf field <code>string available_inventory_item_id = 2;</code>
     */
    protected $available_inventory_item_id = '';
    /**
     * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
     * that contains a fix for this vulnerability.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 3;</code>
     */
    protected $fixed_cpe_uri = '';
    /**
     * The upstream OS patch, packages or KB that fixes the vulnerability.
     *
     * Generated from protobuf field <code>string upstream_fix = 4;</code>
     */
    protected $upstream_fix = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $installed_inventory_item_id
     *           Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     *           This field displays the inventory items affected by this vulnerability.
     *           If the vulnerability report was not updated after the VM inventory
     *           update, these values might not display in VM inventory. For some
     *           operating systems, this field might be empty.
     *     @type string $available_inventory_item_id
     *           Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     *           If the vulnerability report was not updated after the VM inventory
     *           update, these values might not display in VM inventory. If there is no
     *           available fix, the field is empty. The `inventory_item` value specifies
     *           the latest `SoftwarePackage` available to the VM that fixes the
     *           vulnerability.
     *     @type string $fixed_cpe_uri
     *           The recommended [CPE URI](https://cpe.mitre.org/specification/) update
     *           that contains a fix for this vulnerability.
     *     @type string $upstream_fix
     *           The upstream OS patch, packages or KB that fixes the vulnerability.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Osconfig\V1\Vulnerability::initOnce();
        parent::__construct($data);
    }

    /**
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some
     * operating systems, this field might be empty.
     *
     * Generated from protobuf field <code>string installed_inventory_item_id = 1;</code>
     * @return string
     */
    public function getInstalledInventoryItemId()
    {
        return $this->installed_inventory_item_id;
    }

    /**
     * Corresponds to the `INSTALLED_PACKAGE` inventory item on the VM.
     * This field displays the inventory items affected by this vulnerability.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. For some
     * operating systems, this field might be empty.
     *
     * Generated from protobuf field <code>string installed_inventory_item_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setInstalledInventoryItemId($var)
    {
        GPBUtil::checkString($var, True);
        $this->installed_inventory_item_id = $var;

        return $this;
    }

    /**
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     *
     * Generated from protobuf field <code>string available_inventory_item_id = 2;</code>
     * @return string
     */
    public function getAvailableInventoryItemId()
    {
        return $this->available_inventory_item_id;
    }

    /**
     * Corresponds to the `AVAILABLE_PACKAGE` inventory item on the VM.
     * If the vulnerability report was not updated after the VM inventory
     * update, these values might not display in VM inventory. If there is no
     * available fix, the field is empty. The `inventory_item` value specifies
     * the latest `SoftwarePackage` available to the VM that fixes the
     * vulnerability.
     *
     * Generated from protobuf field <code>string available_inventory_item_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setAvailableInventoryItemId($var)
    {
        GPBUtil::checkString($var, True);
        $this->available_inventory_item_id = $var;

        return $this;
    }

    /**
     * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
     * that contains a fix for this vulnerability.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 3;</code>
     * @return string
     */
    public function getFixedCpeUri()
    {
        return $this->fixed_cpe_uri;
    }

    /**
     * The recommended [CPE URI](https://cpe.mitre.org/specification/) update
     * that contains a fix for this vulnerability.
     *
     * Generated from protobuf field <code>string fixed_cpe_uri = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setFixedCpeUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->fixed_cpe_uri = $var;

        return $this;
    }

    /**
     * The upstream OS patch, packages or KB that fixes the vulnerability.
     *
     * Generated from protobuf field <code>string upstream_fix = 4;</code>
     * @return string
     */
    public function getUpstreamFix()
    {
        return $this->upstream_fix;
    }

    /**
     * The upstream OS patch, packages or KB that fixes the vulnerability.
     *
     * Generated from protobuf field <code>string upstream_fix = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setUpstreamFix($var)
    {
        GPBUtil::checkString($var, True);
        $this->upstream_fix = $var;

        return $this;
    }

}


