<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networksecurity/v1/address_group.proto

namespace Google\Cloud\NetworkSecurity\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Request used by the CreateAddressGroup method.
 *
 * Generated from protobuf message <code>google.cloud.networksecurity.v1.CreateAddressGroupRequest</code>
 */
class CreateAddressGroupRequest extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The parent resource of the AddressGroup. Must be in the
     * format `projects/&#42;&#47;locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     */
    protected $parent = '';
    /**
     * Required. Short name of the AddressGroup resource to be created.
     * This value should be 1-63 characters long, containing only
     * letters, numbers, hyphens, and underscores, and should not start
     * with a number. E.g. "authz_policy".
     *
     * Generated from protobuf field <code>string address_group_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $address_group_id = '';
    /**
     * Required. AddressGroup resource to be created.
     *
     * Generated from protobuf field <code>.google.cloud.networksecurity.v1.AddressGroup address_group = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $address_group = null;
    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $request_id = '';

    /**
     * @param string                                        $parent         Required. The parent resource of the AddressGroup. Must be in the
     *                                                                      format `projects/&#42;/locations/{location}`. Please see
     *                                                                      {@see AddressGroupServiceClient::organizationLocationName()} for help formatting this field.
     * @param \Google\Cloud\NetworkSecurity\V1\AddressGroup $addressGroup   Required. AddressGroup resource to be created.
     * @param string                                        $addressGroupId Required. Short name of the AddressGroup resource to be created.
     *                                                                      This value should be 1-63 characters long, containing only
     *                                                                      letters, numbers, hyphens, and underscores, and should not start
     *                                                                      with a number. E.g. "authz_policy".
     *
     * @return \Google\Cloud\NetworkSecurity\V1\CreateAddressGroupRequest
     *
     * @experimental
     */
    public static function build(string $parent, \Google\Cloud\NetworkSecurity\V1\AddressGroup $addressGroup, string $addressGroupId): self
    {
        return (new self())
            ->setParent($parent)
            ->setAddressGroup($addressGroup)
            ->setAddressGroupId($addressGroupId);
    }

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $parent
     *           Required. The parent resource of the AddressGroup. Must be in the
     *           format `projects/&#42;&#47;locations/{location}`.
     *     @type string $address_group_id
     *           Required. Short name of the AddressGroup resource to be created.
     *           This value should be 1-63 characters long, containing only
     *           letters, numbers, hyphens, and underscores, and should not start
     *           with a number. E.g. "authz_policy".
     *     @type \Google\Cloud\NetworkSecurity\V1\AddressGroup $address_group
     *           Required. AddressGroup resource to be created.
     *     @type string $request_id
     *           Optional. An optional request ID to identify requests. Specify a unique
     *           request ID so that if you must retry your request, the server will know to
     *           ignore the request if it has already been completed. The server will
     *           guarantee that for at least 60 minutes since the first request.
     *           For example, consider a situation where you make an initial request and
     *           the request times out. If you make the request again with the same request
     *           ID, the server can check if original operation with the same request ID
     *           was received, and if so, will ignore the second request. This prevents
     *           clients from accidentally creating duplicate commitments.
     *           The request ID must be a valid UUID with the exception that zero UUID is
     *           not supported (00000000-0000-0000-0000-000000000000).
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networksecurity\V1\AddressGroup::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The parent resource of the AddressGroup. Must be in the
     * format `projects/&#42;&#47;locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getParent()
    {
        return $this->parent;
    }

    /**
     * Required. The parent resource of the AddressGroup. Must be in the
     * format `projects/&#42;&#47;locations/{location}`.
     *
     * Generated from protobuf field <code>string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setParent($var)
    {
        GPBUtil::checkString($var, True);
        $this->parent = $var;

        return $this;
    }

    /**
     * Required. Short name of the AddressGroup resource to be created.
     * This value should be 1-63 characters long, containing only
     * letters, numbers, hyphens, and underscores, and should not start
     * with a number. E.g. "authz_policy".
     *
     * Generated from protobuf field <code>string address_group_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getAddressGroupId()
    {
        return $this->address_group_id;
    }

    /**
     * Required. Short name of the AddressGroup resource to be created.
     * This value should be 1-63 characters long, containing only
     * letters, numbers, hyphens, and underscores, and should not start
     * with a number. E.g. "authz_policy".
     *
     * Generated from protobuf field <code>string address_group_id = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setAddressGroupId($var)
    {
        GPBUtil::checkString($var, True);
        $this->address_group_id = $var;

        return $this;
    }

    /**
     * Required. AddressGroup resource to be created.
     *
     * Generated from protobuf field <code>.google.cloud.networksecurity.v1.AddressGroup address_group = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\NetworkSecurity\V1\AddressGroup|null
     */
    public function getAddressGroup()
    {
        return $this->address_group;
    }

    public function hasAddressGroup()
    {
        return isset($this->address_group);
    }

    public function clearAddressGroup()
    {
        unset($this->address_group);
    }

    /**
     * Required. AddressGroup resource to be created.
     *
     * Generated from protobuf field <code>.google.cloud.networksecurity.v1.AddressGroup address_group = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\NetworkSecurity\V1\AddressGroup $var
     * @return $this
     */
    public function setAddressGroup($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\NetworkSecurity\V1\AddressGroup::class);
        $this->address_group = $var;

        return $this;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * Optional. An optional request ID to identify requests. Specify a unique
     * request ID so that if you must retry your request, the server will know to
     * ignore the request if it has already been completed. The server will
     * guarantee that for at least 60 minutes since the first request.
     * For example, consider a situation where you make an initial request and
     * the request times out. If you make the request again with the same request
     * ID, the server can check if original operation with the same request ID
     * was received, and if so, will ignore the second request. This prevents
     * clients from accidentally creating duplicate commitments.
     * The request ID must be a valid UUID with the exception that zero UUID is
     * not supported (00000000-0000-0000-0000-000000000000).
     *
     * Generated from protobuf field <code>string request_id = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

}

