<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/networkmanagement/v1/vpc_flow_logs_config.proto

namespace Google\Cloud\NetworkManagement\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * A configuration to generate VPC Flow Logs.
 *
 * Generated from protobuf message <code>google.cloud.networkmanagement.v1.VpcFlowLogsConfig</code>
 */
class VpcFlowLogsConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. Unique name of the configuration. The name can have one of the
     * following forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Optional. The user-supplied description of the VPC Flow Logs configuration.
     * Maximum of 512 characters.
     *
     * Generated from protobuf field <code>optional string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $description = null;
    /**
     * Optional. The state of the VPC Flow Log configuration. Default value is
     * ENABLED. When creating a new configuration, it must be enabled. Setting
     * state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $state = null;
    /**
     * Optional. The aggregation interval for the logs. Default value is
     * INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $aggregation_interval = null;
    /**
     * Optional. The value of the field must be in (0, 1]. The sampling rate of
     * VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
     * sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs,
     * use the state field instead. Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $flow_sampling = null;
    /**
     * Optional. Configures whether all, none or a subset of metadata fields
     * should be added to the reported VPC flow logs. Default value is
     * INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $metadata = null;
    /**
     * Optional. Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $metadata_fields;
    /**
     * Optional. Export filter used to define which VPC Flow Logs should be
     * logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $filter_expr = null;
    /**
     * Optional. Determines whether to include cross project annotations in the
     * logs. This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $cross_project_metadata = null;
    /**
     * Output only. Describes the state of the configured target resource for
     * diagnostic purposes.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.TargetResourceState target_resource_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $target_resource_state = null;
    /**
     * Optional. Resource labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. The time the config was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The time the config was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    protected $target_resource;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           Identifier. Unique name of the configuration. The name can have one of the
     *           following forms:
     *           - For project-level configurations:
     *           `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *           - For organization-level configurations:
     *           `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *     @type string $description
     *           Optional. The user-supplied description of the VPC Flow Logs configuration.
     *           Maximum of 512 characters.
     *     @type int $state
     *           Optional. The state of the VPC Flow Log configuration. Default value is
     *           ENABLED. When creating a new configuration, it must be enabled. Setting
     *           state=DISABLED will pause the log generation for this config.
     *     @type int $aggregation_interval
     *           Optional. The aggregation interval for the logs. Default value is
     *           INTERVAL_5_SEC.
     *     @type float $flow_sampling
     *           Optional. The value of the field must be in (0, 1]. The sampling rate of
     *           VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
     *           sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs,
     *           use the state field instead. Default value is 1.0.
     *     @type int $metadata
     *           Optional. Configures whether all, none or a subset of metadata fields
     *           should be added to the reported VPC flow logs. Default value is
     *           INCLUDE_ALL_METADATA.
     *     @type array<string>|\Google\Protobuf\Internal\RepeatedField $metadata_fields
     *           Optional. Custom metadata fields to include in the reported VPC flow logs.
     *           Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *     @type string $filter_expr
     *           Optional. Export filter used to define which VPC Flow Logs should be
     *           logged.
     *     @type int $cross_project_metadata
     *           Optional. Determines whether to include cross project annotations in the
     *           logs. This field is available only for organization configurations. If not
     *           specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *     @type int $target_resource_state
     *           Output only. Describes the state of the configured target resource for
     *           diagnostic purposes.
     *     @type string $network
     *           Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     *           within the network.
     *           Format: projects/{project_id}/global/networks/{name}
     *     @type string $subnet
     *           Traffic will be logged from VMs within the subnetwork.
     *           Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *     @type string $interconnect_attachment
     *           Traffic will be logged from the Interconnect Attachment.
     *           Format:
     *           projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *     @type string $vpn_tunnel
     *           Traffic will be logged from the VPN Tunnel.
     *           Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Resource labels to represent user-provided metadata.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The time the config was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The time the config was updated.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Networkmanagement\V1\VpcFlowLogsConfig::initOnce();
        parent::__construct($data);
    }

    /**
     * Identifier. Unique name of the configuration. The name can have one of the
     * following forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. Unique name of the configuration. The name can have one of the
     * following forms:
     * - For project-level configurations:
     * `projects/{project_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     * - For organization-level configurations:
     * `organizations/{organization_id}/locations/global/vpcFlowLogsConfigs/{vpc_flow_logs_config_id}`
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Optional. The user-supplied description of the VPC Flow Logs configuration.
     * Maximum of 512 characters.
     *
     * Generated from protobuf field <code>optional string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getDescription()
    {
        return isset($this->description) ? $this->description : '';
    }

    public function hasDescription()
    {
        return isset($this->description);
    }

    public function clearDescription()
    {
        unset($this->description);
    }

    /**
     * Optional. The user-supplied description of the VPC Flow Logs configuration.
     * Maximum of 512 characters.
     *
     * Generated from protobuf field <code>optional string description = 2 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setDescription($var)
    {
        GPBUtil::checkString($var, True);
        $this->description = $var;

        return $this;
    }

    /**
     * Optional. The state of the VPC Flow Log configuration. Default value is
     * ENABLED. When creating a new configuration, it must be enabled. Setting
     * state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getState()
    {
        return isset($this->state) ? $this->state : 0;
    }

    public function hasState()
    {
        return isset($this->state);
    }

    public function clearState()
    {
        unset($this->state);
    }

    /**
     * Optional. The state of the VPC Flow Log configuration. Default value is
     * ENABLED. When creating a new configuration, it must be enabled. Setting
     * state=DISABLED will pause the log generation for this config.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.State state = 3 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\State::class);
        $this->state = $var;

        return $this;
    }

    /**
     * Optional. The aggregation interval for the logs. Default value is
     * INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getAggregationInterval()
    {
        return isset($this->aggregation_interval) ? $this->aggregation_interval : 0;
    }

    public function hasAggregationInterval()
    {
        return isset($this->aggregation_interval);
    }

    public function clearAggregationInterval()
    {
        unset($this->aggregation_interval);
    }

    /**
     * Optional. The aggregation interval for the logs. Default value is
     * INTERVAL_5_SEC.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.AggregationInterval aggregation_interval = 4 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setAggregationInterval($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\AggregationInterval::class);
        $this->aggregation_interval = $var;

        return $this;
    }

    /**
     * Optional. The value of the field must be in (0, 1]. The sampling rate of
     * VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
     * sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs,
     * use the state field instead. Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return float
     */
    public function getFlowSampling()
    {
        return isset($this->flow_sampling) ? $this->flow_sampling : 0.0;
    }

    public function hasFlowSampling()
    {
        return isset($this->flow_sampling);
    }

    public function clearFlowSampling()
    {
        unset($this->flow_sampling);
    }

    /**
     * Optional. The value of the field must be in (0, 1]. The sampling rate of
     * VPC Flow Logs where 1.0 means all collected logs are reported. Setting the
     * sampling rate to 0.0 is not allowed. If you want to disable VPC Flow Logs,
     * use the state field instead. Default value is 1.0.
     *
     * Generated from protobuf field <code>optional float flow_sampling = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param float $var
     * @return $this
     */
    public function setFlowSampling($var)
    {
        GPBUtil::checkFloat($var);
        $this->flow_sampling = $var;

        return $this;
    }

    /**
     * Optional. Configures whether all, none or a subset of metadata fields
     * should be added to the reported VPC flow logs. Default value is
     * INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getMetadata()
    {
        return isset($this->metadata) ? $this->metadata : 0;
    }

    public function hasMetadata()
    {
        return isset($this->metadata);
    }

    public function clearMetadata()
    {
        unset($this->metadata);
    }

    /**
     * Optional. Configures whether all, none or a subset of metadata fields
     * should be added to the reported VPC flow logs. Default value is
     * INCLUDE_ALL_METADATA.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.Metadata metadata = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setMetadata($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\Metadata::class);
        $this->metadata = $var;

        return $this;
    }

    /**
     * Optional. Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getMetadataFields()
    {
        return $this->metadata_fields;
    }

    /**
     * Optional. Custom metadata fields to include in the reported VPC flow logs.
     * Can only be specified if "metadata" was set to CUSTOM_METADATA.
     *
     * Generated from protobuf field <code>repeated string metadata_fields = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<string>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setMetadataFields($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::STRING);
        $this->metadata_fields = $arr;

        return $this;
    }

    /**
     * Optional. Export filter used to define which VPC Flow Logs should be
     * logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getFilterExpr()
    {
        return isset($this->filter_expr) ? $this->filter_expr : '';
    }

    public function hasFilterExpr()
    {
        return isset($this->filter_expr);
    }

    public function clearFilterExpr()
    {
        unset($this->filter_expr);
    }

    /**
     * Optional. Export filter used to define which VPC Flow Logs should be
     * logged.
     *
     * Generated from protobuf field <code>optional string filter_expr = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setFilterExpr($var)
    {
        GPBUtil::checkString($var, True);
        $this->filter_expr = $var;

        return $this;
    }

    /**
     * Optional. Determines whether to include cross project annotations in the
     * logs. This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return int
     */
    public function getCrossProjectMetadata()
    {
        return isset($this->cross_project_metadata) ? $this->cross_project_metadata : 0;
    }

    public function hasCrossProjectMetadata()
    {
        return isset($this->cross_project_metadata);
    }

    public function clearCrossProjectMetadata()
    {
        unset($this->cross_project_metadata);
    }

    /**
     * Optional. Determines whether to include cross project annotations in the
     * logs. This field is available only for organization configurations. If not
     * specified in org configs will be set to CROSS_PROJECT_METADATA_ENABLED.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.CrossProjectMetadata cross_project_metadata = 13 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param int $var
     * @return $this
     */
    public function setCrossProjectMetadata($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\CrossProjectMetadata::class);
        $this->cross_project_metadata = $var;

        return $this;
    }

    /**
     * Output only. Describes the state of the configured target resource for
     * diagnostic purposes.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.TargetResourceState target_resource_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return int
     */
    public function getTargetResourceState()
    {
        return isset($this->target_resource_state) ? $this->target_resource_state : 0;
    }

    public function hasTargetResourceState()
    {
        return isset($this->target_resource_state);
    }

    public function clearTargetResourceState()
    {
        unset($this->target_resource_state);
    }

    /**
     * Output only. Describes the state of the configured target resource for
     * diagnostic purposes.
     *
     * Generated from protobuf field <code>optional .google.cloud.networkmanagement.v1.VpcFlowLogsConfig.TargetResourceState target_resource_state = 12 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param int $var
     * @return $this
     */
    public function setTargetResourceState($var)
    {
        GPBUtil::checkEnum($var, \Google\Cloud\NetworkManagement\V1\VpcFlowLogsConfig\TargetResourceState::class);
        $this->target_resource_state = $var;

        return $this;
    }

    /**
     * Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     * within the network.
     * Format: projects/{project_id}/global/networks/{name}
     *
     * Generated from protobuf field <code>string network = 100;</code>
     * @return string
     */
    public function getNetwork()
    {
        return $this->readOneof(100);
    }

    public function hasNetwork()
    {
        return $this->hasOneof(100);
    }

    /**
     * Traffic will be logged from VMs, VPN tunnels and Interconnect Attachments
     * within the network.
     * Format: projects/{project_id}/global/networks/{name}
     *
     * Generated from protobuf field <code>string network = 100;</code>
     * @param string $var
     * @return $this
     */
    public function setNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(100, $var);

        return $this;
    }

    /**
     * Traffic will be logged from VMs within the subnetwork.
     * Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *
     * Generated from protobuf field <code>string subnet = 101;</code>
     * @return string
     */
    public function getSubnet()
    {
        return $this->readOneof(101);
    }

    public function hasSubnet()
    {
        return $this->hasOneof(101);
    }

    /**
     * Traffic will be logged from VMs within the subnetwork.
     * Format: projects/{project_id}/regions/{region}/subnetworks/{name}
     *
     * Generated from protobuf field <code>string subnet = 101;</code>
     * @param string $var
     * @return $this
     */
    public function setSubnet($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(101, $var);

        return $this;
    }

    /**
     * Traffic will be logged from the Interconnect Attachment.
     * Format:
     * projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *
     * Generated from protobuf field <code>string interconnect_attachment = 102;</code>
     * @return string
     */
    public function getInterconnectAttachment()
    {
        return $this->readOneof(102);
    }

    public function hasInterconnectAttachment()
    {
        return $this->hasOneof(102);
    }

    /**
     * Traffic will be logged from the Interconnect Attachment.
     * Format:
     * projects/{project_id}/regions/{region}/interconnectAttachments/{name}
     *
     * Generated from protobuf field <code>string interconnect_attachment = 102;</code>
     * @param string $var
     * @return $this
     */
    public function setInterconnectAttachment($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(102, $var);

        return $this;
    }

    /**
     * Traffic will be logged from the VPN Tunnel.
     * Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *
     * Generated from protobuf field <code>string vpn_tunnel = 103;</code>
     * @return string
     */
    public function getVpnTunnel()
    {
        return $this->readOneof(103);
    }

    public function hasVpnTunnel()
    {
        return $this->hasOneof(103);
    }

    /**
     * Traffic will be logged from the VPN Tunnel.
     * Format: projects/{project_id}/regions/{region}/vpnTunnels/{name}
     *
     * Generated from protobuf field <code>string vpn_tunnel = 103;</code>
     * @param string $var
     * @return $this
     */
    public function setVpnTunnel($var)
    {
        GPBUtil::checkString($var, True);
        $this->writeOneof(103, $var);

        return $this;
    }

    /**
     * Optional. Resource labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Resource labels to represent user-provided metadata.
     *
     * Generated from protobuf field <code>map<string, string> labels = 11 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. The time the config was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The time the config was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 9 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The time the config was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The time the config was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getTargetResource()
    {
        return $this->whichOneof("target_resource");
    }

}

