<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/clouddms/v1/clouddms_resources.proto

namespace Google\Cloud\CloudDms\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Settings for creating an AlloyDB cluster.
 *
 * Generated from protobuf message <code>google.cloud.clouddms.v1.AlloyDbSettings</code>
 */
class AlloyDbSettings extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     */
    protected $initial_user = null;
    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     *
     * Generated from protobuf field <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $vpc_network = '';
    /**
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     */
    private $labels;
    /**
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;</code>
     */
    protected $primary_instance_settings = null;
    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $encryption_config = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\CloudDms\V1\AlloyDbSettings\UserPassword $initial_user
     *           Required. Input only. Initial user to setup during cluster creation.
     *           Required.
     *     @type string $vpc_network
     *           Required. The resource link for the VPC network in which cluster resources
     *           are created and from which they are accessible via Private IP. The network
     *           must belong to the same project as the cluster. It is specified in the
     *           form: "projects/{project_number}/global/networks/{network_id}". This is
     *           required to create a cluster.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Labels for the AlloyDB cluster created by DMS. An object containing a list
     *           of 'key', 'value' pairs.
     *     @type \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings $primary_instance_settings
     *     @type \Google\Cloud\CloudDms\V1\AlloyDbSettings\EncryptionConfig $encryption_config
     *           Optional. The encryption config can be specified to encrypt the data disks
     *           and other persistent data resources of a cluster with a
     *           customer-managed encryption key (CMEK). When this field is not
     *           specified, the cluster will then use default encryption scheme to
     *           protect the user data.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Clouddms\V1\ClouddmsResources::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @return \Google\Cloud\CloudDms\V1\AlloyDbSettings\UserPassword|null
     */
    public function getInitialUser()
    {
        return $this->initial_user;
    }

    public function hasInitialUser()
    {
        return isset($this->initial_user);
    }

    public function clearInitialUser()
    {
        unset($this->initial_user);
    }

    /**
     * Required. Input only. Initial user to setup during cluster creation.
     * Required.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.UserPassword initial_user = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = INPUT_ONLY];</code>
     * @param \Google\Cloud\CloudDms\V1\AlloyDbSettings\UserPassword $var
     * @return $this
     */
    public function setInitialUser($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\AlloyDbSettings\UserPassword::class);
        $this->initial_user = $var;

        return $this;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     *
     * Generated from protobuf field <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getVpcNetwork()
    {
        return $this->vpc_network;
    }

    /**
     * Required. The resource link for the VPC network in which cluster resources
     * are created and from which they are accessible via Private IP. The network
     * must belong to the same project as the cluster. It is specified in the
     * form: "projects/{project_number}/global/networks/{network_id}". This is
     * required to create a cluster.
     *
     * Generated from protobuf field <code>string vpc_network = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setVpcNetwork($var)
    {
        GPBUtil::checkString($var, True);
        $this->vpc_network = $var;

        return $this;
    }

    /**
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Labels for the AlloyDB cluster created by DMS. An object containing a list
     * of 'key', 'value' pairs.
     *
     * Generated from protobuf field <code>map<string, string> labels = 3;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;</code>
     * @return \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings|null
     */
    public function getPrimaryInstanceSettings()
    {
        return $this->primary_instance_settings;
    }

    public function hasPrimaryInstanceSettings()
    {
        return isset($this->primary_instance_settings);
    }

    public function clearPrimaryInstanceSettings()
    {
        unset($this->primary_instance_settings);
    }

    /**
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.PrimaryInstanceSettings primary_instance_settings = 4;</code>
     * @param \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings $var
     * @return $this
     */
    public function setPrimaryInstanceSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\AlloyDbSettings\PrimaryInstanceSettings::class);
        $this->primary_instance_settings = $var;

        return $this;
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Cloud\CloudDms\V1\AlloyDbSettings\EncryptionConfig|null
     */
    public function getEncryptionConfig()
    {
        return $this->encryption_config;
    }

    public function hasEncryptionConfig()
    {
        return isset($this->encryption_config);
    }

    public function clearEncryptionConfig()
    {
        unset($this->encryption_config);
    }

    /**
     * Optional. The encryption config can be specified to encrypt the data disks
     * and other persistent data resources of a cluster with a
     * customer-managed encryption key (CMEK). When this field is not
     * specified, the cluster will then use default encryption scheme to
     * protect the user data.
     *
     * Generated from protobuf field <code>.google.cloud.clouddms.v1.AlloyDbSettings.EncryptionConfig encryption_config = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param \Google\Cloud\CloudDms\V1\AlloyDbSettings\EncryptionConfig $var
     * @return $this
     */
    public function setEncryptionConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\CloudDms\V1\AlloyDbSettings\EncryptionConfig::class);
        $this->encryption_config = $var;

        return $this;
    }

}

