<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/dialogflow/cx/v3/generator.proto

namespace Google\Cloud\Dialogflow\Cx\V3;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Generators contain prompt to be sent to the LLM model to generate text. The
 * prompt can contain parameters which will be resolved before calling the
 * model. It can optionally contain banned phrases to ensure the model responses
 * are safe.
 *
 * Generated from protobuf message <code>google.cloud.dialogflow.cx.v3.Generator</code>
 */
class Generator extends \Google\Protobuf\Internal\Message
{
    /**
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     */
    protected $name = '';
    /**
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $display_name = '';
    /**
     * Required. Prompt for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $prompt_text = null;
    /**
     * Optional. List of custom placeholders in the prompt text.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $placeholders;
    /**
     * The LLM model settings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 9;</code>
     */
    protected $llm_model_settings = null;
    /**
     * Parameters passed to the LLM to configure its behavior.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Generator.ModelParameter model_parameter = 8;</code>
     */
    protected $model_parameter = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $name
     *           The unique identifier of the generator.
     *           Must be set for the
     *           [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator]
     *           method. [Generators.CreateGenerate][] populates the name automatically.
     *           Format:
     *           `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
     *     @type string $display_name
     *           Required. The human-readable name of the generator, unique within the
     *           agent. The prompt contains pre-defined parameters such as $conversation,
     *           $last-user-utterance, etc. populated by Dialogflow. It can also contain
     *           custom placeholders which will be resolved during fulfillment.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Phrase $prompt_text
     *           Required. Prompt for the LLM model.
     *     @type array<\Google\Cloud\Dialogflow\Cx\V3\Generator\Placeholder>|\Google\Protobuf\Internal\RepeatedField $placeholders
     *           Optional. List of custom placeholders in the prompt text.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings $llm_model_settings
     *           The LLM model settings.
     *     @type \Google\Cloud\Dialogflow\Cx\V3\Generator\ModelParameter $model_parameter
     *           Parameters passed to the LLM to configure its behavior.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Dialogflow\Cx\V3\Generator::initOnce();
        parent::__construct($data);
    }

    /**
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * The unique identifier of the generator.
     * Must be set for the
     * [Generators.UpdateGenerator][google.cloud.dialogflow.cx.v3.Generators.UpdateGenerator]
     * method. [Generators.CreateGenerate][] populates the name automatically.
     * Format:
     * `projects/<ProjectID>/locations/<LocationID>/agents/<AgentID>/generators/<GeneratorID>`.
     *
     * Generated from protobuf field <code>string name = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getDisplayName()
    {
        return $this->display_name;
    }

    /**
     * Required. The human-readable name of the generator, unique within the
     * agent. The prompt contains pre-defined parameters such as $conversation,
     * $last-user-utterance, etc. populated by Dialogflow. It can also contain
     * custom placeholders which will be resolved during fulfillment.
     *
     * Generated from protobuf field <code>string display_name = 2 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setDisplayName($var)
    {
        GPBUtil::checkString($var, True);
        $this->display_name = $var;

        return $this;
    }

    /**
     * Required. Prompt for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Phrase|null
     */
    public function getPromptText()
    {
        return $this->prompt_text;
    }

    public function hasPromptText()
    {
        return isset($this->prompt_text);
    }

    public function clearPromptText()
    {
        unset($this->prompt_text);
    }

    /**
     * Required. Prompt for the LLM model.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Phrase prompt_text = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Phrase $var
     * @return $this
     */
    public function setPromptText($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Phrase::class);
        $this->prompt_text = $var;

        return $this;
    }

    /**
     * Optional. List of custom placeholders in the prompt text.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\RepeatedField
     */
    public function getPlaceholders()
    {
        return $this->placeholders;
    }

    /**
     * Optional. List of custom placeholders in the prompt text.
     *
     * Generated from protobuf field <code>repeated .google.cloud.dialogflow.cx.v3.Generator.Placeholder placeholders = 5 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array<\Google\Cloud\Dialogflow\Cx\V3\Generator\Placeholder>|\Google\Protobuf\Internal\RepeatedField $var
     * @return $this
     */
    public function setPlaceholders($var)
    {
        $arr = GPBUtil::checkRepeatedField($var, \Google\Protobuf\Internal\GPBType::MESSAGE, \Google\Cloud\Dialogflow\Cx\V3\Generator\Placeholder::class);
        $this->placeholders = $arr;

        return $this;
    }

    /**
     * The LLM model settings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 9;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings|null
     */
    public function getLlmModelSettings()
    {
        return $this->llm_model_settings;
    }

    public function hasLlmModelSettings()
    {
        return isset($this->llm_model_settings);
    }

    public function clearLlmModelSettings()
    {
        unset($this->llm_model_settings);
    }

    /**
     * The LLM model settings.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.LlmModelSettings llm_model_settings = 9;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings $var
     * @return $this
     */
    public function setLlmModelSettings($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\LlmModelSettings::class);
        $this->llm_model_settings = $var;

        return $this;
    }

    /**
     * Parameters passed to the LLM to configure its behavior.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Generator.ModelParameter model_parameter = 8;</code>
     * @return \Google\Cloud\Dialogflow\Cx\V3\Generator\ModelParameter|null
     */
    public function getModelParameter()
    {
        return $this->model_parameter;
    }

    public function hasModelParameter()
    {
        return isset($this->model_parameter);
    }

    public function clearModelParameter()
    {
        unset($this->model_parameter);
    }

    /**
     * Parameters passed to the LLM to configure its behavior.
     *
     * Generated from protobuf field <code>.google.cloud.dialogflow.cx.v3.Generator.ModelParameter model_parameter = 8;</code>
     * @param \Google\Cloud\Dialogflow\Cx\V3\Generator\ModelParameter $var
     * @return $this
     */
    public function setModelParameter($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\Dialogflow\Cx\V3\Generator\ModelParameter::class);
        $this->model_parameter = $var;

        return $this;
    }

}

