<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/developer_connect.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * Configuration for connections to an instance of Bitbucket Cloud.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.BitbucketCloudConfig</code>
 */
class BitbucketCloudConfig extends \Google\Protobuf\Internal\Message
{
    /**
     * Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud
     * Platform.
     *
     * Generated from protobuf field <code>string workspace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $workspace = '';
    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This is used to validate and create
     * webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     */
    protected $webhook_secret_secret_version = '';
    /**
     * Required. An access token with the minimum `repository` access.
     * It can either be a workspace, project or repository access token.
     * It's recommended to use a system account to generate the credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $read_authorizer_credential = null;
    /**
     * Required. An access token with the minimum `repository`, `pullrequest` and
     * `webhook` scope access. It can either be a workspace, project or repository
     * access token. This is needed to create webhooks. It's recommended to use a
     * system account to generate these credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    protected $authorizer_credential = null;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $workspace
     *           Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud
     *           Platform.
     *     @type string $webhook_secret_secret_version
     *           Required. Immutable. SecretManager resource containing the webhook secret
     *           used to verify webhook events, formatted as
     *           `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This is used to validate and create
     *           webhooks.
     *     @type \Google\Cloud\DeveloperConnect\V1\UserCredential $read_authorizer_credential
     *           Required. An access token with the minimum `repository` access.
     *           It can either be a workspace, project or repository access token.
     *           It's recommended to use a system account to generate the credentials.
     *     @type \Google\Cloud\DeveloperConnect\V1\UserCredential $authorizer_credential
     *           Required. An access token with the minimum `repository`, `pullrequest` and
     *           `webhook` scope access. It can either be a workspace, project or repository
     *           access token. This is needed to create webhooks. It's recommended to use a
     *           system account to generate these credentials.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\DeveloperConnect::initOnce();
        parent::__construct($data);
    }

    /**
     * Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud
     * Platform.
     *
     * Generated from protobuf field <code>string workspace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return string
     */
    public function getWorkspace()
    {
        return $this->workspace;
    }

    /**
     * Required. The Bitbucket Cloud Workspace ID to be connected to Google Cloud
     * Platform.
     *
     * Generated from protobuf field <code>string workspace = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param string $var
     * @return $this
     */
    public function setWorkspace($var)
    {
        GPBUtil::checkString($var, True);
        $this->workspace = $var;

        return $this;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This is used to validate and create
     * webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @return string
     */
    public function getWebhookSecretSecretVersion()
    {
        return $this->webhook_secret_secret_version;
    }

    /**
     * Required. Immutable. SecretManager resource containing the webhook secret
     * used to verify webhook events, formatted as
     * `projects/&#42;&#47;secrets/&#42;&#47;versions/&#42;`. This is used to validate and create
     * webhooks.
     *
     * Generated from protobuf field <code>string webhook_secret_secret_version = 2 [(.google.api.field_behavior) = REQUIRED, (.google.api.field_behavior) = IMMUTABLE, (.google.api.resource_reference) = {</code>
     * @param string $var
     * @return $this
     */
    public function setWebhookSecretSecretVersion($var)
    {
        GPBUtil::checkString($var, True);
        $this->webhook_secret_secret_version = $var;

        return $this;
    }

    /**
     * Required. An access token with the minimum `repository` access.
     * It can either be a workspace, project or repository access token.
     * It's recommended to use a system account to generate the credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\UserCredential|null
     */
    public function getReadAuthorizerCredential()
    {
        return $this->read_authorizer_credential;
    }

    public function hasReadAuthorizerCredential()
    {
        return isset($this->read_authorizer_credential);
    }

    public function clearReadAuthorizerCredential()
    {
        unset($this->read_authorizer_credential);
    }

    /**
     * Required. An access token with the minimum `repository` access.
     * It can either be a workspace, project or repository access token.
     * It's recommended to use a system account to generate the credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential read_authorizer_credential = 3 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\UserCredential $var
     * @return $this
     */
    public function setReadAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\UserCredential::class);
        $this->read_authorizer_credential = $var;

        return $this;
    }

    /**
     * Required. An access token with the minimum `repository`, `pullrequest` and
     * `webhook` scope access. It can either be a workspace, project or repository
     * access token. This is needed to create webhooks. It's recommended to use a
     * system account to generate these credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @return \Google\Cloud\DeveloperConnect\V1\UserCredential|null
     */
    public function getAuthorizerCredential()
    {
        return $this->authorizer_credential;
    }

    public function hasAuthorizerCredential()
    {
        return isset($this->authorizer_credential);
    }

    public function clearAuthorizerCredential()
    {
        unset($this->authorizer_credential);
    }

    /**
     * Required. An access token with the minimum `repository`, `pullrequest` and
     * `webhook` scope access. It can either be a workspace, project or repository
     * access token. This is needed to create webhooks. It's recommended to use a
     * system account to generate these credentials.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.UserCredential authorizer_credential = 4 [(.google.api.field_behavior) = REQUIRED];</code>
     * @param \Google\Cloud\DeveloperConnect\V1\UserCredential $var
     * @return $this
     */
    public function setAuthorizerCredential($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\UserCredential::class);
        $this->authorizer_credential = $var;

        return $this;
    }

}

