<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# source: google/cloud/developerconnect/v1/developer_connect.proto

namespace Google\Cloud\DeveloperConnect\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\RepeatedField;
use Google\Protobuf\Internal\GPBUtil;

/**
 * AccountConnector encapsulates what a platform administrator needs to
 * configure for users to connect to the service providers, which includes,
 * among other fields, the OAuth client ID, client secret, and authorization and
 * token endpoints.
 *
 * Generated from protobuf message <code>google.cloud.developerconnect.v1.AccountConnector</code>
 */
class AccountConnector extends \Google\Protobuf\Internal\Message
{
    /**
     * Identifier. The resource name of the accountConnector, in the format
     * `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     */
    protected $name = '';
    /**
     * Output only. The timestamp when the accountConnector was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $create_time = null;
    /**
     * Output only. The timestamp when the accountConnector was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $update_time = null;
    /**
     * Optional. Allows users to store small amounts of arbitrary data.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $annotations;
    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    protected $etag = '';
    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     */
    private $labels;
    /**
     * Output only. Start OAuth flow by clicking on this URL.
     *
     * Generated from protobuf field <code>string oauth_start_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     */
    protected $oauth_start_uri = '';
    protected $account_connector_config;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type \Google\Cloud\DeveloperConnect\V1\ProviderOAuthConfig $provider_oauth_config
     *           Provider OAuth config.
     *     @type string $name
     *           Identifier. The resource name of the accountConnector, in the format
     *           `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
     *     @type \Google\Protobuf\Timestamp $create_time
     *           Output only. The timestamp when the accountConnector was created.
     *     @type \Google\Protobuf\Timestamp $update_time
     *           Output only. The timestamp when the accountConnector was updated.
     *     @type array|\Google\Protobuf\Internal\MapField $annotations
     *           Optional. Allows users to store small amounts of arbitrary data.
     *     @type string $etag
     *           Optional. This checksum is computed by the server based on the value of
     *           other fields, and may be sent on update and delete requests to ensure the
     *           client has an up-to-date value before proceeding.
     *     @type array|\Google\Protobuf\Internal\MapField $labels
     *           Optional. Labels as key value pairs
     *     @type string $oauth_start_uri
     *           Output only. Start OAuth flow by clicking on this URL.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Google\Cloud\Developerconnect\V1\DeveloperConnect::initOnce();
        parent::__construct($data);
    }

    /**
     * Provider OAuth config.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ProviderOAuthConfig provider_oauth_config = 5;</code>
     * @return \Google\Cloud\DeveloperConnect\V1\ProviderOAuthConfig|null
     */
    public function getProviderOauthConfig()
    {
        return $this->readOneof(5);
    }

    public function hasProviderOauthConfig()
    {
        return $this->hasOneof(5);
    }

    /**
     * Provider OAuth config.
     *
     * Generated from protobuf field <code>.google.cloud.developerconnect.v1.ProviderOAuthConfig provider_oauth_config = 5;</code>
     * @param \Google\Cloud\DeveloperConnect\V1\ProviderOAuthConfig $var
     * @return $this
     */
    public function setProviderOauthConfig($var)
    {
        GPBUtil::checkMessage($var, \Google\Cloud\DeveloperConnect\V1\ProviderOAuthConfig::class);
        $this->writeOneof(5, $var);

        return $this;
    }

    /**
     * Identifier. The resource name of the accountConnector, in the format
     * `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @return string
     */
    public function getName()
    {
        return $this->name;
    }

    /**
     * Identifier. The resource name of the accountConnector, in the format
     * `projects/{project}/locations/{location}/accountConnectors/{account_connector_id}`.
     *
     * Generated from protobuf field <code>string name = 1 [(.google.api.field_behavior) = IDENTIFIER];</code>
     * @param string $var
     * @return $this
     */
    public function setName($var)
    {
        GPBUtil::checkString($var, True);
        $this->name = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the accountConnector was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getCreateTime()
    {
        return $this->create_time;
    }

    public function hasCreateTime()
    {
        return isset($this->create_time);
    }

    public function clearCreateTime()
    {
        unset($this->create_time);
    }

    /**
     * Output only. The timestamp when the accountConnector was created.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp create_time = 2 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setCreateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->create_time = $var;

        return $this;
    }

    /**
     * Output only. The timestamp when the accountConnector was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return \Google\Protobuf\Timestamp|null
     */
    public function getUpdateTime()
    {
        return $this->update_time;
    }

    public function hasUpdateTime()
    {
        return isset($this->update_time);
    }

    public function clearUpdateTime()
    {
        unset($this->update_time);
    }

    /**
     * Output only. The timestamp when the accountConnector was updated.
     *
     * Generated from protobuf field <code>.google.protobuf.Timestamp update_time = 3 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param \Google\Protobuf\Timestamp $var
     * @return $this
     */
    public function setUpdateTime($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Timestamp::class);
        $this->update_time = $var;

        return $this;
    }

    /**
     * Optional. Allows users to store small amounts of arbitrary data.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getAnnotations()
    {
        return $this->annotations;
    }

    /**
     * Optional. Allows users to store small amounts of arbitrary data.
     *
     * Generated from protobuf field <code>map<string, string> annotations = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setAnnotations($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->annotations = $arr;

        return $this;
    }

    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return string
     */
    public function getEtag()
    {
        return $this->etag;
    }

    /**
     * Optional. This checksum is computed by the server based on the value of
     * other fields, and may be sent on update and delete requests to ensure the
     * client has an up-to-date value before proceeding.
     *
     * Generated from protobuf field <code>string etag = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param string $var
     * @return $this
     */
    public function setEtag($var)
    {
        GPBUtil::checkString($var, True);
        $this->etag = $var;

        return $this;
    }

    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getLabels()
    {
        return $this->labels;
    }

    /**
     * Optional. Labels as key value pairs
     *
     * Generated from protobuf field <code>map<string, string> labels = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setLabels($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->labels = $arr;

        return $this;
    }

    /**
     * Output only. Start OAuth flow by clicking on this URL.
     *
     * Generated from protobuf field <code>string oauth_start_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @return string
     */
    public function getOauthStartUri()
    {
        return $this->oauth_start_uri;
    }

    /**
     * Output only. Start OAuth flow by clicking on this URL.
     *
     * Generated from protobuf field <code>string oauth_start_uri = 10 [(.google.api.field_behavior) = OUTPUT_ONLY];</code>
     * @param string $var
     * @return $this
     */
    public function setOauthStartUri($var)
    {
        GPBUtil::checkString($var, True);
        $this->oauth_start_uri = $var;

        return $this;
    }

    /**
     * @return string
     */
    public function getAccountConnectorConfig()
    {
        return $this->whichOneof("account_connector_config");
    }

}

